/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.dialogs;

import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBUtil;
import oracle.javatools.util.Holder;

public class DBUIProgressBar {
    private static final int DELAY = 5000;
    private static final int WC_DELAY = 1000;
    private final String m_title;
    private boolean m_cancellable = true;
    private ProgressBar m_pbar;
    private String m_baseDialogName;

    public DBUIProgressBar(String string) {
        this.m_title = string;
    }

    public void setDialogName(String string) {
        this.m_baseDialogName = string;
    }

    public void setCancellable(boolean bl) {
        this.m_cancellable = bl;
    }

    public void execute(Runnable runnable) {
        this.execute(runnable, null, null);
    }

    public <T, E extends Throwable> T execute(ProgressCallable<T, E> progressCallable) throws E {
        return this.execute(progressCallable, null, null);
    }

    public <T, E extends Throwable> T execute(final ProgressCallable<T, E> progressCallable, String string, String string2) throws E {
        final Holder holder = new Holder();
        final Holder holder2 = new Holder();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    holder.set(progressCallable.call());
                }
                catch (Throwable throwable) {
                    holder2.set((Object)throwable);
                }
            }
        };
        this.execute(runnable, string, string2);
        Throwable throwable = (Throwable)holder2.get();
        if (throwable != null) {
            throw throwable;
        }
        return (T)holder.get();
    }

    public void execute(final Runnable runnable, String string, String string2) {
        if (DBMessageDialog.useDialog() && SwingUtilities.isEventDispatchThread()) {
            if (this.m_pbar != null) {
                throw new IllegalStateException("A DBUIProgressBar cannot be executed twice");
            }
            final ProgressBar progressBar = new ProgressBar(DBMessageDialog.getDialogParent(), this.m_title, null, true);
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        if (!progressBar.hasUserCancelled()) {
                            DBLog.getLogger((Object)runnable).log(Level.SEVERE, throwable.getMessage(), throwable);
                        }
                    }
                    finally {
                        DBUIProgressBar.this.m_pbar.setDoneStatus();
                    }
                }
            };
            String string3 = this.m_baseDialogName == null ? "DBUIProgressBar" : this.m_baseDialogName;
            progressBar.setDialogName(string3 + ":" + DBUtil.createUUID());
            progressBar.setRunnable(runnable2);
            progressBar.setCancelable(this.m_cancellable);
            this.m_pbar = progressBar;
            DBUIProgressBar.start(progressBar, string, string2);
        } else {
            runnable.run();
        }
    }

    public boolean hasUserCancelled() {
        return this.m_pbar != null && this.m_pbar.hasUserCancelled();
    }

    public static void start(ProgressBar progressBar, String string, String string2) {
        progressBar.start(string, string2, 0, 100, 1000, 5000);
    }

    public static abstract class ProgressCallable<T, E extends Throwable> {
        public abstract T call() throws E;
    }
}

