/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.extension;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.util.dnd.DropHelper;
import oracle.ideimpl.db.extension.AbstractExtensionHook;
import oracle.ideimpl.db.jdbc.JdbcDBEditorFactory;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public class DatabaseUIExtensionHook
extends AbstractExtensionHook {
    private static final String HOOK = "database-ui-hook";
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension/db", "database-ui-hook");
    private final Map<String, EditorFactoryHash> m_edFacHashesByClz = new ConcurrentHashMap<String, EditorFactoryHash>();
    private final Map<String, EditorFactoryHash> m_edFacHashesByDBType = new ConcurrentHashMap<String, EditorFactoryHash>();
    private final Map<String, EditorFactoryHash> m_edFacHashesByProType = new ConcurrentHashMap<String, EditorFactoryHash>();
    private DBEditorFactory m_jdbcEdFac;
    private final MultiMap<String, ComponentWrapperHash> m_cwHashes = new MultiMap(CopyOnWriteArrayList.class);
    private final Map<String, TesterComponentHash> m_testerComponents = new ConcurrentHashMap<String, TesterComponentHash>();
    private final List<ProviderPickerHash> m_providerPickers = new CopyOnWriteArrayList<ProviderPickerHash>();
    private final MultiMap<String, DropHelperHash> m_dropHelpers = MultiMap.getMultiMap(ConcurrentHashMap.class, ArrayList.class);
    private HashStructure m_dbExecutorHash;
    private HashStructure m_typeFilterHash;

    @Override
    protected void processHashStructure(HashStructure hashStructure) {
        Object object;
        Object object2;
        Object object32;
        super.processHashStructure(hashStructure);
        for (Object object32 : this.getChildList(hashStructure, "object-editor-factories", "object-editor-factory")) {
            String string;
            String string2;
            object2 = new EditorFactoryHash((HashStructure)object32);
            object = object2.getProviderClassName();
            if (ModelUtil.hasLength((String)object)) {
                this.logWarning((HashStructure)object32, "Specfying provider-class for object-editor-factory registration is deprecated, use database-type");
                this.m_edFacHashesByClz.put((String)object, (EditorFactoryHash)((Object)object2));
            }
            if (ModelUtil.hasLength((String)(string2 = object2.getDatabaseType()))) {
                this.m_edFacHashesByDBType.put(string2, (EditorFactoryHash)((Object)object2));
            }
            if (!ModelUtil.hasLength((String)(string = object2.getProviderType()))) continue;
            this.m_edFacHashesByProType.put(string, (EditorFactoryHash)((Object)object2));
        }
        for (Object object32 : this.getChildList(hashStructure, "component-wrappers", "component-wrapper")) {
            object2 = new ComponentWrapperHash((HashStructure)object32);
            for (String string2 : object2.getPropertyNames()) {
                this.m_cwHashes.add((Object)string2, object2);
            }
        }
        for (Object object32 : this.getChildList(hashStructure, "sql-tester-components", "sql-tester-component")) {
            object2 = new TesterComponentHash((HashStructure)object32);
            object = object2.getID();
            if (ModelUtil.hasLength((String)object)) {
                this.m_testerComponents.put((String)object, (TesterComponentHash)object2);
                continue;
            }
            this.logMissingElemError((HashStructure)object32, "id");
        }
        for (Object object32 : this.getChildList(hashStructure, "provider-pickers", "provider-picker")) {
            object2 = new ProviderPickerHash((HashStructure)object32);
            this.m_providerPickers.add(0, (ProviderPickerHash)((Object)object2));
        }
        for (Object object32 : this.getChildList(hashStructure, "drop-helpers", "drop-helper")) {
            object2 = new DropHelperHash((HashStructure)object32);
            object = ((DropHelperHash)((Object)object2)).getSourceTargetKey();
            if (object == null) continue;
            this.m_dropHelpers.add(object, object2);
        }
        Object object4 = hashStructure.getObject("db-executor");
        if (object4 instanceof HashStructure && ModelUtil.hasLength((String)HashStructureHook.getText((HashStructure)((HashStructure)object4)))) {
            if (this.m_dbExecutorHash != null) {
                this.logWarning(this.m_dbExecutorHash, "db-executor replaced by downstream extension");
            }
            this.m_dbExecutorHash = (HashStructure)object4;
        }
        if ((object32 = hashStructure.getObject("default-object-type-filter")) instanceof HashStructure) {
            if (this.m_typeFilterHash != null) {
                this.logWarning(this.m_typeFilterHash, "default-object-type-filter replaced by downstream extension");
            }
            this.m_typeFilterHash = object32;
        }
    }

    public DBEditorFactory findEditorFactory(DBObjectProvider dBObjectProvider) {
        DBEditorFactory dBEditorFactory = null;
        if (dBObjectProvider instanceof Database) {
            dBEditorFactory = this.findEditorFactory(dBObjectProvider.getClass());
            if (dBEditorFactory == null) {
                dBEditorFactory = this.findDatabaseEditorFactory(dBObjectProvider.getDescriptor());
            }
        } else {
            this.checkListenerInit();
            EditorFactoryHash editorFactoryHash = this.m_edFacHashesByProType.get(dBObjectProvider.getProviderType());
            if (editorFactoryHash != null) {
                dBEditorFactory = editorFactoryHash.getEditorFactory();
            }
        }
        return dBEditorFactory;
    }

    public DBEditorFactory findDatabaseEditorFactory(DatabaseDescriptor databaseDescriptor) {
        this.checkListenerInit();
        DBEditorFactory dBEditorFactory = null;
        EditorFactoryHash editorFactoryHash = this.m_edFacHashesByDBType.get(databaseDescriptor.getDatabaseType());
        if (editorFactoryHash != null) {
            dBEditorFactory = editorFactoryHash.getEditorFactory();
        }
        if (dBEditorFactory == null && (dBEditorFactory = this.m_jdbcEdFac) == null) {
            this.m_jdbcEdFac = dBEditorFactory = new JdbcDBEditorFactory();
        }
        return dBEditorFactory;
    }

    @Deprecated
    public DBEditorFactory findEditorFactory(Class<? extends DBObjectProvider> clazz) {
        DBEditorFactory dBEditorFactory = null;
        block0: for (Class<? extends DBObjectProvider> clazz2 = clazz; clazz2 != null && (dBEditorFactory = this.getEditorFactory(clazz2)) == null; clazz2 = clazz2.getSuperclass()) {
            for (Class<?> clazz3 : clazz2.getInterfaces()) {
                dBEditorFactory = this.getEditorFactory(clazz3);
                if (dBEditorFactory != null) break block0;
            }
        }
        return dBEditorFactory;
    }

    private DBEditorFactory getEditorFactory(Class clazz) {
        this.checkListenerInit();
        DBEditorFactory dBEditorFactory = null;
        EditorFactoryHash editorFactoryHash = this.m_edFacHashesByClz.get(clazz.getName());
        if (editorFactoryHash != null) {
            dBEditorFactory = editorFactoryHash.getEditorFactory();
        }
        return dBEditorFactory;
    }

    public Map<String, Collection<ComponentWrapperHash>> getComponentWrappers() {
        return Collections.unmodifiableMap(this.m_cwHashes);
    }

    public ComponentWrapper createComponentWrapper(ComponentContext componentContext) {
        ComponentWrapper componentWrapper;
        block2: {
            ComponentWrapperHash componentWrapperHash;
            this.checkListenerInit();
            componentWrapper = null;
            String string = componentContext.getPropertyName();
            String string2 = Property.getLastProperty((String)string);
            Collection collection = this.m_cwHashes.get((Object)string);
            if (collection == null && !string.equals(string2)) {
                collection = this.m_cwHashes.get((Object)string2);
            }
            if (collection == null || collection.isEmpty()) break block2;
            ListIterator listIterator = ((List)collection).listIterator(collection.size());
            while (listIterator.hasPrevious() && (!(componentWrapperHash = (ComponentWrapperHash)((Object)listIterator.previous())).isCompatibleContext(componentContext, string, string2) || (componentWrapper = componentWrapperHash.createWrapper(componentContext)) == null)) {
            }
        }
        return componentWrapper;
    }

    public Collection<String> getSQLTesterComponentIDs() {
        this.checkListenerInit();
        return new TreeSet<String>(this.m_testerComponents.keySet());
    }

    public TesterComponent getSQLTesterComponent(String string) {
        this.checkListenerInit();
        return this.m_testerComponents.get(string);
    }

    public Iterable<ProviderPickerHash> getDBObjectProviderPickers() {
        this.checkListenerInit();
        return this.m_providerPickers;
    }

    public List<DropHelper> getDropHelpers(String string, String string2) {
        this.checkListenerInit();
        String string3 = DatabaseUIExtensionHook.createDropHelperKey(string, string2);
        List list = (List)this.m_dropHelpers.get((Object)string3);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        Collections.sort(arrayList, (dropHelperHash, dropHelperHash2) -> DatabaseUIExtensionHook.compareDropHelperHash(dropHelperHash, dropHelperHash2));
        ArrayList<DropHelper> arrayList2 = new ArrayList<DropHelper>();
        for (DropHelperHash dropHelperHash3 : arrayList) {
            DropHelper dropHelper = dropHelperHash3.getDropHelper();
            if (dropHelper == null) continue;
            arrayList2.add(dropHelper);
        }
        return arrayList2;
    }

    public ExecutorService getDBExecutor() {
        this.checkListenerInit();
        HashStructure hashStructure = this.m_dbExecutorHash;
        ExecutorService executorService = null;
        if (hashStructure != null) {
            try {
                MetaClass metaClass = this.getMetaClass(hashStructure);
                executorService = (ExecutorService)metaClass.newInstance();
            }
            catch (Exception exception) {
                this.logError(hashStructure, exception.getMessage());
            }
        }
        return executorService;
    }

    public Collection<String> getDefaultObjectTypeFilter() {
        this.checkListenerInit();
        TreeSet<String> treeSet = new TreeSet<String>();
        HashStructure hashStructure = this.m_typeFilterHash;
        if (hashStructure != null) {
            for (HashStructure hashStructure2 : hashStructure.getAsList("object-type")) {
                String string = HashStructureHook.getText((HashStructure)hashStructure2);
                treeSet.add(string);
            }
        }
        return treeSet;
    }

    public static DatabaseUIExtensionHook getHook() {
        return DatabaseUIExtensionHook.findHook(NAME, DatabaseUIExtensionHook.class);
    }

    private static int compareDropHelperHash(DropHelperHash dropHelperHash, DropHelperHash dropHelperHash2) {
        float f;
        float f2 = dropHelperHash.getWeight();
        int n = f2 == (f = dropHelperHash2.getWeight()) ? 0 : (f2 > f ? -1 : 1);
        return n;
    }

    private static String createDropHelperKey(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(" -> ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private final class DropHelperHash
    extends HashStructureAdapter {
        private DropHelperHash(HashStructure hashStructure) {
            super(hashStructure);
        }

        private String getSourceTargetKey() {
            String string;
            String string2 = this._hash.getString("source");
            String string3 = this._hash.getString("target");
            if (ModelUtil.hasLength((String)string2) && ModelUtil.hasLength((String)string3)) {
                string = DatabaseUIExtensionHook.createDropHelperKey(string2, string3);
            } else {
                String string4 = ModelUtil.hasLength((String)string2) ? "target" : "source";
                string = null;
                DatabaseUIExtensionHook.this.logMissingElemError(this._hash, string4);
            }
            return string;
        }

        private float getWeight() {
            return this._hash.getFloat("weight");
        }

        private DropHelper getDropHelper() {
            HashStructure hashStructure = this._hash.getHashStructure("helper-class");
            return DatabaseUIExtensionHook.this.instantiateClass(hashStructure, DropHelper.class);
        }
    }

    public class ProviderPickerHash
    extends HashStructureAdapter {
        public ProviderPickerHash(HashStructure hashStructure) {
            super(hashStructure);
        }

        public String getProviderType() {
            return this._hash.getString("provider-type/#text");
        }

        public DBObjectProviderPicker getProviderPicker() {
            DBObjectProviderPicker dBObjectProviderPicker = null;
            HashStructure hashStructure = this._hash.getHashStructure("picker-class");
            if (hashStructure != null) {
                dBObjectProviderPicker = DatabaseUIExtensionHook.this.instantiateClass(hashStructure, DBObjectProviderPicker.class);
            }
            return dBObjectProviderPicker;
        }

        public String getLabel() {
            return this._hash.getString("label/#text");
        }
    }

    public class TesterComponentHash
    extends TesterComponent.DelegateTesterComponent {
        private final HashStructure m_hash;

        TesterComponentHash(HashStructure hashStructure) {
            this.m_hash = hashStructure;
        }

        @Override
        protected TesterComponent createDelegate() {
            TesterComponent testerComponent = null;
            HashStructure hashStructure = this.m_hash.getHashStructure("class");
            if (hashStructure != null) {
                testerComponent = DatabaseUIExtensionHook.this.instantiateClass(hashStructure, TesterComponent.class);
            }
            return testerComponent;
        }

        @Override
        public String getName() {
            return DatabaseUIExtensionHook.this.getText(this.m_hash, "display-name");
        }

        public String getID() {
            return DatabaseUIExtensionHook.this.getText(this.m_hash, "id");
        }
    }

    public class EditorFactoryHash
    extends HashStructureAdapter {
        private DBEditorFactory m_edFac;

        public EditorFactoryHash(HashStructure hashStructure) {
            super(hashStructure);
        }

        public String getProviderClassName() {
            return this._hash.getString("provider-class/#text");
        }

        public String getProviderType() {
            return this._hash.getString("provider-type/#text");
        }

        public String getDatabaseType() {
            return this._hash.getString("database-type/#text");
        }

        public DBEditorFactory getEditorFactory() {
            HashStructure hashStructure;
            if (this.m_edFac == null && (hashStructure = this._hash.getHashStructure("factory-class")) != null) {
                this.m_edFac = DatabaseUIExtensionHook.this.instantiateClass(hashStructure, DBEditorFactory.class);
            }
            return this.m_edFac;
        }
    }

    public class ComponentWrapperHash
    extends HashStructureAdapter {
        private static final String PANEL_CLASS = "panel-class";
        private static final String WRAPPER_CLASS = "wrapper-class";

        public ComponentWrapperHash(HashStructure hashStructure) {
            super(hashStructure);
        }

        public Collection<String> getPropertyNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (HashStructure hashStructure : this._hash.getAsList("property-name")) {
                arrayList.add(HashStructureHook.getText((HashStructure)hashStructure));
            }
            return arrayList;
        }

        public ComponentWrapper createWrapper(ComponentContext componentContext) {
            ComponentWrapper<Object> componentWrapper = null;
            HashStructure hashStructure = this._hash.getHashStructure(PANEL_CLASS);
            if (hashStructure != null) {
                BaseEditorPanel baseEditorPanel = DatabaseUIExtensionHook.this.instantiateClass(hashStructure, BaseEditorPanel.class);
                if (baseEditorPanel != null) {
                    componentWrapper = componentContext != null && componentContext.isButtonContext() ? baseEditorPanel.createButtonWrapper() : baseEditorPanel.createPanelWrapper();
                }
            } else {
                HashStructure hashStructure2 = this._hash.getHashStructure(WRAPPER_CLASS);
                if (hashStructure2 != null) {
                    Class<ComponentWrapper> clazz = DatabaseUIExtensionHook.this.loadClass(hashStructure2, ComponentWrapper.class);
                    try {
                        Constructor<ComponentWrapper> constructor = clazz.getConstructor(String.class);
                        componentWrapper = constructor.newInstance(componentContext.getPropertyName());
                    }
                    catch (Exception exception) {
                        componentWrapper = DatabaseUIExtensionHook.this.instantiateClass(hashStructure2, ComponentWrapper.class);
                    }
                } else {
                    DatabaseUIExtensionHook.this.logMissingElemsError(hashStructure2, null, PANEL_CLASS, WRAPPER_CLASS);
                    if (componentContext == null) {
                        throw new IllegalStateException("Missing panel-class or wrapper-class");
                    }
                }
            }
            return componentWrapper;
        }

        public boolean isCompatibleContext(ComponentContext componentContext, String string, String string2) {
            PropertyInfo propertyInfo;
            Object object;
            String string3;
            boolean bl = true;
            DBObjectProvider dBObjectProvider = componentContext.getProvider();
            DBObject dBObject = componentContext.getUpdatedObject();
            if (dBObject != null && (string3 = this.getObjectClassName()) != null && !(bl = DatabaseUIExtensionHook.this.isAssignableFrom(string3, (Class)(object = dBObject.getClass()))) && !string.equals(string2) && dBObjectProvider != null && (propertyInfo = dBObjectProvider.getPropertyManager().findPropertyInfo((Class)object, Property.getParentProperty((String)string))) != null) {
                bl = DatabaseUIExtensionHook.this.isAssignableFrom(string3, propertyInfo.getPropertyClass());
            }
            if (bl && dBObjectProvider != null) {
                string3 = this.getProviderType();
                if (string3 != null) {
                    bl = string3.equals(dBObjectProvider.getProviderType());
                }
                if (bl && (object = this.getDatabaseType()) != null) {
                    bl = ((String)object).equals(dBObjectProvider.getDescriptor().getDatabaseType());
                }
            }
            return bl;
        }

        private String getObjectClassName() {
            return this._hash.getString("object-class/#text");
        }

        public Class<? extends DBObject> getObjectClass() {
            return DatabaseUIExtensionHook.this.loadClass(this._hash, "object-class", DBObject.class);
        }

        private String getDatabaseType() {
            return this._hash.getString("database-type/#text");
        }

        private String getProviderType() {
            return this._hash.getString("provider-type/#text");
        }
    }
}

