/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.model;

import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectProviderNode;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ideimpl.db.extension.DatabaseExtensionHook;
import oracle.ideimpl.db.model.DatabaseNodeRecognizer;
import oracle.javatools.db.DBObject;

public abstract class ProviderNodeRecognizer<T> {
    public abstract String getProviderType(T var1);

    public abstract Object getProviderIdentifier(T var1);

    public abstract boolean isProviderNode(T var1);

    public DBObject getDBObject(T t) {
        return t instanceof DBObjectNode ? ((DBObjectNode)t).getDBObject() : null;
    }

    public boolean isDBObjectNode(T t) {
        return t instanceof DBObjectNode;
    }

    public static <T> ProviderNodeRecognizer<T> findRecognizer(T t) {
        ProviderNodeRecognizer providerNodeRecognizer = DatabaseNodeRecognizer.createRecognizer(t);
        if (providerNodeRecognizer == null) {
            if (t instanceof DBObjectProviderNode) {
                providerNodeRecognizer = new ProRecognizer();
            } else {
                DatabaseExtensionHook databaseExtensionHook = DatabaseExtensionHook.getHook();
                if (databaseExtensionHook != null) {
                    providerNodeRecognizer = databaseExtensionHook.findNodeRecognizer(t);
                }
            }
        }
        return providerNodeRecognizer;
    }

    private static class ProRecognizer
    extends ProviderNodeRecognizer<DBObjectProviderNode> {
        private ProRecognizer() {
        }

        @Override
        public Object getProviderIdentifier(DBObjectProviderNode dBObjectProviderNode) {
            return dBObjectProviderNode.getProviderIdentifier();
        }

        @Override
        public String getProviderType(DBObjectProviderNode dBObjectProviderNode) {
            return dBObjectProviderNode.getProviderType();
        }

        @Override
        public boolean isProviderNode(DBObjectProviderNode dBObjectProviderNode) {
            return !(dBObjectProviderNode instanceof DBObjectTypeNode);
        }
    }
}

