/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora;

import java.net.URL;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.plsql.PlSqlComparator;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlSourceObjectBuilder;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;

abstract class PlSqlPanelLibrary
extends PanelLibrary {
    protected PlSqlPanelLibrary(String string) {
        super(string);
    }

    @Override
    protected Class<? extends Traversable> getDDLPanel() {
        return null;
    }

    protected List<String> getTitles(DBObject dBObject, DBObjectProvider dBObjectProvider, boolean bl) {
        return Collections.emptyList();
    }

    protected void ensureNameIsInSource(PlSqlSourceObject plSqlSourceObject, DBObjectProvider dBObjectProvider) throws CancelledException {
        PlSqlUtil.TypeAndNameInfo typeAndNameInfo;
        String string;
        String string2 = plSqlSourceObject.getName();
        if (!string2.equals(string = (typeAndNameInfo = PlSqlUtil.getTypeAndNameFromSource((PlSqlSourceObject)plSqlSourceObject, (DatabaseDescriptor)dBObjectProvider.getDescriptor())).getName())) {
            StringBuilder stringBuilder = new StringBuilder(plSqlSourceObject.getSource());
            PlSqlParser plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)dBObjectProvider);
            if (plSqlParser != null) {
                PlSqlToken plSqlToken = null;
                PlSqlToken plSqlToken2 = null;
                PlSqlToken plSqlToken3 = plSqlParser.getTokenAtOffset(plSqlParser.getEndOffsetOfObject());
                if (plSqlToken3 != null && plSqlToken3.matches(";") && (plSqlToken = (PlSqlToken)plSqlToken3.getPrevCodeToken()).matches(string)) {
                    plSqlToken2 = (PlSqlToken)plSqlToken.getPrevCodeToken();
                }
                if (plSqlToken2 != null && plSqlToken2.matches("END")) {
                    stringBuilder.replace(plSqlToken.getStart(), plSqlToken.getEnd() + 1, this.adjustCase(string2));
                }
                stringBuilder.replace(typeAndNameInfo.getNameStart(), typeAndNameInfo.getNameEnd() + 1, this.adjustCase(string2));
                plSqlSourceObject.setSource(stringBuilder.toString());
            }
        }
    }

    private String adjustCase(String string) {
        if (string != null && GlobalSettings.getInstance().isNewPlSqlLowerCase() && !string.startsWith("\"") && !string.startsWith("'")) {
            return string.toLowerCase();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitSource(DBEditorConfig dBEditorConfig) throws DBException {
        final SchemaObject schemaObject = (SchemaObject)dBEditorConfig.getUpdatedObject();
        SchemaObject schemaObject2 = (SchemaObject)dBEditorConfig.getOriginalObject();
        final DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        URL uRL = this.getNodeURL(schemaObject, dBObjectProvider);
        Node node = null;
        try {
            node = NodeFactory.findOrCreate((URL)uRL);
        }
        catch (Exception exception) {
            throw new DBException(null, "Error finding pl/sql node.", (Throwable)exception);
        }
        String string = this.initialiseSource(dBEditorConfig);
        if (node instanceof TextNode) {
            final TextNode textNode = (TextNode)node;
            textNode.addNodeListener(new NodeListener(){
                final Schema schema;
                final String name;
                final String dbType;
                {
                    this.schema = schemaObject.getSchema();
                    this.name = schemaObject.getName();
                    this.dbType = schemaObject.getType();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void nodeSaved(NodeEvent nodeEvent) {
                    try {
                        SchemaObject schemaObject2 = dBObjectProvider.getObject(this.dbType, this.schema, this.name);
                        if (schemaObject2 != null && dBObjectProvider instanceof AbstractDatabase) {
                            ((AbstractDatabase)dBObjectProvider).fireObjectsAdded(this.schema, new SchemaObject[]{schemaObject2});
                        }
                    }
                    catch (DBException dBException) {
                        String string = UIBundle.get("PLSQL_PANEL_ERR");
                        Throwable throwable = dBException.getCause();
                        if (throwable instanceof SQLException) {
                            SQLErrorDialog.showErrorDialog(null, string, (SQLException)throwable);
                        } else {
                            DBExceptionDialog.showErrorDialog(null, string, dBException);
                        }
                    }
                    finally {
                        textNode.removeNodeListener((NodeListener)this);
                    }
                }

                public void nodeClosed(NodeEvent nodeEvent) {
                    textNode.removeNodeListener((NodeListener)this);
                }
            });
            if (dBObjectProvider instanceof Database) {
                SourceObject sourceObject;
                String string2;
                String string3 = this.getSource((SystemObject)schemaObject2);
                if (ModelUtil.areDifferent((Object)string3, (Object)(string2 = this.getSource((SystemObject)schemaObject)))) {
                    sourceObject = null;
                    boolean bl = false;
                    try {
                        sourceObject = textNode.acquireTextBuffer();
                        if (sourceObject.isReadOnly()) {
                            sourceObject.setReadOnly(false);
                            bl = true;
                        }
                        sourceObject.beginEdit();
                        sourceObject.removeToEnd(0);
                        if (string != null) {
                            sourceObject.append(string.toCharArray());
                        }
                    }
                    finally {
                        if (sourceObject != null) {
                            sourceObject.endEdit();
                            if (bl) {
                                sourceObject.setReadOnly(true);
                            }
                            textNode.releaseTextBuffer();
                        }
                    }
                }
                if (node instanceof BaseDBObjectTextNode && (sourceObject = ((BaseDBObjectTextNode)node).getDBObjectFromBuffer()).getClass() == schemaObject.getClass()) {
                    PropertyHelper propertyHelper = new PropertyHelper(dBObjectProvider);
                    for (Map.Entry entry : schemaObject.getProperties().entrySet()) {
                        String string4 = (String)entry.getKey();
                        PropertyInfo propertyInfo = PropertyHelper.findPropertyInfo(sourceObject.getClass(), (String)string4, (DBObjectProvider)dBObjectProvider);
                        if ("source".equals(string4) || propertyInfo == null || propertyInfo.isDerived()) continue;
                        sourceObject.setProperty(string4, entry.getValue());
                    }
                }
            }
        }
    }

    protected String initialiseSource(DBEditorConfig dBEditorConfig) throws CancelledException {
        SchemaObject schemaObject = (SchemaObject)dBEditorConfig.getUpdatedObject();
        SchemaObject schemaObject2 = (SchemaObject)dBEditorConfig.getOriginalObject();
        boolean bl = schemaObject2 == null;
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        String string = (String)schemaObject.getProperty("source");
        if (string == null) {
            string = this.getDefaultSource(dBObjectProvider, schemaObject);
        }
        if (schemaObject instanceof PlSqlSourceObject) {
            Trigger trigger;
            PlSqlSourceObject plSqlSourceObject = (PlSqlSourceObject)schemaObject;
            if (!bl) {
                if (plSqlSourceObject instanceof Trigger) {
                    trigger = (Trigger)plSqlSourceObject;
                    Trigger trigger2 = (Trigger)schemaObject2;
                    trigger.setSource(string);
                } else {
                    PlSqlComparator plSqlComparator = new PlSqlComparator(false, true);
                    trigger = (PlSqlSourceObject)schemaObject2;
                    if (plSqlComparator.compare(trigger.getSource(), plSqlSourceObject.getSource()) == 0) {
                        plSqlSourceObject.setSource(trigger.getSource());
                    }
                    this.ensureNameIsInSource(plSqlSourceObject, dBObjectProvider);
                }
            } else {
                plSqlSourceObject.setSource(string);
                this.ensureNameIsInSource(plSqlSourceObject, dBObjectProvider);
            }
            if (TemplateExpander.isPendingObject((DBObject)plSqlSourceObject)) {
                string = plSqlSourceObject.getSource();
                trigger = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
                if (!trigger.isCode()) {
                    trigger = (PlSqlToken)trigger.getNextCodeToken();
                }
                if (trigger != null && trigger.isCode() && !trigger.matches("CREATE")) {
                    string = "CREATE OR REPLACE\n" + string;
                }
            }
        }
        return string;
    }

    @Override
    public boolean prepareEditorInBackground(DBEditorConfig dBEditorConfig) {
        return true;
    }

    public void prepareObjectForEditor(DBEditorConfig dBEditorConfig, List list) throws DBException {
        super.prepareObjectForEditor(dBEditorConfig, list);
        this.deferRebuildSource(dBEditorConfig, true);
    }

    protected String getSource(SystemObject systemObject) {
        if (systemObject instanceof PlSqlSourceObject) {
            return ((PlSqlSourceObject)systemObject).getSource();
        }
        return null;
    }

    @Override
    public void commitToProvider(final DBEditorConfig dBEditorConfig) {
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        SystemObject systemObject = dBEditorConfig.getUpdatedObject();
        DBUIProgressBar dBUIProgressBar = new DBUIProgressBar(dBEditorConfig.isEdit() ? this.getEditTitle() : this.getCreateTitle());
        DBUIProgressBar.ProgressCallable<Boolean, CancelledException> progressCallable = new DBUIProgressBar.ProgressCallable<Boolean, CancelledException>(){

            @Override
            public Boolean call() throws CancelledException {
                PlSqlPanelLibrary.this.deferRebuildSource(dBEditorConfig, false);
                return null;
            }
        };
        boolean bl = false;
        try {
            dBUIProgressBar.execute(progressCallable);
            bl = dBUIProgressBar.hasUserCancelled();
        }
        catch (CancelledException cancelledException) {
            bl = true;
        }
        if (bl) {
            dBEditorConfig.setResult(DBEditorConfig.Result.CANCELLED);
        } else {
            URL uRL = DBURLFactory.getURL(dBObjectProvider, systemObject);
            if (uRL != null) {
                try {
                    Node node = NodeFactory.findOrCreate((URL)uRL);
                    Context context = Context.newIdeContext((Node)node);
                    EditorManager editorManager = EditorManager.getEditorManager();
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                    editorManager.openEditor(openEditorOptions);
                }
                catch (Exception exception) {
                    DBLog.logStackTrace((String)"Error finding object node.", (Throwable)exception);
                }
            }
            try {
                this.commitSource(dBEditorConfig);
                dBEditorConfig.setResult(DBEditorConfig.Result.SUCCESS);
                if (!(dBEditorConfig.getProvider() instanceof Database)) {
                    super.commitToProvider(dBEditorConfig);
                }
            }
            catch (DBException dBException) {
                dBEditorConfig.setException(dBException);
                dBEditorConfig.setResult(DBEditorConfig.Result.ERROR);
            }
        }
    }

    protected String getDefaultSource(DBObjectProvider dBObjectProvider, SchemaObject schemaObject) throws CancelledException {
        return PlSqlUtil.getDefaultSource((DBObjectProvider)dBObjectProvider, (PlSqlSourceObject)((PlSqlSourceObject)schemaObject));
    }

    protected URL getNodeURL(SchemaObject schemaObject, DBObjectProvider dBObjectProvider) {
        return DBURLFactory.getURL(dBObjectProvider, (SystemObject)schemaObject);
    }

    @Override
    public boolean showEditorAfterCommit() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<String> getNamesToExclude(DBObjectProvider dBObjectProvider, DBObject dBObject) {
        HashSet<String> hashSet = new HashSet<String>();
        if (dBObject instanceof Schema) {
            String string = ((Schema)dBObject).getName();
            for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                CodeEditor codeEditor;
                Context context;
                Node node;
                if (!(editor instanceof CodeEditor) || !((node = (context = CodeEditor.getContext((BasicEditorPane)(codeEditor = (CodeEditor)editor).getFocusedEditorPane())).getNode()) instanceof DBObjectPlSqlNode) || !node.isDirty()) continue;
                DBObjectPlSqlNode dBObjectPlSqlNode = (DBObjectPlSqlNode)node;
                String string2 = dBObjectPlSqlNode.getSchemaName();
                if (!dBObjectPlSqlNode.getProvider().equals(dBObjectProvider) || !string.equals(string2)) continue;
                String string3 = null;
                TextBuffer textBuffer = dBObjectPlSqlNode.acquireTextBuffer();
                if (textBuffer != null) {
                    try {
                        string3 = new String(textBuffer.getChars(0, textBuffer.getLength()));
                    }
                    catch (Exception exception) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to get pl/sql source.", exception);
                    }
                    finally {
                        dBObjectPlSqlNode.releaseTextBuffer();
                    }
                }
                if (string3 != null) {
                    hashSet.add(PlSqlUtil.getNameFromSource(string3));
                }
                hashSet.add(dBObjectPlSqlNode.getObjectName());
            }
        }
        return hashSet;
    }

    public boolean canEditObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        boolean bl = false;
        if (dBObjectProvider instanceof Database) {
            if (TemplateExpander.isPendingObject((DBObject)dBObject)) {
                bl = true;
            } else if (this.supportsEditDialog()) {
                Node node;
                URL uRL = this.getNodeURL((SchemaObject)dBObject, dBObjectProvider);
                Node node2 = node = uRL == null ? null : NodeFactory.find((URL)uRL);
                if (node == null || !node.isDirty()) {
                    bl = super.canEditObject(dBObject, dBObjectProvider);
                }
            }
        } else {
            bl = super.canEditObject(dBObject, dBObjectProvider);
        }
        return bl;
    }

    protected boolean supportsEditDialog() {
        return false;
    }

    @Override
    public boolean shouldValidateOnExit(BaseEditorPanel baseEditorPanel, Namespace namespace) {
        DBObjectProvider dBObjectProvider;
        boolean bl = super.shouldValidateOnExit(baseEditorPanel, namespace);
        DBEditorConfig dBEditorConfig = (DBEditorConfig)namespace.find(DBEditorConfig.class);
        DBObjectProvider dBObjectProvider2 = dBObjectProvider = dBEditorConfig == null ? null : dBEditorConfig.getProvider();
        if (bl && dBEditorConfig != null && dBObjectProvider instanceof Database && dBEditorConfig.isEdit()) {
            try {
                dBObjectProvider.validateObject((DBObject)dBEditorConfig.getOriginalObject(), (DBObject)dBEditorConfig.getUpdatedObject());
                bl = false;
            }
            catch (ValidationException validationException) {
                bl = true;
            }
        }
        return bl;
    }

    private void deferRebuildSource(DBEditorConfig dBEditorConfig, boolean bl) throws CancelledException {
        DBObjectProvider dBObjectProvider;
        DerivedPropertyBuilder derivedPropertyBuilder;
        SystemObject systemObject;
        if (!dBEditorConfig.isInFlatEditor() && (systemObject = dBEditorConfig.getUpdatedObject()) instanceof PlSqlSourceObject && (derivedPropertyBuilder = (dBObjectProvider = dBEditorConfig.getProvider()).getObjectFactory().ensureDerivedPropertyBuilder((DBObject)systemObject)) instanceof PlSqlSourceObjectBuilder) {
            PlSqlSourceObjectBuilder plSqlSourceObjectBuilder = (PlSqlSourceObjectBuilder)derivedPropertyBuilder;
            if (bl) {
                plSqlSourceObjectBuilder.deferRebuildSource();
            } else {
                plSqlSourceObjectBuilder.actionRebuildSource();
            }
        }
    }
}

