/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.dialogs.CascadeConfirmDialog;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.PropertyAccess;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class BaseChildrenEditorPanel<C extends ChildDBObject, P extends DBObject>
extends BaseEditorPanel<P> {
    private static final String NAME_SETTINGS_KEY = "db-current-child-name";
    private Holder<ChildObjectEditorPanel> m_childPanel;
    private C m_currentChild;
    private DocumentListener m_childDocListener;
    private Namespace m_childDataContext;
    private String m_childProperty;

    public BaseChildrenEditorPanel(String string) {
        super(string);
    }

    protected abstract ChildObjectEditorPanel<C, P> createChildPanel();

    protected final ChildObjectEditorPanel getChildPanel() {
        if (this.m_childPanel == null) {
            this.m_childPanel = new Holder(this.createChildPanel());
        }
        return (ChildObjectEditorPanel)this.m_childPanel.get();
    }

    public final C getCurrentChild() {
        return this.m_currentChild;
    }

    protected final void setCurrentChild(C c) {
        this.m_currentChild = c;
    }

    protected abstract void selectChild(C var1);

    protected String getChildProperty() {
        if (this.m_childProperty == null) {
            throw new IllegalStateException("getChildProperty() must be overridden (unless used exclusively via a ComponentWrapper).");
        }
        return this.m_childProperty;
    }

    @Override
    protected void initialiseWrappedPanel(ComponentContext componentContext) {
        super.initialiseWrappedPanel(componentContext);
        this.m_childProperty = componentContext.getPropertyName();
    }

    protected abstract Class<C> getChildClass();

    protected String getChildType() {
        return Metadata.getType(this.getChildClass());
    }

    protected boolean isHorizontalSplit() {
        return true;
    }

    protected C newChild() {
        String string;
        ChildDBObject childDBObject = (ChildDBObject)this.getProvider().getObjectFactory().newObject(this.getChildClass(), this.getParentUpdatedObject());
        String string2 = childDBObject.getName();
        String string3 = string = string2 != null ? string2 : this.getNewChildBaseName();
        if (string != null) {
            childDBObject.setName(DBUtil.getUniqueName(this.getChildNames(), (String)string));
        }
        TemporaryObjectID.setID((DBObject)childDBObject, (boolean)true);
        return (C)childDBObject;
    }

    protected void removeFromParent(C c) {
        DBObject dBObject = this.getParentUpdatedObject();
        DBObject dBObject2 = c.getParent();
        boolean bl = false;
        for (DBObject dBObject3 = dBObject2; dBObject3 != null; dBObject3 = dBObject3.getParent()) {
            if (dBObject3 != dBObject) continue;
            bl = true;
            break;
        }
        if (bl) {
            dBObject2.removeOwnedObject(c);
        }
    }

    protected boolean confirmCascadeDelete(C c) {
        Object t = this.getUpdatedObject();
        return this.confirmCascadeDelete((ChildDBObject)c, (DBObject)t);
    }

    protected boolean confirmCascadeDelete(ChildDBObject childDBObject, DBObject dBObject) {
        boolean bl = true;
        if (!this.isInFlatEditor() && childDBObject != null) {
            CascadeRequiredException cascadeRequiredException;
            ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
            ArrayList<DBObjectID> arrayList2 = new ArrayList<DBObjectID>();
            this.addCascadeItems((DBObject)childDBObject, dBObject, arrayList, arrayList2);
            if (arrayList2 != null && arrayList2.size() > 0 && (bl = CascadeConfirmDialog.confirmCascade((Component)((Object)this), cascadeRequiredException = new CascadeRequiredException((DBObject)childDBObject, arrayList2), null, null))) {
                try {
                    this.cascadeChildDelete((DBObject)childDBObject, dBObject, arrayList);
                }
                catch (DBException dBException) {
                    DBExceptionDialog.showErrorDialog((Component)((Object)this), ProviderOperator.getErrorTitle(this.getEditorConfig()), dBException);
                }
            }
        }
        return bl;
    }

    protected void cascadeChildDelete(DBObject dBObject, DBObject dBObject2, Collection<DBObject> collection) throws DBException {
        Map map = this.getProvider().getDescriptor().getValidators(this.getProvider());
        DBObjectValidator dBObjectValidator = (DBObjectValidator)map.get(dBObject2.getType());
        for (DBObject dBObject3 : collection) {
            dBObjectValidator.cascadeDelete(dBObject3, dBObject2);
        }
        dBObjectValidator.cascadeDelete(dBObject, dBObject2);
    }

    private void addCascadeItems(DBObject dBObject, DBObject dBObject2, Collection<DBObject> collection, Collection<DBObjectID> collection2) {
        Collection<DBObject> collection3 = this.findUsagesIn(dBObject, dBObject2);
        for (DBObject dBObject3 : collection3) {
            DBObjectID dBObjectID = dBObject3.getID();
            if (dBObjectID == null || collection2.contains(dBObjectID)) continue;
            collection2.add(dBObjectID);
            collection.add(dBObject3);
            this.addCascadeItems(dBObject3, dBObject2, collection, collection2);
        }
    }

    protected Collection<DBObject> findUsagesIn(DBObject dBObject, DBObject dBObject2) {
        return DBUtil.findUsagesIn((DBObject)dBObject, (DBObject)dBObject2);
    }

    protected DBObject getParentUpdatedObject() {
        Namespace namespace;
        Namespace namespace2;
        DBObject dBObject = null;
        if (ModelUtil.hasLength((String)this.getComponentFactory().getBasePath()) && (namespace2 = this.getDataContext()) != (namespace = namespace2.getParent())) {
            dBObject = (DBObject)namespace.find("NewChildObject");
        }
        if (dBObject == null) {
            dBObject = (DBObject)this.getUpdatedObject();
        }
        return dBObject;
    }

    protected final Collection<String> getChildNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ChildDBObject childDBObject : this.getChildren()) {
            arrayList.add(childDBObject.getName());
        }
        return arrayList;
    }

    protected String getNewChildBaseName() {
        String string;
        String string2 = this.getChildType();
        if (this.getProvider().getDescriptor().getCasePolicy() == 1) {
            string2 = string2.toLowerCase();
        }
        if (!(string = string2 + "1").equals(this.getProvider().getExternalName(string))) {
            string = string.replace(' ', '_');
        }
        return string;
    }

    protected boolean canChangeChildProperty() {
        boolean bl = true;
        Object t = this.getUpdatedObject();
        if (t instanceof SystemObject) {
            String string = this.getComponentFactory().getBasePath();
            String string2 = this.getChildProperty();
            String string3 = ModelUtil.hasLength((String)string) ? Property.createPath((String[])new String[]{string, string2}) : string2;
            PropertyAction propertyAction = this.getProvider().getPropertyManager().canChangeProperty((SystemObject)this.getOriginalObject(), (SystemObject)t, string3);
            bl = propertyAction != null;
        }
        return bl;
    }

    protected boolean preserveListOrder() {
        return true;
    }

    protected Comparator<? super C> getChildComparator() {
        return DBUtil.getNameComparator();
    }

    protected List<C> getChildList() {
        Comparator<C> comparator;
        ArrayList<ChildDBObject> arrayList;
        block5: {
            arrayList = new ArrayList<ChildDBObject>();
            DBObject dBObject = this.getParentUpdatedObject();
            String string = this.getChildProperty();
            try {
                comparator = this.getPropertyHelper().getPropertyValueOrFail((Object)dBObject, string);
                if (comparator == null) break block5;
                if (comparator instanceof DBObject[]) {
                    DBObject[] dBObjectArray = (DBObject[])comparator;
                    for (int i = 0; i < dBObjectArray.length; ++i) {
                        arrayList.add((ChildDBObject)dBObjectArray[i]);
                    }
                    break block5;
                }
                throw new IllegalStateException("property must be a list of child objects");
            }
            catch (MissingPropertyException missingPropertyException) {
                throw new IllegalStateException("no such property: " + string);
            }
        }
        if (!this.preserveListOrder() && (comparator = this.getChildComparator()) != null) {
            Collections.sort(arrayList, comparator);
        }
        return arrayList;
    }

    protected Namespace getChildDataContext() {
        if (this.m_childDataContext == null) {
            this.m_childDataContext = new Namespace(this.getDataContext());
        }
        this.m_childDataContext.put("NewChildObject", this.m_currentChild);
        return this.m_childDataContext;
    }

    private DocumentListener getChildDocListener() {
        if (this.m_childDocListener == null) {
            this.m_childDocListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    BaseChildrenEditorPanel.this.currentChildNameChangedImpl();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    BaseChildrenEditorPanel.this.currentChildNameChangedImpl();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    BaseChildrenEditorPanel.this.currentChildNameChangedImpl();
                }
            };
        }
        return this.m_childDocListener;
    }

    private void currentChildNameChangedImpl() {
        if (this.isEntered()) {
            this.currentChildNameChanged();
        }
    }

    protected void currentChildNameChanged() {
    }

    protected void enterChildPanel(C c) {
        this.m_currentChild = c;
        ChildObjectEditorPanel childObjectEditorPanel = this.getChildPanel();
        if (childObjectEditorPanel != null) {
            childObjectEditorPanel.onEntry(this.getChildDataContext());
            if (this.m_currentChild != null) {
                this.setChildPanelNameListenerEnabled(true);
            }
        }
    }

    private void setChildPanelNameListenerEnabled(boolean bl) {
        JTextComponent jTextComponent;
        ChildObjectEditorPanel childObjectEditorPanel = this.getChildPanel();
        if (childObjectEditorPanel != null && (jTextComponent = childObjectEditorPanel.getNameField()) != null) {
            DocumentListener documentListener = this.getChildDocListener();
            jTextComponent.getDocument().removeDocumentListener(documentListener);
            if (bl) {
                jTextComponent.getDocument().addDocumentListener(documentListener);
            }
        }
    }

    protected boolean exitChildPanel() {
        boolean bl = true;
        ChildObjectEditorPanel childObjectEditorPanel = this.getChildPanel();
        if (childObjectEditorPanel != null && this.getCurrentChild() != null) {
            try {
                childObjectEditorPanel.onExit(this.getChildDataContext());
                this.setChildPanelNameListenerEnabled(false);
            }
            catch (TraversalException traversalException) {
                bl = false;
                traversalException.showMessageDialog((Component)((Object)this));
            }
        }
        return bl;
    }

    protected void commitChildProperty() {
        this.getPropertyHelper().setPropertyValue((Object)this.getParentUpdatedObject(), this.getChildProperty(), (Object)this.getChildren());
    }

    protected abstract C[] getChildren();

    protected final C getInitialChild(C c) {
        ChildDBObject childDBObject = null;
        ChildDBObject[] childDBObjectArray = this.getChildren();
        if (childDBObjectArray.length > 0) {
            ChildDBObject childDBObject2 = (ChildDBObject)this.getInitialSelection(this.getChildClass());
            if (childDBObject2 != null) {
                childDBObject = this.findChild(childDBObject2, childDBObjectArray);
            }
            if (childDBObject == null && c != null) {
                childDBObject = this.findChild((ChildDBObject)c, childDBObjectArray);
            }
            if (childDBObject == null) {
                childDBObject = childDBObjectArray[0];
            }
        }
        return (C)childDBObject;
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        ChildObjectEditorPanel childObjectEditorPanel;
        boolean bl = false;
        DBEditorConfig dBEditorConfig = this.getEditorConfig();
        if (this.isInitialSelectionProcessed() && dBEditorConfig.getProperty() != null && (childObjectEditorPanel = this.getChildPanel()) != null) {
            bl = childObjectEditorPanel.requestFocusForEditorConfig();
        }
        if (!bl) {
            bl = super.requestFocusForEditorConfig();
        }
        return bl;
    }

    protected C findChild(C c, C[] CArray) {
        C c2 = null;
        C c3 = null;
        for (int i = 0; i < CArray.length; ++i) {
            if (CArray[i] == c) {
                c2 = CArray[i];
                break;
            }
            if (c3 != null || !DBUtil.areNamesAndTypesEqual(CArray[i], c)) continue;
            c3 = CArray[i];
        }
        return c2 != null ? c2 : c3;
    }

    @Override
    public void saveSettings(PropertyAccess propertyAccess) {
        super.saveSettings(propertyAccess);
        C c = this.getCurrentChild();
        if (c != null) {
            propertyAccess.setProperty(NAME_SETTINGS_KEY, c.getName());
        }
    }

    @Override
    protected void loadSettings(PropertyAccess propertyAccess) {
        ChildDBObject[] childDBObjectArray;
        super.loadSettings(propertyAccess);
        String string = propertyAccess.getProperty(NAME_SETTINGS_KEY, null);
        if (string != null && (childDBObjectArray = this.getChildren()) != null) {
            for (ChildDBObject childDBObject : childDBObjectArray) {
                if (childDBObject == null || !childDBObject.getName().equals(string)) continue;
                this.selectChild(childDBObject);
                break;
            }
        }
    }
}

