/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.db.panels.DBTraversable;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.property.Property;
import oracle.javatools.ui.Header;

public class DBNavigable
extends Navigable {
    private WeakReference<Traversable> m_traversable;
    private boolean m_incHeader;
    private Namespace m_dataContext;
    private Collection<String> m_properties;

    private DBNavigable() {
    }

    public DBNavigable(String string, Class<? extends Traversable> clazz) {
        super(string, clazz);
    }

    public DBNavigable(String string, Class<? extends Traversable> clazz, Class[] classArray, Object[] objectArray) {
        super(string, clazz, classArray, objectArray, null);
    }

    public DBNavigable(Navigable navigable, boolean bl) {
        navigable.copyTo((Object)this);
        this.setIncludeHeader(bl);
    }

    public void setIncludeHeader(boolean bl) {
        this.m_incHeader = bl;
    }

    public void setProperties(Collection<String> collection) {
        this.m_properties = collection;
    }

    public Collection<String> getProperties() {
        Traversable traversable;
        if (this.m_properties == null && this.m_traversable != null && this.m_dataContext != null && (traversable = (Traversable)this.m_traversable.get()) instanceof BaseEditorPanel) {
            this.m_properties = ((BaseEditorPanel)traversable).getComponentFactory().getPaths();
        }
        return this.m_properties;
    }

    public boolean isPanelProperty(String string) {
        boolean bl = false;
        if (this.m_properties != null) {
            for (String string2 : this.m_properties) {
                if (string2 == null || !string2.equals(string) && !Property.startsWith((String)string2, (String[])new String[]{string})) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected void setDataScope(Namespace namespace) {
        super.setDataScope(namespace);
        this.m_dataContext = namespace;
    }

    protected Traversable newTraversable() {
        Traversable traversable = null;
        if (this.m_traversable != null) {
            traversable = (Traversable)this.m_traversable.get();
        }
        if (traversable == null) {
            traversable = super.newTraversable();
            if (this.m_incHeader) {
                traversable = new FlatTraversable(this, traversable);
            }
            this.m_traversable = new WeakReference<Traversable>(traversable);
        }
        return traversable;
    }

    public Object copyTo(Object object) {
        if (object == null) {
            object = new DBNavigable();
        }
        super.copyTo(object);
        if (object instanceof DBNavigable) {
            ((DBNavigable)((Object)object)).m_properties = this.m_properties;
            ((DBNavigable)((Object)object)).m_incHeader = this.m_incHeader;
        }
        return object;
    }

    private static class FlatTraversable
    implements DBTraversable {
        private final Navigable m_navigable;
        private final Traversable m_delegate;
        private JScrollPane m_scrollPane;

        FlatTraversable(Navigable navigable, Traversable traversable) {
            this.m_navigable = navigable;
            this.m_delegate = traversable;
        }

        public Component getComponent() {
            if (this.m_scrollPane == null) {
                JPanel jPanel = new JPanel();
                jPanel.setMinimumSize(new Dimension(400, 400));
                Header header = new Header();
                header.setLevel(Header.Level.PAGE);
                header.setText(this.m_navigable.getShortLabel());
                header.setIcon(this.m_navigable.getIcon());
                DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(jPanel, true);
                dBUILayoutHelper.add((Component)header, 1, 1, false, false);
                dBUILayoutHelper.nextRow();
                Component component = this.m_delegate.getComponent();
                dBUILayoutHelper.add(component, 1, 1, true, true);
                jPanel.setName(component.getName() + "FlatWrapper");
                dBUILayoutHelper.layout();
                this.m_scrollPane = DBUILayoutHelper.createFlatScrollPane(jPanel);
            }
            return this.m_scrollPane;
        }

        @Override
        public Object getExitTransition() {
            return null;
        }

        public String getHelpID() {
            return this.m_delegate.getHelpID();
        }

        public void onEntry(TraversableContext traversableContext) {
            try {
                this.m_delegate.onEntry(traversableContext);
            }
            catch (Exception exception) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Error entering panel", exception);
            }
        }

        public void onExit(TraversableContext traversableContext) throws TraversalException {
            try {
                this.m_delegate.onExit(traversableContext);
            }
            catch (TraversalException traversalException) {
                throw traversalException;
            }
            catch (Exception exception) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Error exiting panel", exception);
            }
        }

        @Override
        public Component getDefaultFocusComponent() {
            return this.m_delegate instanceof DBTraversable ? ((DBTraversable)this.m_delegate).getDefaultFocusComponent() : null;
        }

        @Override
        public boolean requestFocusForEditorConfig() {
            return this.m_delegate instanceof DBTraversable ? ((DBTraversable)this.m_delegate).requestFocusForEditorConfig() : false;
        }
    }
}

