/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.ExtendedPartitionType;
import oracle.ideimpl.db.panels.partition.HashPartitionPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;

abstract class AbstractPartitionPanel<T extends DBObject>
extends BaseEditorPanel<T> {
    private final ChildSelectableComponentEditorPanel m_chooserPanel;
    private final HashPartitionPanel m_hashPanel;
    private final JPanel m_container;
    private static final String HASH_PANEL = "Hash";
    private static final String RANGE_AND_LIST_PANEL = "RangeAndList";

    AbstractPartitionPanel(String string, ChildSelectableComponentEditorPanel childSelectableComponentEditorPanel, HashPartitionPanel hashPartitionPanel) {
        super(string);
        this.m_chooserPanel = childSelectableComponentEditorPanel;
        this.m_hashPanel = hashPartitionPanel;
        this.m_container = new JPanel(new CardLayout());
        this.m_container.add((Component)((Object)this.m_chooserPanel), RANGE_AND_LIST_PANEL);
        this.m_container.add((Component)((Object)this.m_hashPanel), HASH_PANEL);
    }

    @Override
    public void initialiseComponents() {
        super.initialiseComponents();
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        this.layoutComponents(dBUILayoutHelper);
        dBUILayoutHelper.layout();
    }

    protected ChildSelectableComponentEditorPanel getPartitionChooserPanel() {
        return this.m_chooserPanel;
    }

    protected void layoutComponents(DBUILayoutHelper dBUILayoutHelper) {
        dBUILayoutHelper.add(this.m_container, 4, 1, true, true);
    }

    @Override
    protected void initialisePanel() {
        ExtendedPartitionType extendedPartitionType = this.getExtendedPartitionType();
        CardLayout cardLayout = (CardLayout)this.m_container.getLayout();
        boolean bl = extendedPartitionType.isLocalIndex();
        if (extendedPartitionType.isHash() && !bl) {
            cardLayout.show(this.m_container, HASH_PANEL);
            this.m_hashPanel.onEntry((TraversableContext)this.getDataContext());
        } else if (extendedPartitionType.isRange() || extendedPartitionType.isList() || extendedPartitionType.isReference() || bl) {
            cardLayout.show(this.m_container, RANGE_AND_LIST_PANEL);
            this.m_chooserPanel.onEntry((TraversableContext)this.getDataContext());
            this.initChooserPanel(this.m_chooserPanel);
        } else {
            throw new IllegalStateException("Attempting to access subpartitions for a table that doesn't have subpartitioning");
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        ExtendedPartitionType extendedPartitionType = this.getExtendedPartitionType();
        if (extendedPartitionType != null) {
            boolean bl = extendedPartitionType.isLocalIndex();
            CardLayout cardLayout = (CardLayout)this.m_container.getLayout();
            if (extendedPartitionType.isHash() && !bl) {
                cardLayout.show(this.m_container, HASH_PANEL);
                this.m_hashPanel.onExit((TraversableContext)this.getDataContext());
            } else if (extendedPartitionType.isRange() || extendedPartitionType.isList() || extendedPartitionType.isReference() || bl) {
                cardLayout.show(this.m_container, RANGE_AND_LIST_PANEL);
                this.m_chooserPanel.onExit((TraversableContext)this.getDataContext());
            } else {
                throw new IllegalStateException("Attempting to access subpartitions for a table that doesn't have subpartitioning");
            }
        }
    }

    protected ExtendedPartitionType getExtendedPartitionType() {
        ExtendedPartitionType extendedPartitionType = null;
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)this.getUpdatedObject().getProperty("OracleTablePartitions");
        if (oracleTablePartitions != null) {
            extendedPartitionType = ExtendedPartitionType.getType((DBObject)oracleTablePartitions);
        } else {
            OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)this.getUpdatedObject().getProperty("OracleIndexPartitions");
            if (oracleIndexPartitions != null) {
                extendedPartitionType = ExtendedPartitionType.getType((DBObject)oracleIndexPartitions);
            }
        }
        return extendedPartitionType;
    }

    @Override
    protected void validateObject() throws TraversalException {
    }

    protected void initChooserPanel(ChildSelectableComponentEditorPanel childSelectableComponentEditorPanel) {
    }
}

