/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.Box;
import javax.swing.JComboBox;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.controls.ValuesPropertyPanel;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.partition.TablePartitionPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ReferencePartitionHelper;

class PartitionByPanel
extends BaseEditorPanel<Table> {
    private final TablePartitionPanel m_parent;
    private final Component m_glue = Box.createHorizontalGlue();

    PartitionByPanel(TablePartitionPanel tablePartitionPanel) {
        this.m_parent = tablePartitionPanel;
    }

    public String getName() {
        return UIBundle.get("PARTITIONS_SUBTAB_BY");
    }

    @Override
    public void initialiseComponents() {
        super.initialiseComponents();
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        ComponentWrapper componentWrapper = this.getOrCreateWrapper(PartitionProperty.PARTITION_TYPE);
        dBUILayoutHelper.add(componentWrapper.getLabel(), 1, 1, false, false);
        dBUILayoutHelper.add(componentWrapper.getComponent(), 1, 1, false, false);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper2 = this.getOrCreateWrapper(PartitionProperty.PARTITION_COLS);
        dBUILayoutHelper.add(componentWrapper2.getLabel(), 1, 1, false, false);
        dBUILayoutHelper.add(componentWrapper2.getComponent(), 1, 1, true, true);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper3 = this.getOrCreateWrapper(PartitionProperty.REFERENCE_CONSTRAINT);
        dBUILayoutHelper.addChildren((Component)componentWrapper3.getActiveComponent(), new Integer[0]);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper4 = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_TYPE);
        componentWrapper4.getLabel().setText(UIBundle.get("SUBPARTITION_TYPE_LABEL"));
        dBUILayoutHelper.add(componentWrapper4.getLabel(), 1, 1, false, false);
        dBUILayoutHelper.add(componentWrapper4.getComponent(), 1, 1, false, false);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper5 = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_COLS);
        dBUILayoutHelper.add(componentWrapper5.getLabel(), 1, 1, false, false);
        dBUILayoutHelper.add(componentWrapper5.getComponent(), 1, 1, true, true);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.m_glue, 2, 1, true, true);
        dBUILayoutHelper.layout();
        componentWrapper.addListener(propertyChangeEvent -> this.processPartitionTypeChange());
        componentWrapper2.addListener(propertyChangeEvent -> this.processPartitionColsChange(propertyChangeEvent, PartitionProperty.PARTITION_COLS));
        componentWrapper3.addListener(propertyChangeEvent -> this.processPropertyChange(PartitionProperty.REFERENCE_CONSTRAINT));
        componentWrapper4.addListener(propertyChangeEvent -> this.processPropertyChange(PartitionProperty.SUBPARTITION_TYPE));
        componentWrapper5.addListener(propertyChangeEvent -> this.processPartitionColsChange(propertyChangeEvent, PartitionProperty.SUBPARTITION_COLS));
    }

    @Override
    public void initialisePanel() {
        this.enableControls();
    }

    private void processPropertyChange(String string) {
        if (string.equals(PartitionProperty.SUBPARTITION_TYPE)) {
            ComponentWrapper componentWrapper = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_COLS);
            componentWrapper.setPropertyValue(new String[0]);
        }
        this.enableControls();
    }

    private void processPartitionColsChange(PropertyChangeEvent propertyChangeEvent, String string) {
        Object[] objectArray = (Object[])propertyChangeEvent.getNewValue();
        ValuesPropertyPanel.updateTablePartitionMaxValues(objectArray.length, (Table)this.getUpdatedObject(), string.equals(PartitionProperty.SUBPARTITION_COLS));
        this.enableControls();
    }

    private void processPartitionTypeChange() {
        ComponentWrapper componentWrapper = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_TYPE);
        ComponentWrapper componentWrapper2 = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_COLS);
        ComponentWrapper componentWrapper3 = this.getOrCreateWrapper(PartitionProperty.PARTITION_COLS);
        ComponentWrapper componentWrapper4 = this.getOrCreateWrapper(PartitionProperty.REFERENCE_CONSTRAINT);
        componentWrapper.refreshObject(componentWrapper.getComponentContext().getUpdatedObject());
        componentWrapper2.setPropertyValue(new String[0]);
        componentWrapper.setPropertyValue(null);
        componentWrapper3.setPropertyValue(new String[0]);
        componentWrapper4.setPropertyValue(null);
        this.getComponentFactory().processComponents();
        this.enableControls();
    }

    private void enableControls() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        ComponentWrapper componentWrapper = this.getOrCreateWrapper(PartitionProperty.PARTITION_COLS);
        ComponentWrapper componentWrapper2 = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_TYPE);
        ComponentWrapper componentWrapper3 = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_COLS);
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        boolean bl4 = this.hasPartitionTypeSet(oracleTablePartitions);
        boolean bl5 = bl3 = bl4 && this.hasPartitionColumns(oracleTablePartitions);
        boolean bl6 = bl4 && oracleTablePartitions.getReferenceConstraintID() != null && ReferencePartitionHelper.isValidReferenceConstraintID((OracleTablePartitions)oracleTablePartitions, (!(this.getProvider() instanceof Database) ? 1 : 0) != 0) ? true : (bl2 = false);
        boolean bl7 = bl4 && this.hasPartitionTypeSet(oracleTablePartitions == null ? null : oracleTablePartitions.getSubpartitionModel()) ? true : (bl = false);
        boolean bl8 = bl && this.hasPartitionColumns(oracleTablePartitions == null ? null : oracleTablePartitions.getSubpartitionModel());
        Object t = componentWrapper2.getActiveComponent();
        boolean bl9 = t instanceof JComboBox ? ((JComboBox)t).getItemCount() > 1 : true;
        componentWrapper.setEnabled(bl4);
        componentWrapper2.setEnabled(bl4 && bl9);
        componentWrapper3.setEnabled(bl && bl9);
        this.m_parent.enablePartitionDefintionTab(bl3 || bl2 || bl4 && oracleTablePartitions.getPartitions().length > 0);
        this.m_parent.enableSubpartitionTemplateTab(bl8 || bl && oracleTablePartitions.getSubpartitionModel().getPartitions().length > 0);
        if (!bl4 || oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
            this.m_glue.setVisible(true);
        } else {
            this.m_glue.setVisible(false);
        }
    }

    private boolean hasPartitionTypeSet(OracleTablePartitions oracleTablePartitions) {
        boolean bl = false;
        if (oracleTablePartitions != null && oracleTablePartitions.getProperty("partitionType") != null) {
            bl = true;
        }
        return bl;
    }

    private boolean hasPartitionColumns(OracleTablePartitions oracleTablePartitions) {
        boolean bl = false;
        if (oracleTablePartitions != null) {
            DBObjectID[] dBObjectIDArray = (DBObjectID[])oracleTablePartitions.getProperty("partitionColumns");
            bl = dBObjectIDArray != null && dBObjectIDArray.length > 0;
        }
        return bl;
    }
}

