/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.plsql;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.ui.table.GenericTableCellRenderer;

class PlSqlParametersPanel
extends ChildTableEditorPanel<PlSqlParameter, Procedure> {
    private DTRefCellRenderer m_renderer;

    PlSqlParametersPanel() {
        super("PlSqlParametersPanel");
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        if (this.m_renderer == null) {
            this.m_renderer = new DTRefCellRenderer();
            this.setDefaultRenderer(PlSqlReference.class, (TableCellRenderer)((Object)this.m_renderer));
        }
    }

    @Override
    protected String[] getPropertiesForRow() {
        return new String[]{"name", "mode", "noCopy", "dataTypeReference", "defaultValue"};
    }

    @Override
    protected PlSqlParameter newChild() {
        PlSqlParameter plSqlParameter = (PlSqlParameter)this.getProvider().getObjectFactory().newObject(this.getChildClass());
        plSqlParameter.setName(DBUtil.getUniqueName(this.getWrapperTableModel().getRowNames(), (String)this.getNewChildBaseName()));
        plSqlParameter.setMode(PlSqlParameter.Mode.IN);
        DataTypeUsage dataTypeUsage = this.getProvider().getDescriptor().createDefaultTypeUsage();
        String string = DBUtil.getDBObjectName((DBObjectID)dataTypeUsage.getDataTypeID());
        PlSqlReference plSqlReference = DataTypeHelper.getDataTypeRefForString((DBObjectProvider)this.getProvider(), null, (String)string);
        plSqlParameter.setDataTypeReference(plSqlReference);
        return plSqlParameter;
    }

    protected void removeChild(PlSqlParameter plSqlParameter) {
        ((Procedure)this.getUpdatedObject()).removeParameter(plSqlParameter);
    }

    @Override
    protected String getChildProperty() {
        return "parameters";
    }

    @Override
    protected Class<PlSqlParameter> getChildClass() {
        return PlSqlParameter.class;
    }

    @Override
    protected String getNewChildBaseName() {
        return "PARAM1";
    }

    @Override
    protected void validateObject() throws TraversalException {
        if (((Procedure)this.getUpdatedObject()).getSource() != null) {
            super.validateObject();
        }
    }

    @Override
    protected Collection<DBObject> findUsagesIn(DBObject dBObject, DBObject dBObject2) {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject3 : super.findUsagesIn(dBObject, dBObject2)) {
            if (dBObject3 instanceof PlSqlReference) continue;
            arrayList.add(dBObject3);
        }
        return arrayList;
    }

    private class DTRefCellRenderer
    extends GenericTableCellRenderer {
        private DTRefCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof PlSqlReference) {
                PlSqlReference plSqlReference = (PlSqlReference)object;
                DBObjectProvider dBObjectProvider = PlSqlParametersPanel.this.getProvider();
                Schema schema = null;
                try {
                    schema = dBObjectProvider.getDefaultSchema();
                }
                catch (DBException dBException) {
                    PlSqlParametersPanel.this.getLogger().warning(dBException.getMessage());
                }
                String string = DataTypeHelper.getTypeStringFromRef((PlSqlReference)plSqlReference, (Schema)schema, (DBObjectProvider)dBObjectProvider);
                ((JLabel)component).setText(string);
            }
            return component;
        }
    }
}

