/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.insight.completion.DBCompletionSupportFactory;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.db.util.SchemaObjectBuilder;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryOwner;

public abstract class BaseSQLQueryBuilderPanel
extends BaseEditorPanel<SQLQueryOwner> {
    private boolean m_declarativeLayoutDone;

    protected BaseSQLQueryBuilderPanel() {
    }

    protected abstract void layoutComponents();

    @Override
    public final void initialisePanel() {
        SQLQueryBuilder sQLQueryBuilder;
        Namespace namespace = this.getDataContext();
        DBEditorConfig dBEditorConfig = (DBEditorConfig)namespace.get(DBEditorConfig.class);
        SQLQuery sQLQuery = this.requiresDeclarativeQuery() ? BaseSQLQueryBuilderPanel.findAndBuildQuery(dBEditorConfig) : BaseSQLQueryBuilderPanel.findQuery(dBEditorConfig);
        String string = this.getLayoutOnlyMessage(sQLQuery, sQLQueryBuilder = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)sQLQuery, (DBObjectProvider)this.getProvider(), (Schema)dBEditorConfig.getSchema()));
        if (string != null) {
            BaseSQLQueryBuilderPanel.layoutMessageOnly((JPanel)((Object)this), string);
            this.m_declarativeLayoutDone = false;
        } else {
            if (!this.m_declarativeLayoutDone) {
                this.layoutComponents();
                this.m_declarativeLayoutDone = true;
            }
            SQLFragment sQLFragment = this.getInitialSelection(SQLFragment.class);
            this.init(sQLQueryBuilder, (DBObject)sQLFragment);
        }
        this.validate();
    }

    protected String getLayoutOnlyMessage(SQLQuery sQLQuery, SQLQueryBuilder sQLQueryBuilder) {
        String string = null;
        if (this.requiresDeclarativeQuery() && (sQLQueryBuilder == null || !sQLQuery.isDeclarative())) {
            string = UIBundle.get("QUERY_DECL_FAIL");
        }
        return string;
    }

    protected boolean requiresDeclarativeQuery() {
        return true;
    }

    protected abstract void init(SQLQueryBuilder var1, DBObject var2);

    protected SQLQuery findQuery() {
        return BaseSQLQueryBuilderPanel.findQuery(this.getEditorConfig());
    }

    @Override
    protected void validateObject() throws TraversalException {
    }

    protected CompletionSupport getCompletionSupport(JTextComponent jTextComponent) {
        Namespace namespace = this.getDataContext();
        DBEditorConfig dBEditorConfig = (DBEditorConfig)namespace.get(DBEditorConfig.class);
        SQLQuery sQLQuery = this.requiresDeclarativeQuery() ? BaseSQLQueryBuilderPanel.findAndBuildQuery(dBEditorConfig) : BaseSQLQueryBuilderPanel.findQuery(dBEditorConfig);
        DBInsightContext dBInsightContext = new DBInsightContext();
        dBInsightContext.setProvider(this.getProvider());
        dBInsightContext.setContextObject((DBObject)sQLQuery);
        Context context = (Context)namespace.getRoot().get(Context.class);
        if (context == null) {
            context = Context.newIdeContext();
        }
        return DBCompletionSupportFactory.getCompletionSupport(dBInsightContext, context, jTextComponent);
    }

    protected static void addText(JTextComponent jTextComponent, String string) {
        int n;
        if (jTextComponent.getSelectedText() == null) {
            n = jTextComponent.getCaretPosition();
            if (n > 0) {
                try {
                    String string2 = jTextComponent.getText(n - 1, 1);
                    if (!(" ".equals(string2) || "(".equals(string2) || "\n".equals(string2))) {
                        string = " " + string;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        } else {
            n = jTextComponent.getSelectionStart();
        }
        jTextComponent.replaceSelection(string);
        int n2 = string.contains("(") ? n + string.indexOf("(") + 1 : n + string.length();
        jTextComponent.setCaretPosition(n2);
    }

    protected static SQLQuery findAndBuildQuery(DBEditorConfig dBEditorConfig) {
        SQLQuery sQLQuery = BaseSQLQueryBuilderPanel.findQuery(dBEditorConfig);
        SchemaObjectBuilder schemaObjectBuilder = new SchemaObjectBuilder(true);
        schemaObjectBuilder.buildDerivedProperties(dBEditorConfig.getProvider());
        try {
            schemaObjectBuilder.ensureObjectBuiltEx(new DBObject[]{sQLQuery});
        }
        catch (DBException dBException) {
            DBLog.getLogger(BaseSQLQueryBuilderPanel.class).fine(dBException.getMessage());
        }
        return sQLQuery;
    }

    protected static SQLQuery findQuery(DBEditorConfig dBEditorConfig) {
        SystemObject systemObject = dBEditorConfig.getUpdatedObject();
        if (systemObject == null) {
            systemObject = dBEditorConfig.getChildObject();
        }
        SQLQuery sQLQuery = null;
        if (systemObject instanceof SQLQuery) {
            sQLQuery = (SQLQuery)systemObject;
        } else if (systemObject instanceof SQLQueryOwner) {
            sQLQuery = ((SQLQueryOwner)systemObject).getSQLQuery();
        }
        return sQLQuery;
    }

    static void layoutMessageOnly(JPanel jPanel, String string) {
        jPanel.removeAll();
        jPanel.setLayout(new BorderLayout());
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(string);
        jTextPane.getAccessibleContext().setAccessibleName(string);
        jTextPane.getAccessibleContext().setAccessibleDescription("");
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setEnabled(true);
        jTextPane.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add((Component)jTextPane, "Center");
    }
}

