/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import javax.swing.JPanel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.SelectDBObjectsPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;

public abstract class BaseSQLQueryPickerPanel
extends SelectDBObjectsPanel {
    private String[] m_types;
    private SQLQueryBuilder m_builder;
    private boolean m_declarativeLayoutDone;
    private SchemaObject m_sObj;
    private boolean m_canAlwaysNext = true;
    private Namespace m_dataContext;

    protected BaseSQLQueryPickerPanel() {
    }

    protected BaseSQLQueryPickerPanel(boolean bl) {
        this.m_canAlwaysNext = bl;
    }

    protected final Namespace getDataContext() {
        return this.m_dataContext;
    }

    protected final SQLQueryBuilder getBuilder() {
        return this.m_builder;
    }

    protected final SchemaObject getSchemaObject() {
        DBEditorConfig dBEditorConfig = (DBEditorConfig)this.m_dataContext.get(DBEditorConfig.class);
        SystemObject systemObject = dBEditorConfig.getUpdatedObject();
        if (systemObject == null) {
            systemObject = dBEditorConfig.getChildObject();
        }
        return DBUtil.getSchemaObject((DBObject)systemObject);
    }

    @Override
    protected final String[] getAvailableTypes() {
        if (this.m_types == null) {
            this.m_types = new String[]{"ALIAS", "MATERIALIZED VIEW", "SYNONYM", "TABLE", "VIEW"};
        }
        return this.m_types;
    }

    @Override
    public final void init(boolean bl, TraversableContext traversableContext) {
        DBEditorConfig dBEditorConfig = (DBEditorConfig)traversableContext.get(DBEditorConfig.class);
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        this.m_dataContext = traversableContext;
        super.init(bl, traversableContext);
        SQLQuery sQLQuery = BaseSQLQueryBuilderPanel.findAndBuildQuery(dBEditorConfig);
        this.m_builder = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)sQLQuery, (DBObjectProvider)this.getProvider(), (Schema)dBEditorConfig.getSchema());
        String string = this.getLayoutOnlyMessage(sQLQuery, this.m_builder);
        if (string != null) {
            this.clearToPicker();
            this.getShuttle().setEnabled(false);
            BaseSQLQueryBuilderPanel.layoutMessageOnly((JPanel)((Object)this), string);
            this.m_declarativeLayoutDone = false;
        } else {
            if (!this.m_declarativeLayoutDone) {
                this.removeAll();
                this.layoutComponents();
                this.m_declarativeLayoutDone = true;
            }
            this.getShuttle().setEnabled(true);
            this.initToPicker(this.m_builder, this.getProvider(), dBEditorConfig.getSchema());
        }
    }

    protected String getLayoutOnlyMessage(SQLQuery sQLQuery, SQLQueryBuilder sQLQueryBuilder) {
        String string = null;
        if (this.m_builder == null || !sQLQuery.isDeclarative()) {
            string = UIBundle.get("QUERY_DECL_FAIL");
        } else if (sQLQuery.getSetOperator() != null) {
            string = UIBundle.get("QUICK_PICK_AND_SET_CANT_SET");
        }
        return string;
    }

    protected abstract void clearToPicker();

    protected abstract void initToPicker(SQLQueryBuilder var1, DBObjectProvider var2, Schema var3);

    @Override
    public final void commit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_builder != null) {
            this.commitToPicker(traversableContext);
        }
    }

    protected abstract void commitToPicker(TraversableContext var1) throws TraversalException;

    @Override
    protected boolean canFinish() {
        return true;
    }

    @Override
    protected boolean canAlwaysNext() {
        return this.m_canAlwaysNext;
    }
}

