/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.FastStringBuffer;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ideimpl.db.panels.sql.WhereEditor;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

public class HavingPanel
extends BaseSQLQueryBuilderPanel {
    private JPanel m_center;
    private WhereEditor m_whereEditor = new WhereEditor("HavingPanel", this);
    private JWrappedLabel m_desc = new JWrappedLabel();
    private JWrappedLabel m_groupBy = new JWrappedLabel();
    private JLabel m_labelGROUPBY = new JLabel("<html><b>GROUP BY</b></html>");
    private JLabel m_labelHAVING = new JLabel();
    private boolean m_havingAllowedLayout;
    private GroupByObject m_gbo;
    private SQLQueryBuilder m_builder;

    @Override
    protected String getLayoutOnlyMessage(SQLQuery sQLQuery, SQLQueryBuilder sQLQueryBuilder) {
        String string = super.getLayoutOnlyMessage(sQLQuery, sQLQueryBuilder);
        if (string == null) {
            if (sQLQuery.getSetOperator() != null) {
                string = UIBundle.get("HAVING_AND_SET_CANT_SET");
            } else if (sQLQuery.getGroupByObject() == null) {
                string = UIBundle.get("HAVING_NO_GROUPBY");
            }
        }
        return string;
    }

    @Override
    protected void layoutComponents() {
        this.removeAll();
        this.setLayout(new BorderLayout(0, 15));
        this.m_desc.setText(UIBundle.get("HAVING_DESC"));
        this.add((Component)this.m_desc, "North");
        if (this.m_center == null) {
            DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("HavingPanel");
            this.m_center = new JPanel();
            this.m_center.setLayout(new GridBagLayout());
            dBUIResourceHelper.setName(this.m_center, "HavingPanel");
            this.m_center.add((Component)this.m_labelGROUPBY, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.m_center.add((Component)this.m_groupBy, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0));
            dBUIResourceHelper.resLabel(this.m_labelHAVING, this.m_whereEditor.getDefaultComponent(), "&HAVING", "Having");
            this.m_labelHAVING.setText("<html><b><u>H</u>AVING</b></html>");
            this.m_center.add((Component)this.m_labelHAVING, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.m_center.add((Component)this.m_whereEditor, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add(this.m_center, "Center");
    }

    @Override
    protected void init(SQLQueryBuilder sQLQueryBuilder, DBObject dBObject) {
        this.m_builder = sQLQueryBuilder;
        this.m_whereEditor.setTemplates(this.m_builder.getSQLQuery().getFromObjects(), null);
        this.m_whereEditor.setDBObjectProvider(this.getProvider());
        this.m_gbo = this.m_builder.getSQLQuery().getGroupByObject();
        if (this.m_gbo != null) {
            SQLFragment[] sQLFragmentArray = this.m_gbo.getExpressions();
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            for (int i = 0; i < sQLFragmentArray.length; ++i) {
                fastStringBuffer.append(sQLFragmentArray[i].getSQLText());
                if (i >= sQLFragmentArray.length - 1) continue;
                fastStringBuffer.append(", ");
            }
            this.m_groupBy.setText(fastStringBuffer.toString());
            this.m_whereEditor.setTemplates(this.m_builder.listAllFromObjects(), this.m_builder.listAvailableFKs());
            WhereObject whereObject = this.m_gbo.getHaving();
            this.m_whereEditor.init(whereObject, this.m_builder);
        }
    }

    @Override
    public void commitPanel() throws TraversalException {
        TraversableContext traversableContext = (TraversableContext)this.getDataContext();
        if (this.m_builder != null && this.m_whereEditor.isEnabled() && this.m_gbo != null && this.m_whereEditor.hasTextChanged()) {
            String string = this.m_whereEditor.getWhereText();
            if (ModelUtil.hasLength((String)string)) {
                try {
                    SQLFragment sQLFragment = this.m_builder.parseHavingExpression(string);
                    if (!(sQLFragment instanceof WhereObject)) {
                        sQLFragment = new WhereObject(sQLFragment);
                    }
                    this.m_builder.setHavingObject((WhereObject)sQLFragment);
                }
                catch (SQLQueryException sQLQueryException) {
                    throw new TraversalException(sQLQueryException.getMessage());
                }
            } else if (this.m_builder.getSQLQuery().getGroupByObject() != null) {
                this.m_builder.setHavingObject(null);
            }
        }
    }
}

