/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.sql.SQLQueryEditDialog;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ideimpl.db.panels.sql.ExpressionPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.InvalidAliasException;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.util.ModelUtil;

public class SelectObjectsPanel
extends BaseSQLQueryBuilderPanel
implements ExpressionPanel.FragmentProvider,
DocumentListener,
ActionListener {
    public static final String FUNCTIONS_CAT = UIBundle.get("EXP_FUNCTIONS");
    private boolean m_init;
    private SQLQueryBuilder m_builder;
    private JWrappedLabel m_desc = new JWrappedLabel(UIBundle.get("SELECT_DESC"));
    private ExpressionPanel m_expPanel;
    private JLabel m_lblSelectType = new JLabel();
    private JComboBox m_cmbSelectType = new JComboBox();
    private DefaultComboBoxModel m_mdlSelectType = new NonNullableComboBoxModel();
    private JPanel m_editor;
    private JTextField m_expression = new JTextField();
    private CompletionSupport m_completionSupport;
    private JTextField m_alias = new JTextField();
    private JLabel m_expLabel = new JLabel();
    private JLabel m_aliasLabel = new JLabel();
    private JButton m_validate = new JButton();
    private JButton m_editQuery = new JButton(new EditQueryAction());
    private JButton m_btnSubQuery = new JButton(new AddQueryAction());
    private JTextArea m_subQueryText = new JTextArea();
    private JLabel m_subQueryLabel = new JLabel(UIBundle.get("EXP_SUBQUERY"));
    private JScrollPane m_scrollPane = new JScrollPane(this.m_subQueryText);
    private ControlBar m_toolbar = new ControlBar();
    ComponentWithTitlebar m_compTitleBar = new ComponentWithTitlebar((JComponent)this.m_scrollPane, this.m_subQueryLabel, this.m_toolbar);
    private boolean m_commitPending;
    private SelectObject m_current;
    private boolean m_new;
    private boolean m_showSelectType;
    private DBUIResourceHelper m_reshelp;

    @Override
    protected String getLayoutOnlyMessage(SQLQuery sQLQuery, SQLQueryBuilder sQLQueryBuilder) {
        String string = super.getLayoutOnlyMessage(sQLQuery, sQLQueryBuilder);
        if (string == null && sQLQuery.getSetOperator() != null) {
            string = UIBundle.get("SELECT_AND_SET_CANT_SET");
        }
        return string;
    }

    @Override
    protected void layoutComponents() {
        if (this.m_mdlSelectType.getSize() == 0) {
            this.m_mdlSelectType.addElement(UIBundle.get("SELECT_INFO_LABEL_EXPRESSION"));
            this.m_mdlSelectType.addElement(UIBundle.get("SELECT_INFO_LABEL_SUBQUERY"));
        }
        this.m_mdlSelectType.setSelectedItem(UIBundle.get("SELECT_INFO_LABEL_EXPRESSION"));
        this.removeAll();
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.m_desc, "North");
        this.m_expPanel = new ExpressionPanel(this);
        this.add(this.m_expPanel, "Center");
    }

    @Override
    protected void init(SQLQueryBuilder sQLQueryBuilder, DBObject dBObject) {
        this.m_builder = sQLQueryBuilder;
        List list = this.getProvider().getDescriptor().listBuiltInFunctions();
        if (!this.m_init) {
            this.m_expPanel.setDBObjectProvider(this.getProvider());
            this.m_expPanel.addFunctions(list);
            this.m_init = true;
        }
        this.m_expPanel.clearTemplates();
        HashSet<Object> hashSet = new HashSet<Object>();
        FromObject[] fromObjectArray = this.m_builder.listAllFromObjects();
        for (int i = 0; i < fromObjectArray.length; ++i) {
            this.m_expPanel.addTemplate((SQLFragment)fromObjectArray[i], true);
            hashSet.add(fromObjectArray[i]);
        }
        hashSet.addAll(Arrays.asList(list));
        if (this.m_completionSupport == null) {
            this.m_completionSupport = this.getCompletionSupport(this.m_expression);
        }
        SelectObject selectObject = dBObject instanceof SelectObject ? (SelectObject)dBObject : null;
        SQLQuery sQLQuery = this.m_builder.getSQLQuery();
        this.m_expPanel.entered((SQLFragment[])sQLQuery.getSelectObjects(), (SQLFragment)selectObject);
    }

    @Override
    public void commitPanel() throws TraversalException {
        if (this.m_expPanel != null) {
            this.m_expPanel.exited();
        }
    }

    private SelectObject newSelectObject() {
        SelectObject selectObject = new SelectObject();
        selectObject.setID(TemporaryObjectID.createID((DBObject)selectObject));
        return selectObject;
    }

    private void updateCurrentFrag() throws SQLQueryException {
        String string = null;
        SQLFragment sQLFragment = null;
        if (this.m_current != null) {
            string = this.m_current.getAlias();
            sQLFragment = this.m_current.getExpression();
        }
        try {
            String string2 = this.m_mdlSelectType.getSelectedItem().equals(UIBundle.get("SELECT_INFO_LABEL_SUBQUERY")) ? "(" + this.m_subQueryText.getText().trim() + ")" : this.m_expression.getText().trim();
            String string3 = this.m_alias.getText().trim();
            if ("".equals(string3)) {
                string3 = null;
            }
            this.validateAlias((AliasFragment)this.m_current, string3);
            if (this.m_current != null) {
                SQLFragment sQLFragment2 = this.m_builder.parseSelectExpression(string2);
                if (this.m_new) {
                    this.m_current.setExpression(sQLFragment2);
                    if (this.m_mdlSelectType.getSelectedItem().equals(UIBundle.get("SELECT_INFO_LABEL_SUBQUERY"))) {
                        this.m_current.setAlias("<ALIAS>");
                    } else {
                        this.m_current.setAlias(string3);
                    }
                    this.m_builder.addSelectObject(this.m_current);
                    this.m_new = false;
                } else {
                    SelectObject selectObject = (SelectObject)this.m_current.copyTo(null);
                    selectObject.setExpression(sQLFragment2);
                    selectObject.setAlias(string3);
                    this.m_builder.replaceSelectObject(this.m_current, selectObject);
                }
                this.m_expPanel.repaint();
                if ("<ALIAS>".equals(this.m_current.getAlias())) {
                    this.m_current.setAlias(null);
                }
            }
        }
        catch (SQLQueryException sQLQueryException) {
            if (this.m_new) {
                this.m_current.setAlias(string);
                this.m_current.setExpression(sQLFragment);
            }
            throw sQLQueryException;
        }
    }

    private void enableComponents(boolean bl) {
        this.m_aliasLabel.setEnabled(bl);
        this.m_alias.setEnabled(bl);
        this.m_expLabel.setEnabled(bl);
        this.m_expression.setEnabled(bl);
        this.m_validate.setEnabled(bl);
        this.m_cmbSelectType.setEnabled(bl);
        if (!bl) {
            this.m_alias.setText(null);
            this.m_expression.setText(null);
            this.m_subQueryText.setText(null);
            this.m_commitPending = false;
        }
    }

    @Override
    public String getComponentNamePrefix() {
        return "SelectObjectsPanel";
    }

    @Override
    public JPanel getEditorUI() {
        if (this.m_reshelp == null) {
            this.m_reshelp = new DBUIResourceHelper(this.getComponentNamePrefix());
        }
        this.m_editor = new JPanel();
        this.m_editor.setName(this.getComponentNamePrefix());
        this.m_cmbSelectType.removeActionListener(this);
        this.m_cmbSelectType.addActionListener(this);
        this.m_cmbSelectType.setModel(this.m_mdlSelectType);
        this.layoutSelectPanel(false);
        this.enableComponents(false);
        return this.m_editor;
    }

    private void layoutSelectPanel(boolean bl) {
        this.m_editor.removeAll();
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this.m_editor);
        dBUILayoutHelper.setMargins(5);
        this.m_reshelp.resLabel(this.m_lblSelectType, this.m_cmbSelectType, UIBundle.get("SELECT_INFO_LABEL_TYPE"), "SelectType");
        dBUILayoutHelper.add(this.m_lblSelectType);
        dBUILayoutHelper.add(this.m_cmbSelectType, 2, 1, false, false);
        dBUILayoutHelper.nextRow();
        if (this.m_mdlSelectType.getSelectedItem().equals(UIBundle.get("SELECT_INFO_LABEL_SUBQUERY"))) {
            this.m_toolbar.removeAll();
            this.m_toolbar.add((Component)this.m_editQuery);
            if (!this.m_cmbSelectType.isEnabled()) {
                this.m_reshelp.resLabel(this.m_expLabel, this.m_subQueryText, UIBundle.get("EXP_EXPRESSION"), "Expression");
                this.m_subQueryText.getDocument().addDocumentListener(this);
                dBUILayoutHelper.add((Component)this.m_compTitleBar, 2, 4, true, true);
                dBUILayoutHelper.nextRow();
                dBUILayoutHelper.nextRow();
                dBUILayoutHelper.nextRow();
                dBUILayoutHelper.nextRow();
                dBUILayoutHelper.nextRow();
                this.m_reshelp.resLabel(this.m_aliasLabel, this.m_alias, UIBundle.get("EXP_ALIAS"), "Alias");
                this.m_alias.getDocument().addDocumentListener(this);
                dBUILayoutHelper.add(this.m_aliasLabel);
                dBUILayoutHelper.add(this.m_alias);
            } else {
                this.m_reshelp.resButton(this.m_btnSubQuery, UIBundle.get("EXP_EDIT_SUBQUERY"), "SubQuery");
                dBUILayoutHelper.add(this.m_btnSubQuery);
                dBUILayoutHelper.pushLeft();
                dBUILayoutHelper.pushUp();
            }
        } else {
            this.m_reshelp.resLabel(this.m_expLabel, this.m_expression, UIBundle.get("EXP_EXPRESSION"), "Expression");
            ToolTipManager.sharedInstance().registerComponent(this.m_expression);
            this.m_expression.getDocument().addDocumentListener(this);
            dBUILayoutHelper.add(this.m_expLabel);
            dBUILayoutHelper.add(this.m_expression);
            dBUILayoutHelper.nextRow();
            this.m_reshelp.resLabel(this.m_aliasLabel, this.m_alias, UIBundle.get("EXP_ALIAS"), "Alias");
            this.m_alias.getDocument().addDocumentListener(this);
            dBUILayoutHelper.add(this.m_aliasLabel);
            dBUILayoutHelper.add(this.m_alias);
            dBUILayoutHelper.nextRow();
            this.m_reshelp.resButton(this.m_validate, UIBundle.get("EXP_VALIDATE"), "Validate");
            this.m_validate.removeActionListener(this);
            this.m_validate.addActionListener(this);
            dBUILayoutHelper.add(this.m_validate);
            dBUILayoutHelper.pushUp();
        }
        dBUILayoutHelper.layout();
        this.m_editor.revalidate();
        this.m_editor.repaint();
    }

    @Override
    public String getEditorName() {
        return UIBundle.get("SELECT_EDITOR");
    }

    @Override
    public String getListTitle() {
        return UIBundle.get("SELECT_LIST_TITLE");
    }

    @Override
    public String getTemplateTitle() {
        return UIBundle.get("EXP_PALETTE");
    }

    @Override
    public SQLFragment newFragment() {
        this.m_current = this.newSelectObject();
        this.edit((SQLFragment)this.m_current);
        this.m_commitPending = true;
        this.m_new = true;
        this.m_cmbSelectType.setEnabled(true);
        this.showSelectCombo(true);
        this.m_showSelectType = true;
        return this.m_current;
    }

    @Override
    public boolean removeFragment(SQLFragment sQLFragment) {
        boolean bl = false;
        if (this.m_new) {
            this.m_new = false;
            bl = true;
        } else {
            SQLFragment[] sQLFragmentArray = this.m_builder.getDependentObjects((SelectObject)sQLFragment);
            bl = sQLFragmentArray != null && sQLFragmentArray.length > 0 && !MessageDialog.confirm((Component)((Object)this), (Object)UIBundle.get("SELECT_DEPS"), (String)UIBundle.get("SELECT_DEPS_TITLE"), null) ? false : this.m_builder.removeSelectObject((SelectObject)sQLFragment);
        }
        return bl;
    }

    @Override
    public void moveFragment(SQLFragment sQLFragment, int n) {
        this.m_builder.getSQLQuery().moveSelectObject((SelectObject)sQLFragment, n);
    }

    @Override
    public void commit() throws TraversalException {
        if (this.m_commitPending) {
            SQLFragment sQLFragment = this.m_current == null ? null : this.m_current.getExpression();
            String string = sQLFragment == null ? null : sQLFragment.getSQLText();
            String string2 = this.m_expression.getText().trim();
            String string3 = this.m_current.getAlias();
            String string4 = this.m_alias.getText().trim();
            try {
                this.validateAlias((AliasFragment)this.m_current, string4);
            }
            catch (InvalidAliasException invalidAliasException) {
                this.m_commitPending = false;
                throw new TraversalException(invalidAliasException.getMessage());
            }
            if (ModelUtil.areDifferent((Object)string4, (Object)string3) || ModelUtil.areDifferent((Object)string2, (Object)string)) {
                try {
                    this.updateCurrentFrag();
                }
                catch (SQLQueryException sQLQueryException) {
                    throw new TraversalException(sQLQueryException.getMessage());
                }
            }
            this.m_commitPending = false;
        }
    }

    @Override
    public void edit(SQLFragment sQLFragment) {
        SelectObject selectObject = this.m_current = sQLFragment instanceof SelectObject ? (SelectObject)sQLFragment : null;
        if (this.m_current == null) {
            this.enableComponents(false);
        } else {
            SQLFragment sQLFragment2;
            this.m_alias.setText(this.m_current == null ? "" : this.m_current.getAlias());
            SQLFragment sQLFragment3 = sQLFragment2 = this.m_current == null ? null : this.m_current.getExpression();
            if (sQLFragment2 instanceof SQLQuery) {
                this.m_mdlSelectType.setSelectedItem(UIBundle.get("SELECT_INFO_LABEL_SUBQUERY"));
                this.m_expPanel.hideTemplatePanel(true);
                this.m_subQueryText.setText(sQLFragment2 == null ? "" : sQLFragment2.getSQLText());
                this.m_subQueryText.setEditable(false);
            } else {
                this.m_mdlSelectType.setSelectedItem(UIBundle.get("SELECT_INFO_LABEL_EXPRESSION"));
                this.m_expPanel.hideTemplatePanel(false);
                this.m_expression.setText(sQLFragment2 == null ? "" : sQLFragment2.getSQLText());
                this.m_subQueryText.setText("");
                this.m_expression.requestFocusInWindow();
                this.m_expression.selectAll();
            }
            this.m_cmbSelectType.setEnabled(false);
            this.layoutSelectPanel(this.m_showSelectType);
            this.enableComponents(true);
            this.showSelectCombo(false);
            this.m_showSelectType = false;
            this.m_commitPending = false;
        }
    }

    public void addQuery() {
        SQLQueryEditDialog sQLQueryEditDialog = new SQLQueryEditDialog();
        sQLQueryEditDialog.setBindVariables((Collection)this.getDataContext().get("bindVariables"));
        String string = this.m_subQueryText.getText();
        DBEditorConfig dBEditorConfig = this.getEditorConfig();
        Schema schema = dBEditorConfig.getSchema();
        try {
            String string2;
            String string3;
            DBObjectProvider dBObjectProvider = this.getProvider();
            if (schema == null) {
                schema = dBObjectProvider.getDefaultSchema();
            }
            SQLQuery sQLQuery = new SQLQuery();
            if (string.toUpperCase().indexOf("SELECT") != -1) {
                sQLQuery.setQueryString(string);
            }
            String string4 = string = (sQLQuery = sQLQueryEditDialog.editQuery(sQLQuery, dBObjectProvider, schema)) == null ? null : sQLQuery.getSQLText();
            if (string != null && !(string3 = string.replaceAll(" ", "").replaceAll("\n", "")).equals(string2 = "SELECT \n    \nFROM \n    \n".replaceAll(" ", "").replaceAll("\n", ""))) {
                this.m_subQueryText.setText(string);
                this.updateCurrentFrag();
                this.m_cmbSelectType.setEnabled(false);
                this.showSelectCombo(false);
                this.layoutSelectPanel(true);
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private void showSelectCombo(boolean bl) {
        this.m_cmbSelectType.setVisible(bl);
        this.m_lblSelectType.setVisible(bl);
    }

    @Override
    public void addToExpression(String string) {
        SelectObjectsPanel.addText(this.m_expression, string);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.m_cmbSelectType) {
                if (this.m_mdlSelectType.getSelectedItem().equals(UIBundle.get("SELECT_INFO_LABEL_EXPRESSION"))) {
                    this.layoutSelectPanel(true);
                    this.m_expression.requestFocusInWindow();
                    this.m_expression.selectAll();
                    this.m_expPanel.hideTemplatePanel(false);
                } else {
                    this.layoutSelectPanel(true);
                    this.m_subQueryText.setEditable(false);
                    this.m_expPanel.hideTemplatePanel(true);
                }
            } else {
                this.updateCurrentFrag();
                String string = this.m_current == null ? null : this.m_current.getAlias();
                String string2 = this.m_alias.getText().trim();
                this.validateAlias((AliasFragment)this.m_current, string2);
                if (string != null && ModelUtil.areDifferent((Object)string, (Object)string2)) {
                    this.m_alias.setText(string);
                }
                DBObjectRenderer.setToolTipText(this.m_expression, null);
            }
        }
        catch (SQLQueryException sQLQueryException) {
            String string = sQLQueryException.getMessage();
            this.m_expPanel.showInvalidExpressionDialog(new TraversalException(string));
            DBObjectRenderer.setToolTipText(this.m_expression, string);
        }
    }

    private void validateAlias(AliasFragment aliasFragment, String string) throws InvalidAliasException {
        DBObjectProvider dBObjectProvider;
        if (ModelUtil.hasLength((String)string) && (dBObjectProvider = this.getProvider()) != null) {
            try {
                dBObjectProvider.validateName("COLUMN", string);
            }
            catch (InvalidNameException invalidNameException) {
                throw new InvalidAliasException(aliasFragment, invalidNameException.getMessage());
            }
        }
    }

    class AddQueryAction
    extends AbstractAction {
        AddQueryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectObjectsPanel.this.addQuery();
        }
    }

    class EditQueryAction
    extends AbstractAction {
        public EditQueryAction() {
            this.putValue("SmallIcon", OracleIcons.getIcon((String)"edit.png"));
            this.putValue("ShortDescription", UIBundle.get("EXP_EDIT_SUBQUERY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectObjectsPanel.this.addQuery();
        }
    }
}

