/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;
import oracle.jdeveloper.db.adapter.JDBCParameterInfo;

public class DerbyConnectionCreator
extends AbstractConnectionCreator {
    public static final String DERBY_EMBEDDED_DRIVER_CLASS = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String DERBY_CLIENT_DRIVER_CLASS = "org.apache.derby.jdbc.ClientDriver";
    public static final String SUBTYPE_DERBY = "derby";
    public static final String SUBPROTOCOL_CLASS_REFTYPE = "subprotocol";

    @Override
    public String getDriverClassName(Properties properties) throws SQLException {
        String string = super.getDriverClassName(properties);
        if (!this.hasLength(string)) {
            string = DERBY_EMBEDDED_DRIVER_CLASS;
        }
        return string;
    }

    @Override
    public String getConnectionURL(Properties properties) throws SQLException {
        String string = super.getConnectionURL(properties);
        if (!this.hasLength(string)) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder("jdbc:derby:");
            if (DERBY_CLIENT_DRIVER_CLASS.equals(this.getDriverClassName(properties))) {
                stringBuilder.append("//").append(this.getPropertyOrThrow(properties, "hostname"));
                string2 = properties.getProperty("port");
                if (this.hasLength(string2)) {
                    stringBuilder.append(":").append(string2);
                }
                stringBuilder.append("/");
            } else {
                string2 = properties.getProperty(SUBPROTOCOL_CLASS_REFTYPE);
                if (this.hasLength(string2)) {
                    try {
                        DerbySubprotocol.valueOf(string2);
                        stringBuilder.append(string2).append(":");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SQLException(illegalArgumentException.getMessage());
                    }
                }
            }
            string2 = this.getPropertyOrThrow(properties, "dataSourceName");
            stringBuilder.append(string2);
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> collection = super.listAllowedProperties();
        collection.add(SUBPROTOCOL_CLASS_REFTYPE);
        collection.add("dataSourceName");
        return collection;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        return Collections.singleton("dataSourceName");
    }

    @Override
    protected boolean allowNullPassword() {
        return true;
    }

    @Override
    public Collection<JDBCParameterInfo> listJDBCParameterInfos(Properties properties) throws SQLException {
        ArrayList<JDBCParameterInfo> arrayList = new ArrayList<JDBCParameterInfo>();
        arrayList.add(new JDBCParameterInfo("bootPassword", null));
        arrayList.add(new JDBCParameterInfo("collation", null));
        arrayList.add(new JDBCParameterInfo("create", "true"));
        arrayList.add(new JDBCParameterInfo("createFrom", null));
        arrayList.add(new JDBCParameterInfo("dataEncryption", "true"));
        arrayList.add(new JDBCParameterInfo("drop", "true"));
        arrayList.add(new JDBCParameterInfo("encryptionKey", null));
        arrayList.add(new JDBCParameterInfo("encryptionProvider", null));
        arrayList.add(new JDBCParameterInfo("encryptionAlgorithm", null));
        arrayList.add(new JDBCParameterInfo("failover", "true"));
        arrayList.add(new JDBCParameterInfo("logDevice", null));
        arrayList.add(new JDBCParameterInfo("newEncryptionKey", null));
        arrayList.add(new JDBCParameterInfo("newBootPassword", null));
        arrayList.add(new JDBCParameterInfo("restoreFrom", null));
        arrayList.add(new JDBCParameterInfo("rollForwardRecoveryFrom", null));
        arrayList.add(new JDBCParameterInfo("securityMechanism", null));
        arrayList.add(new JDBCParameterInfo("shutdown", "true"));
        arrayList.add(new JDBCParameterInfo("slaveHost", null));
        arrayList.add(new JDBCParameterInfo("slavePort", null));
        arrayList.add(new JDBCParameterInfo("ssl", null));
        arrayList.add(new JDBCParameterInfo("startMaster", "true"));
        arrayList.add(new JDBCParameterInfo("startSlave", "true"));
        arrayList.add(new JDBCParameterInfo("stopMaster", "true"));
        arrayList.add(new JDBCParameterInfo("stopSlave", "true"));
        arrayList.add(new JDBCParameterInfo("territory", null));
        arrayList.add(new JDBCParameterInfo("traceDirectory", null));
        arrayList.add(new JDBCParameterInfo("traceFile", null));
        arrayList.add(new JDBCParameterInfo("traceFileAppend", "true"));
        arrayList.add(new JDBCParameterInfo("traceLevel", null));
        arrayList.add(new JDBCParameterInfo("upgrade", "true"));
        return arrayList;
    }

    public static enum DerbySubprotocol {
        directory,
        memory,
        classpath,
        jar;

    }
}

