/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdeveloper.db.adapter.AbstractOracleConnCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.ssh.SSHConnectionCreator;
import oracle.jdeveloper.db.ssh.SSHTunnelConfiguration;
import oracle.jdeveloper.db.ssh.SSHTunnelException;
import oracle.jdevimpl.db.resource.DBAdapterBundle;

public class OracleConnectionCreator
extends AbstractOracleConnCreator
implements SSHConnectionCreator {
    public static final String ORACLE_DRIVER_CLASS = "oracle.jdbc.OracleDriver";
    public static final String OLD_ORACLE_DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";
    public static final String SUBTYPE_ORA_JDBC = "oraJDBC";
    public static final String ORA_DRIVER_TYPE_CLASS_REFTYPE = "oraDriverType";
    public static final String ORA_DRIVER_THIN = "thin";
    public static final String ORA_DRIVER_OCI8 = "oci8";

    @Override
    public String getConnectionURL(Properties properties) throws SQLException {
        String string = super.getConnectionURL(properties);
        if (this.hasLength(string)) {
            return string;
        }
        String string2 = this.getPropertyOrThrow(properties, "hostname");
        String string3 = this.getPropertyOrThrow(properties, "port");
        String string4 = properties.getProperty("sid");
        String string5 = properties.getProperty("serviceName");
        String string6 = this.getPropertyOrThrow(properties, ORA_DRIVER_TYPE_CLASS_REFTYPE);
        if (ORA_DRIVER_THIN.equals(string6)) {
            if (string4 != null) {
                return "jdbc:oracle:thin:@" + string2 + ":" + string3 + ":" + string4;
            }
            if (string5 != null) {
                return "jdbc:oracle:thin:@//" + string2 + ":" + string3 + "/" + string5;
            }
            throw new SQLException(DBAdapterBundle.get("ERROR_SID_SERVICE_NAME"));
        }
        if (ORA_DRIVER_OCI8.equals(string6)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("jdbc:oracle:oci8:@");
            stringBuilder.append("(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=");
            stringBuilder.append(string2);
            stringBuilder.append(")(PORT=");
            stringBuilder.append(string3);
            stringBuilder.append("))(CONNECT_DATA=(");
            if (string4 != null) {
                stringBuilder.append("SID=").append(string4);
            } else if (string5 != null) {
                stringBuilder.append("SERVICE_NAME=").append(string5);
            } else {
                throw new SQLException(DBAdapterBundle.get("ERROR_SID_SERVICE_NAME"));
            }
            stringBuilder.append(")))");
            return stringBuilder.toString();
        }
        throw new SQLException("Unrecognized Oracle JDBC driver type: " + string6);
    }

    @Override
    public String getDriverClassName(Properties properties) throws SQLException {
        String string = super.getDriverClassName(properties);
        if (this.hasLength(string) && !string.equals(OLD_ORACLE_DRIVER_CLASS)) {
            return string;
        }
        return ORACLE_DRIVER_CLASS;
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> collection = super.listAllowedProperties();
        collection.add("serviceName");
        collection.add("SSH.Enabled");
        return collection;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("hostname");
        hashSet.add("port");
        hashSet.add(ORA_DRIVER_TYPE_CLASS_REFTYPE);
        return hashSet;
    }

    @Override
    public SSHTunnelConfiguration getConfiguration(DatabaseProvider databaseProvider) throws SQLException {
        SSHTunnelConfiguration sSHTunnelConfiguration;
        String string = this.getConnectionURL(databaseProvider.getProperties());
        Pattern pattern = Pattern.compile(".*@/*([^:]+):([0-9]*)[:|/].*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            sSHTunnelConfiguration = SSHTunnelConfiguration.createFromMatcher(string, matcher, 1, 2);
        } else if (Pattern.matches("(?i)(?s).*DESCRIPTION\\s*=.*", string)) {
            sSHTunnelConfiguration = SSHTunnelConfiguration.parseAddressSyntax(string);
        } else {
            throw new SSHTunnelException(DBAdapterBundle.get("SSH_URL_PARSE_FAILED"));
        }
        return sSHTunnelConfiguration;
    }
}

