/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractOracleConnCreator;

public class OracleLiteConnectionCreator
extends AbstractOracleConnCreator {
    public static final String OLITE_DRIVER_CLASS = "oracle.lite.poljdbc.POLJDBCDriver";
    public static final String SUBTYPE_OLITE = "oraLite";

    @Override
    public String getConnectionURL(Properties properties) throws SQLException {
        String string = properties.getProperty("dataSourceName");
        if (string != null && string.length() > 0) {
            return "jdbc:polite:" + string;
        }
        String string2 = this.getPropertyOrThrow(properties, "hostname");
        String string3 = this.getPropertyOrThrow(properties, "port");
        String string4 = this.getPropertyOrThrow(properties, "sid");
        return "jdbc:polite4@" + string2 + ":" + string3 + ":" + string4;
    }

    @Override
    public String getDriverClassName(Properties properties) throws SQLException {
        String string = super.getDriverClassName(properties);
        if (this.hasLength(string)) {
            return string;
        }
        return OLITE_DRIVER_CLASS;
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> collection = super.listAllowedProperties();
        collection.add("dataSourceName");
        return collection;
    }
}

