/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public class SQLServerConnectionCreator
extends AbstractConnectionCreator {
    public static final String SQLSERVER_WEBLOGIC_DRIVER_CLASS = "weblogic.jdbc.sqlserver.SQLServerDriver";
    public static final String SQLSERVER_DRIVER_CLASS = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String SUBTYPE_SQLSERVER = "SQLServer";
    public static final String INSTANCE_CLASS_REFTYPE = "instanceName";

    @Override
    public String getDriverClassName(Properties properties) throws SQLException {
        String string = super.getDriverClassName(properties);
        if (this.hasLength(string)) {
            return string;
        }
        return SQLSERVER_DRIVER_CLASS;
    }

    @Override
    public String getConnectionURL(Properties properties) throws SQLException {
        String string;
        String string2 = super.getConnectionURL(properties);
        if (this.hasLength(string2)) {
            string = string2;
        } else {
            String string3 = this.getPropertyOrThrow(properties, "hostname");
            String string4 = properties.getProperty("port");
            String string5 = properties.getProperty("dataSourceName");
            String string6 = properties.getProperty(INSTANCE_CLASS_REFTYPE);
            StringBuilder stringBuilder = new StringBuilder("jdbc:");
            if (SQLSERVER_WEBLOGIC_DRIVER_CLASS.equals(this.getDriverClassName(properties))) {
                stringBuilder.append("weblogic:");
            }
            stringBuilder.append("sqlserver://").append(string3);
            if (this.hasLength(string6)) {
                stringBuilder.append("\\").append(string6);
            }
            if (this.hasLength(string4)) {
                stringBuilder.append(":").append(string4);
            }
            if (this.hasLength(string5)) {
                stringBuilder.append(";databaseName=").append(string5);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> collection = super.listAllowedProperties();
        collection.add("hostname");
        collection.add("port");
        collection.add("dataSourceName");
        collection.add(INSTANCE_CLASS_REFTYPE);
        return collection;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        return Collections.singleton("hostname");
    }
}

