/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.ssh;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.ssh.SSHConnectionCreator;
import oracle.jdeveloper.db.ssh.SSHTunnel;
import oracle.jdeveloper.db.ssh.SSHTunnelException;
import oracle.jdevimpl.db.resource.DBAdapterBundle;

public final class SSHTunnelConfiguration {
    public static final String SSH_ENABLED = "SSH.Enabled";
    public static final String SSH_USER = "SSH.User";
    public static final String SSH_PASSWORD = "SSH.Password";
    public static final String SSH_HOST = "SSH.Host";
    public static final String SSH_PORT = "SSH.Port";
    public static final String SSH_KEY_FILE = "SSH.LocalFile";
    public static final String SSH_USE_PROXY = "SSH.UseProxy";
    private final String m_url;
    private final String m_host;
    private final int[] m_hostOffsets;
    private final int m_port;
    private final int[] m_portOffsets;

    public SSHTunnelConfiguration(String string, String string2, int[] nArray, int n, int[] nArray2) {
        this.m_url = string;
        this.m_host = string2;
        this.m_hostOffsets = nArray;
        this.m_port = n;
        this.m_portOffsets = nArray2;
    }

    public String getRemoteHost() {
        return this.m_host;
    }

    public int getRemotePort() {
        return this.m_port;
    }

    public String getLocalConnectionURL(SSHTunnel sSHTunnel) {
        StringBuilder stringBuilder = new StringBuilder(this.m_url);
        if (this.m_hostOffsets[0] > this.m_portOffsets[0]) {
            this.replaceHost(stringBuilder, sSHTunnel);
            this.replacePort(stringBuilder, sSHTunnel);
        } else {
            this.replacePort(stringBuilder, sSHTunnel);
            this.replaceHost(stringBuilder, sSHTunnel);
        }
        return stringBuilder.toString();
    }

    private void replaceHost(StringBuilder stringBuilder, SSHTunnel sSHTunnel) {
        stringBuilder.replace(this.m_hostOffsets[0], this.m_hostOffsets[1], sSHTunnel.getLocalHost());
    }

    private void replacePort(StringBuilder stringBuilder, SSHTunnel sSHTunnel) {
        stringBuilder.replace(this.m_portOffsets[0], this.m_portOffsets[1], String.valueOf(sSHTunnel.getLocalPort()));
    }

    public static int parsePort(String string) throws SSHTunnelException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SSHTunnelException(DBAdapterBundle.get("SSH_INVALID_PORT"));
        }
    }

    public static SSHTunnelConfiguration createFromMatcher(String string, Matcher matcher, int n, int n2) throws SSHTunnelException {
        String string2 = matcher.group(n);
        int[] nArray = new int[]{matcher.start(n), matcher.end(n)};
        String string3 = matcher.group(n2);
        int[] nArray2 = new int[]{matcher.start(n2), matcher.end(n2)};
        return new SSHTunnelConfiguration(string, string2, nArray, SSHTunnelConfiguration.parsePort(string3), nArray2);
    }

    public static SSHTunnelConfiguration parseAddressSyntax(String string) throws SSHTunnelException {
        int[] nArray;
        String string2;
        int[] nArray2;
        String string3;
        Pattern pattern = Pattern.compile("\\(\\s*HOST\\s*=\\s*([^\\s)]+)\\s*\\)", 2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string3 = matcher.group(1);
            nArray2 = new int[]{matcher.start(1), matcher.end(1)};
            if (matcher.find()) {
                throw new SSHTunnelException(DBAdapterBundle.get("SSH_HOST_MULTIPLE"));
            }
        } else {
            throw new SSHTunnelException(DBAdapterBundle.get("SSH_HOST_MISSING"));
        }
        pattern = Pattern.compile("\\(\\s*PORT\\s*=\\s*([^\\s)]+)\\s*\\)", 2);
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            string2 = matcher.group(1);
            nArray = new int[]{matcher.start(1), matcher.end(1)};
            if (matcher.find()) {
                throw new SSHTunnelException(DBAdapterBundle.get("SSH_PORT_MULTIPLE"));
            }
        } else {
            throw new SSHTunnelException(DBAdapterBundle.get("SSH_PORT_MISSING"));
        }
        return new SSHTunnelConfiguration(string, string3, nArray2, SSHTunnelConfiguration.parsePort(string2), nArray);
    }

    public static SSHTunnelConfiguration getConfiguration(DatabaseProvider databaseProvider) throws SQLException {
        ConnectionCreator connectionCreator = DatabaseProvider.getCreator(databaseProvider);
        if (connectionCreator instanceof SSHConnectionCreator) {
            return ((SSHConnectionCreator)connectionCreator).getConfiguration(databaseProvider);
        }
        throw new SSHTunnelException(DBAdapterBundle.get("SSH_NOT_SUPPORTED"));
    }

    public static final boolean requiresTunnel(DatabaseProvider databaseProvider) {
        return Boolean.parseBoolean(databaseProvider.getProperty(SSH_ENABLED));
    }
}

