/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.jdeveloper.db.adapter.DatabaseProvider;

public class CMHelper {
    private static final String CONNECTION_ID = "oracle.adf.rc.connectionId";
    private static final String CONNECTION_NAME = "ConnectionName";
    private static final String DEPLOY_PASSWORD = "DeployPassword";
    private static final String URL = "URL";
    private static final String HOSTNAME = "HOSTNAME";
    private static final String SID = "SID";
    private static final String JDBC_PORT = "JDBC_PORT";
    private static final String JDBC_DRIVER = "JdbcDriver";
    private static final String ORACLE_JDBC_TYPE = "ORACLE_JDBC_TYPE";
    private static final String PASSWORD = "password";
    private static final String ROLE = "Role";
    private static final String USERNAME = "user";
    private static final String CONNECTION_TYPE = "ConnectionType";
    public static final String CONN_ORACLE_JDBC = "JDBC";
    public static final String CONN_ORACLE_LITE = "ORACLE_LITE";
    public static final String CONN_JDBC_ODBC = "JDBC_ODBC";
    public static final String CONN_OTHER_JDBC = "OTHER_JDBC";
    public static final String CONN_MYSQL = "MYSQL";
    public static final String CONN_BI_JDBC = "BI_JDBC";
    public static final String CONN_FTP = "FTP";
    public static final String CONN_JNDI = "JNDI";
    private static final String ODBC_DSN = "DSN";
    private static final String EXTRA_PARAMS = "EXTRA_PARAMS";
    private static final String SERVICE_NAME = "ServiceName";
    private static final String ALL_SCHEMAS = "AllSchemas";
    private static final Map<String, String> s_props = new HashMap<String, String>();

    private CMHelper() {
    }

    public static Referenceable createReferenceFromDescriptor(Properties properties) {
        DatabaseProvider databaseProvider = new DatabaseProvider();
        for (Object object : properties.keySet()) {
            String string;
            String string2;
            if (!(object instanceof String)) continue;
            if (object.equals(CONNECTION_TYPE)) {
                String string3;
                string2 = "subtype";
                String string4 = properties.getProperty(CONNECTION_TYPE);
                string = string4.equals(CONN_ORACLE_JDBC) ? ((string3 = properties.getProperty(JDBC_DRIVER)) == null || string3.contains("Oracle") ? "oraJDBC" : "thirdParty") : (string4.equals(CONN_OTHER_JDBC) ? "thirdParty" : (string4.equals(CONN_ORACLE_LITE) ? "oraLite" : (string4.equals(CONN_JDBC_ODBC) ? "ODBCBridge" : (string4.equals(CONN_MYSQL) ? CONN_MYSQL : string4))));
            } else if (object.equals(CONNECTION_NAME)) {
                string2 = null;
                string = null;
            } else {
                string2 = s_props.containsKey((String)object) ? s_props.get((String)object) : (String)object;
                string = string2.equals("driver") && properties.getProperty((String)object).equals("oracle.jdbc.driver.OracleDriver") ? "oracle.jdbc.OracleDriver" : properties.getProperty((String)object);
            }
            if (string2 == null) continue;
            databaseProvider.setProperty(string2, string);
        }
        if (databaseProvider.getProperty(PASSWORD) != null && databaseProvider.getProperty("SavePassword") == null) {
            databaseProvider.setProperty("SavePassword", String.valueOf(true));
        }
        if (databaseProvider.getProperty(PASSWORD) == null) {
            databaseProvider.setProperty("SavePassword", String.valueOf(false));
        }
        return databaseProvider;
    }

    public static Properties createDescriptorFromReference(Referenceable referenceable) {
        Properties properties = new Properties();
        Reference reference = null;
        try {
            reference = referenceable.getReference();
        }
        catch (NamingException namingException) {
            return properties;
        }
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            Object object;
            RefAddr refAddr = enumeration.nextElement();
            String string = null;
            String string2 = null;
            if (refAddr instanceof SecureRefAddr) {
                object = (SecureRefAddr)refAddr;
                string = object.getName();
                string2 = object.getValue();
            } else {
                string = refAddr.getType();
                string2 = (String)refAddr.getContent();
            }
            if (string.equals(CONNECTION_ID)) {
                properties.setProperty(CONNECTION_NAME, string2);
                continue;
            }
            if (string.equals(CONNECTION_TYPE)) {
                properties.setProperty(CONNECTION_TYPE, string2);
                continue;
            }
            if (string.equals("subtype")) {
                object = string2;
                if (string2.equals("oraJDBC")) {
                    object = CONN_ORACLE_JDBC;
                } else if (string2.equals("thirdParty")) {
                    object = CONN_OTHER_JDBC;
                } else if (string2.equals("oraLite")) {
                    object = CONN_ORACLE_LITE;
                } else if (string2.equals("ODBCBridge")) {
                    object = CONN_JDBC_ODBC;
                } else if (string2.equals(CONN_MYSQL)) {
                    object = CONN_MYSQL;
                }
                properties.setProperty(CONNECTION_TYPE, (String)object);
                continue;
            }
            if (string.equals(USERNAME)) {
                properties.setProperty(USERNAME, string2);
                continue;
            }
            if (string.equals(PASSWORD)) {
                properties.setProperty(PASSWORD, string2);
                continue;
            }
            if (string.equals(DEPLOY_PASSWORD)) {
                properties.setProperty(DEPLOY_PASSWORD, string2);
                continue;
            }
            if (string.equals("role")) {
                properties.setProperty(ROLE, string2);
                continue;
            }
            if (string.equals("sid")) {
                properties.setProperty(SID, string2);
                continue;
            }
            if (string.equals("serviceName")) {
                properties.setProperty(SERVICE_NAME, string2);
                continue;
            }
            if (string.equals("oraDriverType")) {
                properties.setProperty(ORACLE_JDBC_TYPE, string2);
                continue;
            }
            if (string.equals("port")) {
                properties.setProperty(JDBC_PORT, string2);
                continue;
            }
            if (string.equals("hostname")) {
                properties.setProperty(HOSTNAME, string2);
                continue;
            }
            if (string.equals("customUrl")) {
                properties.setProperty(URL, string2);
                continue;
            }
            if (string.equals("driver")) {
                properties.setProperty(JDBC_DRIVER, string2);
                continue;
            }
            if (string.equals("dataSourceName")) {
                properties.setProperty(ODBC_DSN, string2);
                continue;
            }
            if (string.equals("parameters")) {
                properties.setProperty(EXTRA_PARAMS, string2);
                continue;
            }
            if (!string.equals("allSchemas")) continue;
            properties.setProperty(ALL_SCHEMAS, string2);
        }
        return properties;
    }

    static {
        s_props.put(CONNECTION_TYPE, "subtype");
        s_props.put(HOSTNAME, "hostname");
        s_props.put(JDBC_PORT, "port");
        s_props.put(SID, "sid");
        s_props.put(SERVICE_NAME, "serviceName");
        s_props.put(ODBC_DSN, "dataSourceName");
        s_props.put(JDBC_DRIVER, "driver");
        s_props.put(ROLE, "role");
        s_props.put(URL, "customUrl");
        s_props.put(EXTRA_PARAMS, "parameters");
        s_props.put(ORACLE_JDBC_TYPE, "oraDriverType");
    }
}

