/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class AnimatedCellIcon
implements Icon {
    private final Icon _icon;
    private final List<RepaintTask> _list = new ArrayList<RepaintTask>();

    public AnimatedCellIcon(Icon icon) {
        assert (icon instanceof Observable | icon instanceof ImageIcon) : "Icon must be observable for the animation to work";
        if (icon instanceof ImageIcon) {
            icon = new ImageIcon(((ImageIcon)icon).getImage());
        }
        this._icon = icon;
        new UpdateObserver(this, icon);
    }

    @Override
    public void paintIcon(Component component, Graphics g, int x, int y) {
        this._icon.paintIcon(component, g, x, y);
        if (component != null) {
            Component nonRenderAncestor = this.findNonRendererAncestor(component);
            Point pt = SwingUtilities.convertPoint(component, x, y, nonRenderAncestor);
            this._list.add(new RepaintTask(nonRenderAncestor, new Rectangle(pt.x, pt.y, this.getIconWidth(), this.getIconHeight())));
        }
    }

    public void repaint() {
        for (Object rt : this._list.toArray()) {
            ((RepaintTask)rt).repaint();
        }
        this._list.clear();
    }

    private Component findNonRendererAncestor(Component c) {
        Container ancestor = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c);
        if (ancestor != null && ancestor != c && ancestor.getParent() != null) {
            c = this.findNonRendererAncestor(ancestor.getParent());
        }
        return c;
    }

    @Override
    public int getIconWidth() {
        return this._icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this._icon.getIconHeight();
    }

    private static class UpdateObserver
    implements ImageObserver,
    Observer {
        private WeakReference<AnimatedCellIcon> _reference;
        private Icon _original;

        public UpdateObserver(AnimatedCellIcon animVersion, Icon original) {
            if (original instanceof ImageIcon) {
                ((ImageIcon)original).setImageObserver(this);
            } else if (original instanceof Observable) {
                ((Observable)((Object)original)).addObserver(this);
            } else {
                throw new ClassCastException("Icon must be of type ImageIcon or Observable");
            }
            this._reference = new WeakReference<AnimatedCellIcon>(animVersion);
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x30) != 0) {
                AnimatedCellIcon animIcon = (AnimatedCellIcon)this._reference.get();
                if (animIcon != null) {
                    animIcon.repaint();
                } else {
                    ((ImageIcon)this._original).setImageObserver(null);
                }
            }
            return (infoflags & 0xA0) == 0;
        }

        @Override
        public void update(Observable o, Object arg) {
            AnimatedCellIcon animIcon = (AnimatedCellIcon)this._reference.get();
            if (animIcon != null) {
                animIcon.repaint();
            } else {
                ((Observable)((Object)this._original)).deleteObserver(this);
            }
        }
    }

    private static class RepaintTask {
        private Component _component;
        private Rectangle _rectangle;

        public RepaintTask(Component component, Rectangle rectangle) {
            this._component = component;
            this._rectangle = rectangle;
        }

        public void repaint() {
            this._component.repaint(this._rectangle.x, this._rectangle.y, this._rectangle.width, this._rectangle.height);
        }
    }
}

