/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewportChangeNotifier {
    private JComponent component;
    private List<JViewport> viewports = new ArrayList<JViewport>();
    private ChangeL changeL = new ChangeL();
    private transient ArrayList changeListeners = new ArrayList(2);
    private AncestorL ancestorL = new AncestorL();

    public ViewportChangeNotifier(JComponent component) {
        this.component = component;
        component.addAncestorListener(this.ancestorL);
        this.attach();
    }

    public void dispose() {
        this.detatch();
        this.component.removeAncestorListener(this.ancestorL);
        this.component = null;
        this.changeListeners.clear();
    }

    private void detatch() {
        for (JViewport viewport : this.viewports) {
            viewport.removeChangeListener(this.changeL);
        }
        this.viewports.clear();
    }

    private void attach() {
        for (Container c = this.component.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JViewport)) continue;
            JViewport viewport = (JViewport)c;
            this.viewports.add(viewport);
            viewport.addChangeListener(this.changeL);
        }
    }

    private void reattach() {
        this.detatch();
        this.attach();
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList(2);
        }
        this.changeListeners.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged(ChangeEvent changeEvent) {
        List list;
        ViewportChangeNotifier viewportChangeNotifier = this;
        synchronized (viewportChangeNotifier) {
            if (this.changeListeners == null) {
                return;
            }
            list = (List)this.changeListeners.clone();
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((ChangeListener)list.get(i)).stateChanged(changeEvent);
        }
    }

    private class AncestorL
    implements AncestorListener {
        private AncestorL() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            ViewportChangeNotifier.this.reattach();
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            ViewportChangeNotifier.this.reattach();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    private class ChangeL
    implements ChangeListener {
        private ChangeL() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ViewportChangeNotifier.this.fireStateChanged(e);
        }
    }
}

