/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToolBar;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.builders.BuiltToolBar;
import oracle.javatools.ui.builders.BuiltToolBarImpl;
import oracle.javatools.ui.search.SearchField;

public final class ToolBarBuilder {
    private ToolBarInstructions instructions = new ToolBarInstructions();
    static final String SEPARATOR_ITEM = "SEPARATOR_ITEM";

    public BuiltToolBar build() {
        BuiltToolBarImpl tc = new BuiltToolBarImpl(this.instructions);
        return tc;
    }

    public void setToolBar(JToolBar toolBar) {
        this.instructions.toolBar = toolBar;
    }

    public void addActions(boolean leftAligned, Action ... actions) {
        if (leftAligned) {
            for (Action a : actions) {
                this.instructions.leftContents.add(a);
            }
        } else {
            for (Action a : actions) {
                this.instructions.rightContents.add(a);
            }
        }
    }

    public void addDropActions(boolean leftAligned, String text, Action ... actions) {
        if (leftAligned) {
            this.instructions.leftContents.add(new DropAction(text, actions));
        } else {
            this.instructions.rightContents.add(new DropAction(text, actions));
        }
    }

    public void addDropActions(boolean leftAligned, Icon icon, String tooltipText, Action ... actions) {
        if (leftAligned) {
            this.instructions.leftContents.add(new DropAction(icon, tooltipText, actions));
        } else {
            this.instructions.rightContents.add(new DropAction(icon, tooltipText, actions));
        }
    }

    public void addComponents(boolean leftAligned, Component ... components) {
        if (leftAligned) {
            for (Component c : components) {
                c.setMaximumSize(c.getPreferredSize());
                this.instructions.leftContents.add(c);
            }
        } else {
            for (Component c : components) {
                c.setMaximumSize(c.getPreferredSize());
                this.instructions.rightContents.add(c);
            }
        }
    }

    public void addSeparator(boolean leftAligned) {
        if (leftAligned) {
            this.instructions.leftContents.add(SEPARATOR_ITEM);
        } else {
            this.instructions.rightContents.add(SEPARATOR_ITEM);
        }
    }

    public void setActionsSecondary(Action ... actions) {
        for (Action action : actions) {
            this.instructions.moreToolbarActions.add(action);
        }
    }

    public void setActionsSecondary(String moreActionsText, Action ... actions) {
        this.instructions.moreActionsText = moreActionsText;
        this.setActionsSecondary(actions);
    }

    public void setSearch(SearchField.Style searchStyle, String searchPrompt) {
        this.instructions.searchStyle = searchStyle;
        this.instructions.searchPrompt = searchPrompt;
    }

    final class ToolBarInstructions {
        List<Object> leftContents = new ArrayList<Object>();
        List<Object> rightContents = new ArrayList<Object>();
        String moreActionsText = UIBundle.get("TOOLBAR_MORE_ACTIONS");
        List<Action> moreToolbarActions = new ArrayList<Action>();
        SearchField.Style searchStyle = null;
        String searchPrompt = "";
        JToolBar toolBar = new JToolBar();

        ToolBarInstructions() {
        }
    }

    final class DropAction {
        final String text;
        final Icon icon;
        final List<Action> actions = new ArrayList<Action>();

        public DropAction(String text, Action[] actions) {
            this.text = text;
            this.icon = null;
            for (Action action : actions) {
                this.actions.add(action);
            }
        }

        public DropAction(Icon icon, String tooltipText, Action[] actions) {
            this.icon = icon;
            this.text = tooltipText;
            for (Action action : actions) {
                this.actions.add(action);
            }
        }
    }
}

