/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.javatools.ui.ghost.UIConstants;

public class GhostBackgroundPanel
extends JPanel {
    private List<JComponent> clearList = new ArrayList<JComponent>();
    private SoftReference<BufferedImage> imgRef;

    public GhostBackgroundPanel(LayoutManager layoutManager, UIConstants.Look look) {
        super(layoutManager);
        this.setLook(look);
    }

    public GhostBackgroundPanel(UIConstants.Look look) {
        this.setLook(look);
    }

    public void setLook(UIConstants.Look look) {
        this.setOpaque(false);
        this.setBackground(UIConstants.getColor("ghost.panel.background", look));
        this.putClientProperty(UIConstants.VETO_CONVERSION, true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.paintToImage(), 0, 0, null);
    }

    private BufferedImage paintToImage() {
        BufferedImage img = this.getImage();
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, img.getWidth(), img.getHeight());
        g2.setColor(this.getBackground());
        g2.setComposite(AlphaComposite.getInstance(3, 0.93f));
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setComposite(AlphaComposite.Clear);
        for (JComponent comp : this.clearList) {
            Rectangle thatR = comp.getBounds();
            Rectangle thisR = SwingUtilities.convertRectangle(comp.getParent(), thatR, this);
            g2.fill(thisR);
        }
        g2.dispose();
        return img;
    }

    private BufferedImage getImage() {
        BufferedImage img = null;
        if (this.imgRef != null) {
            img = this.imgRef.get();
        }
        if (img == null || img.getWidth() != this.getWidth() || img.getHeight() != this.getHeight()) {
            img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            this.imgRef = new SoftReference<BufferedImage>(img);
        }
        return img;
    }

    public void registerTransparentComponent(JComponent comp) {
        if (!this.clearList.contains(comp)) {
            this.clearList.add(comp);
        }
    }

    public void unregisterTransparentComponent(JComponent comp) {
        this.clearList.remove(comp);
    }
}

