/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip.templates;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.ItemTemplate;
import oracle.javatools.ui.infotip.templates.TemplateUtils;
import oracle.javatools.ui.plaf.IconicButtonUI;

public final class SingleItemTemplate
extends BasicTemplate
implements ItemTemplate {
    private static int MAX_VISIBLE_ROWS = 16;
    public static final String CONFIGURE = "Configure";
    private SuperLabel title = new SuperLabel();
    private JTextArea desc;
    private JScrollPane sp = TemplateUtils.createScrollPane();
    private JButton expandButton = new JButton();
    private static int PREFERRED_WIDTH = 400;
    private boolean expanded = false;
    private List<JComponent> expansionComponenets = new ArrayList<JComponent>();

    public SingleItemTemplate(Severity severity, String title, String description, List<? extends Action> actions, InfoTipStyles infoTipStyle) {
        this(severity, title, description, actions, infoTipStyle, -1);
    }

    public SingleItemTemplate(Severity severity, String title, String description, List<? extends Action> actions, final InfoTipStyles infoTipStyle, int maxWidth) {
        super(new JPanel((LayoutManager)new MigLayout("ins 0, gapx 2, gapy 0, hidemode 3, fill, nogrid")));
        this.title.setLabelOverride(true);
        this.content.setOpaque(false);
        this.sp.setVisible(this.expanded);
        this.expandButton.setFocusable(false);
        this.expandButton.setOpaque(false);
        this.expandButton.setContentAreaFilled(false);
        this.expandButton.setIcon(null);
        this.expandButton.setText(UIBundle.get("INFO_TIP_MORE"));
        this.expandButton.setFont(this.expandButton.getFont().deriveFont(9.0f));
        this.expandButton.setBorder(null);
        this.expandButton.setVerticalAlignment(3);
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SingleItemTemplate.this.expandButton.getParent().remove(SingleItemTemplate.this.expandButton);
                SingleItemTemplate.this.toggleExpansion();
            }
        });
        this.title.setPreferredWrapWidth(Math.max(PREFERRED_WIDTH, maxWidth));
        this.expandButton.setForeground(infoTipStyle.getMoreTextColor());
        this.desc = TemplateUtils.createDescriptionArea(infoTipStyle);
        this.sp.setViewportView(this.desc);
        Icon errorIcon = infoTipStyle.scaleIcon(OracleIcons.getIcon((String)"error.png"));
        Icon warnIcon = infoTipStyle.scaleIcon(OracleIcons.getIcon((String)"warning.png"));
        Icon incompleteIcon = infoTipStyle.scaleIcon(OracleIcons.getIcon((String)"incompletestatus.png"));
        Icon configureIcon = infoTipStyle.scaleIcon(OracleIcons.getIcon((String)"configure.png"));
        Icon fixIcon = infoTipStyle.scaleIcon(OracleIcons.getIcon((String)"fix.png"));
        this.title.setForeground(infoTipStyle.getItemTextColor());
        this.title.setFont(infoTipStyle.getItemTitleFont());
        this.title.setText(title);
        JLabel iconLabel = new JLabel();
        iconLabel.setVerticalAlignment(1);
        if (severity == Severity.ERROR) {
            iconLabel.setIcon(errorIcon);
        } else if (severity == Severity.WARNING) {
            iconLabel.setIcon(warnIcon);
        } else if (severity == Severity.INCOMPLETE) {
            iconLabel.setIcon(incompleteIcon);
        } else {
            return;
        }
        this.content.add((Component)iconLabel, "alignx left, grow 0, aligny baseline");
        this.content.add((Component)this.title, "alignx left, w 100%, growy, aligny baseline");
        if (description != null && description.length() > 0) {
            this.content.add((Component)this.expandButton, "alignx left,  gapleft 16, grow 0");
        }
        this.content.add(Box.createVerticalStrut(infoTipStyle.getItemTitleInsets().bottom), "newline");
        int iconGap = iconLabel.getIcon().getIconWidth() + 2;
        if (description != null && description.length() > 0) {
            this.desc.setText(description);
            this.expansionComponenets.add(this.sp);
            this.content.add((Component)this.sp, "wmin 400, newline, span, grow, gapleft " + iconGap + ", gapbottom 4");
        }
        for (final Action action : actions) {
            final SuperLabel fixItem = new SuperLabel((String)action.getValue("Name"));
            fixItem.setLabelOverride(true);
            fixItem.setPreferredWrapWidth(Math.max(PREFERRED_WIDTH, maxWidth));
            final Font normal = fixItem.getFont();
            Map<TextAttribute, ?> attributes = normal.getAttributes();
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            final Font underlined = normal.deriveFont(attributes);
            fixItem.setBackground(null);
            fixItem.setOpaque(false);
            fixItem.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            fixItem.setForeground(infoTipStyle.getHyperLinkTextColor(false));
            fixItem.setEnabled(action.isEnabled());
            final JButton configureButton = new JButton();
            configureButton.setToolTipText(UIBundle.get("INFO_TIP_CONFIGURE"));
            configureButton.setIcon(configureIcon);
            IconicButtonUI.install(configureButton);
            configureButton.setVisible(false);
            configureButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            configureButton.setOpaque(false);
            int height = Math.max(fixItem.getPreferredSize().height, configureButton.getPreferredSize().height);
            JLabel fixIconLabel = new JLabel(fixIcon);
            this.content.add((Component)fixIconLabel, "newline, alignx left, aligny top");
            this.content.add((Component)fixItem, "grow, gapbottom 2, gapleft " + (iconGap - 1) + ", height " + height);
            this.content.add((Component)configureButton, "grow 0, align right, gapleft 0, height " + height);
            if (!action.isEnabled()) continue;
            MouseAdapter fixMouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    fixItem.setFont(underlined);
                    fixItem.setForeground(infoTipStyle.getHyperLinkTextColor(true));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    fixItem.setFont(normal);
                    fixItem.setForeground(infoTipStyle.getHyperLinkTextColor(false));
                    configureButton.setVisible(false);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    SingleItemTemplate.this.fireActionPerformed("closeInfotipCommand");
                    action.actionPerformed(new ActionEvent(fixItem, 1001, "transform"));
                }
            };
            fixIconLabel.addMouseListener(fixMouseAdapter);
            fixItem.addMouseListener(fixMouseAdapter);
            configureButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (action.isEnabled()) {
                        action.actionPerformed(new ActionEvent(fixItem, 1001, SingleItemTemplate.CONFIGURE));
                    }
                }
            });
            configureButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    fixItem.setFont(underlined);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    fixItem.setFont(normal);
                    configureButton.setVisible(false);
                }
            });
        }
    }

    private void toggleExpansion() {
        this.expanded = !this.expanded;
        for (JComponent c : this.expansionComponenets) {
            c.setVisible(this.expanded);
        }
        this.fireActionPerformed("sizeChangedCommand");
    }

    public void setHover(InfoTipHover hover) {
    }

    @Override
    public int getPreferredWidth() {
        return this.title.getPreferredSize().width;
    }

    @Override
    public void setPreferredWidth(int width) {
        this.desc.setSize(width, 99999999);
        Dimension prefSize = this.desc.getPreferredSize();
        this.desc.setPreferredSize(prefSize);
        int rowHeight = this.desc.getFontMetrics(this.desc.getFont()).getHeight();
        int height = Math.min(rowHeight * MAX_VISIBLE_ROWS, this.desc.getPreferredSize().height);
        Insets insets = this.sp.getInsets();
        this.sp.setPreferredSize(new Dimension(width, height + insets.top + insets.bottom));
    }

    public static enum Severity {
        ERROR,
        WARNING,
        INCOMPLETE;

    }
}

