/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.list;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SingleListSelectionModel
implements ListSelectionModel {
    private int selectedIndex = 0;
    private List<ListSelectionListener> listeners = new CopyOnWriteArrayList<ListSelectionListener>();

    @Override
    public void setSelectionInterval(int index0, int index1) {
        this.updateSelection(index0);
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        this.updateSelection(index0);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
    }

    @Override
    public int getMinSelectionIndex() {
        return this.selectedIndex;
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.selectedIndex;
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.selectedIndex == index;
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.selectedIndex;
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        this.updateSelection(index);
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.selectedIndex;
    }

    @Override
    public void setLeadSelectionIndex(int index) {
        this.updateSelection(index);
    }

    @Override
    public void clearSelection() {
        this.updateSelection(0);
    }

    @Override
    public boolean isSelectionEmpty() {
        return false;
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
    }

    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
    }

    @Override
    public boolean getValueIsAdjusting() {
        return false;
    }

    @Override
    public void setSelectionMode(int selectionMode) {
    }

    @Override
    public int getSelectionMode() {
        return 0;
    }

    @Override
    public void addListSelectionListener(ListSelectionListener x) {
        this.listeners.add(x);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener x) {
        this.listeners.remove(x);
    }

    protected void updateSelection(int index) {
        if (index == this.selectedIndex) {
            return;
        }
        int oldIndex = this.selectedIndex;
        this.selectedIndex = index;
        ListSelectionEvent evt = new ListSelectionEvent(this, oldIndex, this.selectedIndex, false);
        for (ListSelectionListener l : this.listeners) {
            l.valueChanged(evt);
        }
    }
}

