/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.popup;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JWindow;
import oracle.javatools.ui.popup.PopupWindowListener;
import oracle.javatools.ui.popup.PopupWindowManager;

public final class PopupWindow {
    private JAWSLabel jawsLabel;
    private AccessibleContext accessibleContext;
    private JComponent content;
    private JWindow window;
    private boolean visible;
    private List<PopupWindowListener> listeners = new CopyOnWriteArrayList<PopupWindowListener>();
    private Map<Object, Object> clientProperties;
    private final PopupWindowManager manager;

    PopupWindow(JComponent content, JWindow window, PopupWindowManager manager) {
        this.content = content;
        this.window = window;
        this.manager = manager;
        this.jawsLabel = new JAWSLabel();
        this.jawsLabel.setPreferredSize(new Dimension(0, 0));
        this.accessibleContext = this.jawsLabel.getAccessibleContext();
        window.getContentPane().add((Component)this.jawsLabel, "South");
    }

    public void addPopupWindowListener(PopupWindowListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePopupWindowListener(PopupWindowListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void setAccessibleName(String name) {
        this.jawsLabel.setText(name);
    }

    public JComponent getContent() {
        return this.content;
    }

    void setContent(JComponent content) {
        this.content = content;
    }

    public void updatePopupContent(JComponent content, boolean focusable) {
        JComponent oldContent = this.getContent();
        this.window.getContentPane().remove(oldContent);
        this.setContent(content);
        this.window.getContentPane().add(content);
        this.window.setFocusableWindowState(focusable);
        Dimension contentSize = content.getPreferredSize();
        this.window.setSize(contentSize);
        this.window.validate();
    }

    public JWindow getWindow() {
        return this.window;
    }

    public void putClientProperty(Object key, Object value) {
        if (this.clientProperties == null) {
            this.clientProperties = new HashMap<Object, Object>();
        }
        this.clientProperties.put(key, value);
    }

    public Object getClientProperty(Object key) {
        if (this.clientProperties == null) {
            return null;
        }
        return this.clientProperties.get(key);
    }

    PopupWindowManager getManager() {
        return this.manager;
    }

    void close() {
        if (this.window != null) {
            this.window.setVisible(false);
            this.window.dispose();
        }
        this.window = null;
        this.visible = false;
        for (PopupWindowListener l : this.listeners) {
            l.popupClosed(this, 2);
        }
    }

    void parentFocusGained() {
        for (PopupWindowListener l : this.listeners) {
            l.parentFocusGained(this);
        }
    }

    void parentFocusLost(boolean isTemporary) {
        for (PopupWindowListener l : this.listeners) {
            l.parentFocusLost(this, isTemporary);
        }
    }

    void setVisible(boolean visible) {
        this.visible = visible;
    }

    boolean isVisible() {
        return this.visible;
    }

    private class JAWSLabel
    extends JLabel {
        private JAWSLabel() {
        }

        @Override
        public void setText(String text) {
            String oldText = this.getText();
            super.setText(text);
            AccessibleContext ac = this.getAccessibleContext();
            if (ac != null) {
                ac.firePropertyChange("AccessibleName", oldText, text);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJAWSLabel();
            }
            return this.accessibleContext;
        }

        private class AccessibleJAWSLabel
        extends JLabel.AccessibleJLabel {
            private AccessibleJAWSLabel() {
                super(JAWSLabel.this);
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
                super.addPropertyChangeListener(listener);
                String str = JAWSLabel.this.getText();
                if (str != null) {
                    JAWSLabel.this.setText("");
                    JAWSLabel.this.setText(str);
                }
            }
        }
    }
}

