/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.JTableHeader;
import oracle.javatools.ui.table.RolloverTableHandler;
import oracle.javatools.ui.table.RowHeader;
import oracle.javatools.ui.table.TableUIManager;

class SelectAllComponent
extends JLabel {
    private Color _oldRowColor;
    private Color _oldColColor;
    private Color _oldRowColorFg;
    private Color _oldColColorFg;
    private JTable _table;
    private JTableHeader _colHeader;
    private RowHeader _rowHeader;
    private Listener _listener;
    private boolean _stored;
    private boolean _focusHighlight;
    private boolean _pressed;

    public SelectAllComponent(JTable table) {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, TableUIManager.SELECTALL_CORNER_BORDER));
        this._table = table;
        this._colHeader = this._table.getTableHeader();
        this._rowHeader = (RowHeader)table.getClientProperty("tableRowHeader");
        this._listener = new Listener();
        this._table.addPropertyChangeListener("tableRowHeader", this._listener);
        this._table.addPropertyChangeListener("tableHeader", this._listener);
        this.addMouseListener(this._listener);
        this.addMouseMotionListener(this._listener);
    }

    public void dispose() {
        this.removeMouseListener(this._listener);
        this.removeMouseMotionListener(this._listener);
        this._table.removePropertyChangeListener("tableRowHeader", this._listener);
        this._table.removePropertyChangeListener("tableHeader", this._listener);
        this._table = null;
        this._colHeader = null;
        this._rowHeader = null;
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean focusPaint;
        Color bgColor = null;
        boolean bl = focusPaint = this._focusHighlight || this.hasFocus();
        bgColor = focusPaint || this._pressed ? (focusPaint ? RolloverTableHandler.getHeaderRolloverHighlight() : TableUIManager.SELECTALL_PRESSED) : TableUIManager.TABLE_GRID_COLOR;
        Color old = g.getColor();
        g.setColor(bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(old);
        super.paintComponent(g);
    }

    private void _updateBackground(boolean focussed, boolean selected, boolean selectAll) {
        this._focusHighlight = focussed;
        this._pressed = selected;
        if (this._focusHighlight || this._pressed) {
            this._storeOriginalHeaderColor();
            this._setSelectionHeaderColor(this._focusHighlight);
        } else {
            this._reStoreOriginalHeaderColor();
        }
        if (selectAll) {
            this._table.selectAll();
        }
        this.repaint();
    }

    private void _storeOriginalHeaderColor() {
        if (!this._stored) {
            if (this._colHeader != null) {
                this._oldColColor = this._colHeader.getBackground();
                this._oldColColorFg = this._colHeader.getForeground();
            }
            if (this._rowHeader != null) {
                this._oldRowColor = this._rowHeader.getBackground();
                this._oldRowColorFg = this._rowHeader.getForeground();
            }
            this._stored = true;
        }
    }

    private void _reStoreOriginalHeaderColor() {
        if (this._colHeader != null) {
            this._colHeader.putClientProperty("Opacity", Boolean.FALSE);
            if (this._oldColColor != null) {
                this._colHeader.setBackground(this._oldColColor);
            }
            if (this._oldColColorFg != null) {
                this._colHeader.setForeground(this._oldColColorFg);
            }
            this._oldColColor = null;
            this._oldColColorFg = null;
        }
        if (this._rowHeader != null) {
            if (this._oldRowColor != null) {
                this._rowHeader.setBackground(this._oldRowColor);
            }
            if (this._oldRowColorFg != null) {
                this._rowHeader.setForeground(this._oldRowColorFg);
            }
            this._oldRowColor = null;
            this._oldRowColorFg = null;
        }
        this._stored = false;
    }

    private void _setSelectionHeaderColor(boolean rollOver) {
        Color fg;
        Color bg = rollOver ? RolloverTableHandler.getTableCellRolloverHighlight() : this._table.getSelectionBackground();
        Color color = fg = rollOver ? null : this._table.getSelectionForeground();
        if (this._colHeader != null) {
            this._colHeader.putClientProperty("Opacity", Boolean.TRUE);
            this._colHeader.setBackground(bg);
            if (fg != null) {
                this._colHeader.setForeground(fg);
            }
        }
        if (this._rowHeader != null) {
            this._rowHeader.setBackground(bg);
            if (fg != null) {
                this._rowHeader.setForeground(fg);
            }
        }
    }

    private class Listener
    extends MouseInputAdapter
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            SelectAllComponent.this._updateBackground(true, SelectAllComponent.this._pressed, false);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            SelectAllComponent.this._updateBackground(false, false, false);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            SelectAllComponent.this._updateBackground(false, true, false);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            SelectAllComponent.this._updateBackground(false, false, SelectAllComponent.this.contains(me.getPoint()));
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            SelectAllComponent.this._updateBackground(true, false, false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            String name = pe.getPropertyName();
            if ("tableRowHeader".equals(name)) {
                SelectAllComponent.this._rowHeader = (RowHeader)pe.getNewValue();
            } else {
                SelectAllComponent.this._colHeader = (JTableHeader)pe.getNewValue();
            }
        }
    }
}

