/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.javatools.ui.table.ReadOnlySimpleTableFormat;
import oracle.javatools.ui.table.ReorderableTableModel;
import oracle.javatools.ui.table.SimpleTableFormat;

public final class SimpleTableModel<T>
extends AbstractTableModel
implements ReorderableTableModel {
    private SimpleTableFormat<T> tableFormat;
    private final List<T> list = new ArrayList<T>(){

        @Override
        public T set(int index, T element) {
            Object ret = super.set(index, element);
            SimpleTableModel.this.fireTableRowsUpdated(index, index);
            return ret;
        }

        @Override
        public void add(int index, T element) {
            super.add(index, element);
            SimpleTableModel.this.fireTableRowsInserted(index, index);
        }

        @Override
        public T remove(int index) {
            Object ret = super.remove(index);
            SimpleTableModel.this.fireTableRowsDeleted(index, index);
            return ret;
        }

        @Override
        public boolean addAll(Collection<? extends T> items) {
            if (items.isEmpty()) {
                return false;
            }
            int lastIndex = this.size();
            boolean ret = super.addAll(items);
            SimpleTableModel.this.fireTableRowsInserted(lastIndex, this.size() - 1);
            return ret;
        }

        @Override
        public void clear() {
            int size = this.size();
            if (size == 0) {
                return;
            }
            super.clear();
            SimpleTableModel.this.fireTableRowsDeleted(0, size - 1);
        }
    };

    public SimpleTableModel(SimpleTableFormat<T> format) {
        this(new ArrayList(), format);
    }

    public SimpleTableModel(List<T> tableRows) {
        assert (tableRows != null);
        this.tableFormat = new DefaultTableFormat();
        this.list.addAll(tableRows);
    }

    public SimpleTableModel(List<T> tableRows, SimpleTableFormat<T> format) {
        assert (tableRows != null);
        assert (format != null);
        this.tableFormat = format;
        this.list.addAll(tableRows);
    }

    public SimpleTableModel(T[] tableRows, SimpleTableFormat<T> format) {
        assert (tableRows != null);
        assert (format != null);
        this.tableFormat = format;
        this.list.addAll(Arrays.asList(tableRows));
    }

    public List<T> asList() {
        return this.list;
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.tableFormat.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.tableFormat.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.tableFormat.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.tableFormat.isCellEditable(this.list.get(rowIndex), columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.tableFormat.getValueAt(this.list.get(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.tableFormat.setValueAt(this.list.get(rowIndex), aValue, columnIndex);
    }

    public void setFormat(SimpleTableFormat<T> format) {
        this.tableFormat = format;
        this.fireTableStructureChanged();
    }

    public T getRow(int i) {
        return this.list.get(i);
    }

    public int indexOf(T element) {
        return this.list.indexOf(element);
    }

    private void checkBounds(int index) {
        if (index < 0 || index > this.getRowCount() - 1) {
            throw new IndexOutOfBoundsException("Index " + index + " must be between 0 and " + (this.getRowCount() - 1));
        }
    }

    public void rowDataChanged(int index) {
        if (this.getRowCount() == 0) {
            return;
        }
        super.fireTableRowsUpdated(index, index);
    }

    public void rowDataChanged(T row) {
        int index = this.list.indexOf(row);
        if (this.getRowCount() == 0) {
            return;
        }
        super.fireTableRowsUpdated(index, index);
    }

    @Override
    public void moveRow(int start, int end, int to) {
        T bT = this.list.remove(start);
        this.list.add(to, bT);
    }

    private class DefaultTableFormat
    extends ReadOnlySimpleTableFormat<T> {
        private DefaultTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return null;
        }

        @Override
        public Object getValueAt(T rowValue, int columnIndex) {
            return rowValue.toString();
        }
    }
}

