/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.treetable;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import oracle.javatools.ui.treetable.TreeTableModel;

public class NodeTableModelAdapter<T>
implements TableModel {
    private TreeTableModel treeTableModel;
    private T node;
    private transient ArrayList tableModelListeners = new ArrayList(2);

    public NodeTableModelAdapter(TreeTableModel treeTableModel, T node) {
        this.treeTableModel = treeTableModel;
        this.node = node;
    }

    public boolean isExpandable(int row) {
        Object child = this.treeTableModel.getChild(this.node, row);
        return !this.treeTableModel.isLeaf(child);
    }

    public NodeTableModelAdapter getNodeTableModelForChild(int row) {
        Object childNode = this.treeTableModel.getChild(this.node, row);
        NodeTableModelAdapter<Object> childModel = new NodeTableModelAdapter<Object>(this.treeTableModel, childNode);
        return childModel;
    }

    @Override
    public int getRowCount() {
        return this.treeTableModel.getChildCount(this.node);
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.treeTableModel.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.treeTableModel.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Object childNode = this.treeTableModel.getChild(this.node, rowIndex);
        return this.treeTableModel.isCellEditable(childNode, columnIndex);
    }

    public Object getChildNodeAtRow(int rowIndex) {
        return this.treeTableModel.getChild(this.node, rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.treeTableModel.getValueAt(this.getChildNodeAtRow(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object childNode = this.treeTableModel.getChild(this.node, rowIndex);
        this.treeTableModel.setValueAt(aValue, childNode, columnIndex);
        TableModelEvent evt = new TableModelEvent(this, rowIndex);
        this.fireTableChanged(evt);
    }

    @Override
    public synchronized void addTableModelListener(TableModelListener listener) {
        if (this.tableModelListeners == null) {
            this.tableModelListeners = new ArrayList(2);
        }
        this.tableModelListeners.add(listener);
    }

    @Override
    public synchronized void removeTableModelListener(TableModelListener listener) {
        if (this.tableModelListeners != null) {
            this.tableModelListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableChanged(TableModelEvent tableModelEvent) {
        List list;
        NodeTableModelAdapter nodeTableModelAdapter = this;
        synchronized (nodeTableModelAdapter) {
            if (this.tableModelListeners == null) {
                return;
            }
            list = (List)this.tableModelListeners.clone();
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((TableModelListener)list.get(i)).tableChanged(tableModelEvent);
        }
    }

    public T getNode() {
        return this.node;
    }

    public final TreeTableModel getTreeTableModel() {
        return this.treeTableModel;
    }

    public final void setNode(T node) {
        this.node = node;
        TableModelEvent event = new TableModelEvent(this);
        this.fireTableChanged(event);
    }
}

