/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.branchcompare;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.branchcompare.BranchListItem;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITBranchCompare
extends VCSCommand {
    public static String COMMAND_ID = "oracle.jdeveloper.vcs.git.branchcompare";

    public GITBranchCompare() {
        super(Ide.findOrCreateCmdID((String)COMMAND_ID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doitImpl() throws Exception {
        Element[] selection = this.getContext().getSelection();
        GitClient client = null;
        if (selection.length > 0 && selection[0] instanceof BranchListItem) {
            BranchListItem item = (BranchListItem)selection[0];
            URL url = item.getURL();
            String type = GITUtil.getSuffixAsType(url);
            File files = new File(url.getPath());
            String charsetName = StreamDecoder.getDefaultEncoding((URL)url);
            String activeBranch = (String)this.getContext().getProperty("ActiveBranch");
            String compareBranch = (String)this.getContext().getProperty("CompareBranch");
            ByteArrayOutputStream activeOS = new ByteArrayOutputStream();
            ByteArrayOutputStream trackOS = new ByteArrayOutputStream();
            try {
                String filenameAct;
                client = GITClientAdaptor.getClient(url);
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("catFile");
                String filenameCmp = filenameAct = URLFileSystem.getFileName((URL)url);
                client.catFile(files, activeBranch, (OutputStream)activeOS, (ProgressMonitor)monitor);
                if (activeOS.size() == 0 && item.getOrginal() != null) {
                    File files2 = new File(item.getOrginal().getPath());
                    client.catFile(files2, activeBranch, (OutputStream)activeOS, (ProgressMonitor)monitor);
                    filenameAct = URLFileSystem.getFileName((URL)item.getOrginal());
                }
                client.catFile(files, compareBranch, (OutputStream)trackOS, (ProgressMonitor)monitor);
                if (trackOS.size() == 0 && item.getOrginal() != null) {
                    Collection<File> files3 = GITUtil.convertURLToFile(new URL[]{item.getOrginal()});
                    client.catFile(files3.toArray(new File[0])[0], compareBranch, (OutputStream)trackOS, (ProgressMonitor)monitor);
                    filenameCmp = URLFileSystem.getFileName((URL)item.getOrginal());
                }
                String title = filenameAct + " - " + activeBranch;
                InputStreamTextContributor activeContrib = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(activeOS.toByteArray()), charsetName, title, title, type);
                title = filenameCmp + " - " + compareBranch;
                InputStreamTextContributor trackContrib = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(trackOS.toByteArray()), charsetName, title, title, type);
                CompareIdeViewer.getCompareIdeViewer().show((CompareContributor)trackContrib, (CompareContributor)activeContrib, selection[0]);
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
        return 0;
    }
}

