/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITRevision;

public class GITStashFileNode
extends Node {
    private URL _toolUrl;
    private File _file;
    private GITRevision _rev;

    GITStashFileNode(URL url, File file, GITRevision revision) {
        this._toolUrl = url;
        this._file = file;
        this._rev = revision;
        this.setURL(GITNavURLFileSystemHelper.toNavigatorURL(url));
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        try {
            return URLFileSystem.toRelativeSpec((URL)this._file.toURI().toURL(), (URL)this._toolUrl);
        }
        catch (MalformedURLException e) {
            return this._file.getPath();
        }
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"file.png");
    }

    public String getToolTipText() {
        return this._file.getPath();
    }

    public Object getData() {
        return this._rev;
    }

    public File getFile() {
        return this._file;
    }
}

