/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITConnectionInfo;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.nav.GITBranchLocalNode;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.nav.GITTagNode;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITTagListNode
extends DefaultContainer
implements GITRemote {
    private GITConnectionInfo _info;

    GITTagListNode(GITConnectionInfo gitConnectionInfo) {
        this._info = gitConnectionInfo;
        this.setURL(GITNavURLFileSystemHelper.toNavigatorURL(this._info.getRootURL()));
    }

    public String getShortLabel() {
        return Resource.get("NAV_NODE_TAGS");
    }

    public Icon getIcon() {
        return ImageIconCache.get((URL)Resource.getBundle().getClass().getResource(Resource.get("TAG_ICON")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() {
        GitClient client = null;
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            try {
                this._children.clear();
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Tags");
                client = GITClientAdaptor.getClient(GITNavURLFileSystemHelper.fromNavigatorURL(this.getURL()));
                Map tags = client.getTags((ProgressMonitor)monitor, true);
                if (monitor.getError() != null) {
                    GITProfile.getQualifiedLogger(GITTagListNode.class.getName()).log(Level.WARNING, monitor.getError());
                }
                if (monitor.hasFinished()) {
                    for (String key : tags.keySet()) {
                        GitTag tag = (GitTag)tags.get(key);
                        this._children.add(new GITTagNode(tag, this._info.getRootURL()));
                    }
                }
            }
            catch (GitException e) {
                GITProfile.getQualifiedLogger(GITBranchLocalNode.class.getName()).log(Level.WARNING, e.getMessage());
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    public String getToolTipText() {
        return URLFileSystem.toDisplayString((URL)this._info.getRootURL());
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public boolean canRefresh() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GITTagListNode)) {
            return false;
        }
        return this.equalsImpl((Node)obj);
    }
}

