/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.nav.GITBranchNode;
import oracle.jdevimpl.vcs.git.nav.GITRemoteConfigNode;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;
import oracle.jdevimpl.vcs.git.nav.GITStashNode;
import oracle.jdevimpl.vcs.git.nav.GITTagNode;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITNavDeleteCommand
extends VCSCommand {
    private static String COMMAND_ID = "oracle.jdeveloper.git.delete-tag";

    public GITNavDeleteCommand() {
        super(Ide.findCmdID((String)COMMAND_ID).intValue());
    }

    protected int doitImpl() throws Exception {
        boolean stat = false;
        if (this.getContext().getNode() instanceof GITTagNode) {
            stat = this.deleteTag((GITTagNode)this.getContext().getNode());
        } else if (this.getContext().getNode() instanceof GITBranchNode) {
            stat = this.deleteBranch((GITBranchNode)this.getContext().getNode());
        } else if (this.getContext().getNode() instanceof GITRemoteConfigNode) {
            stat = this.deleteRemote((GITRemoteConfigNode)this.getContext().getNode());
        } else if (this.getContext().getNode() instanceof GITStashNode) {
            stat = this.deleteStash((GITStashNode)this.getContext().getNode());
        }
        if (stat) {
            final URL root = this.getContext().getNode().getURL();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GITRepositoryNavigator.getInstance().updateNavigator(root, false);
                }
            });
        }
        return stat ? 0 : 1;
    }

    private boolean deleteTag(GITTagNode node) throws GITProcessException {
        GitClient client = null;
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("deleteTag");
            client = GITClientAdaptor.getClient(GITNavURLFileSystemHelper.fromNavigatorURL(node.getURL()));
            client.deleteTag(node.getTagInfo().getTagName(), (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITNavDeleteCommand.class.getName()).log(Level.WARNING, monitor.getError());
                throw new GITProcessException(Resource.format("ERROR_DELETE_TAG", node.getTagInfo().getTagName()), monitor.getError());
            }
        }
        catch (GitException ge) {
            GITProfile.getQualifiedLogger(GITNavDeleteCommand.class.getName()).log(Level.WARNING, ge.getMessage());
            throw new GITProcessException(Resource.format("ERROR_DELETE_TAG", node.getTagInfo().getTagName()), (Exception)((Object)ge));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return true;
    }

    private boolean deleteBranch(GITBranchNode node) throws GITProcessException {
        GitClient client = null;
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("deleteBranch");
            client = GITClientAdaptor.getClient(GITNavURLFileSystemHelper.fromNavigatorURL(node.getURL()));
            client.deleteBranch(node.getBranch().getName(), false, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITNavDeleteCommand.class.getName()).log(Level.WARNING, monitor.getError());
                throw new GITProcessException(Resource.format("ERROR_DELETE_BRANCH", node.getBranch().getName()), monitor.getError());
            }
        }
        catch (GitException ge) {
            GITProfile.getQualifiedLogger(GITNavDeleteCommand.class.getName()).log(Level.WARNING, ge.getMessage());
            throw new GITProcessException(Resource.format("ERROR_DELETE_BRANCH", node.getBranch().getName()), (Exception)((Object)ge));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return true;
    }

    private boolean deleteRemote(GITRemoteConfigNode node) throws GITProcessException {
        boolean stat = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)Resource.format("CONFIRM_DELETE", node.getRemoteName()), (String)Resource.format("CONFIRM_DELETE_TITLE", new Object[0]), null);
        if (!stat) {
            return false;
        }
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("removeRemote");
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(GITNavURLFileSystemHelper.fromNavigatorURL(node.getURL()));
            client.removeRemote(node.getRemoteName(), (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITNavDeleteCommand.class.getName()).log(Level.WARNING, monitor.getError());
                throw new GITProcessException(Resource.format("ERROR_DELETE_CONFIG", node.getRemoteName()), monitor.getError());
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITNavDeleteCommand.class.getName()).log(Level.WARNING, e.getMessage());
            throw new GITProcessException(Resource.format("ERROR_DELETE_CONFIG", node.getRemoteName()), (Exception)((Object)e));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return true;
    }

    private boolean deleteStash(GITStashNode node) throws GITProcessException {
        boolean stat = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)Resource.format("CONFIRM_DELETE_STASH", node.getShortLabel()), (String)Resource.format("CONFIRM_DELETE_STASH_TITLE", new Object[0]), null);
        if (!stat) {
            return false;
        }
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("removeRemote");
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(GITNavURLFileSystemHelper.fromNavigatorURL(node.getURL()));
            client.stashDrop(node.getStashIndex(), (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITNavDeleteCommand.class.getName()).log(Level.WARNING, monitor.getError());
                throw new GITProcessException(Resource.format("ERROR_DELETE_STASH", node.getShortLabel()), monitor.getError());
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITNavDeleteCommand.class.getName()).log(Level.WARNING, e.getMessage());
            throw new GITProcessException(Resource.format("ERROR_DELETE_STASH", node.getShortLabel()), (Exception)((Object)e));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return true;
    }
}

