/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.vcs.git.GITBranchComparator;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;

public class GITBranchPanel
extends JPanel {
    private JTree _tree;
    private Collection<PropertyChangeListener> _listener = new HashSet<PropertyChangeListener>();

    public GITBranchPanel(Map<String, GitBranch> branches, boolean remoteFirst, boolean expandFirst) {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(new BranchNode(Resource.get("BRANCH_TOP_NODE"), false));
        this.createNodes(top, branches, remoteFirst);
        this._tree = new JTree(top);
        this._tree.getSelectionModel().setSelectionMode(1);
        DefaultTreeCellRenderer render = new DefaultTreeCellRenderer();
        render.setLeafIcon(OracleIcons.getIcon((String)"branch.png"));
        this._tree.setCellRenderer(render);
        this.initLayout();
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                BranchNode bNode = (BranchNode)tNode.getUserObject();
                GITBranchPanel.this.selectionMade(bNode);
            }
        });
        if (expandFirst) {
            this._tree.expandRow(1);
        }
    }

    public GITBranchPanel(Map<String, GitBranch> branches) {
        this(branches, false, false);
    }

    public void addSelectionChangeListener(PropertyChangeListener listener) {
        this._listener.add(listener);
    }

    public void removeSelectionChangeListener(PropertyChangeListener listener) {
        this._listener.remove(listener);
    }

    public Component getDefaultComp() {
        return this._tree;
    }

    private void selectionMade(BranchNode bNode) {
        if (bNode == null) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(bNode._name, bNode._name, !bNode.isIsGitBranch(), bNode.isIsGitBranch());
        this._listener.stream().forEach(item -> item.propertyChange(evt));
    }

    private void createNodes(DefaultMutableTreeNode top, Map<String, GitBranch> branches, boolean remoteFirst) {
        DefaultMutableTreeNode local = new DefaultMutableTreeNode(new BranchNode(Resource.get("BRANCH_LOCAL_NODE"), false));
        DefaultMutableTreeNode remote = new DefaultMutableTreeNode(new BranchNode(Resource.get("BRANCH_REMOTE_NODE"), false));
        if (remoteFirst) {
            top.add(remote);
            top.add(local);
        } else {
            top.add(local);
            top.add(remote);
        }
        ArrayList<GitBranch> sortBranchs = new ArrayList<GitBranch>(branches.values());
        Collections.sort(sortBranchs, new GITBranchComparator());
        for (GitBranch branch : sortBranchs) {
            if (branch.isRemote()) {
                remote.add(new DefaultMutableTreeNode(new BranchNode(branch.getName(), true), false));
                continue;
            }
            local.add(new DefaultMutableTreeNode(new BranchNode(branch.getName(), true), false));
        }
    }

    public String getSelectedBranch() {
        DefaultMutableTreeNode path = (DefaultMutableTreeNode)this._tree.getSelectionPath().getLastPathComponent();
        return path.getUserObject().toString();
    }

    private void initLayout() {
        Insets ins = new Insets(5, 5, 5, 5);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this._tree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
    }

    private static class BranchNode {
        private String _name;
        private boolean _isGitBranch;

        BranchNode(String name, boolean branch) {
            this._name = name;
            this._isGitBranch = branch;
        }

        public boolean isIsGitBranch() {
            return this._isGitBranch;
        }

        public String toString() {
            return this._name;
        }
    }
}

