/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.util.IlvFrameworkProduct;
import ilog.views.util.IlvImageUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.io.IOException;

public final class IlvUtil {
    static final float a = 1.0E-20f;
    private static float b = 3.0f;
    private static int c = 96;

    private IlvUtil() {
    }

    public static void BoundingBox(IlvRect ilvRect, float[] fArray, float[] fArray2, int n) {
        ilvRect.x = fArray[0];
        ilvRect.y = fArray2[0];
        ilvRect.width = 0.0f;
        ilvRect.height = 0.0f;
        for (int i = 1; i < n; ++i) {
            ilvRect.add(fArray[i], fArray2[i]);
        }
    }

    public static void BoundingBox(IlvRect ilvRect, IlvPoint[] ilvPointArray, int n) {
        ilvRect.x = ilvPointArray[0].x;
        ilvRect.y = ilvPointArray[0].y;
        ilvRect.width = 0.0f;
        ilvRect.height = 0.0f;
        for (int i = 1; i < n; ++i) {
            ilvRect.add(ilvPointArray[i].x, ilvPointArray[i].y);
        }
    }

    public static Frame GetFrame(Component component) {
        if (component instanceof Frame || component == null) {
            return (Frame)component;
        }
        return IlvUtil.GetFrame(component.getParent());
    }

    public static float GetDeltaLine() {
        return b;
    }

    public static void SetDeltaLine(float f) {
        b = f;
    }

    public static int GetHeadlessScreenResolution() {
        return c;
    }

    public static void SetHeadlessScreenResolution(int n) {
        c = n;
    }

    public static boolean PointInLine(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
        return IlvUtil.a(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, ilvPoint3.x, ilvPoint3.y, false);
    }

    public static boolean PointInLine(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, boolean bl) {
        return IlvUtil.a(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, ilvPoint3.x, ilvPoint3.y, bl);
    }

    static boolean a(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        double d;
        if (f == f3 && f2 == f4 || f == f5 && f2 == f6) {
            return true;
        }
        float f7 = Math.min(f3, f5);
        float f8 = Math.min(f4, f6);
        float f9 = Math.max(f3, f5) - f7 + 2.0f * b;
        float f10 = Math.max(f4, f6) - f8 + 2.0f * b;
        if (!(f >= (f7 -= b) && f <= f7 + f9 && f2 >= (f8 -= b) && f2 <= f8 + f10)) {
            return false;
        }
        double d2 = (f - f3) * (f5 - f3) + (f2 - f4) * (f6 - f4);
        if (d2 < 0.0) {
            if (bl) {
                return false;
            }
            d = (f - f3) * (f - f3) + (f2 - f4) * (f2 - f4);
        } else {
            d2 = (f5 - f) * (f5 - f3) + (f6 - f2) * (f6 - f4);
            if (d2 < 0.0) {
                if (bl) {
                    return false;
                }
                d = (f - f5) * (f - f5) + (f2 - f6) * (f2 - f6);
            } else {
                double d3 = (f2 - f4) * (f5 - f3) - (f - f3) * (f6 - f4);
                d = d3 * d3 / (double)((f5 - f3) * (f5 - f3) + (f6 - f4) * (f6 - f4));
            }
        }
        return d <= (double)(b * b);
    }

    public static IlvPoint GetLineIntersection(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5) {
        return IlvUtil.GetLineIntersection(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, ilvPoint3.x, ilvPoint3.y, ilvPoint4.x, ilvPoint4.y, ilvPoint5);
    }

    public static IlvPoint GetLineIntersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, IlvPoint ilvPoint) {
        double d9 = d3 - d;
        double d10 = d8 - d6;
        double d11 = d9 * d10;
        double d12 = d7 - d5;
        double d13 = d4 - d2;
        double d14 = d12 * d13;
        if (d11 == d14) {
            return null;
        }
        if (ilvPoint == null) {
            ilvPoint = new IlvPoint();
        }
        ilvPoint.x = d == d3 ? (float)d : (d5 == d7 ? (float)d5 : (float)((d * d14 - d5 * d11 + (d6 - d2) * d9 * d12) / (d14 - d11)));
        ilvPoint.y = d2 == d4 ? (float)d2 : (d6 == d8 ? (float)d6 : (float)((d2 * d11 - d6 * d14 + (d5 - d) * d13 * d10) / (d11 - d14)));
        return ilvPoint;
    }

    public static Cursor CursorFromDirection(int n) {
        switch (n) {
            case 1: {
                return Cursor.getPredefinedCursor(10);
            }
            case 2: {
                return Cursor.getPredefinedCursor(11);
            }
            case 4: {
                return Cursor.getPredefinedCursor(8);
            }
            case 8: {
                return Cursor.getPredefinedCursor(9);
            }
            case 9: {
                return Cursor.getPredefinedCursor(4);
            }
            case 5: {
                return Cursor.getPredefinedCursor(6);
            }
            case 6: {
                return Cursor.getPredefinedCursor(7);
            }
            case 10: {
                return Cursor.getPredefinedCursor(5);
            }
        }
        return Cursor.getDefaultCursor();
    }

    public static double degreesToRadians(double d) {
        return d * Math.PI / 180.0;
    }

    public static double radiansToDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static Image GetImageFromFile(Class clazz, String string) throws IOException {
        return IlvImageUtil.getImageFromFile(clazz, string);
    }

    static final boolean a(IlvRect ilvRect, IlvRect ilvRect2, int n) {
        if (ilvRect.equals(ilvRect2)) {
            return true;
        }
        return IlvUtil.a(ilvRect.x, ilvRect2.x, n) && IlvUtil.a(ilvRect.y, ilvRect2.y, n) && IlvUtil.a(ilvRect.width, ilvRect2.width, n) && IlvUtil.a(ilvRect.height, ilvRect2.height, n);
    }

    private static boolean a(float f, float f2, int n) {
        if ((double)f < 1.0E-4 && (double)f2 < 1.0E-4) {
            return true;
        }
        float f3 = Math.abs(f - f2);
        if ((double)f3 < 1.0E-4) {
            return true;
        }
        double d = f3 / f2;
        double d2 = n != 0 ? (double)(f2 / (float)n) : 1.0E-4;
        return !(d > d2);
    }

    public static final void registerKey(String string) {
    }

    public static final int GetVersion() {
        return IlvFrameworkProduct.getVersion();
    }

    public static final int GetMinorVersion() {
        return IlvFrameworkProduct.getMinorVersion();
    }

    public static final int GetSubMinorVersion() {
        return IlvFrameworkProduct.getSubMinorVersion();
    }

    public static final int GetPatchLevel() {
        return IlvFrameworkProduct.getPatchLevel();
    }
}

