/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvLayerVisibilityFilter;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvZoomFactorVisibilityFilter
extends IlvLayerVisibilityFilter {
    private double a;
    private double b;
    private boolean c = true;
    public static final float NO_LIMIT = -1.0f;

    public IlvZoomFactorVisibilityFilter(double d, double d2) {
        this.a = d;
        this.b = d2;
    }

    public IlvZoomFactorVisibilityFilter(IlvInputStream ilvInputStream) throws IlvReadFileException {
        try {
            this.a = ilvInputStream.readDouble("minZoomFactor");
            this.b = ilvInputStream.readDouble("maxZoomFactor");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public boolean isVisible(IlvManagerLayer ilvManagerLayer, IlvManagerView ilvManagerView) {
        double d = ilvManagerView.getTransformer().zoomFactor();
        return (this.a == -1.0 || d > this.a) && (this.b == -1.0 || d <= this.b);
    }

    @Override
    public boolean isPersistent() {
        return this.c;
    }

    public void setPersistent(boolean bl) {
        this.c = bl;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("minZoomFactor", this.a);
        ilvOutputStream.write("maxZoomFactor", this.b);
    }

    public double getMinZoomFactor() {
        return this.a;
    }

    public void setMinZoomFactor(double d) {
        this.a = d;
    }

    public double getMaxZoomFactor() {
        return this.b;
    }

    public void setMaxZoomFactor(double d) {
        this.b = d;
    }
}

