/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.docview;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvDocumentTemplate;
import ilog.views.appframe.docview.IlvFileDocument;
import ilog.views.appframe.docview.IlvFileFilter;
import ilog.views.appframe.docview.IlvStreamDocument;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.appframe.util.IlvUtil;
import ilog.views.util.internal.IlvURLUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class IlvFileDocumentTemplate
extends IlvDocumentTemplate {
    private IlvFileFilter[] a;
    private boolean b;
    private boolean c = true;
    private transient ArrayList d;
    static final String e = "LastModification";
    static final String f = "FileTemplates";
    static final String g = "FileTemplateFilters";
    public static final String DEFAULT_FILE_FILTER_PROPERTY = "DefaultFileFilter";

    public IlvFileDocumentTemplate() {
    }

    public IlvFileDocumentTemplate(String string) {
        super(string);
    }

    public boolean matchPathName(URL uRL) {
        IlvFileFilter ilvFileFilter = this.getMatchingFilter(uRL);
        return ilvFileFilter != null;
    }

    public boolean matchPathName(String string) {
        IlvFileFilter ilvFileFilter = this.getMatchingFilter(string);
        return ilvFileFilter != null;
    }

    public IlvFileFilter getMatchingFilter(URL uRL) {
        File file;
        if (uRL == null) {
            return null;
        }
        try {
            file = IlvURLUtil.convertFileURLToFile(uRL);
        }
        catch (Exception exception) {
            file = null;
        }
        if (file == null || this.a == null) {
            return null;
        }
        for (int i = 0; i < this.a.length; ++i) {
            if (!this.a[i].accept(file)) continue;
            return this.a[i];
        }
        return null;
    }

    public IlvFileFilter getMatchingFilter(String string) {
        if (string == null) {
            return null;
        }
        if (this.a == null) {
            return null;
        }
        for (int i = 0; i < this.a.length; ++i) {
            if (!this.a[i].accept(string)) continue;
            return this.a[i];
        }
        return null;
    }

    public boolean readDocument(IlvFileDocument ilvFileDocument, URL uRL, IlvFileFilter ilvFileFilter) {
        try {
            URLConnection uRLConnection = IlvURLUtil.openConnection(uRL);
            ilvFileDocument.clean();
            ilvFileDocument.setModified(false);
            ilvFileDocument.setProperty(e, new Long(uRLConnection.getLastModified()));
            boolean bl = ilvFileDocument.readDocument(uRL, ilvFileFilter);
            ilvFileDocument.setModified(false);
            if (bl) {
                ilvFileDocument.setProperty("FileFilter", ilvFileFilter);
            }
            return bl;
        }
        catch (IOException iOException) {
            String string = ilvFileDocument.getApplication().getFormattedString("Docview.FileDoesNotExists", new Object[]{IlvURLUtil.convertFileURLToFilename(uRL)});
            JOptionPane.showMessageDialog(this.getApplication().getMainComponent(), string);
            return false;
        }
    }

    public boolean readDocument(IlvStreamDocument ilvStreamDocument, Reader reader, IlvFileFilter ilvFileFilter) {
        try {
            ilvStreamDocument.clean();
            ilvStreamDocument.setModified(false);
            boolean bl = ilvStreamDocument.readStreamDocument(reader, ilvFileFilter);
            ilvStreamDocument.setModified(false);
            if (bl) {
                ilvStreamDocument.setProperty("FileFilter", ilvFileFilter);
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setDocumentPathName(IlvFileDocument ilvFileDocument, URL uRL) {
        ilvFileDocument.setPathName(uRL);
        if (uRL != null) {
            String string = IlvUtil.GetFileName(uRL);
            ilvFileDocument.setTitle(string != null ? string : IlvUtil.GetFileName(IlvURLUtil.convertFileURLToFilename(uRL)));
        } else {
            ilvFileDocument.setTitle(ilvFileDocument.getApplication().getString("Docview.Untitled"));
        }
    }

    void a(IlvFileDocument ilvFileDocument, boolean bl) {
    }

    public boolean revertDocument(IlvFileDocument ilvFileDocument) {
        IlvApplication ilvApplication = ilvFileDocument.getApplication();
        String string = ilvApplication.getFormattedString("Docview.CancelModifOf", new Object[]{IlvURLUtil.convertFileURLToFilename(ilvFileDocument.getPathName())});
        int n = JOptionPane.showConfirmDialog(ilvApplication.getMainComponent(), string, ilvApplication.getString("Docview.RevertWarning"), 0, 3, new ImageIcon("ilviews/appframe/saveico.xpm"));
        if (n != 0) {
            return false;
        }
        ilvFileDocument.clean();
        IlvFileFilter ilvFileFilter = (IlvFileFilter)ilvFileDocument.getProperty("FileFilter");
        if (this.readDocument(ilvFileDocument, ilvFileDocument.getPathName(), ilvFileFilter)) {
            this.initializeDocumentViews(ilvFileDocument);
            return true;
        }
        return false;
    }

    public void initializeFileChooser(JFileChooser jFileChooser, boolean bl) {
        HashMap<IlvFileFilter, IlvFileDocumentTemplate> hashMap = (HashMap<IlvFileFilter, IlvFileDocumentTemplate>)jFileChooser.getClientProperty(f);
        if (hashMap == null) {
            hashMap = new HashMap<IlvFileFilter, IlvFileDocumentTemplate>();
            jFileChooser.putClientProperty(f, hashMap);
        }
        HashMap hashMap2 = (HashMap)jFileChooser.getClientProperty(g);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            jFileChooser.putClientProperty(g, hashMap2);
        }
        ArrayList<IlvFileFilter> arrayList = new ArrayList<IlvFileFilter>(this.a.length);
        hashMap2.put(this, arrayList);
        if (this.a != null && this.a.length != 0) {
            int n;
            ArrayList<IlvFileFilter> arrayList2 = new ArrayList<IlvFileFilter>(this.a.length);
            for (n = 0; n < this.a.length; ++n) {
                if (!this.a(bl, this.a[n])) continue;
                arrayList2.add(this.a[n]);
            }
            int n2 = -1;
            if (this.d != null) {
                for (int i = 0; i < this.d.size(); ++i) {
                    int n3 = arrayList2.indexOf(this.d.get(i));
                    if (n3 == -1) continue;
                    n2 = n3;
                    break;
                }
            }
            for (n = arrayList2.size() - 1; n >= 0; --n) {
                if (n == n2) continue;
                IlvFileFilter ilvFileFilter = (IlvFileFilter)arrayList2.get(n);
                jFileChooser.addChoosableFileFilter(ilvFileFilter);
                hashMap.put(ilvFileFilter, this);
                arrayList.add(ilvFileFilter);
            }
            if (n2 != -1) {
                IlvFileFilter ilvFileFilter = (IlvFileFilter)arrayList2.get(n2);
                jFileChooser.addChoosableFileFilter(ilvFileFilter);
                hashMap.put(ilvFileFilter, this);
                arrayList.add(ilvFileFilter);
            }
        }
    }

    boolean a(boolean bl, IlvFileFilter ilvFileFilter) {
        if (bl) {
            return (ilvFileFilter.getAccessMode() & 1) != 0;
        }
        return (ilvFileFilter.getAccessMode() & 2) != 0;
    }

    String[] d() {
        if (this.a == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.a.length * 2];
        int n = 0;
        for (int i = 0; i < this.a.length; ++i) {
            stringArray[n++] = this.a[i].getExtension();
            stringArray[n++] = this.a[i].getDescription();
        }
        return stringArray;
    }

    void a(String[] stringArray) {
        if (stringArray == null) {
            this.a = null;
        } else {
            this.a = new IlvFileFilter[stringArray.length];
            int n = 0;
            int n2 = 0;
            while (n < stringArray.length) {
                this.a[n] = this.createFileFilter(stringArray[n2], stringArray[n2 + 1]);
                ++n;
                n2 += 2;
            }
        }
    }

    public int getFilterCount() {
        return this.a == null ? 0 : this.a.length;
    }

    public IlvFileFilter getFilter(int n) {
        if (n >= this.getFilterCount()) {
            return null;
        }
        return this.a[n];
    }

    public void addFilter(IlvFileFilter ilvFileFilter) {
        IlvFileFilter[] ilvFileFilterArray = new IlvFileFilter[this.getFilterCount() + 1];
        if (this.a != null && this.a.length != 0) {
            System.arraycopy(this.a, 0, ilvFileFilterArray, 0, this.a.length);
        }
        ilvFileFilterArray[this.getFilterCount()] = ilvFileFilter;
        this.a = ilvFileFilterArray;
    }

    public IlvFileFilter setDefaultFilter(IlvFileFilter ilvFileFilter) {
        IlvFileFilter ilvFileFilter2 = null;
        if (this.d == null) {
            this.d = new ArrayList();
        } else if (this.d.size() != 0) {
            int n = this.d.indexOf(ilvFileFilter);
            if (n == 0) {
                return ilvFileFilter;
            }
            ilvFileFilter2 = (IlvFileFilter)this.d.get(0);
            if (n != -1) {
                this.d.remove(n);
            }
        }
        this.d.add(0, ilvFileFilter);
        this.setProperty(DEFAULT_FILE_FILTER_PROPERTY, ilvFileFilter);
        return ilvFileFilter2;
    }

    public IlvFileFilter getDefaultFilter() {
        return this.d != null && this.d.size() != 0 ? (IlvFileFilter)this.d.get(0) : null;
    }

    public boolean removeFilter(IlvFileFilter ilvFileFilter) {
        int n = this.getFilterIndex(ilvFileFilter);
        if (n == -1) {
            return false;
        }
        IlvFileFilter[] ilvFileFilterArray = new IlvFileFilter[this.getFilterCount() - 1];
        if (n != 0) {
            System.arraycopy(this.a, 0, ilvFileFilterArray, 0, n);
        }
        if (n != this.a.length - 1) {
            System.arraycopy(this.a, n + 1, ilvFileFilterArray, n, this.a.length - n - 1);
        }
        this.a = ilvFileFilterArray;
        if (this.d != null) {
            this.d.remove(ilvFileFilter);
        }
        return true;
    }

    public int getFilterIndex(IlvFileFilter ilvFileFilter) {
        if (this.a == null) {
            return -1;
        }
        for (int i = 0; i < this.a.length; ++i) {
            if (this.a[i] != ilvFileFilter) continue;
            return i;
        }
        return -1;
    }

    IlvFileFilter a(int n, IlvFileFilter ilvFileFilter) {
        if (n >= this.getFilterCount()) {
            IlvFileFilter[] ilvFileFilterArray = new IlvFileFilter[n + 1];
            if (this.a != null && this.a.length != 0) {
                System.arraycopy(this.a, 0, ilvFileFilterArray, 0, this.a.length);
            }
            for (int i = 0; i < n; ++i) {
                ilvFileFilterArray[i] = null;
            }
            ilvFileFilterArray[n] = ilvFileFilter;
            this.a = ilvFileFilterArray;
            return null;
        }
        IlvFileFilter ilvFileFilter2 = this.a[n];
        this.a[n] = ilvFileFilter;
        return ilvFileFilter2;
    }

    String a(int n) {
        if (n >= this.getFilterCount()) {
            return null;
        }
        return this.getFilter(n).getExtension();
    }

    String b(int n) {
        if (n >= this.getFilterCount()) {
            return null;
        }
        return this.getFilter(n).getDescription();
    }

    public boolean appearsInLoadFileFilters() {
        return this.b;
    }

    public void setAppearsInLoadFileFilters(boolean bl) {
        this.b = bl;
    }

    public boolean appearsInNewDocuments() {
        return this.c;
    }

    public void setAppearsInNewDocuments(boolean bl) {
        this.c = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String string2 = this.b("open_command", null);
        if (string2 != null && string2.equals(string)) {
            this.getApplication().openDocument(this);
            return;
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    public boolean isProcessingAction(String string) {
        String string2 = this.b("open_command", null);
        if (string2 != null && string2.equals(string)) {
            return true;
        }
        return super.isProcessingAction(string);
    }

    @Override
    public boolean readSettings(IlvSettingsElement ilvSettingsElement, IlvApplication ilvApplication) {
        if (!super.readSettings(ilvSettingsElement, ilvApplication)) {
            return false;
        }
        this.a = null;
        this.d = null;
        IlvFileFilter ilvFileFilter = null;
        IlvSettingsElement[] ilvSettingsElementArray = ilvSettingsElement.getChildren("filter");
        int n = ilvSettingsElementArray == null ? 0 : ilvSettingsElementArray.length;
        ArrayList<IlvFileFilter> arrayList = new ArrayList<IlvFileFilter>(n);
        for (int i = 0; i < n; ++i) {
            IlvFileFilter ilvFileFilter2 = this.createFileFilter(ilvSettingsElementArray[i].getString("format"), ilvSettingsElementArray[i].getString("description"));
            String string = ilvSettingsElementArray[i].getString("accessMode");
            if (string != null) {
                if (string.equals("READ")) {
                    ilvFileFilter2.setAccessMode(1);
                } else if (string.equals("WRITE")) {
                    ilvFileFilter2.setAccessMode(2);
                } else if (string.equals("READ_WRITE")) {
                    ilvFileFilter2.setAccessMode(3);
                } else {
                    ilvFileFilter2.setAccessMode(0);
                }
            }
            boolean bl = false;
            boolean bl2 = ilvSettingsElementArray[i].getBoolean("default", false);
            String string2 = ilvFileFilter2.getDescription();
            if (string2 != null) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    IlvFileFilter ilvFileFilter3 = (IlvFileFilter)arrayList.get(j);
                    if (ilvFileFilter3.getDescription() == null || !ilvFileFilter3.getDescription().equals(string2) || ilvFileFilter3.getAccessMode() != ilvFileFilter2.getAccessMode()) continue;
                    ilvFileFilter3.a(ilvFileFilter2.getExtension());
                    bl = true;
                    if (!bl2) break;
                    ilvFileFilter = ilvFileFilter3;
                    break;
                }
            }
            if (bl) continue;
            if (bl2) {
                ilvFileFilter = ilvFileFilter2;
            }
            arrayList.add(ilvFileFilter2);
        }
        if (n != 0) {
            this.a = new IlvFileFilter[arrayList.size()];
            System.arraycopy(arrayList.toArray(), 0, this.a, 0, this.a.length);
            if (ilvFileFilter != null) {
                this.setDefaultFilter(ilvFileFilter);
            }
        }
        this.b = ilvSettingsElement.getBoolean("appearsInMainFileBrowser", true);
        this.c = ilvSettingsElement.getBoolean("appearsInNewDocuments", this.b);
        return true;
    }

    protected IlvFileFilter createFileFilter(String string, String string2) {
        return new IlvFileFilter(this, string, string2);
    }
}

