/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.docview.jnlp;

import ilog.views.appframe.docview.IlvAbstractFileDocument;
import ilog.views.appframe.docview.IlvDocument;
import ilog.views.appframe.docview.IlvFileDocument;
import ilog.views.appframe.docview.IlvFileDocumentTemplate;
import ilog.views.appframe.docview.IlvFileFilter;
import ilog.views.appframe.docview.IlvMainWindow;
import ilog.views.appframe.docview.IlvStreamDocument;
import ilog.views.appframe.docview.internal.IlvDocumentManager;
import ilog.views.appframe.docview.jnlp.IlvJNLPFileChooserSelection;
import ilog.views.appframe.docview.jnlp.IlvJNLPFileContents;
import ilog.views.appframe.swing.IlvSwingMainWindow;
import ilog.views.appframe.util.IlvFileChooserSelection;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JFrame;

class IlvJNLPDocumentManager
extends IlvDocumentManager {
    public static final String JNLP_FILE_CONTENTS_PROPERTY = "JNLP_FILE_CONTENTS";

    @Override
    public IlvFileChooserSelection[] showFileChooser(String string, String string2, int n, IlvFileDocumentTemplate ilvFileDocumentTemplate, Component component) {
        FileOpenService fileOpenService;
        String[] stringArray = null;
        try {
            fileOpenService = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
        }
        catch (UnavailableServiceException unavailableServiceException) {
            fileOpenService = null;
        }
        if (ilvFileDocumentTemplate != null) {
            stringArray = new String[ilvFileDocumentTemplate.getFilterCount()];
            for (int i = 0; i < ilvFileDocumentTemplate.getFilterCount(); ++i) {
                stringArray[i] = ilvFileDocumentTemplate.getFilter(i).getExtension();
            }
        }
        try {
            FileContents fileContents = null;
            if (fileOpenService != null) {
                fileContents = fileOpenService.openFileDialog(string, stringArray);
            }
            if (fileContents != null) {
                int n2;
                for (n2 = 0; stringArray != null && n2 < stringArray.length && !fileContents.getName().endsWith(stringArray[n2]); ++n2) {
                }
                return new IlvFileChooserSelection[]{new IlvJNLPFileChooserSelection(ilvFileDocumentTemplate, ilvFileDocumentTemplate != null ? ilvFileDocumentTemplate.getFilter(n2) : null, fileContents)};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IlvDocument openDocument(boolean bl, IlvMainWindow ilvMainWindow) {
        IlvFileChooserSelection[] ilvFileChooserSelectionArray;
        JFrame jFrame = null;
        if (ilvMainWindow instanceof IlvSwingMainWindow) {
            jFrame = ((IlvSwingMainWindow)ilvMainWindow).getFrame();
        }
        if (ilvMainWindow instanceof JFrame) {
            jFrame = (JFrame)((Object)ilvMainWindow);
        }
        if ((ilvFileChooserSelectionArray = this.getApplication().showFileChooser(null, null, 10, null, jFrame)) == null || ilvFileChooserSelectionArray.length == 0) {
            return null;
        }
        if (ilvFileChooserSelectionArray[0] instanceof IlvJNLPFileChooserSelection) {
            try {
                IlvFileDocumentTemplate ilvFileDocumentTemplate = this.findBestTemplate(((IlvJNLPFileChooserSelection)ilvFileChooserSelectionArray[0]).getFileContents().getName());
                return this.newDocument(true, ilvFileDocumentTemplate, new IlvJNLPDocumentInitializer(), ilvFileChooserSelectionArray[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.openDocument(ilvFileChooserSelectionArray[0].getURL(), bl, true);
    }

    @Override
    public boolean saveDocument(IlvDocument ilvDocument) {
        block5: {
            block4: {
                if (!(ilvDocument instanceof IlvAbstractFileDocument)) break block4;
                if (ilvDocument.getProperty(JNLP_FILE_CONTENTS_PROPERTY) != null) break block5;
            }
            return false;
        }
        IlvAbstractFileDocument ilvAbstractFileDocument = (IlvAbstractFileDocument)ilvDocument;
        try {
            FileContents fileContents = (FileContents)ilvAbstractFileDocument.getProperty(JNLP_FILE_CONTENTS_PROPERTY);
            OutputStream outputStream = fileContents.getOutputStream(true);
            IlvFileFilter ilvFileFilter = (IlvFileFilter)ilvAbstractFileDocument.getProperty("FileFilter");
            ilvAbstractFileDocument.writeDocument(new OutputStreamWriter(outputStream), ilvFileFilter);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean saveFileDocument(IlvFileDocument ilvFileDocument, String string, IlvFileFilter ilvFileFilter, boolean bl) {
        FileContents fileContents;
        FileSaveService fileSaveService;
        try {
            fileSaveService = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
        }
        catch (UnavailableServiceException unavailableServiceException) {
            fileSaveService = null;
        }
        if (fileSaveService == null) {
            return false;
        }
        try {
            fileContents = (FileContents)ilvFileDocument.getProperty(JNLP_FILE_CONTENTS_PROPERTY);
            fileContents = fileSaveService.saveAsFileDialog(null, null, (FileContents)(fileContents == null ? new IlvJNLPFileContents(ilvFileDocument) : fileContents));
            if (fileContents != null) {
                ilvFileDocument.setProperty(JNLP_FILE_CONTENTS_PROPERTY, fileContents);
                ilvFileDocument.setProperty("MRU", Boolean.FALSE);
            }
        }
        catch (Exception exception) {
        }
        if (ilvFileDocument.getProperty(JNLP_FILE_CONTENTS_PROPERTY) == null || !(ilvFileDocument instanceof IlvAbstractFileDocument)) {
            return false;
        }
        try {
            fileContents = (FileContents)ilvFileDocument.getProperty(JNLP_FILE_CONTENTS_PROPERTY);
            if (fileContents != null && fileContents.canWrite()) {
                OutputStream outputStream = fileContents.getOutputStream(true);
                IlvFileFilter ilvFileFilter2 = (IlvFileFilter)ilvFileDocument.getProperty("FileFilter");
                ((IlvAbstractFileDocument)ilvFileDocument).writeDocument(new OutputStreamWriter(outputStream), ilvFileFilter2);
                ilvFileDocument.setTitle(fileContents.getName());
                ilvFileDocument.setModified(false);
                return true;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return false;
    }

    private static class IlvJNLPDocumentInitializer
    implements IlvDocumentManager.DocumentInitializer {
        private IlvJNLPDocumentInitializer() {
        }

        @Override
        public boolean initializeDocument(IlvDocument ilvDocument, Object object, IlvDocumentManager.DocTemplateInfo docTemplateInfo) {
            if (!(ilvDocument instanceof IlvStreamDocument)) {
                return false;
            }
            try {
                FileContents fileContents = ((IlvJNLPFileChooserSelection)object).getFileContents();
                ((IlvFileDocumentTemplate)ilvDocument.getDocumentTemplate()).readDocument((IlvStreamDocument)ilvDocument, new InputStreamReader(fileContents.getInputStream()), ((IlvJNLPFileChooserSelection)object).getFilter());
                ilvDocument.setTitle(fileContents.getName());
                ilvDocument.setProperty(IlvJNLPDocumentManager.JNLP_FILE_CONTENTS_PROPERTY, fileContents);
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
    }
}

