/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.form.internal.controller.validation;

import ilog.views.appframe.form.internal.controller.IlvEditionContext;
import ilog.views.appframe.form.internal.controller.IlvFormEditor;
import ilog.views.appframe.form.internal.controller.IlvFormSingleEditor;
import ilog.views.appframe.form.internal.controller.validation.IlvFileValidator;
import ilog.views.appframe.form.internal.controller.validation.IlvValidationError;
import ilog.views.appframe.form.internal.controller.validation.Messages;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.w3c.dom.Element;

public class IlvFileMustExistValidator
extends IlvFileValidator {
    private boolean a = false;

    @Override
    protected IlvValidationError validateFile(File file, int n, IlvEditionContext ilvEditionContext) {
        Object object;
        if (file == null) {
            return this.createError(Messages.GetMessage(this.a ? "Validator.File.NullDirectory" : "Validator.File.NullFile"), ilvEditionContext);
        }
        if (file.exists()) {
            return null;
        }
        Container container = null;
        IlvFormEditor ilvFormEditor = this.getEditor();
        if (ilvFormEditor instanceof IlvFormSingleEditor) {
            object = ((IlvFormSingleEditor)ilvFormEditor).getControl();
            if (object instanceof Container) {
                container = (Container)object;
            } else if (object instanceof Component) {
                container = ((Component)object).getParent();
            }
        }
        if (JOptionPane.showConfirmDialog(container, Messages.GetMessage(this.a ? "Validator.File.CreateDirectoryFormat" : "Validator.File.CreateFileFormat", this.input.getInputText()), Messages.GetMessage(this.a ? "Validator.File.CreateDirectoryDialogTitle" : "Validator.File.CreateFileDialogTitle"), 0, 3) == 0) {
            object = file.getParentFile();
            if (object != null) {
                try {
                    ((File)object).mkdirs();
                }
                catch (Exception exception) {
                    return this.createError(Messages.GetMessage("Validator.File.CouldNotCreateDirectory", ((File)object).getPath(), exception.getMessage()), ilvEditionContext);
                }
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    return this.createError(Messages.GetMessage("Validator.File.CouldNotCreateFile", file.getPath(), iOException.getMessage()), ilvEditionContext);
                }
            }
            return null;
        }
        object = Messages.GetMessage(this.message, this.input.getInputText());
        return this.createError((String)object, ilvEditionContext);
    }

    @Override
    public void read(Element element) {
        super.read(element);
        String string = element.getAttribute("directory");
        if (string != null && string.length() != 0) {
            this.a = Boolean.getBoolean(string);
        }
        if (this.message == null || this.message.length() == 0) {
            this.message = Messages.GetMessage(this.a ? "Validator.File.DirectoryMustExistFormat" : "Validator.File.FileMustExistFormat");
        }
        string = element.getAttribute("validate");
        if (string == null || string.length() == 0) {
            this.mode = 2;
        }
    }
}

