/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.settings.internal;

import ilog.views.appframe.settings.IlvSettings;
import ilog.views.appframe.settings.IlvSettingsManager;
import ilog.views.appframe.settings.xml.IlvXMLSettings;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.swing.IlvSwingUtil;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IlvSettingsVersion {
    private IlvSwingUtil.Version a;
    private long b;
    public static final boolean DEBUG = false;
    public static final boolean IN_USE = true;
    public static final boolean GET_JAR_ENTRY_DATES = true;
    private static SimpleDateFormat c = null;
    private static final int d = 1000000;
    private static final int e = 10000;
    private static final int f = 100;

    public IlvSettingsVersion() {
    }

    public IlvSettingsVersion(IlvSettings ilvSettings, boolean bl) {
        block12: {
            IlvSettings[] ilvSettingsArray;
            block11: {
                Object object;
                if (!(ilvSettings instanceof IlvXMLSettings)) break block11;
                IlvXMLSettings ilvXMLSettings = (IlvXMLSettings)ilvSettings;
                URL uRL = ilvXMLSettings.getXMLFileURL();
                if (uRL == null) {
                    // empty if block
                }
                try {
                    if ("jar".equals(uRL.getProtocol())) {
                        object = uRL.getPath();
                        int n = ((String)object).indexOf(33);
                        if (n != -1) {
                            String string = ((String)object).substring(0, n);
                            if (string.startsWith("file:")) {
                                string = IlvURLUtil.convertFileURLToFilename(new URL(string));
                            }
                            File file = new File(string);
                            JarFile jarFile = new JarFile(file);
                            try {
                                ZipEntry zipEntry = jarFile.getEntry(((String)object).substring(n + 2));
                                this.b = zipEntry.getTime();
                            }
                            catch (Exception exception) {
                                this.b = file.lastModified();
                            }
                        }
                    } else {
                        object = IlvURLUtil.convertFileURLToFile(uRL);
                        this.b = ((File)object).lastModified();
                    }
                }
                catch (Exception exception) {
                    return;
                }
                if (!bl || (object = IlvSettingsVersion.a(ilvXMLSettings)) == null) break block12;
                String string = object.getAttribute("version");
                if (string == null || string.length() == 0) break block12;
                this.a = IlvSettingsVersion.ParseVersion(string);
                break block12;
            }
            if (ilvSettings instanceof IlvSettingsManager && (ilvSettingsArray = ((IlvSettingsManager)ilvSettings).getSettings()) != null) {
                for (int i = 0; i < ilvSettingsArray.length; ++i) {
                    IlvSettingsVersion ilvSettingsVersion = new IlvSettingsVersion(ilvSettingsArray[i], false);
                    this.mergeWith(ilvSettingsVersion);
                }
            }
        }
    }

    public IlvSwingUtil.Version getVersion() {
        return this.a;
    }

    public void mergeWith(IlvSettingsVersion ilvSettingsVersion) {
        if (ilvSettingsVersion.b != 0L && (this.b == 0L || ilvSettingsVersion.b > this.b)) {
            this.b = ilvSettingsVersion.b;
        }
        this.mergeWith(ilvSettingsVersion.a);
    }

    public void mergeWith(IlvSwingUtil.Version version) {
        if (version == null) {
            return;
        }
        if (this.a != null && this.a.compareTo(version) >= 0) {
            return;
        }
        int n = version.intValue();
        int n2 = n / 1000000;
        int n3 = (n -= n2 * 1000000) / 10000;
        int n4 = (n -= n3 * 10000) / 100;
        n -= n4 * 100;
        this.a = new IlvSwingUtil.Version(n2, n3, n4);
    }

    public int compareVersions(IlvSettingsVersion ilvSettingsVersion) {
        if (ilvSettingsVersion.a == null) {
            return this.a != null ? 1 : 0;
        }
        if (this.a == null) {
            return -1;
        }
        return this.a.compareTo(ilvSettingsVersion.a);
    }

    public int compareDates(IlvSettingsVersion ilvSettingsVersion) {
        if (ilvSettingsVersion.b == 0L) {
            return 1;
        }
        if (ilvSettingsVersion.b == this.b) {
            return 0;
        }
        return this.b > ilvSettingsVersion.b ? 1 : -1;
    }

    public int compareTo(IlvSettingsVersion ilvSettingsVersion) {
        int n = this.compareVersions(ilvSettingsVersion);
        if (n != 0) {
            return n;
        }
        return this.compareDates(ilvSettingsVersion);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IlvSettingsVersion)) {
            return false;
        }
        return this.compareTo((IlvSettingsVersion)object) == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.a == null ? "No version" : this.a.toString());
        stringBuffer.append(' ');
        stringBuffer.append('-');
        stringBuffer.append(' ');
        if (c == null) {
            c = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        }
        stringBuffer.append(c.format(new Date(this.b)));
        return stringBuffer.toString();
    }

    public static void WriteVersion(IlvXMLSettings ilvXMLSettings, IlvSwingUtil.Version version) {
        Element element = IlvSettingsVersion.a(ilvXMLSettings);
        if (element != null) {
            if (version == null) {
                if (element.hasAttribute("version")) {
                    element.removeAttribute("version");
                }
            } else {
                element.setAttribute("version", version.toString());
            }
        }
    }

    public static IlvSwingUtil.Version ParseVersion(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = stringBuffer.indexOf(".");
        String string2 = n5 == -1 ? string : string.substring(0, n5);
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (n5 != -1) {
            n = stringBuffer.indexOf(".", n5 + 1);
            string2 = n == -1 ? string.substring(n5 + 1) : string.substring(n5 + 1, n);
            n5 = n;
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return new IlvSwingUtil.Version(n2, n3, n4);
            }
        }
        if (n5 != -1) {
            n = stringBuffer.indexOf(".", n5 + 1);
            string2 = n == -1 ? string.substring(n5 + 1) : string.substring(n5 + 1, n);
            n5 = n;
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return new IlvSwingUtil.Version(n2, n3, n4);
            }
        }
        return new IlvSwingUtil.Version(n2, n3, n4);
    }

    public static String GetURLID(URL uRL) {
        if (uRL == null) {
            return "null";
        }
        String string = IlvURLUtil.convertFileURLToFilename(uRL);
        int n = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String GetSettingsID(IlvSettings ilvSettings) {
        if (ilvSettings instanceof IlvXMLSettings) {
            URL uRL = ((IlvXMLSettings)ilvSettings).getXMLFileURL();
            return "XML settings (" + IlvSettingsVersion.GetURLID(uRL) + ")";
        }
        Class<?> clazz = ilvSettings.getClass();
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    private static Element a(IlvXMLSettings ilvXMLSettings) {
        NodeList nodeList;
        Element element = ilvXMLSettings.getDocumentElement();
        if (element.getTagName().equals("appframe") && (nodeList = element.getChildNodes()) != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                if (!((Element)node).getTagName().equals("settings")) continue;
                return (Element)node;
            }
        }
        return null;
    }

    public static void Print(String string) {
        System.out.println("IlvSettingsVersion: " + string);
    }
}

