/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.bars;

import ilog.views.appframe.settings.IlvSettings;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.appframe.swing.bars.IlvBarStyle;
import ilog.views.appframe.swing.bars.IlvBarWorkspace;
import ilog.views.appframe.swing.bars.IlvDockingBarAreaHandler;
import ilog.views.appframe.util.logging.IlvLog;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;

public class IlvConfigurationExtension {
    private String a;
    private ArrayList b;
    private HashMap c;
    private HashMap d;
    private boolean e = true;
    private static final String f = "dock";
    private static final String g = "undock";
    private static final String h = "show";
    private static final String i = "hide";

    public IlvConfigurationExtension(IlvSettingsElement ilvSettingsElement) {
        this.readSettings(ilvSettingsElement);
    }

    public void apply(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
        if (this.b != null) {
            ConfigurationAction configurationAction;
            int n;
            if (this.e) {
                for (n = 0; n < this.b.size(); ++n) {
                    configurationAction = (ConfigurationAction)this.b.get(n);
                    configurationAction.a(ilvDockingBarAreaHandler);
                }
                this.e = false;
            }
            for (n = 0; n < this.b.size(); ++n) {
                configurationAction = (ConfigurationAction)this.b.get(n);
                if (!configurationAction.canApply()) continue;
                configurationAction.apply(ilvDockingBarAreaHandler);
            }
        }
    }

    public void unApply(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
        if (this.b != null) {
            for (int i = this.b.size() - 1; i >= 0; --i) {
                ConfigurationAction configurationAction = (ConfigurationAction)this.b.get(i);
                if (!configurationAction.canApply()) continue;
                configurationAction.unApply(ilvDockingBarAreaHandler);
            }
        }
    }

    public void addBarStyles(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
        this.a(ilvDockingBarAreaHandler, true);
    }

    public void removeBarStyles(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
        this.a(ilvDockingBarAreaHandler, false);
    }

    void a(IlvDockingBarAreaHandler ilvDockingBarAreaHandler, boolean bl) {
        if (this.c == null || this.c.size() == 0) {
            return;
        }
        if (bl && this.d == null) {
            this.d = new HashMap(this.c.size());
        }
        for (IlvBarStyle ilvBarStyle : this.c.values()) {
            IlvBarStyle ilvBarStyle2;
            if (bl) {
                ilvBarStyle2 = ilvDockingBarAreaHandler.a(ilvBarStyle);
                ilvBarStyle.setExtension(ilvBarStyle2 == null);
                this.d.put(ilvBarStyle.getName(), ilvBarStyle2);
                continue;
            }
            ilvBarStyle2 = (IlvBarStyle)this.d.get(ilvBarStyle.getName());
            if (ilvBarStyle2 == null) {
                ilvDockingBarAreaHandler.f(ilvBarStyle.getName());
                continue;
            }
            ilvDockingBarAreaHandler.a(ilvBarStyle2);
        }
    }

    public void readSettings(IlvSettingsElement ilvSettingsElement) {
        Object object;
        int n;
        IlvSettingsElement[] ilvSettingsElementArray;
        this.a = ilvSettingsElement.getString("name");
        IlvSettingsElement ilvSettingsElement2 = ilvSettingsElement.getFirstChild("actions");
        this.b = null;
        if (ilvSettingsElement2 != null && (ilvSettingsElementArray = ilvSettingsElement2.getChildren()) != null && ilvSettingsElementArray.length != 0) {
            this.b = new ArrayList(ilvSettingsElementArray.length);
            for (n = 0; n < ilvSettingsElementArray.length; ++n) {
                object = this.createAction(ilvSettingsElementArray[n].getType());
                if (object == null) continue;
                ((ConfigurationAction)object).readSettings(ilvSettingsElementArray[n]);
                this.b.add(object);
            }
        }
        ilvSettingsElementArray = (ilvSettingsElement2 = ilvSettingsElement.getFirstChild("bars")) == null ? null : ilvSettingsElement2.getChildren("bar");
        this.c = new HashMap();
        if (ilvSettingsElementArray != null) {
            for (n = 0; n < ilvSettingsElementArray.length; ++n) {
                object = new IlvBarStyle(ilvSettingsElementArray[n]);
                this.c.put(((IlvBarStyle)object).getName(), object);
            }
        }
    }

    public void writeSettings(IlvSettingsElement ilvSettingsElement) {
        IlvSettingsElement ilvSettingsElement2;
        IlvSettingsElement ilvSettingsElement3;
        IlvSettings ilvSettings = ilvSettingsElement.getSettings();
        ilvSettingsElement.removeAll(null);
        if (this.a != null) {
            ilvSettingsElement.setString("name", this.a);
        }
        if (this.b != null && this.b.size() != 0) {
            ilvSettingsElement3 = ilvSettingsElement.ensureChildElement("actions");
            for (int i = 0; i < this.b.size(); ++i) {
                Object object = (ConfigurationAction)this.b.get(i);
                ilvSettingsElement2 = ilvSettings.createSettingsElement(((ConfigurationAction)object).getSettingsType());
                ((ConfigurationAction)object).writeSettings(ilvSettingsElement2);
                ilvSettingsElement3.getSettings().addSettingsElement(ilvSettingsElement3, ilvSettingsElement2, -1);
            }
        }
        ilvSettingsElement.removeAll("bars");
        if (this.c != null && this.c.size() != 0) {
            ilvSettingsElement3 = ilvSettingsElement.ensureChildElement("bars");
            for (Object object : this.c.values()) {
                ilvSettingsElement2 = ilvSettings.createSettingsElement("bar");
                ((IlvBarStyle)object).writeSettings(ilvSettingsElement2);
                ilvSettingsElement3.add(ilvSettingsElement2);
            }
        }
    }

    public String getName() {
        return this.a;
    }

    public boolean doesApplyConfiguration(IlvBarWorkspace ilvBarWorkspace) {
        if (this.a == null || this.a.length() == 0) {
            return true;
        }
        return this.a.compareToIgnoreCase(ilvBarWorkspace.getName()) == 0;
    }

    public void applyConfiguration(IlvBarWorkspace ilvBarWorkspace) {
    }

    protected ConfigurationAction createAction(String string) {
        if (string.equals(f)) {
            return new DockAction();
        }
        if (string.equals(g)) {
            return new UndockAction();
        }
        if (string.equals(h)) {
            return new VisibilityAction(true);
        }
        if (string.equals(i)) {
            return new VisibilityAction(false);
        }
        IlvLog.Log("ilog.views.appframe", IlvLog.WARNING, "Logging.BarDocking.UnknownConfigAction", new Object[]{string});
        return null;
    }

    static class VisibilityAction
    extends ConfigurationAction {
        private boolean a;
        private HashMap b = new HashMap(3);

        public VisibilityAction(boolean bl) {
            this.a = bl;
        }

        @Override
        public String getSettingsType() {
            return this.a ? IlvConfigurationExtension.h : IlvConfigurationExtension.i;
        }

        @Override
        public void apply(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
            boolean bl = this.isFirstUse(ilvDockingBarAreaHandler);
            super.apply(ilvDockingBarAreaHandler);
            if (!this.canApply()) {
                return;
            }
            IlvBarWorkspace ilvBarWorkspace = ilvDockingBarAreaHandler.getCurrentWorkspace();
            if (bl) {
                this.b.put(ilvBarWorkspace, ilvDockingBarAreaHandler.isBarVisible(this.name) ? Boolean.TRUE : Boolean.FALSE);
            }
            super.apply(ilvDockingBarAreaHandler);
            if (this.a(ilvDockingBarAreaHandler) != this.a) {
                ilvDockingBarAreaHandler.setBarVisible(this.name, this.a);
            }
        }

        @Override
        public void unApply(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
            boolean bl = this.a(ilvDockingBarAreaHandler);
            if (this.canApply() && bl != this.a) {
                ilvDockingBarAreaHandler.setBarVisible(this.name, bl);
            }
        }

        private boolean a(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
            return Boolean.TRUE.equals(this.b.get(ilvDockingBarAreaHandler.getCurrentWorkspace()));
        }
    }

    static class UndockAction
    extends ConfigurationAction {
        Point a;

        UndockAction() {
        }

        @Override
        public void readSettings(IlvSettingsElement ilvSettingsElement) {
            super.readSettings(ilvSettingsElement);
            this.a = new Point(ilvSettingsElement.getInt("x", 0), ilvSettingsElement.getInt("y", 0));
        }

        @Override
        public void writeSettings(IlvSettingsElement ilvSettingsElement) {
            super.writeSettings(ilvSettingsElement);
            ilvSettingsElement.setInt("x", this.a.x);
            ilvSettingsElement.setInt("y", this.a.y);
        }

        @Override
        public String getSettingsType() {
            return IlvConfigurationExtension.g;
        }

        @Override
        public void apply(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
            boolean bl = this.isFirstUse(ilvDockingBarAreaHandler);
            super.apply(ilvDockingBarAreaHandler);
            if (!this.canApply()) {
                return;
            }
            if (bl) {
                ilvDockingBarAreaHandler.undock(this.name, this.a);
            } else {
                ilvDockingBarAreaHandler.setBarVisible(this.name, true);
            }
        }

        @Override
        public void unApply(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
            if (this.canApply()) {
                ilvDockingBarAreaHandler.setBarVisible(this.name, false);
            }
        }
    }

    static class DockAction
    extends ConfigurationAction {
        int a;

        DockAction() {
        }

        @Override
        public void readSettings(IlvSettingsElement ilvSettingsElement) {
            super.readSettings(ilvSettingsElement);
            this.a = this.a(ilvSettingsElement, "orientation");
        }

        @Override
        public void writeSettings(IlvSettingsElement ilvSettingsElement) {
            super.writeSettings(ilvSettingsElement);
            this.a(ilvSettingsElement, "orientation", this.a);
        }

        @Override
        public String getSettingsType() {
            return IlvConfigurationExtension.f;
        }

        @Override
        public void apply(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
            boolean bl = this.isFirstUse(ilvDockingBarAreaHandler);
            super.apply(ilvDockingBarAreaHandler);
            if (!this.canApply()) {
                return;
            }
            if (bl) {
                ilvDockingBarAreaHandler.dock(this.name, this.a);
            } else {
                ilvDockingBarAreaHandler.setBarVisible(this.name, true);
            }
        }

        @Override
        public void unApply(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
            if (this.canApply()) {
                ilvDockingBarAreaHandler.setBarVisible(this.name, false);
            }
        }
    }

    static abstract class ConfigurationAction {
        private boolean a;
        private ArrayList b = new ArrayList(3);
        protected String name;
        boolean c;
        boolean d;

        ConfigurationAction() {
        }

        public void apply(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
            if (this.isFirstUse(ilvDockingBarAreaHandler)) {
                this.a = !ilvDockingBarAreaHandler.d(this.name);
                this.b.add(ilvDockingBarAreaHandler.getCurrentWorkspace());
            }
        }

        public abstract void unApply(IlvDockingBarAreaHandler var1);

        public void readSettings(IlvSettingsElement ilvSettingsElement) {
            this.name = ilvSettingsElement.getString("name");
            this.c = ilvSettingsElement.getBoolean("force", false);
        }

        public void writeSettings(IlvSettingsElement ilvSettingsElement) {
            ilvSettingsElement.setString("name", this.name);
            ilvSettingsElement.setBoolean("force", this.c);
        }

        public abstract String getSettingsType();

        private boolean a(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
            this.d = this.c || !ilvDockingBarAreaHandler.d(this.name);
            return this.d;
        }

        int a(IlvSettingsElement ilvSettingsElement, String string) {
            block11: {
                block10: {
                    String string2;
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    string2 = ilvSettingsElement.getString(string, "top");
                                    if (string2.compareToIgnoreCase("top") == 0) break block6;
                                    if (string2.compareToIgnoreCase("north") != 0) break block7;
                                }
                                return 1;
                            }
                            if (string2.compareToIgnoreCase("left") == 0) break block8;
                            if (string2.compareToIgnoreCase("west") != 0) break block9;
                        }
                        return 2;
                    }
                    if (string2.compareToIgnoreCase("right") == 0) break block10;
                    if (string2.compareToIgnoreCase("east") != 0) break block11;
                }
                return 4;
            }
            return 3;
        }

        void a(IlvSettingsElement ilvSettingsElement, String string, int n) {
            switch (n) {
                case 2: {
                    ilvSettingsElement.setString(string, "left");
                    break;
                }
                case 1: {
                    ilvSettingsElement.setString(string, "top");
                    break;
                }
                case 4: {
                    ilvSettingsElement.setString(string, "right");
                    break;
                }
                case 3: {
                    ilvSettingsElement.setString(string, "bottom");
                    break;
                }
                default: {
                    ilvSettingsElement.setString(string, "top");
                }
            }
        }

        public boolean canApply() {
            return this.d;
        }

        protected boolean isFirstUse(IlvDockingBarAreaHandler ilvDockingBarAreaHandler) {
            return !this.b.contains(ilvDockingBarAreaHandler.getCurrentWorkspace());
        }
    }
}

