/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.docking;

import ilog.views.appframe.swing.docking.IlvDockingManager;
import ilog.views.appframe.swing.docking.IlvFloatableWindow;
import ilog.views.appframe.swing.docking.dockable.IlvDockable;
import ilog.views.appframe.swing.util.IlvFocusManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

class DockableMouseListener
implements MouseListener,
MouseMotionListener,
ContainerListener {
    IlvDockable a;
    IlvDockingManager b;
    boolean c = false;

    public DockableMouseListener(IlvDockable ilvDockable, IlvDockingManager ilvDockingManager) {
        this.a = ilvDockable;
        this.b = ilvDockingManager;
    }

    public void addListeners(Component component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.addListeners(container.getComponent(i));
            }
        }
    }

    public void removeListeners(Component component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.removeListeners(container.getComponent(i));
            }
        }
    }

    public boolean hasMouseListener(Component component) {
        MouseListener[] mouseListenerArray = (MouseListener[])component.getListeners(MouseListener.class);
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            if (mouseListenerArray[i] instanceof DockableMouseListener) continue;
            return true;
        }
        return false;
    }

    public boolean hasMouseMotionListener(Component component) {
        MouseMotionListener[] mouseMotionListenerArray = (MouseMotionListener[])component.getListeners(MouseMotionListener.class);
        for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
            if (mouseMotionListenerArray[i] instanceof DockableMouseListener) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        this.b.a(this.a, false);
        Component component2 = SwingUtilities.getRoot(this.a.getComponent());
        if (component2 instanceof IlvFloatableWindow) {
            ((IlvFloatableWindow)component2).toFront();
        }
        MouseListener[] mouseListenerArray = (MouseListener[])component.getListeners(MouseListener.class);
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            if (!(mouseListenerArray[i] instanceof IlvFocusManager.FocusRouter)) continue;
            mouseListenerArray[i].mousePressed(mouseEvent);
        }
        if (!this.hasMouseListener(component)) {
            boolean bl = false;
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                MouseListener[] mouseListenerArray2 = (MouseListener[])container.getListeners(MouseListener.class);
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(component, mouseEvent, container);
                for (int i = 0; i < mouseListenerArray2.length; ++i) {
                    if (mouseListenerArray2[i] instanceof DockableMouseListener) continue;
                    mouseListenerArray2[i].mousePressed(mouseEvent2);
                    bl = true;
                }
                if (bl) break;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (!this.hasMouseListener(component)) {
            boolean bl = false;
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                MouseListener[] mouseListenerArray = (MouseListener[])container.getListeners(MouseListener.class);
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(component, mouseEvent, container);
                for (int i = 0; i < mouseListenerArray.length; ++i) {
                    if (mouseListenerArray[i] instanceof DockableMouseListener) continue;
                    mouseListenerArray[i].mouseClicked(mouseEvent2);
                    bl = true;
                }
                if (bl) break;
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (!this.hasMouseListener(component)) {
            boolean bl = false;
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                MouseListener[] mouseListenerArray = (MouseListener[])container.getListeners(MouseListener.class);
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(component, mouseEvent, container);
                for (int i = 0; i < mouseListenerArray.length; ++i) {
                    if (mouseListenerArray[i] instanceof DockableMouseListener) continue;
                    mouseListenerArray[i].mouseEntered(mouseEvent2);
                    bl = true;
                }
                if (bl) break;
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (!this.hasMouseListener(component)) {
            boolean bl = false;
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                MouseListener[] mouseListenerArray = (MouseListener[])container.getListeners(MouseListener.class);
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(component, mouseEvent, container);
                for (int i = 0; i < mouseListenerArray.length; ++i) {
                    if (mouseListenerArray[i] instanceof DockableMouseListener) continue;
                    mouseListenerArray[i].mouseExited(mouseEvent2);
                    bl = true;
                }
                if (bl) break;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (!this.hasMouseListener(component)) {
            boolean bl = false;
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                MouseListener[] mouseListenerArray = (MouseListener[])container.getListeners(MouseListener.class);
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(component, mouseEvent, container);
                for (int i = 0; i < mouseListenerArray.length; ++i) {
                    if (mouseListenerArray[i] instanceof DockableMouseListener) continue;
                    mouseListenerArray[i].mouseReleased(mouseEvent2);
                    bl = true;
                }
                if (bl) break;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (!this.hasMouseMotionListener(component)) {
            boolean bl = false;
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                MouseMotionListener[] mouseMotionListenerArray = (MouseMotionListener[])container.getListeners(MouseMotionListener.class);
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(component, mouseEvent, container);
                for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                    if (mouseMotionListenerArray[i] instanceof DockableMouseListener) continue;
                    mouseMotionListenerArray[i].mouseMoved(mouseEvent2);
                    bl = true;
                }
                if (bl) break;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.c) {
            return;
        }
        this.c = true;
        Component component = (Component)mouseEvent.getSource();
        if (!this.hasMouseMotionListener(component)) {
            boolean bl = false;
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                MouseMotionListener[] mouseMotionListenerArray = (MouseMotionListener[])container.getListeners(MouseMotionListener.class);
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(component, mouseEvent, container);
                for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                    if (mouseMotionListenerArray[i] instanceof DockableMouseListener) continue;
                    mouseMotionListenerArray[i].mouseDragged(mouseEvent2);
                    bl = true;
                }
                if (bl) break;
            }
        }
        this.c = false;
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.addListeners(containerEvent.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this.removeListeners(containerEvent.getChild());
    }
}

