/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.beans.editor;

import com.ibm.icu.util.ULocale;
import ilog.views.IlvPoint;
import ilog.views.beans.editor.IlvPointArrayEditorPanel;
import ilog.views.beans.editor.IlvPointEditor;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.beans.editor.IlvTextLineArrayPropertyEditor;
import java.awt.Component;
import java.util.StringTokenizer;

public class IlvPointArrayEditor
extends IlvTextLineArrayPropertyEditor {
    private ULocale a;
    private int b;
    IlvPoint[] c = null;
    IlvPointArrayEditorPanel d = null;
    IlvPointEditor e = null;

    public IlvPointArrayEditor() {
        this("", false);
    }

    public IlvPointArrayEditor(ULocale uLocale) {
        this("", false, uLocale);
    }

    public IlvPointArrayEditor(String string, boolean bl) {
        this(string, bl, IlvLocaleUtil.getCurrentULocale());
    }

    public IlvPointArrayEditor(String string, boolean bl, ULocale uLocale) {
        this(string, bl, uLocale, 0);
    }

    public IlvPointArrayEditor(String string, boolean bl, ULocale uLocale, int n) {
        this.e = new IlvPointEditor(string, bl, uLocale);
        this.a = uLocale;
        this.b = n;
    }

    @Override
    public Component getCustomEditor() {
        if (this.d == null) {
            this.d = new IlvPointArrayEditorPanel(this.e, this.a, this.b);
        }
        this.d.setEditor(this);
        this.d.a(this.c);
        return this.d;
    }

    @Override
    public Object getValue() {
        return this.c;
    }

    @Override
    public void setValue(Object object) {
        IlvPoint[] ilvPointArray = this.c;
        this.c = (IlvPoint[])object;
        this.firePropertyChange(ilvPointArray, this.c);
        if (this.d != null && this.d.getEditor() == this) {
            this.d.a(this.c);
        }
    }

    @Override
    public String getJavaInitializationString() {
        IlvPoint[] ilvPointArray = (IlvPoint[])this.getValue();
        if (ilvPointArray == null) {
            return "null";
        }
        int n = ilvPointArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("new ilog.views.IlvPoint[] {");
        for (int i = 0; i < n; ++i) {
            IlvPoint ilvPoint;
            if (i > 0) {
                stringBuffer.append(",");
            }
            if ((ilvPoint = this.c[i]) == null) {
                stringBuffer.append("null");
                continue;
            }
            stringBuffer.append("new ilog.views.IlvPoint((float)" + ilvPoint.x + "," + "(float)" + ilvPoint.y + ")");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public String getAsText() {
        if (this.c == null) {
            return "";
        }
        int n = this.c.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            this.e.setValue(this.c[i]);
            stringBuffer.append(this.e.getAsText());
        }
        return stringBuffer.toString();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        try {
            int n = string.length();
            if (n == 0) {
                if (this.b > 0) {
                    throw new IllegalArgumentException("too few points:" + string);
                }
                this.setValue(new IlvPoint[0]);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n2 = stringTokenizer.countTokens();
                int n3 = (n2 + 1) / 2;
                if (n3 < this.b) {
                    throw new IllegalArgumentException("too few points:" + string);
                }
                int n4 = 0;
                boolean bl = true;
                IlvPoint[] ilvPointArray = new IlvPoint[n3];
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    try {
                        double d = Double.parseDouble(string2);
                        if (bl) {
                            ilvPointArray[n4] = new IlvPoint((float)d, 0.0f);
                            bl = false;
                            continue;
                        }
                        ilvPointArray[n4].move(ilvPointArray[n4].x, (float)d);
                        bl = true;
                        ++n4;
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("invalid input:" + string);
                    }
                }
                this.setValue(ilvPointArray);
            }
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(exception.getMessage());
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    @Override
    public String convertElementToLocalizedText(Object object) {
        this.e.setValue(object);
        return this.e.getAsLocalizedText();
    }

    public static class MinTwoPoints
    extends IlvPointArrayEditor {
        public MinTwoPoints() {
            super("", false, IlvLocaleUtil.getCurrentULocale(), 2);
        }
    }
}

