/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.docview;

import com.ibm.icu.util.ULocale;
import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvAbstractFileDocument;
import ilog.views.appframe.docview.IlvDocumentView;
import ilog.views.appframe.docview.IlvFileDocumentTemplate;
import ilog.views.appframe.docview.IlvFileFilter;
import ilog.views.appframe.event.IlvMessageMapper;
import ilog.views.appframe.swing.IlvSwingMainWindow;
import ilog.views.appframe.util.IlvFileChooserSelection;
import ilog.views.builder.docview.IlvCustomizerView;
import ilog.views.builder.docview.IlvMessageView;
import ilog.views.builder.docview.IlvPropertySheetView;
import ilog.views.builder.docview.IlvRuleTreeView;
import ilog.views.builder.docview.selector.IlvSelectorEdition;
import ilog.views.builder.editor.IlvCSSCustomizer;
import ilog.views.builder.event.BuilderSelectionEvent;
import ilog.views.builder.event.BuilderSelectionListener;
import ilog.views.builder.event.IlvInheritedCSSDeclaration;
import ilog.views.builder.event.IlvStyleChangeSupport;
import ilog.views.builder.event.StyleChangeEvent;
import ilog.views.builder.event.StyleChangeListener;
import ilog.views.builder.gui.IlvContextualFileChooser;
import ilog.views.builder.gui.IlvCustomizerHandler;
import ilog.views.builder.gui.IlvExpressionCustomizer;
import ilog.views.builder.gui.IlvVariableDialog;
import ilog.views.builder.selection.IlvBuilderSelectionManager;
import ilog.views.css.model.IlvNode;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleImpl;
import ilog.views.css.model.IlvRuleModel;
import ilog.views.css.model.IlvRuleUtils;
import ilog.views.css.model.IlvSelector;
import ilog.views.css.selector.IlvSelectorContext;
import ilog.views.css.swing.IlvCSSExpressionEditor;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.css.IlvCSSDocument;
import ilog.views.util.css.IlvCSSEngine;
import ilog.views.util.css.IlvCSSModel;
import ilog.views.util.css.IlvMapBasedApplicableDeclarationCollection;
import ilog.views.util.css.IlvParserHandler;
import ilog.views.util.css.event.RuleSetEvent;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.css.parser.Parser;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.cssbeans.IlvCSSBeans;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.styling.IlvCSSAttributeSelector;
import ilog.views.util.styling.IlvCSSDeclaration;
import ilog.views.util.styling.IlvCSSFunction;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public abstract class IlvBuilderDocument
extends IlvAbstractFileDocument
implements StyleChangeListener {
    public static final int SEVERITY_NODES_LINKS = 2;
    public static final int SEVERITY_RENDERER = 5;
    public static final int SEVERITY_GRAPH_LAYOUT = 500;
    public static final int SEVERITY_GRAPH_LAYOUT_IMMEDIATELY = 501;
    private IlvBuilderSelectionManager a = new IlvBuilderSelectionManager();
    private IlvBuilderSelectionManager b = new IlvBuilderSelectionManager();
    private HashMap c = new HashMap();
    private static Object d;
    private IlvStyleChangeSupport e = new IlvStyleChangeSupport(this);
    private CompoundEdit f = null;
    private Logger g;
    private IlvExpressionCustomizer h;
    private Object i;
    protected static final int RULE_ACTION_REMOVE = 0;
    protected static final int RULE_ACTION_CHANGE = 1;
    protected static final int RULE_ACTION_ADD = 2;
    public static final String RULE_EVENT_NAME = "XX-rule-event";
    public static final String DECLARATION_EVENT_NAME = "XX-rule-event";
    public static final Object NEW_VALUE;
    public static final Object CHANGED_VALUE;
    private HashMap j = new HashMap();
    private ArrayList k = new ArrayList();
    public static final boolean WITH_DISABLED = true;
    public static final int SEVERITY_UNDEFINED = -1;
    public static final int SEVERITY_NONE = 0;
    public static final int SEVERITY_ADJUSTMENT = -10;
    public static final int SEVERITY_MAX = 100;
    private IlvParserHandler l;
    private HashMap m = new HashMap(3);
    private IlvFileDocumentTemplate n;

    public IlvBuilderDocument() {
        LocalBuilderSelectionListener localBuilderSelectionListener = new LocalBuilderSelectionListener();
        this.getSelectionManager().addSelectionListener(localBuilderSelectionListener, 60);
        String string = IlvRuleTreeView.class.getName();
        string = string.substring(0, string.lastIndexOf(46));
        this.g = Logger.getLogger(string);
        IlvMessageView.addLogPublisher(string, new CheckRulesLogPublisher());
        this.l = this.makeParserHandler();
        Parser.setParserHandler(this.l);
    }

    public String getEditAsTextHelpMessage(IlvCSSCustomizer ilvCSSCustomizer, String string) {
        return IlvCSSExpressionEditor.getEditAsTextHelpMessage(this.getSelectorContext(), this.getSelectedEditableRule());
    }

    @Override
    public void setApplication(IlvApplication ilvApplication) {
        super.setApplication(ilvApplication);
        if (ilvApplication != null) {
            this.a(ilvApplication);
        }
    }

    private void a(IlvApplication ilvApplication) {
        ImageIcon imageIcon;
        if (IlvCSSCustomizer.INHERITANCE_ICONS[0] != null) {
            return;
        }
        IlvCSSCustomizer.INHERITANCE_ICONS[0] = imageIcon = ilvApplication.getImageIcon("Builder.Icons.TriangleRight");
        IlvCSSCustomizer.INHERITANCE_ICONS[1] = imageIcon;
        IlvCSSCustomizer.INHERITANCE_ICONS[2] = imageIcon = ilvApplication.getImageIcon("Builder.Icons.TriangleUp");
        IlvCSSCustomizer.INHERITANCE_ICONS[3] = imageIcon;
        IlvCSSCustomizer.INHERITANCE_ICONS[4] = imageIcon;
    }

    public IlvRule[] getRules() {
        return this.getRules(false);
    }

    public final IlvRule[] getRules(boolean bl) {
        IlvRuleModel.RulesSubset rulesSubset = this.getRulesSubset(bl);
        return this.getCSS().getRules(rulesSubset);
    }

    public abstract IlvRuleModel.RulesSubset getRulesSubset(boolean var1);

    public IlvRule makeRuleTree() {
        this.getCSS().buildTree();
        return this.getCSS().getRootRule();
    }

    public String getLocalizedName(IlvRule ilvRule) {
        return ilvRule.toString();
    }

    protected boolean softEquals(String string, String string2) {
        return string != null && string.equals(string2);
    }

    protected boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    protected IlvRule[] getEditableRules(IlvRule[] ilvRuleArray) {
        return ilvRuleArray;
    }

    public abstract Object[] getMatchingObjects(IlvRule var1);

    public abstract IlvRule[] getMatchedRules(Object var1);

    @Override
    protected void registerMappings(IlvMessageMapper ilvMessageMapper) {
        super.registerMappings(ilvMessageMapper);
        ilvMessageMapper.registerActionMethod("RuleDeleteAction", "deleteRule");
        ilvMessageMapper.registerActionStateMethod("RuleDeleteAction", "deleteRuleUI");
        ilvMessageMapper.registerActionMethod("RuleCutAction", "cutRule");
        ilvMessageMapper.registerActionStateMethod("RuleCutAction", "cutRuleUI");
        ilvMessageMapper.registerActionMethod("RuleCopyAction", "copyRule");
        ilvMessageMapper.registerActionStateMethod("RuleCopyAction", "copyRuleUI");
        ilvMessageMapper.registerActionMethod("RulePasteAction", "pasteRule");
        ilvMessageMapper.registerActionStateMethod("RulePasteAction", "pasteRuleUI");
        ilvMessageMapper.registerActionMethod("DeclarationsPasteAction", "pasteDeclarations");
        ilvMessageMapper.registerActionStateMethod("DeclarationsPasteAction", "pasteDeclarationsUI");
        ilvMessageMapper.registerActionMethod("RuleEnableAction", "enableRule");
        ilvMessageMapper.registerActionStateMethod("RuleEnableAction", "enableRuleUI");
        ilvMessageMapper.registerActionMethod("RuleDisableAction", "disableRule");
        ilvMessageMapper.registerActionStateMethod("RuleDisableAction", "disableRuleUI");
        ilvMessageMapper.registerActionMethod("RuleAddAction", "addRule");
        ilvMessageMapper.registerActionStateMethod("RuleAddAction", "addRuleUI");
        ilvMessageMapper.registerActionMethod("RuleChangeAction", "changeRule");
        ilvMessageMapper.registerActionStateMethod("RuleChangeAction", "changeRuleUI");
        ilvMessageMapper.registerActionMethod("CheckRulesAction", "checkRules");
        ilvMessageMapper.registerActionStateMethod("CheckRulesAction", "checkRulesUI");
        ilvMessageMapper.registerActionMethod("ApplyStyle", "applyStyle");
        ilvMessageMapper.registerActionMethod("PageSetup", "pageSetup");
        ilvMessageMapper.registerActionMethod("PrintPreview", "printPreview");
        ilvMessageMapper.registerActionMethod("Print", "print");
        ilvMessageMapper.registerActionMethod("EditVariables", "editVariables");
        ilvMessageMapper.registerActionMethod("EditFunctions", "editFunctions");
    }

    public void deleteRule() {
        Object object = this.getSelectionManager().getSelection();
        if (object != null) {
            this.getSelectionManager().setSelection(null);
            this.getRedSelectionManager().setSelection(null);
            this.deleteRule((IlvRule)object);
        }
    }

    public void deleteRuleUI(Action action) {
        Object object = this.getSelectionManager().getSelection();
        if (object == null || this.selectionIsRequiredRule()) {
            action.setEnabled(false);
        } else {
            action.setEnabled(this.isDeleteRuleEnable(object));
        }
    }

    public void cutRule() {
        Object object = this.getSelectionManager().getSelection();
        if (object != null) {
            this.getSelectionManager().setSelection(null);
            this.getRedSelectionManager().setSelection(null);
            this.cutRule((IlvRule)object);
        }
    }

    public void cutRuleUI(Action action) {
        Object object = this.getSelectionManager().getSelection();
        if (object == null || this.selectionIsRequiredRule()) {
            action.setEnabled(false);
        } else {
            action.setEnabled(this.isCutRuleEnable(object));
        }
    }

    public void copyRule() {
        Object object = this.getSelectionManager().getSelection();
        IlvRule ilvRule = (IlvRule)object;
        if (ilvRule != null) {
            this.copyRule(ilvRule);
        }
    }

    public void copyRuleUI(Action action) {
        Object object = this.getSelectionManager().getSelection();
        if (object != null) {
            action.setEnabled(this.isCopyRuleEnable(object));
        } else {
            action.setEnabled(false);
        }
    }

    public void pasteRuleUI(Action action) {
        Object object = IlvBuilderDocument.getClipboard();
        if (object != null) {
            action.setEnabled(this.isPasteRuleEnable(object));
        } else {
            action.setEnabled(false);
        }
    }

    public void pasteDeclarationsUI(Action action) {
        Object object = IlvBuilderDocument.getClipboard();
        if (object != null) {
            action.setEnabled(this.isPasteRuleEnable(object) && this.getSelectedEditableRule() != null);
        } else {
            action.setEnabled(false);
        }
    }

    public void editVariables() {
        IlvVariableDialog ilvVariableDialog = new IlvVariableDialog(this);
        ilvVariableDialog.showDialog();
        if (this.h != null) {
            this.h.refresh();
        }
    }

    public void editFunctions() {
        if (this.h != null) {
            this.h.refresh();
        }
    }

    private void a(IlvRule ilvRule, IlvRule[] ilvRuleArray, long l) {
        this.a(ilvRuleArray, l);
        this.getUndoManager().addEdit(new VisibilityEdit(ilvRule, ilvRuleArray));
        if (l == 0L) {
            this.getSelectionManager().resetSelection();
        } else {
            this.getSelectionManager().setSelection(null);
        }
    }

    private void a(IlvRule[] ilvRuleArray, long l) {
        if (ilvRuleArray.length > 0) {
            for (int i = 0; i < ilvRuleArray.length; ++i) {
                IlvRule ilvRule = ilvRuleArray[i];
                ilvRule.setDisabledGroup(l);
            }
            IlvRule ilvRule = ilvRuleArray[0];
            this.ruleEnabledChangedNotify(ilvRule, ilvRule.isEnabled());
        }
    }

    public void enableRule() {
        IlvRule ilvRule = this.getSelectedEditableRule();
        if (ilvRule == null) {
            return;
        }
        IlvRule[] ilvRuleArray = (IlvRule[])this.m.get(ilvRule);
        if (ilvRuleArray == null || ilvRuleArray.length == 1) {
            ilvRuleArray = new IlvRule[]{ilvRule};
            if (ilvRule.getDisabledGroup() > 1L) {
                ilvRuleArray = this.a(ilvRule);
            }
        }
        this.b(ilvRule, null, 0L);
        this.a(ilvRule, ilvRuleArray, 0L);
    }

    private IlvRule[] a(IlvRule ilvRule) {
        long l = ilvRule.getDisabledGroup();
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            IlvRule ilvRule2 = ilvRuleArray[i];
            if (l != ilvRule2.getDisabledGroup()) continue;
            arrayList.add(ilvRule2);
        }
        this.m.put(ilvRule, arrayList);
        return arrayList.toArray(new IlvRule[arrayList.size()]);
    }

    private void b(IlvRule ilvRule, IlvRule[] ilvRuleArray, long l) {
        if (ilvRuleArray == null) {
            this.m.remove(ilvRule);
        } else {
            this.m.put(ilvRule, ilvRuleArray);
            ilvRule.setDisabledGroup(l);
            for (int i = 0; i < ilvRuleArray.length; ++i) {
                IlvRule ilvRule2 = ilvRuleArray[i];
                ilvRule2.setDisabledGroup(l);
            }
            if (ilvRuleArray.length > 0) {
                IlvRule ilvRule3 = ilvRuleArray[0];
                this.ruleEnabledChangedNotify(ilvRule3, ilvRule3.isEnabled());
            }
        }
    }

    public void disableRule() {
        IlvRule ilvRule = this.getSelectedEditableRule();
        if (ilvRule == null) {
            return;
        }
        IlvRule[] ilvRuleArray = this.getSelectedRuleAndSubrules(ilvRule);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l = System.currentTimeMillis();
        this.a(ilvRule, ilvRuleArray, l);
        this.b(ilvRule, ilvRuleArray, l);
    }

    protected IlvRule[] getSelectedRuleAndSubrules(IlvRule ilvRule) {
        IlvRule ilvRule2 = ilvRule;
        HashSet<IlvRule> hashSet = new HashSet<IlvRule>();
        hashSet.add(ilvRule2);
        this.getCSS().getAdditionalRules(ilvRule2, this.getCSS().getParentRules(ilvRule2, true), hashSet, false);
        hashSet.remove(ilvRule2);
        IlvRule[] ilvRuleArray = hashSet.toArray(new IlvRule[hashSet.size()]);
        IlvRule[] ilvRuleArray2 = new IlvRule[ilvRuleArray.length + 1];
        ilvRuleArray2[0] = ilvRule2;
        System.arraycopy(ilvRuleArray, 0, ilvRuleArray2, 1, ilvRuleArray.length);
        return ilvRuleArray2;
    }

    public void enableRuleUI(Action action) {
        Object object = this.getSelectionManager().getSelection();
        if (object == null) {
            action.setEnabled(false);
            return;
        }
        if (object != null && object instanceof IlvRule) {
            IlvRule ilvRule = (IlvRule)object;
            action.setEnabled(!ilvRule.isEnabled());
        } else {
            action.setEnabled(false);
        }
    }

    public void disableRuleUI(Action action) {
        Object object = this.getSelectionManager().getSelection();
        if (object != null) {
            action.setEnabled(this.isDisableRuleEnable(object));
        } else {
            action.setEnabled(false);
        }
    }

    public static synchronized Object getClipboard() {
        return d;
    }

    public static synchronized Object setClipboard(Object object) {
        Object object2 = d;
        d = object;
        return object2;
    }

    public synchronized boolean isPasteRuleEnable(Object object) {
        return object instanceof IlvRule[];
    }

    public synchronized boolean isCopyRuleEnable(Object object) {
        return object instanceof IlvRule;
    }

    public synchronized boolean isCutRuleEnable(Object object) {
        return object instanceof IlvRule;
    }

    public synchronized boolean isDeleteRuleEnable(Object object) {
        return object instanceof IlvRule;
    }

    public synchronized boolean isDisableRuleEnable(Object object) {
        if (object instanceof IlvRule) {
            IlvRule ilvRule = (IlvRule)object;
            return ilvRule.isEnabled();
        }
        return false;
    }

    public synchronized void deleteRule(IlvRule ilvRule) {
        this.deleteRules(this.b(ilvRule));
    }

    private IlvRule[] b(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray2;
        ArrayList arrayList = new ArrayList();
        this.fillListWithChildren(arrayList, ilvRule);
        HashSet<IlvRule> hashSet = new HashSet<IlvRule>();
        for (IlvRule[] ilvRuleArray2 : arrayList) {
            hashSet.add((IlvRule)ilvRuleArray2);
            this.getCSS().getAdditionalRules((IlvRule)ilvRuleArray2, this.getCSS().getParentRules((IlvRule)ilvRuleArray2, true), hashSet, false);
        }
        ilvRuleArray2 = hashSet.toArray(new IlvRule[hashSet.size()]);
        return ilvRuleArray2;
    }

    public synchronized void deleteRules(IlvRule[] ilvRuleArray) {
        StyleChangeEvent.Remove remove = new StyleChangeEvent.Remove(this, null, null, ilvRuleArray);
        remove.setSeverity(100);
        this.styleChange(remove);
    }

    public synchronized void cutRule(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray = this.copyRule(ilvRule);
        if (IlvBuilderDocument.getClipboard() != null && IlvBuilderDocument.getClipboard() instanceof IlvRule[]) {
            this.deleteRules(ilvRuleArray);
        }
    }

    public synchronized IlvRule[] copyRule(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray = this.b(ilvRule);
        IlvBuilderDocument.setClipboard(this.getEditableRules(ilvRuleArray));
        return ilvRuleArray;
    }

    protected void fillListWithChildren(ArrayList arrayList, IlvRule ilvRule) {
        List<IlvNode> list;
        if (ilvRule == null) {
            return;
        }
        if (!arrayList.contains(ilvRule)) {
            arrayList.add(ilvRule);
        }
        if ((list = ilvRule.getChildren()) == null) {
            return;
        }
        for (IlvRule ilvRule2 : list) {
            this.fillListWithChildren(arrayList, ilvRule2);
        }
    }

    public synchronized void pasteRule() {
        if (IlvBuilderDocument.getClipboard() != null && IlvBuilderDocument.getClipboard() instanceof IlvRule[]) {
            IlvRule[] ilvRuleArray = (IlvRule[])IlvBuilderDocument.getClipboard();
            IlvRule[] ilvRuleArray2 = new IlvRule[ilvRuleArray.length];
            for (int i = 0; i < ilvRuleArray.length; ++i) {
                ilvRuleArray2[i] = ilvRuleArray[i].copy();
            }
            StyleChangeEvent.Add add = new StyleChangeEvent.Add(this, null, null, ilvRuleArray2);
            this.styleChange(add);
        }
    }

    public synchronized void pasteDeclarations() {
        if (IlvBuilderDocument.getClipboard() != null && IlvBuilderDocument.getClipboard() instanceof IlvRule[] && this.getSelectedEditableRule() != null) {
            Object object;
            IlvRule[] ilvRuleArray = (IlvRule[])IlvBuilderDocument.getClipboard();
            ArrayList<IlvCSSDeclaration> arrayList = new ArrayList<IlvCSSDeclaration>();
            for (int i = 0; i < ilvRuleArray.length; ++i) {
                object = ilvRuleArray[i];
                IlvCSSDeclaration[] ilvCSSDeclarationArray = object.getCSSDeclarations();
                arrayList.addAll(Arrays.asList(ilvCSSDeclarationArray));
            }
            IlvCSSDeclaration[] ilvCSSDeclarationArray = arrayList.toArray(new IlvCSSDeclaration[arrayList.size()]);
            object = new StyleChangeEvent.Add(this, this.getSelectedEditableRule(), ilvCSSDeclarationArray, null);
            this.styleChange((StyleChangeEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRule() {
        IlvRule ilvRule = this.getSelectedEditableRule();
        IlvSelectorContext ilvSelectorContext = this.getSelectorContext();
        IlvSelector ilvSelector = ilvRule.getSelector();
        String string = ilvRule.getName();
        IlvRule ilvRule2 = null;
        try {
            ilvSelectorContext.setInitialEditableRule(ilvRule);
            ilvSelectorContext.setSelectorEditor(true);
            ilvRule2 = IlvSelectorEdition.changeRule(this.getApplication().getMainComponent(), ilvRule, ilvSelectorContext, this.ruleEditionWithDataModel() ? this : null);
        }
        finally {
            ilvSelectorContext.setInitialEditableRule(null);
            ilvSelectorContext.setSelectorEditor(false);
        }
        if (ilvRule2 != null) {
            String string2 = ilvRule2.getName();
            ilvRule.copyAttributes(ilvRule2);
            IlvSelector ilvSelector2 = ilvRule2.getSelector();
            this.getCSS().setSelector(ilvRule, ilvSelector);
            StyleChangeEvent.SelectorChange selectorChange = new StyleChangeEvent.SelectorChange((Object)this, ilvRule, ilvSelector2, string, string2);
            this.styleChange(selectorChange);
        }
    }

    public void changeRuleUI(Action action) {
        IlvRule ilvRule = this.getSelectedEditableRule();
        if (this.selectionIsRequiredRule()) {
            action.setEnabled(false);
        } else {
            action.setEnabled(ilvRule != null && !ilvRule.isConfigurationRule() && ilvRule.isEnabled());
        }
    }

    protected boolean selectionIsRequiredRule() {
        IlvRule ilvRule = this.getSelectedEditableRule();
        if (ilvRule == null) {
            return false;
        }
        return "true".equalsIgnoreCase(ilvRule.getMetaDeclarationValue("_REQUIRED_SELECTOR"));
    }

    protected void checkRulesForErrors(HashMap<Rule, IlvRule> hashMap) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRules() {
        Object object;
        IlvMessageView ilvMessageView = IlvMessageView.getMessageView(this.getApplication());
        ilvMessageView.clearEntries();
        int n = ilvMessageView.getCount(Level.SEVERE);
        int n2 = ilvMessageView.getCount(Level.WARNING);
        Level level = ilvMessageView.getLevel();
        ilvMessageView.setLevel(Level.INFO);
        Logger.getLogger("ilog.views.builder").log(Level.INFO, MessageFormat.format(this.getApplication().getString("Builder.CheckRules.CheckingRules"), this.getTitle()));
        ilvMessageView.setLevel(Level.WARNING);
        try {
            object = this.e();
            this.checkRulesForErrors((HashMap<Rule, IlvRule>)object);
            if (!((HashMap)object).isEmpty()) {
                Object[] objectArray = new Object[1 + ((HashMap)object).size()];
                objectArray[0] = this;
                int n3 = 1;
                for (Map.Entry<Rule, IlvRule> entry : ((HashMap)object).entrySet()) {
                    IlvRule ilvRule = entry.getValue();
                    ilvRule.setUsed(false);
                    this.c(ilvRule);
                    objectArray[n3++] = ilvRule;
                }
                this.g.log(Level.WARNING, this.getApplication().getString("Builder.CheckRules.NoMatch"), objectArray);
            }
            ilvMessageView.setLevel(Level.INFO);
            n = ilvMessageView.getCount(Level.SEVERE) - n;
            n2 = ilvMessageView.getCount(Level.WARNING) - n2;
        }
        catch (Exception exception) {
            try {
                Logger.getLogger("ilog.views.builder").log(Level.WARNING, this.getApplication().getString("Builder.CheckRules.Error"), exception);
                ilvMessageView.setLevel(Level.INFO);
                n = ilvMessageView.getCount(Level.SEVERE) - n;
                n2 = ilvMessageView.getCount(Level.WARNING) - n2;
            }
            catch (Throwable throwable) {
                ilvMessageView.setLevel(Level.INFO);
                n = ilvMessageView.getCount(Level.SEVERE) - n;
                n2 = ilvMessageView.getCount(Level.WARNING) - n2;
                String string = MessageFormat.format(this.getApplication().getString("Builder.CheckRules.ErrorsWarnings"), new Integer(n), new Integer(n2));
                Logger.getLogger("ilog.views.builder").log(Level.INFO, string);
                ilvMessageView.setLevel(level);
                throw throwable;
            }
            String string = MessageFormat.format(this.getApplication().getString("Builder.CheckRules.ErrorsWarnings"), new Integer(n), new Integer(n2));
            Logger.getLogger("ilog.views.builder").log(Level.INFO, string);
            ilvMessageView.setLevel(level);
        }
        object = MessageFormat.format(this.getApplication().getString("Builder.CheckRules.ErrorsWarnings"), new Integer(n), new Integer(n2));
        Logger.getLogger("ilog.views.builder").log(Level.INFO, (String)object);
        ilvMessageView.setLevel(level);
    }

    private HashMap<Rule, IlvRule> e() {
        HashMap<Rule, IlvRule> hashMap = new HashMap<Rule, IlvRule>();
        IlvRule ilvRule = this.f();
        if (ilvRule != null) {
            for (int i = 0; i < ilvRule.getChildCount(); ++i) {
                IlvRule ilvRule2 = (IlvRule)ilvRule.getChildAt(i);
                if (ilvRule2.isFake()) continue;
                this.a(ilvRule2, hashMap);
            }
        }
        return hashMap;
    }

    private void a(IlvRule ilvRule, HashMap<Rule, IlvRule> hashMap) {
        hashMap.put(((IlvRuleImpl)ilvRule).getRule(), ilvRule);
        for (int i = 0; i < ilvRule.getChildCount(); ++i) {
            IlvRule ilvRule2 = (IlvRule)ilvRule.getChildAt(i);
            this.a(ilvRule2, hashMap);
        }
    }

    protected final void markRulesUsed(IlvCSSEngine.MatchingResult matchingResult, HashMap<Rule, IlvRule> hashMap) {
        for (Object object : matchingResult.keySet()) {
            Rule[] ruleArray;
            for (Rule rule : ruleArray = matchingResult.getRules(object)) {
                hashMap.remove(rule);
            }
        }
    }

    public void checkRulesUI(Action action) {
        action.setEnabled(this.getCSS().getAllRules(true) != null);
    }

    private IlvRule f() {
        return this.getCSS().getRootRule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRule() {
        IlvRule ilvRule = this.getSelectedEditableRule();
        IlvSelectorContext ilvSelectorContext = this.getSelectorContext();
        IlvRule ilvRule2 = null;
        try {
            ilvSelectorContext.setInitialEditableRule(ilvRule);
            ilvSelectorContext.setSelectorEditor(true);
            ilvRule2 = IlvSelectorEdition.createNewRule(this.getApplication().getMainComponent(), ilvRule, ilvSelectorContext, this.ruleEditionWithDataModel() ? this : null);
            if (!IlvBuilderDocument.manageRedundantRule(ilvRule2, this, this.getApplication().getMainComponent())) {
                ilvRule2 = null;
            }
        }
        finally {
            ilvSelectorContext.setInitialEditableRule(null);
            ilvSelectorContext.setSelectorEditor(false);
        }
        if (ilvRule2 != null) {
            StyleChangeEvent.Add add = new StyleChangeEvent.Add((Object)this, null, null, new IlvRule[]{ilvRule2}, ilvRule);
            this.styleChange(add);
            this.getSelectionManager().setSelection(ilvRule2);
        }
    }

    public static boolean manageRedundantRule(IlvRule ilvRule, IlvBuilderDocument ilvBuilderDocument, Component component) {
        if (ilvRule == null) {
            return false;
        }
        IlvRule[] ilvRuleArray = ilvBuilderDocument.getRules(true);
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            IlvRule ilvRule2 = ilvRuleArray[i];
            if (!ilvRule2.isIdentical(ilvRule)) continue;
            int n = JOptionPane.showOptionDialog(component, ilvBuilderDocument.getApplication().getString("Builder.Conflict.Message"), ilvBuilderDocument.getApplication().getString("Builder.Conflict.Title"), 0, 2, null, null, null);
            if (n == 0) {
                ilvBuilderDocument.deleteRule(ilvRule2);
                return true;
            }
            return false;
        }
        return true;
    }

    public void addRuleUI(Action action) {
        this.changeRuleUI(action);
    }

    @Override
    public void clean() {
        this.c.clear();
        this.getSelectionManager().setSelection(null);
    }

    public void writeCSS(PrintWriter printWriter) {
        this.writeCSS(printWriter, new IlvCSSDocument(null, null));
    }

    public void writeCSS(PrintWriter printWriter, URL uRL) {
        this.writeCSS(printWriter, new IlvCSSDocument(uRL, null));
    }

    public void writeCSS(PrintWriter printWriter, IlvCSSDocument ilvCSSDocument) {
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            IlvRule ilvRule = ilvRuleArray[i];
            boolean bl = true;
            IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getMetadata();
            for (int j = 0; j < ilvCSSDeclarationArray.length; ++j) {
                IlvCSSDeclaration ilvCSSDeclaration = ilvCSSDeclarationArray[j];
                if (ilvCSSDeclaration.getProperty() != "_WRITABLE") continue;
                if (!ilvCSSDeclaration.getValue().equals("false")) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            ilvRule.printCSS(printWriter, ilvCSSDocument);
        }
    }

    public IlvBuilderSelectionManager getSelectionManager() {
        return this.a;
    }

    public IlvBuilderSelectionManager getRedSelectionManager() {
        return this.b;
    }

    public abstract IlvSelectorContext getSelectorContext();

    @Override
    public void styleChange(StyleChangeEvent styleChangeEvent) {
        Object object;
        Object object2;
        if (styleChangeEvent instanceof StyleChangeEvent.SelectorChange) {
            object2 = (StyleChangeEvent.SelectorChange)styleChangeEvent;
            object = styleChangeEvent.getRule();
            if (object != null) {
                this.getCSS().setSelector((IlvRule)object, ((StyleChangeEvent.SelectorChange)object2).getNewSelector());
                String string = ((StyleChangeEvent.SelectorChange)object2).getNewName();
                if (string != null) {
                    object.setName(string);
                }
                this.ruleChangedNotifyImpl((IlvRule)object, 1, true);
            }
        } else if (styleChangeEvent instanceof StyleChangeEvent.MoveBefore) {
            object2 = (StyleChangeEvent.MoveBefore)styleChangeEvent;
            object = ((StyleChangeEvent.MoveBefore)object2).getMovedRules();
            IlvRule ilvRule = ((StyleChangeEvent.MoveBefore)object2).getDestinationRule();
            IlvRule[] ilvRuleArray = this.getAllRules(true);
            this.a((IlvRule[])object, ilvRule, ilvRuleArray);
        } else if (styleChangeEvent instanceof StyleChangeEvent.AddRemove) {
            IlvCSSDeclaration[] ilvCSSDeclarationArray;
            IlvRule[] ilvRuleArray;
            int n;
            Object object3;
            object2 = styleChangeEvent.getRule();
            object = styleChangeEvent.getDeclarations();
            if (object != null && object2 != null) {
                object3 = object2;
                for (n = 0; n < ((Object[])object).length; ++n) {
                    ilvRuleArray = object[n];
                    if (styleChangeEvent.getMode() == StyleChangeEvent.DELETE) {
                        object2.removeDeclaration(ilvRuleArray.getProperty());
                        continue;
                    }
                    object3.setModified(ilvRuleArray.getProperty());
                    object2.setDeclaration((IlvCSSDeclaration)ilvRuleArray);
                }
                object3.setModified(true);
                this.c((IlvRule)object3);
            }
            if ((object3 = styleChangeEvent.getAdditionalRules()) != null && ((IlvRule[])object3).length > 0) {
                IlvRule ilvRule;
                int n2 = n = styleChangeEvent.isDeleteMode() ? 0 : 2;
                if (styleChangeEvent.isDeleteMode()) {
                    ilvRuleArray = this.getAllRules(true);
                    ((StyleChangeEvent.Remove)styleChangeEvent).setLocation(this.a((IlvRule[])object3, ilvRuleArray));
                }
                for (int i = 0; i < ((Object)object3).length; ++i) {
                    Object object4 = object3[i];
                    if (this.checkDuplicateRule() && !styleChangeEvent.isDeleteMode()) {
                        try {
                            if (this.getCSS().getRule(object4.getSelectorString(), false) != null) continue;
                            this.ruleChangedNotifyImpl((IlvRule)object4, n, false);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    this.ruleChangedNotifyImpl((IlvRule)object4, n, false);
                }
                if (!styleChangeEvent.isDeleteMode() && (ilvRule = ((StyleChangeEvent.Add)styleChangeEvent).getLocation()) != null) {
                    this.a((IlvRule[])object3, ilvRule, this.getAllRules(true));
                }
            }
            if ((ilvCSSDeclarationArray = styleChangeEvent.getDeclarations()) != null) {
                Integer n3 = new Integer(1);
                for (int i = 0; i < ilvCSSDeclarationArray.length; ++i) {
                    IlvCSSDeclaration ilvCSSDeclaration = ilvCSSDeclarationArray[i];
                    if (styleChangeEvent.isDeleteMode()) {
                        IlvRule ilvRule = this.getCSS().getRuleWithDeclaration((IlvRule)object2, ilvCSSDeclaration.getProperty());
                        this.j.put(ilvCSSDeclaration.getProperty(), new Integer(ilvRule == null ? 3 : 2));
                        continue;
                    }
                    this.j.put(ilvCSSDeclaration.getProperty(), n3);
                }
            }
        }
        this.getCSSEngine().fireRuleSetEvent(new RuleSetEvent(this.getCSSEngine(), RuleSetEvent.Type.RULES_CHANGED));
        this.setModified(true);
        boolean bl = this.applyChanges(styleChangeEvent);
        if (!(styleChangeEvent.getSource() instanceof StyleChangeEdit)) {
            object = new StyleChangeEdit(styleChangeEvent);
            if (styleChangeEvent.getSeverity() == -10) {
                if (this.f == null) {
                    this.f = new CompoundEdit(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void undo() throws CannotUndoException {
                            StyleChangeEdit styleChangeEdit = (StyleChangeEdit)this.edits.get(0);
                            StyleChangeEdit styleChangeEdit2 = (StyleChangeEdit)this.lastEdit();
                            if (styleChangeEdit != null && styleChangeEdit2 != null) {
                                int n = styleChangeEdit2.h.getSeverity();
                                try {
                                    styleChangeEdit.h.setSeverity(n);
                                    styleChangeEdit2.h.setSeverity(-10);
                                    super.undo();
                                }
                                finally {
                                    styleChangeEdit.h.setSeverity(-10);
                                    styleChangeEdit2.h.setSeverity(n);
                                }
                            }
                        }
                    };
                }
                this.a(this.f, (UndoableEdit)object);
            } else if (this.f != null) {
                this.a(this.f, (UndoableEdit)object);
                this.f.end();
                this.a(this.getUndoManager(), this.f);
                this.f = null;
            } else if (styleChangeEvent.getMode() != StyleChangeEvent.OVERRIDE || styleChangeEvent.getDeclarations() != null || styleChangeEvent.getAdditionalRules() != null) {
                this.a(this.getUndoManager(), (UndoableEdit)object);
            }
        }
        if (!bl) {
            this.notifyStyleChangeEvent(styleChangeEvent);
        }
    }

    protected boolean checkDuplicateRule() {
        return true;
    }

    private void a(CompoundEdit compoundEdit, UndoableEdit undoableEdit) {
        compoundEdit.addEdit(undoableEdit);
    }

    private String a(StyleChangeEvent styleChangeEvent) {
        IlvRule[] ilvRuleArray;
        IlvCSSDeclaration[] ilvCSSDeclarationArray;
        StringBuffer stringBuffer = new StringBuffer(styleChangeEvent.isDeleteMode() ? "(del) " : "(add)");
        IlvRule ilvRule = styleChangeEvent.getRule();
        if (ilvRule != null) {
            stringBuffer.append(((IlvRuleImpl)ilvRule).getRule().getSelectorStringForDebug()).append(" ");
        }
        if ((ilvCSSDeclarationArray = styleChangeEvent.getDeclarations()) != null) {
            for (int i = 0; i < ilvCSSDeclarationArray.length; ++i) {
                IlvCSSDeclaration ilvCSSDeclaration = ilvCSSDeclarationArray[i];
                stringBuffer.append(ilvCSSDeclaration.getProperty()).append(" : ").append(ilvCSSDeclaration.getValue()).append("; ");
            }
        }
        if ((ilvRuleArray = styleChangeEvent.getAdditionalRules()) != null) {
            for (int i = 0; i < ilvRuleArray.length; ++i) {
                IlvRule ilvRule2 = ilvRuleArray[i];
                stringBuffer.append(" + ").append(((IlvRuleImpl)ilvRule).getRule().getSelectorStringForDebug());
            }
        }
        return stringBuffer.toString();
    }

    protected final void notifyStyleChangeEvent(StyleChangeEvent styleChangeEvent) {
        this.e.fireStyleChangeEvent(styleChangeEvent);
    }

    protected boolean applyChanges(StyleChangeEvent styleChangeEvent) {
        return false;
    }

    private void a(IlvRule[] ilvRuleArray, IlvRule ilvRule, IlvRule[] ilvRuleArray2) {
        int n;
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>(Arrays.asList(ilvRuleArray2));
        for (n = 0; n < ilvRuleArray.length; ++n) {
            IlvRule ilvRule2 = ilvRuleArray[n];
            arrayList.remove(ilvRule2);
        }
        n = arrayList.indexOf(ilvRule);
        if (n == -1) {
            arrayList.addAll(Arrays.asList(ilvRuleArray));
        } else {
            arrayList.addAll(n, Arrays.asList(ilvRuleArray));
        }
        ilvRuleArray2 = arrayList.toArray(new IlvRule[arrayList.size()]);
        this.validateRules(ilvRuleArray2, true);
        this.getCSS().setProperty("XX-rule-event", new Object());
    }

    private IlvRule a(IlvRule[] ilvRuleArray, IlvRule[] ilvRuleArray2) {
        int n = 0;
        IlvRule ilvRule = ilvRuleArray[n];
        for (int i = 0; i < ilvRuleArray2.length - 1; ++i) {
            IlvRule ilvRule2 = ilvRuleArray2[i];
            if (ilvRule2 != ilvRule) continue;
            IlvRule ilvRule3 = ilvRuleArray2[i + 1];
            boolean bl = true;
            for (int j = 0; j < ilvRuleArray.length; ++j) {
                if (ilvRuleArray[j] != ilvRule3) continue;
                bl = false;
                break;
            }
            if (bl) {
                return ilvRule3;
            }
            if (++n == ilvRuleArray.length) {
                return null;
            }
            ilvRule = ilvRuleArray[n];
            i = -1;
        }
        return null;
    }

    public void ruleEnabledChangedNotify(IlvRule ilvRule, boolean bl) {
        this.validateRules(this.getAllRules(true), true);
        IlvRuleTreeView ilvRuleTreeView = this.getTreeView();
        if (ilvRuleTreeView != null) {
            ilvRuleTreeView.refreshLine(ilvRule);
        }
    }

    public void ruleNameChangedNotify(IlvRule ilvRule) {
        IlvRuleTreeView ilvRuleTreeView = this.getTreeView();
        if (ilvRuleTreeView != null) {
            ilvRuleTreeView.repaint();
        }
        this.setModified(true);
    }

    public final IlvRuleTreeView getTreeView() {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            IlvDocumentView ilvDocumentView = this.getView(i);
            if (!(ilvDocumentView instanceof IlvRuleTreeView)) continue;
            return (IlvRuleTreeView)ilvDocumentView;
        }
        return null;
    }

    private void c(IlvRule ilvRule) {
        IlvRuleTreeView ilvRuleTreeView = this.getTreeView();
        if (ilvRuleTreeView != null) {
            ilvRuleTreeView.refreshLine(ilvRule);
        }
    }

    public final IlvPropertySheetView getPropertySheetView() {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            IlvDocumentView ilvDocumentView = this.getView(i);
            if (!(ilvDocumentView instanceof IlvPropertySheetView)) continue;
            return (IlvPropertySheetView)ilvDocumentView;
        }
        return null;
    }

    public final IlvCustomizerView getCustomizerView() {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            IlvDocumentView ilvDocumentView = this.getView(i);
            if (!(ilvDocumentView instanceof IlvCustomizerView)) continue;
            return (IlvCustomizerView)ilvDocumentView;
        }
        return null;
    }

    public IlvDocumentView getModelView() {
        return null;
    }

    public abstract IlvRuleModel getCSS();

    protected void selectionChanged(BuilderSelectionEvent builderSelectionEvent) {
        Action action = this.getApplication().getAction("RuleDeleteAction");
        this.deleteRuleUI(action);
        action = this.getApplication().getAction("RuleCutAction");
        this.cutRuleUI(action);
        action = this.getApplication().getAction("RuleCopyAction");
        this.copyRuleUI(action);
        action = this.getApplication().getAction("RulePasteAction");
        this.pasteRuleUI(action);
        action = this.getApplication().getAction("RuleDisableAction");
        this.disableRuleUI(action);
        action = this.getApplication().getAction("DeclarationsPasteAction");
        this.pasteDeclarationsUI(action);
        action = this.getApplication().getAction("RuleAddAction");
        this.addRuleUI(action);
        action = this.getApplication().getAction("RuleChangeAction");
        this.changeRuleUI(action);
        Object object = builderSelectionEvent.getNewSelection();
        if (object instanceof IlvRule) {
            this.cleanDeclarationStatusCache();
        }
    }

    public void cleanDeclarationStatusCache() {
        if (this.j != null) {
            this.j.clear();
        }
    }

    public Object makeBeanFromRule(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray = this.getCSS().getParentRules(ilvRule, true);
        IlvMapBasedApplicableDeclarationCollection ilvMapBasedApplicableDeclarationCollection = new IlvMapBasedApplicableDeclarationCollection();
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRuleArray[i].getCSSDeclarations();
            for (int j = 0; j < ilvCSSDeclarationArray.length; ++j) {
                Declaration declaration = (Declaration)ilvCSSDeclarationArray[j];
                ilvMapBasedApplicableDeclarationCollection.put(declaration.getProperty(), declaration.getDeclarationValue());
            }
        }
        ilvRuleArray = this.getCSS().getAdditionalRules(ilvRuleArray);
        Object object = null;
        try {
            object = IlvRuleUtils.createBeanFromDeclarations(this, null, new ReflectModel(), ilvMapBasedApplicableDeclarationCollection, null, false, false, ilvRuleArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    public Object makeBeanFromRule2(IlvRule ilvRule) {
        Object object = this.makeBeanFromRule(ilvRule);
        if (object == null) {
            object = this.getExistingBeanFromRule(ilvRule);
        }
        return object;
    }

    public Object getExistingBeanFromRule(IlvRule ilvRule) {
        Object[] objectArray = this.getMatchingObjects(ilvRule);
        if (objectArray != null && objectArray.length > 0) {
            return objectArray[0];
        }
        IlvRule[] ilvRuleArray = this.getCSS().getParentRules(ilvRule);
        if (ilvRuleArray != null) {
            for (int i = ilvRuleArray.length - 1; i >= 0; --i) {
                IlvRule ilvRule2 = ilvRuleArray[i];
                objectArray = this.getMatchingObjects(ilvRule2);
                if (objectArray == null || objectArray.length <= 0) continue;
                return objectArray[0];
            }
        }
        return null;
    }

    public int getDeclarationStatus(IlvRule ilvRule, String string) {
        if (ilvRule == null || ilvRule.getDeclarationValue(string) == null) {
            return 2;
        }
        return 0;
    }

    public IlvRule getSelectedEditableRule() {
        Object object = this.getSelectionManager().getSelection();
        if (object instanceof IlvRule) {
            return (IlvRule)object;
        }
        return null;
    }

    public IlvRule getRedSelectedEditableRule() {
        Object object = this.getRedSelectionManager().getSelection();
        if (object instanceof IlvRule) {
            return (IlvRule)object;
        }
        return null;
    }

    public void addStyleChangeListener(StyleChangeListener styleChangeListener) {
        this.e.addStyleChangeListener(styleChangeListener);
    }

    public void removeStyleChangeListener(StyleChangeListener styleChangeListener) {
        this.e.removeStyleChangeListener(styleChangeListener);
    }

    protected IlvRule[] getAllRules() {
        return this.getCSS().getAllRules(false);
    }

    protected IlvRule[] getAllRules(boolean bl) {
        return this.getCSS().getAllRules(bl);
    }

    protected abstract IlvCSSBeans getCSSBeans();

    public IlvCSSFunction[] getCSSFunctions() {
        IlvCSSBeans ilvCSSBeans = this.getCSSBeans();
        String[] stringArray = ilvCSSBeans.getDefaultFunctions();
        for (int i = 0; i < stringArray.length; ++i) {
            ilvCSSBeans.getFunction(stringArray[i]);
        }
        return this.getCSSBeans().getAllFunctions();
    }

    public IlvCSSEngine getCSSEngine() {
        return this.getCSSBeans().getCSSengine();
    }

    protected void ruleChangedNotifyImpl(IlvRule ilvRule, int n, boolean bl) {
        this.getCSSBeans().clear();
        switch (n) {
            case 0: {
                this.addRemoveRuleImpl(ilvRule, false, bl);
                this.c.remove(ilvRule);
                this.getCSS().setProperty("XX-rule-event", new Object());
                if (this.getSelectionManager().getSelection() != ilvRule || !bl) break;
                this.getSelectionManager().setSelection(null);
                this.getRedSelectionManager().setSelection(null);
                break;
            }
            case 2: {
                this.addRemoveRuleImpl(ilvRule, true, bl);
                ilvRule.setModified(true);
                this.c(ilvRule);
                this.getCSS().setProperty("XX-rule-event", new Object());
                IlvRuleTreeView ilvRuleTreeView = this.getTreeView();
                if (ilvRuleTreeView != null) {
                    ilvRuleTreeView.ensureVisible(ilvRule);
                }
                if (!bl) break;
                this.getSelectionManager().setSelection(ilvRule);
                break;
            }
            case 1: {
                this.validateRules(this.getAllRules(true), true);
                ilvRule.setModified(true);
                this.c(ilvRule);
                this.getCSS().setProperty("XX-rule-event", new Object());
            }
        }
    }

    public boolean known(IlvRule ilvRule) {
        return true;
    }

    protected void addRemoveRuleImpl(IlvRule ilvRule, boolean bl, boolean bl2) {
        IlvRule[] ilvRuleArray;
        IlvRule[] ilvRuleArray2 = this.getAllRules(true);
        if (bl) {
            ilvRuleArray = new IlvRule[ilvRuleArray2.length + 1];
            ilvRuleArray[ilvRuleArray2.length] = ilvRule;
            System.arraycopy(ilvRuleArray2, 0, ilvRuleArray, 0, ilvRuleArray2.length);
        } else {
            int n = -1;
            for (int i = 0; i < ilvRuleArray2.length; ++i) {
                IlvRule ilvRule2 = ilvRuleArray2[i];
                if (ilvRule2 != ilvRule) continue;
                n = i;
                break;
            }
            if (n == -1) {
                return;
            }
            ilvRuleArray = new IlvRule[ilvRuleArray2.length - 1];
            System.arraycopy(ilvRuleArray2, 0, ilvRuleArray, 0, n);
            System.arraycopy(ilvRuleArray2, n + 1, ilvRuleArray, n, ilvRuleArray2.length - n - 1);
        }
        this.validateRules(ilvRuleArray, bl2);
    }

    protected void validateRules(IlvRule[] ilvRuleArray, boolean bl) {
        this.getCSSBeans().clear();
        Rule[] ruleArray = new Rule[ilvRuleArray.length];
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            ruleArray[i] = ((IlvRuleImpl)ilvRuleArray[i]).getRule();
        }
        this.getCSSEngine().setRules(ruleArray);
    }

    public void addCustomizerHandler(IlvCustomizerHandler ilvCustomizerHandler) {
        if (ilvCustomizerHandler == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.k.add(ilvCustomizerHandler);
    }

    public boolean removeCustomizerHandler(IlvCustomizerHandler ilvCustomizerHandler) {
        if (ilvCustomizerHandler == null) {
            throw new IllegalArgumentException("null parameter");
        }
        boolean bl = this.k.contains(ilvCustomizerHandler);
        if (bl) {
            this.k.remove(ilvCustomizerHandler);
        }
        return bl;
    }

    public ListIterator getCustomizerHandlerIterator() {
        return this.k.listIterator();
    }

    public IlvCustomizerHandler getCustomizerHandler(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        IlvCustomizerHandler ilvCustomizerHandler = null;
        do {
            if ((ilvCustomizerHandler = this.a(object, clazz)) == null) continue;
            return ilvCustomizerHandler;
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    private IlvCustomizerHandler a(Object object, Class clazz) {
        ListIterator listIterator = this.getCustomizerHandlerIterator();
        while (listIterator.hasNext()) {
            IlvCustomizerHandler ilvCustomizerHandler = (IlvCustomizerHandler)listIterator.next();
            if (!ilvCustomizerHandler.match(object, clazz)) continue;
            return ilvCustomizerHandler;
        }
        return null;
    }

    void a(Object object) {
        this.i = object;
    }

    Object d() {
        return this.i;
    }

    public IlvParserHandler makeParserHandler() {
        return new InteractiveParserHandler(this);
    }

    protected void applyStyleImpl(URL uRL, boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyStyle() {
        IlvApplication ilvApplication = this.getApplication();
        IlvFileChooserSelection[] ilvFileChooserSelectionArray = ilvApplication.showFileChooser(null, ilvApplication.getString("Builder.ApplyStyle.FileChooserTitle"), 10, this.b(ilvApplication), null);
        if (ilvFileChooserSelectionArray != null && ilvFileChooserSelectionArray.length > 0) {
            Object[] objectArray = new String[3];
            objectArray[0] = ilvApplication.getString("Builder.ApplyStyle.ReplaceOrAppend.Replace");
            objectArray[1] = ilvApplication.getString("Builder.ApplyStyle.ReplaceOrAppend.Append");
            objectArray[2] = ilvApplication.getString("Builder.ApplyStyle.ReplaceOrAppend.Cancel");
            Object[] objectArray2 = objectArray;
            int n = JOptionPane.showOptionDialog(((IlvSwingMainWindow)ilvApplication.getMainWindow()).getFrame(), new JLabel(ilvApplication.getString("Builder.ApplyStyle.ReplaceOrAppend.Message")), ilvApplication.getString("Builder.ApplyStyle.ReplaceOrAppend.Title"), 2, 3, null, objectArray2, objectArray2[0]);
            IlvMessageView ilvMessageView = IlvMessageView.getMessageView(ilvApplication);
            Level level = ilvMessageView.getLevel();
            ilvMessageView.setLevel(Level.WARNING);
            try {
                if (n == 0) {
                    this.applyStyleImpl(ilvFileChooserSelectionArray[0].getURL(), true);
                } else if (n == 1) {
                    this.applyStyleImpl(ilvFileChooserSelectionArray[0].getURL(), false);
                }
            }
            finally {
                ilvMessageView.setLevel(level);
            }
        }
    }

    private IlvFileDocumentTemplate b(IlvApplication ilvApplication) {
        if (this.n == null) {
            this.n = new IlvFileDocumentTemplate();
            IlvFileFilter ilvFileFilter = new IlvFileFilter(this.n, ".css", ilvApplication.getString("Builder.ApplyStyle.CSSDescription"));
            this.n.addFilter(ilvFileFilter);
            this.n.setDefaultFilter(ilvFileFilter);
        }
        return this.n;
    }

    public void pageSetup() {
    }

    public void printPreview() {
    }

    public void print() {
    }

    public boolean ruleEditionWithDataModel() {
        return false;
    }

    static {
        NEW_VALUE = "XX-new";
        CHANGED_VALUE = "XX-changed";
    }

    protected static class InteractiveParserHandler
    extends IlvParserHandler {
        IlvContextualFileChooser a;
        IlvBuilderDocument b;
        boolean c = true;

        public InteractiveParserHandler(IlvBuilderDocument ilvBuilderDocument) {
            this.b = ilvBuilderDocument;
            ilvBuilderDocument.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("Application")) {
                        InteractiveParserHandler.this.a((IlvApplication)propertyChangeEvent.getNewValue());
                    }
                }
            });
        }

        private void a(IlvApplication ilvApplication) {
            if (ilvApplication != null) {
                this.a = new IlvContextualFileChooser(ilvApplication);
            }
        }

        @Override
        public boolean missingSymbolPalette(String string, String string2, String string3) {
            return false;
        }

        @Override
        public String resolvDeclarationURL(Declaration declaration, Rule rule, IlvCSSDocument ilvCSSDocument) {
            String string;
            block8: {
                string = super.resolvDeclarationURL(declaration, rule, ilvCSSDocument);
                try {
                    URL uRL = new URL(string);
                    InputStream inputStream = null;
                    try {
                        inputStream = IlvURLUtil.openStream(uRL);
                    }
                    catch (Exception exception) {
                        URL uRL2 = null;
                        try {
                            uRL2 = IlvURLUtil.convertFilenameToAbsoluteURL(".");
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        IlvCSSDocument ilvCSSDocument2 = new IlvCSSDocument(uRL2, ilvCSSDocument.getURLpath());
                        string = super.resolvDeclarationURL(declaration, rule, ilvCSSDocument2);
                        uRL = new URL(string);
                        inputStream = IlvURLUtil.openStream(uRL);
                        declaration.setDocument(ilvCSSDocument2);
                        ilvCSSDocument.setURL(ilvCSSDocument2.getURL());
                    }
                    inputStream.close();
                }
                catch (Exception exception) {
                    String string2;
                    block10: {
                        String string3;
                        block9: {
                            string3 = declaration.getValue();
                            string2 = string3.substring(4, string3.length() - 1).trim();
                            if (string2.startsWith("\"")) break block9;
                            if (!string2.startsWith("'")) break block10;
                        }
                        string2 = string2.substring(1, string3.length() - 1);
                    }
                    boolean bl = this.c;
                    this.c = false;
                    String string4 = this.a.requestNewFile(this.b.getApplication().getMainComponent(), ilvCSSDocument.getBaseURL(), string2, declaration, bl);
                    if (string4 == string2) break block8;
                    this.b.setModified(true);
                    return string4;
                }
            }
            return string;
        }

        @Override
        public void reset() {
            this.c = true;
        }
    }

    private static class CheckRulesLogPublisher
    extends IlvMessageView.LogPublisher {
        private CheckRulesLogPublisher() {
        }

        @Override
        public Object getHashKey(LogRecord logRecord) {
            return logRecord.getParameters()[1];
        }

        @Override
        public IlvMessageView.LogDetail[] getDetails(LogRecord logRecord, final IlvMessageView ilvMessageView) {
            Object[] objectArray = logRecord.getParameters();
            IlvMessageView.LogDetail[] logDetailArray = new IlvMessageView.LogDetail[objectArray.length - 1];
            String string = ilvMessageView.getApplication().getString("Builder.MessageView.Rule");
            final IlvBuilderDocument ilvBuilderDocument = (IlvBuilderDocument)objectArray[0];
            for (int i = 1; i < objectArray.length; ++i) {
                final IlvRule ilvRule = (IlvRule)objectArray[i];
                logDetailArray[i - 1] = new IlvMessageView.LogDetail(MessageFormat.format(string, ilvRule)){

                    @Override
                    public boolean isClickable() {
                        return ilvMessageView.getDocument() == ilvBuilderDocument && this.a();
                    }

                    @Override
                    public void click() {
                        if (ilvMessageView.getDocument() == ilvBuilderDocument && this.a()) {
                            ilvBuilderDocument.getSelectionManager().setSelection(ilvRule);
                        }
                    }

                    private boolean a() {
                        return ilvBuilderDocument.known(ilvRule);
                    }
                };
            }
            return logDetailArray;
        }
    }

    protected static class ReflectModel
    implements IlvCSSModel {
        @Override
        public Object[] getChildrenAsArray(Object object) {
            return new Object[0];
        }

        @Override
        public String getType(Object object) {
            return null;
        }

        @Override
        public String getCSSclasses(Object object) {
            return null;
        }

        @Override
        public String getID(Object object) {
            return null;
        }

        @Override
        public String getValue(Object object, String string) {
            return "@" + string;
        }

        @Override
        public Object getValueAsObject(Object object, String string) {
            return this.getValue(object, string);
        }

        @Override
        public ULocale getULocale(Object object) {
            return IlvLocaleUtil.getCurrentULocale();
        }

        @Override
        public ComponentOrientation getComponentOrientation(Object object) {
            return ComponentOrientation.UNKNOWN;
        }
    }

    public class StyleChangeEdit
    extends AbstractUndoableEdit {
        IlvRule a;
        IlvRule b;
        IlvRule[] c;
        IlvCSSDeclaration[] d;
        IlvCSSDeclaration[] e;
        IlvCSSAttributeSelector[] f;
        IlvCSSAttributeSelector[] g;
        StyleChangeEvent h;

        public StyleChangeEdit(StyleChangeEvent styleChangeEvent) {
            this.h = styleChangeEvent;
            StyleChangeEvent.Mode mode = styleChangeEvent.getMode();
            if (mode == StyleChangeEvent.MOVE_BEFORE) {
                StyleChangeEvent.MoveBefore moveBefore = (StyleChangeEvent.MoveBefore)styleChangeEvent;
                IlvRule ilvRule = null;
                IlvRule[] ilvRuleArray = IlvBuilderDocument.this.getAllRules(true);
                this.b = moveBefore.getDestinationRule();
                for (int i = 0; i < ilvRuleArray.length - 1; ++i) {
                    if (this.b != ilvRuleArray[i]) continue;
                    ilvRule = ilvRuleArray[i + 1];
                    break;
                }
                this.c = moveBefore.getMovedRules();
                this.a = ilvRule;
            } else if (styleChangeEvent instanceof StyleChangeEvent.AddRemove) {
                this.a = styleChangeEvent.getRule();
                this.c = styleChangeEvent.getAdditionalRules();
                this.d = this.a(styleChangeEvent.getDeclarations());
                if (this.d != null && this.a != null) {
                    for (int i = 0; i < this.d.length; ++i) {
                        this.a.setUnModified(this.d[i].getProperty());
                    }
                }
                this.e = ((StyleChangeEvent.AddRemove)styleChangeEvent).getPreviousDeclarations();
            } else if (mode == StyleChangeEvent.SELECTOR_CHANGE) {
                // empty if block
            }
        }

        private IlvCSSDeclaration[] a(IlvCSSDeclaration[] ilvCSSDeclarationArray) {
            Declaration[] declarationArray = null;
            if (ilvCSSDeclarationArray != null && ilvCSSDeclarationArray.length > 0) {
                declarationArray = new Declaration[ilvCSSDeclarationArray.length];
                for (int i = 0; i < ilvCSSDeclarationArray.length; ++i) {
                    Declaration declaration;
                    Declaration declaration2 = (Declaration)ilvCSSDeclarationArray[i];
                    declarationArray[i] = declaration = Declaration.copy(declaration2);
                }
            }
            return declarationArray;
        }

        @Override
        public boolean isSignificant() {
            return this.h.getSeverity() != 0;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            StyleChangeEvent.Mode mode = this.h.getMode();
            if (mode == StyleChangeEvent.MOVE_BEFORE) {
                StyleChangeEvent.MoveBefore moveBefore = new StyleChangeEvent.MoveBefore(this, this.c, this.a);
                moveBefore.setSeverity(this.h.getSeverity());
                IlvBuilderDocument.this.styleChange(moveBefore);
            } else if (mode == StyleChangeEvent.OVERRIDE) {
                int n;
                Serializable serializable;
                StyleChangeEvent[] styleChangeEventArray = new StyleChangeEvent[3];
                if (this.e != null) {
                    ArrayList<IlvCSSDeclaration> arrayList = new ArrayList<IlvCSSDeclaration>(this.e.length);
                    serializable = new ArrayList(this.e.length);
                    for (int i = 0; i < this.e.length; ++i) {
                        IlvCSSDeclaration ilvCSSDeclaration = this.e[i];
                        this.a.resetModified(this.e[i].getProperty());
                        if (ilvCSSDeclaration instanceof IlvInheritedCSSDeclaration) {
                            ((ArrayList)serializable).add(((IlvInheritedCSSDeclaration)ilvCSSDeclaration).getDeclaration());
                            continue;
                        }
                        arrayList.add(ilvCSSDeclaration);
                    }
                    if (((ArrayList)serializable).size() > 0) {
                        styleChangeEventArray[0] = new StyleChangeEvent.Remove(this, this.a, ((ArrayList)serializable).toArray(new Declaration[((ArrayList)serializable).size()]), null);
                        styleChangeEventArray[0].setSeverity(-10);
                    }
                    if (arrayList.size() > 0) {
                        styleChangeEventArray[1] = new StyleChangeEvent.Add(this, this.a, arrayList.toArray(new Declaration[arrayList.size()]), null);
                        styleChangeEventArray[1].setSeverity(-10);
                    }
                }
                if (this.c != null && this.c.length > 0) {
                    styleChangeEventArray[2] = new StyleChangeEvent.Remove(this, null, null, this.c);
                    styleChangeEventArray[2].setSeverity(-10);
                    ((StyleChangeEvent.Remove)styleChangeEventArray[2]).setLocation(((StyleChangeEvent.AddRemove)this.h).getLocation());
                }
                for (n = 2; n >= 0; --n) {
                    serializable = styleChangeEventArray[n];
                    if (serializable == null) continue;
                    ((StyleChangeEvent)serializable).setSeverity(this.h.getSeverity());
                    break;
                }
                for (n = 0; n < styleChangeEventArray.length; ++n) {
                    serializable = styleChangeEventArray[n];
                    if (serializable == null) continue;
                    IlvBuilderDocument.this.styleChange((StyleChangeEvent)serializable);
                }
            } else if (mode == StyleChangeEvent.DELETE) {
                StyleChangeEvent.Add add = new StyleChangeEvent.Add((Object)this, (Object)this.a, this.e, this.c, ((StyleChangeEvent.AddRemove)this.h).getLocation());
                add.setSeverity(this.h.getSeverity());
                IlvBuilderDocument.this.styleChange(add);
            } else if (mode == StyleChangeEvent.SELECTOR_CHANGE) {
                StyleChangeEvent.SelectorChange selectorChange = (StyleChangeEvent.SelectorChange)this.h;
                StyleChangeEvent.SelectorChange selectorChange2 = new StyleChangeEvent.SelectorChange((Object)this, this.h.getRule(), selectorChange.getOldSelector(), selectorChange.getNewName(), selectorChange.getOldName());
                selectorChange2.setSeverity(this.h.getSeverity());
                IlvBuilderDocument.this.styleChange(selectorChange2);
            } else {
                throw new RuntimeException("to be done.");
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            StyleChangeEvent styleChangeEvent;
            super.redo();
            StyleChangeEvent.Mode mode = this.h.getMode();
            if (mode == StyleChangeEvent.MOVE_BEFORE) {
                styleChangeEvent = new StyleChangeEvent.MoveBefore(this, this.c, this.b);
            } else if (mode == StyleChangeEvent.OVERRIDE) {
                if (this.d != null && this.a != null) {
                    for (int i = 0; i < this.d.length; ++i) {
                        this.a.resetModified(this.d[i].getProperty());
                    }
                }
                styleChangeEvent = new StyleChangeEvent.Add(this, this.a, this.d, this.c);
            } else if (mode == StyleChangeEvent.DELETE) {
                styleChangeEvent = new StyleChangeEvent.Remove(this, this.a, this.d, this.c);
            } else if (mode == StyleChangeEvent.SELECTOR_CHANGE) {
                StyleChangeEvent.SelectorChange selectorChange = (StyleChangeEvent.SelectorChange)this.h;
                styleChangeEvent = new StyleChangeEvent.SelectorChange((Object)this, this.h.getRule(), selectorChange.getNewSelector(), selectorChange.getOldName(), selectorChange.getNewName());
            } else {
                throw new RuntimeException("to be done.");
            }
            styleChangeEvent.setSeverity(this.h.getSeverity());
            IlvBuilderDocument.this.styleChange(styleChangeEvent);
        }

        @Override
        public String getPresentationName() {
            return super.getPresentationName();
        }
    }

    protected class VisibilityEdit
    extends AbstractUndoableEdit {
        IlvRule[] a;
        IlvRule b;

        public VisibilityEdit(IlvRule ilvRule, IlvRule[] ilvRuleArray) {
            this.a = ilvRuleArray;
            this.b = ilvRule;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            long l = this.a();
            this.a(this.b.isEnabled(), l);
        }

        private long a() {
            long l = System.currentTimeMillis();
            if (this.a.length > 0) {
                IlvRule ilvRule = this.a[0];
                IlvBuilderDocument.this.a(this.a, ilvRule.isEnabled() ? l : 0L);
                if (ilvRule.isEnabled()) {
                    IlvBuilderDocument.this.getSelectionManager().resetSelection();
                } else {
                    IlvBuilderDocument.this.getSelectionManager().setSelection(null);
                }
            }
            return l;
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            long l = this.a();
            this.a(this.b.isEnabled(), l);
        }

        private void a(boolean bl, long l) {
            IlvBuilderDocument.this.b(this.b, bl ? null : this.a, l);
        }
    }

    class LocalBuilderSelectionListener
    implements BuilderSelectionListener {
        LocalBuilderSelectionListener() {
        }

        @Override
        public void selectionChanged(BuilderSelectionEvent builderSelectionEvent) {
            IlvBuilderDocument.this.selectionChanged(builderSelectionEvent);
        }
    }
}

