/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvApplyObject;
import ilog.views.IlvBidiGraphic;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvRegion;
import ilog.views.IlvTransformer;
import ilog.views.event.GraphicBagHierarchyEvent;
import ilog.views.event.GraphicBagHierarchyEventReceiver;
import ilog.views.event.GraphicBagHierarchyListener;
import ilog.views.event.ManagerViewsChangedEvent;
import ilog.views.event.ManagerViewsChangedListener;
import ilog.views.event.ManagerViewsHierarchyEventReceiver;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import ilog.views.swing.IlvPopupMenuManager;
import java.awt.Graphics;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;

public class IlvDoubleGraphicHandleBag
extends IlvBidiGraphic
implements IlvGraphicBag,
GraphicBagHierarchyEventReceiver,
ManagerViewsHierarchyEventReceiver {
    private static final short a = 1;
    private static final short b = 2;
    private static final short c = 4;
    protected static final short MAX_FLAG = 4;
    private EventListenerList d;
    private EventListenerList e;
    private IlvGraphic f;
    private IlvGraphic g;
    private short h;

    public IlvDoubleGraphicHandleBag(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        this(ilvGraphic, ilvGraphic2, true);
    }

    protected IlvDoubleGraphicHandleBag(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        this.setObject1(ilvGraphic);
        this.setObject2(ilvGraphic2);
        this.setFlag((short)1, bl);
    }

    public IlvDoubleGraphicHandleBag(IlvDoubleGraphicHandleBag ilvDoubleGraphicHandleBag) {
        super(ilvDoubleGraphicHandleBag);
        if (ilvDoubleGraphicHandleBag.getObject1() != null) {
            this.setObject1(ilvDoubleGraphicHandleBag.getObject1().copy());
        } else {
            this.setObject1(null);
        }
        if (ilvDoubleGraphicHandleBag.getObject2() != null) {
            this.setObject2(ilvDoubleGraphicHandleBag.getObject2().copy());
        } else {
            this.setObject2(null);
        }
        this.setFlag((short)1, ilvDoubleGraphicHandleBag.isFlagSet((short)1));
    }

    public final IlvGraphic getObject1() {
        return this.f;
    }

    public void setObject1(IlvGraphic ilvGraphic) {
        if (ilvGraphic != null && ilvGraphic.getGraphicBag() != null) {
            throw new IllegalArgumentException("Object has already a graphic bag");
        }
        if (this.getObject1() != null) {
            this.getObject1().setGraphicBag(null);
        }
        this.f = ilvGraphic;
        if (ilvGraphic != null) {
            ilvGraphic.setGraphicBag(this);
        }
    }

    public final IlvGraphic getObject2() {
        return this.g;
    }

    public void setObject2(IlvGraphic ilvGraphic) {
        if (ilvGraphic != null && ilvGraphic.getGraphicBag() != null) {
            throw new IllegalArgumentException("Object has already a graphic bag");
        }
        if (this.getObject2() != null) {
            this.getObject2().setGraphicBag(null);
        }
        this.g = ilvGraphic;
        if (ilvGraphic != null) {
            ilvGraphic.setGraphicBag(this);
        }
    }

    protected void setDelegateMoveResize(boolean bl) {
        this.setFlag((short)1, bl);
    }

    @Override
    public IlvGraphic copy() {
        return new IlvDoubleGraphicHandleBag(this);
    }

    @Override
    public boolean zoomable() {
        return this.f.zoomable() && this.g.zoomable();
    }

    public IlvDoubleGraphicHandleBag(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        if (this.object1Name() != null) {
            try {
                this.setObject1(ilvInputStream.readObject(this.object1Name()));
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                this.setObject1(null);
            }
        }
        if (this.object2Name() != null) {
            try {
                this.setObject2(ilvInputStream.readObject(this.object2Name()));
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                this.setObject2(null);
            }
        }
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        if (this.object1Name() != null && this.f != null) {
            ilvOutputStream.write(this.object1Name(), this.f);
        }
        if (this.object2Name() != null && this.g != null) {
            ilvOutputStream.write(this.object2Name(), this.g);
        }
    }

    protected String object1Name() {
        return "object1";
    }

    protected String object2Name() {
        return "object2";
    }

    @Override
    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        Object object;
        this.a(this.getGraphicBag(), 2);
        IlvGraphicBag ilvGraphicBag2 = null;
        if (this.needsGraphicBagHierarchyEvent()) {
            ilvGraphicBag2 = this.a();
        }
        super.setGraphicBag(ilvGraphicBag);
        if (ilvGraphicBag instanceof GraphicBagHierarchyEventReceiver && this.needsGraphicBagHierarchyEvent()) {
            object = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphicBag);
            object.enableGraphicBagHierarchyEventForwarding();
        }
        if (ilvGraphicBag instanceof ManagerViewsHierarchyEventReceiver && this.needsManagerViewsHierarchyEvent()) {
            object = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphicBag);
            object.enableManagerViewsHierarchyEventForwarding();
        }
        this.a(this.getGraphicBag(), 1);
        this.b(ilvGraphicBag2);
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.f != null) {
            this.f.callDraw(graphics, ilvTransformer);
        }
        if (this.g != null) {
            this.g.callDraw(graphics, ilvTransformer);
        }
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect;
        if (this.f != null) {
            ilvRect = this.f.boundingBox(ilvTransformer);
            if (this.g != null) {
                ilvRect.add(this.g.boundingBox(ilvTransformer));
            }
        } else {
            ilvRect = this.g != null ? this.g.boundingBox(ilvTransformer) : new IlvRect(0.0f, 0.0f, 0.1f, 0.1f);
        }
        return ilvRect;
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            if (this.f != null) {
                this.f.applyTransform(ilvTransformer);
            }
            if (this.g != null) {
                this.g.applyTransform(ilvTransformer);
            }
        }
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.f != null && this.f.contains(ilvPoint, ilvPoint2, ilvTransformer)) {
            return true;
        }
        return this.g != null && this.g.contains(ilvPoint, ilvPoint2, ilvTransformer);
    }

    @Override
    public boolean intersects(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        if (this.f != null && this.f.intersects(ilvRect, ilvRect2, ilvTransformer)) {
            return true;
        }
        return this.g != null && this.g.intersects(ilvRect, ilvRect2, ilvTransformer);
    }

    @Override
    public boolean inside(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        if (this.f != null && this.f.inside(ilvRect, ilvRect2, ilvTransformer)) {
            return true;
        }
        return this.g != null && this.g.inside(ilvRect, ilvRect2, ilvTransformer);
    }

    @Override
    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint[] ilvPointArray = new IlvPoint[2];
        int n = 0;
        if (this.f != null && this.f.isVisible()) {
            ilvPointArray[n++] = this.f.getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer);
        }
        if (this.g != null && this.g.isVisible()) {
            ilvPointArray[n++] = this.g.getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer);
        }
        if (n == 0) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint ilvPoint3 = IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray, n);
        return ilvPoint3;
    }

    @Override
    public void move(float f, float f2) {
        if (this.isFlagSet((short)1)) {
            float f3 = Float.MAX_VALUE;
            float f4 = Float.MAX_VALUE;
            IlvRect ilvRect = null;
            IlvRect ilvRect2 = null;
            if (this.f != null) {
                ilvRect = this.f.boundingBox();
                f3 = Math.min(f3, ilvRect.x);
                f4 = Math.min(f4, ilvRect.y);
            }
            if (this.g != null) {
                ilvRect2 = this.g.boundingBox();
                f3 = Math.min(f3, ilvRect2.x);
                f4 = Math.min(f4, ilvRect2.y);
            }
            if (this.f != null) {
                this.f.move(f + ilvRect.x - f3, f2 + ilvRect.y - f4);
            }
            if (this.g != null) {
                this.g.move(f + ilvRect2.x - f3, f2 + ilvRect2.y - f4);
            }
        } else {
            super.move(f, f2);
        }
    }

    @Override
    public void move(IlvPoint ilvPoint) {
        if (this.isFlagSet((short)1)) {
            float f = Float.MAX_VALUE;
            float f2 = Float.MAX_VALUE;
            IlvRect ilvRect = null;
            IlvRect ilvRect2 = null;
            if (this.f != null) {
                ilvRect = this.f.boundingBox();
                f = Math.min(f, ilvRect.x);
                f2 = Math.min(f2, ilvRect.y);
            }
            if (this.g != null) {
                ilvRect2 = this.g.boundingBox();
                f = Math.min(f, ilvRect2.x);
                f2 = Math.min(f2, ilvRect2.y);
            }
            if (this.f != null) {
                this.f.move(new IlvPoint(ilvPoint.x + ilvRect.x - f, ilvPoint.y + ilvRect.y - f2));
            }
            if (this.g != null) {
                this.g.move(new IlvPoint(ilvPoint.x + ilvRect2.x - f, ilvPoint.y + ilvRect2.y - f2));
            }
        } else {
            super.move(ilvPoint);
        }
    }

    @Override
    public void translate(float f, float f2) {
        if (this.isFlagSet((short)1)) {
            if (this.f != null) {
                this.f.translate(f, f2);
            }
            if (this.g != null) {
                this.g.translate(f, f2);
            }
        } else {
            super.translate(f, f2);
        }
    }

    @Override
    public boolean isPersistent() {
        if (this.f != null && !this.f.isPersistent()) {
            return false;
        }
        return this.g == null || this.g.isPersistent();
    }

    @Override
    public String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        String string;
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        ilvTransformer.inverse(ilvPoint2);
        if (this.g != null && this.g.isVisible() && this.g.contains(ilvPoint2, ilvPoint, ilvTransformer) && (string = this.g.getToolTipText(ilvPoint, ilvTransformer)) != null) {
            return string;
        }
        if (this.f != null && this.f.isVisible() && this.f.contains(ilvPoint2, ilvPoint, ilvTransformer) && (string = this.f.getToolTipText(ilvPoint, ilvTransformer)) != null) {
            return string;
        }
        return this.getToolTipText();
    }

    @Override
    public JPopupMenu getPopupMenu(IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, IlvPopupMenuManager ilvPopupMenuManager) {
        JPopupMenu jPopupMenu;
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        ilvTransformer.inverse(ilvPoint2);
        if (this.g != null && this.g.isVisible() && this.g.contains(ilvPoint2, ilvPoint, ilvTransformer) && (jPopupMenu = this.g.getPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager)) != null) {
            return jPopupMenu;
        }
        if (this.f != null && this.f.isVisible() && this.f.contains(ilvPoint2, ilvPoint, ilvTransformer) && (jPopupMenu = this.f.getPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager)) != null) {
            return jPopupMenu;
        }
        return this.getOriginalPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
    }

    protected JPopupMenu getOriginalPopupMenu(IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, IlvPopupMenuManager ilvPopupMenuManager) {
        return super.getPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
    }

    protected final boolean isFlagSet(short s) {
        return (this.h & s) != 0;
    }

    protected final void setFlag(short s, boolean bl) {
        this.h = bl ? (short)(this.h | s) : (short)(this.h & ~s);
    }

    @Override
    public void addObject(IlvGraphic ilvGraphic, boolean bl) {
    }

    @Override
    public void removeObject(IlvGraphic ilvGraphic, boolean bl) {
    }

    @Override
    public IlvGraphicEnumeration getObjects() {
        return IlvUtility.getObjectsImpl(this, this.getObject1(), this.getObject2());
    }

    @Override
    public void reDrawObj(IlvGraphic ilvGraphic) {
        this.reDraw();
    }

    @Override
    public void reDrawRegion(IlvRegion ilvRegion) {
        this.reDraw();
    }

    @Override
    public void reshapeObject(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl) {
        if (ilvGraphic != this.getObject1() && ilvGraphic != this.getObject2()) {
            throw new RuntimeException("Object is not in this bag");
        }
        IlvUtility.reshapeObjectImplForGraphic(this, ilvGraphic, ilvRect, bl);
    }

    @Override
    public void moveObject(IlvGraphic ilvGraphic, float f, float f2, boolean bl) {
        if (ilvGraphic != this.getObject1() && ilvGraphic != this.getObject2()) {
            throw new RuntimeException("Object is not in this bag");
        }
        IlvUtility.moveObjectImplForGraphic(this, ilvGraphic, f, f2, bl);
    }

    @Override
    public void applyToObject(IlvGraphic ilvGraphic, IlvApplyObject ilvApplyObject, Object object, boolean bl) {
        if (ilvGraphic != this.getObject1() && ilvGraphic != this.getObject2()) {
            throw new RuntimeException("Object is not in this bag");
        }
        IlvUtility.applyToObjectImplForGraphic(this, ilvGraphic, ilvApplyObject, object, bl);
    }

    @Override
    public boolean setObjectName(IlvGraphic ilvGraphic, String string) {
        if (ilvGraphic != this.getObject1() && ilvGraphic != this.getObject2()) {
            return false;
        }
        ilvGraphic.setNameImpl(string);
        return true;
    }

    @Override
    public IlvGraphic getObject(String string) {
        if (this.f != null && (string == this.f.getName() || string != null && string.equals(this.f.getName()))) {
            return this.f;
        }
        if (this.g != null && (string == this.g.getName() || string != null && string.equals(this.g.getName()))) {
            return this.g;
        }
        return null;
    }

    @Override
    public void addGraphicBagHierarchyListener(GraphicBagHierarchyListener graphicBagHierarchyListener) {
        if (this.d == null) {
            this.d = new EventListenerList();
        }
        this.d.add(GraphicBagHierarchyListener.class, graphicBagHierarchyListener);
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag instanceof GraphicBagHierarchyEventReceiver) {
            GraphicBagHierarchyEventReceiver graphicBagHierarchyEventReceiver = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphicBag);
            graphicBagHierarchyEventReceiver.enableGraphicBagHierarchyEventForwarding();
        }
    }

    @Override
    public void removeGraphicBagHierarchyListener(GraphicBagHierarchyListener graphicBagHierarchyListener) {
        if (this.d != null) {
            this.d.remove(GraphicBagHierarchyListener.class, graphicBagHierarchyListener);
            if (this.d.getListenerCount() == 0) {
                this.d = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableGraphicBagHierarchyEventForwarding() {
        if (this.isFlagSet((short)2)) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.a();
        synchronized (ilvGraphicBag) {
            this.setFlag((short)2, true);
            IlvGraphicBag ilvGraphicBag2 = this.getGraphicBag();
            if (ilvGraphicBag2 instanceof GraphicBagHierarchyEventReceiver) {
                GraphicBagHierarchyEventReceiver graphicBagHierarchyEventReceiver = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphicBag2);
                graphicBagHierarchyEventReceiver.enableGraphicBagHierarchyEventForwarding();
            }
        }
    }

    @Override
    public boolean needsGraphicBagHierarchyEvent() {
        return this.d != null || this.isFlagSet((short)2);
    }

    private IlvGraphicBag a() {
        IlvGraphicBag ilvGraphicBag = this;
        while (ilvGraphicBag.getGraphicBag() != null) {
            if (ilvGraphicBag instanceof IlvManager) {
                return (IlvGraphicBag)((IlvManager)ilvGraphicBag).getTreeLock();
            }
            ilvGraphicBag = ilvGraphicBag.getGraphicBag();
        }
        return ilvGraphicBag;
    }

    private void b(IlvGraphicBag ilvGraphicBag) {
        if (!this.needsGraphicBagHierarchyEvent()) {
            return;
        }
        IlvGraphicBag ilvGraphicBag2 = this.a();
        GraphicBagHierarchyEvent graphicBagHierarchyEvent = new GraphicBagHierarchyEvent(this, ilvGraphicBag, ilvGraphicBag2);
        this.fireGraphicBagHierarchyEvent(graphicBagHierarchyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireGraphicBagHierarchyEvent(GraphicBagHierarchyEvent graphicBagHierarchyEvent) {
        int n;
        Object object;
        if (this.d != null) {
            object = this.d.getListenerList();
            n = ((Object[])object).length;
            for (int i = n - 1; i >= 0; i -= 2) {
                ((GraphicBagHierarchyListener)object[i]).hierarchyChanged(graphicBagHierarchyEvent);
            }
        }
        if (this.isFlagSet((short)2)) {
            object = this.getObjects();
            while (object.hasMoreElements()) {
                GraphicBagHierarchyEventReceiver graphicBagHierarchyEventReceiver;
                IlvGraphic ilvGraphic = object.nextElement();
                if (!(ilvGraphic instanceof GraphicBagHierarchyEventReceiver) || !(graphicBagHierarchyEventReceiver = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphic)).needsGraphicBagHierarchyEvent()) continue;
                graphicBagHierarchyEventReceiver.fireGraphicBagHierarchyEvent(graphicBagHierarchyEvent);
            }
            object = graphicBagHierarchyEvent.getNewRootBag();
            synchronized (object) {
                n = 0;
                IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    GraphicBagHierarchyEventReceiver graphicBagHierarchyEventReceiver;
                    IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                    if (!(ilvGraphic instanceof GraphicBagHierarchyEventReceiver) || !(graphicBagHierarchyEventReceiver = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphic)).needsGraphicBagHierarchyEvent()) continue;
                    n = 1;
                }
                this.setFlag((short)2, n != 0);
            }
        }
    }

    @Override
    public void addManagerViewsHierarchyListener(ManagerViewsChangedListener managerViewsChangedListener) {
        if (this.e == null) {
            this.e = new EventListenerList();
        }
        this.e.add(ManagerViewsChangedListener.class, managerViewsChangedListener);
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag instanceof ManagerViewsHierarchyEventReceiver) {
            ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphicBag);
            managerViewsHierarchyEventReceiver.enableManagerViewsHierarchyEventForwarding();
        }
    }

    @Override
    public void removeManagerViewsHierarchyListener(ManagerViewsChangedListener managerViewsChangedListener) {
        if (this.e != null) {
            this.e.remove(ManagerViewsChangedListener.class, managerViewsChangedListener);
            if (this.e.getListenerCount() == 0) {
                this.e = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableManagerViewsHierarchyEventForwarding() {
        if (this.isFlagSet((short)4)) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.a();
        synchronized (ilvGraphicBag) {
            this.setFlag((short)4, true);
            IlvGraphicBag ilvGraphicBag2 = this.getGraphicBag();
            if (ilvGraphicBag2 instanceof ManagerViewsHierarchyEventReceiver) {
                ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphicBag2);
                managerViewsHierarchyEventReceiver.enableManagerViewsHierarchyEventForwarding();
            }
        }
    }

    @Override
    public boolean needsManagerViewsHierarchyEvent() {
        return this.e != null || this.isFlagSet((short)4);
    }

    private void a(IlvGraphicBag ilvGraphicBag, int n) {
        if (ilvGraphicBag == null || !this.needsManagerViewsHierarchyEvent()) {
            return;
        }
        while (ilvGraphicBag != null) {
            if (ilvGraphicBag instanceof IlvManager) {
                IlvManager ilvManager = (IlvManager)ilvGraphicBag;
                Enumeration enumeration = ilvManager.getViews();
                while (enumeration.hasMoreElements()) {
                    IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
                    if (ilvManagerView == null) continue;
                    ManagerViewsChangedEvent managerViewsChangedEvent = new ManagerViewsChangedEvent(ilvManager, ilvManagerView, n);
                    this.fireManagerViewsHierarchyEvent(managerViewsChangedEvent);
                }
            }
            ilvGraphicBag = ilvGraphicBag.getGraphicBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireManagerViewsHierarchyEvent(ManagerViewsChangedEvent managerViewsChangedEvent) {
        int n;
        Object object;
        if (this.e != null) {
            object = this.e.getListenerList();
            n = ((Object[])object).length;
            for (int i = n - 1; i >= 0; i -= 2) {
                ((ManagerViewsChangedListener)object[i]).viewChanged(managerViewsChangedEvent);
            }
        }
        if (this.isFlagSet((short)4)) {
            object = this.getObjects();
            while (object.hasMoreElements()) {
                ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver;
                IlvGraphic ilvGraphic = object.nextElement();
                if (!(ilvGraphic instanceof ManagerViewsHierarchyEventReceiver) || !(managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphic)).needsManagerViewsHierarchyEvent()) continue;
                managerViewsHierarchyEventReceiver.fireManagerViewsHierarchyEvent(managerViewsChangedEvent);
            }
            object = this.a();
            synchronized (object) {
                n = 0;
                IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver;
                    IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                    if (!(ilvGraphic instanceof ManagerViewsHierarchyEventReceiver) || !(managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphic)).needsManagerViewsHierarchyEvent()) continue;
                    n = 1;
                }
                this.setFlag((short)4, n != 0);
            }
        }
    }
}

