/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.IlvUnresizeableDrawSelection;
import ilog.views.internal.IlvBoundingBoxCache;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.print.IlvPrintUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public class IlvExpandCollapseMarker
extends IlvGraphic {
    private static final Color a = new Color(60, 178, 113);
    private static final Color b = new Color(0, 128, 0);
    private final IlvPoint c = new IlvPoint();
    private boolean d = true;
    private int e = 9;
    private Color f = null;
    private Color g = null;
    private Color h = null;
    private Color i = null;
    private boolean j = true;
    private transient IlvBoundingBoxCache k = new IlvBoundingBoxCache(3);

    public IlvExpandCollapseMarker() {
        this(new IlvPoint(0.0f, 0.0f), true, 9);
    }

    public IlvExpandCollapseMarker(IlvPoint ilvPoint, boolean bl, int n) {
        this.setPoint(ilvPoint);
        this.setExpandedIcon(bl);
        this.setSize(n);
        this.k.setInvalid();
    }

    public IlvExpandCollapseMarker(IlvExpandCollapseMarker ilvExpandCollapseMarker) {
        super(ilvExpandCollapseMarker);
        this.setPoint(ilvExpandCollapseMarker.getPoint());
        this.setExpandedIcon(ilvExpandCollapseMarker.isExpandedIcon());
        this.setSize(ilvExpandCollapseMarker.getSize());
        this.setZoomable(ilvExpandCollapseMarker.isZoomable());
        this.setForeground(ilvExpandCollapseMarker.f);
        this.setBackground(ilvExpandCollapseMarker.g);
        this.setTopLeftBorder(ilvExpandCollapseMarker.h);
        this.setBottomRightBorder(ilvExpandCollapseMarker.i);
        this.k.setInvalid();
    }

    public IlvExpandCollapseMarker(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setPoint(ilvInputStream.readPoint("point"));
        this.setExpandedIcon(ilvInputStream.readBoolean("expanded"));
        this.setSize(ilvInputStream.readInt("size"));
        this.setZoomable(ilvInputStream.readBoolean("zoomable"));
        this.setForeground(ilvInputStream.readColor("foreground"));
        this.setBackground(ilvInputStream.readColor("background"));
        this.setTopLeftBorder(ilvInputStream.readColor("topLeftBorder"));
        this.setBottomRightBorder(ilvInputStream.readColor("bottomRightBorder"));
        this.k.setInvalid();
    }

    @Override
    public IlvGraphic copy() {
        return new IlvExpandCollapseMarker(this);
    }

    public IlvPoint getPoint() {
        return new IlvPoint(this.c);
    }

    public void setPoint(IlvPoint ilvPoint) {
        if (this.c.x != ilvPoint.x && this.c.y != ilvPoint.y) {
            this.c.x = ilvPoint.x;
            this.c.y = ilvPoint.y;
            this.k.setInvalid();
        }
    }

    public boolean isExpandedIcon() {
        return this.d;
    }

    public void setExpandedIcon(boolean bl) {
        this.d = bl;
    }

    public int getSize() {
        return this.e;
    }

    public void setSize(int n) {
        if (n != this.e) {
            this.e = n;
            this.k.setInvalid();
        }
    }

    public boolean isZoomable() {
        return this.j;
    }

    public void setZoomable(boolean bl) {
        if (bl != this.j) {
            this.j = bl;
            this.k.setInvalid();
        }
    }

    @Override
    public boolean zoomable() {
        return this.j;
    }

    @Override
    public void setForeground(Color color) {
        Color color2 = this.f;
        this.f = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        return this.f == null ? Color.black : this.f;
    }

    @Override
    public void setBackground(Color color) {
        Color color2 = this.g;
        this.g = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getBackground() {
        return this.g == null ? Color.white : this.g;
    }

    public void setTopLeftBorder(Color color) {
        Color color2 = this.h;
        this.h = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getTopLeftBorder() {
        return this.h == null ? a : this.h;
    }

    public void setBottomRightBorder(Color color) {
        Color color2 = this.i;
        this.i = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getBottomRightBorder() {
        return this.i == null ? b : this.i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = this.c;
        if (ilvTransformer != null && !ilvTransformer.isIdentity() && !this.zoomable()) {
            ilvPoint = new IlvPoint(this.c);
            ilvTransformer.apply(ilvPoint);
            ilvTransformer = null;
        }
        if (!this.zoomable() && IlvGraphicUtil.isPrinting(graphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                AffineTransform affineTransform = (AffineTransform)graphics2D.getRenderingHint(IlvPrintUtil.KEY_PRINTING_TRANSFORM);
                if (affineTransform != null) {
                    graphics2D.translate(ilvPoint.x, ilvPoint.y);
                    graphics2D.scale(1.0 / affineTransform.getScaleX(), 1.0 / affineTransform.getScaleY());
                    graphics2D.translate(-ilvPoint.x, -ilvPoint.y);
                }
                this.a(graphics2D, ilvPoint, ilvTransformer);
            }
            finally {
                graphics2D.dispose();
            }
        } else {
            this.a(graphics, ilvPoint, ilvTransformer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Graphics graphics, IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Color color = graphics2D.getColor();
        try {
            GeneralPath generalPath;
            int n = this.getSize();
            int n2 = Math.max(1, n - 1);
            Shape shape = new Rectangle2D.Double(ilvPoint.x, ilvPoint.y, n2, n2);
            Shape shape2 = generalPath = new GeneralPath();
            generalPath.moveTo(ilvPoint.x, ilvPoint.y + (float)n2);
            generalPath.lineTo(ilvPoint.x, ilvPoint.y);
            generalPath.lineTo(ilvPoint.x + (float)n2, ilvPoint.y);
            Shape shape3 = generalPath = new GeneralPath();
            generalPath.moveTo(ilvPoint.x, ilvPoint.y + (float)n2);
            generalPath.lineTo(ilvPoint.x + (float)n2, ilvPoint.y + (float)n2);
            generalPath.lineTo(ilvPoint.x + (float)n2, ilvPoint.y);
            Shape shape4 = generalPath = new GeneralPath();
            float f = (float)Math.floor(n / 2);
            generalPath.moveTo(ilvPoint.x + (float)Math.floor(0.23f * (float)n), ilvPoint.y + f);
            generalPath.lineTo(ilvPoint.x + (float)Math.floor(0.67f * (float)n), ilvPoint.y + f);
            if (!this.isExpandedIcon()) {
                generalPath.moveTo(ilvPoint.x + f, ilvPoint.y + (float)Math.floor(0.23f * (float)n));
                generalPath.lineTo(ilvPoint.x + f, ilvPoint.y + (float)Math.floor(0.67f * (float)n));
            }
            Shape shape5 = generalPath = new GeneralPath();
            if (this.isExpandedIcon()) {
                generalPath.moveTo(ilvPoint.x + f, ilvPoint.y + (float)n);
                generalPath.lineTo(ilvPoint.x + f, ilvPoint.y + 1.2f * (float)n);
            } else {
                generalPath.moveTo(ilvPoint.x + (float)n, ilvPoint.y + f);
                generalPath.lineTo(ilvPoint.x + 1.2f * (float)n, ilvPoint.y + f);
            }
            AffineTransform affineTransform = new AffineTransform();
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                affineTransform.setTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
                shape = affineTransform.createTransformedShape(shape);
                shape2 = affineTransform.createTransformedShape(shape2);
                shape3 = affineTransform.createTransformedShape(shape3);
                shape4 = affineTransform.createTransformedShape(shape4);
                shape5 = affineTransform.createTransformedShape(shape5);
            }
            graphics2D.setColor(this.getBackground());
            graphics2D.fill(shape);
            float f2 = ilvTransformer == null ? 1.0f : (float)ilvTransformer.zoomFactor();
            graphics2D.setStroke(new BasicStroke(f2));
            graphics2D.setColor(this.getTopLeftBorder());
            graphics2D.draw(shape2);
            graphics2D.setColor(this.getBottomRightBorder());
            graphics2D.draw(shape3);
            graphics2D.setColor(this.getForeground());
            graphics2D.draw(shape4);
            graphics2D.draw(shape5);
        }
        finally {
            graphics2D.setStroke(stroke);
            graphics2D.setColor(color);
        }
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.k.get(ilvTransformer);
        if (ilvRect == null) {
            ilvRect = this.calcBoundingBox(ilvTransformer);
            this.k.put(ilvTransformer, ilvRect);
        }
        return ilvRect;
    }

    protected IlvRect calcBoundingBox(IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = this.c;
        if (ilvTransformer != null && !ilvTransformer.isIdentity() && !this.zoomable()) {
            ilvPoint = new IlvPoint(this.c);
            ilvTransformer.apply(ilvPoint);
            ilvTransformer = null;
        }
        int n = this.getSize();
        int n2 = Math.max(1, n - 1);
        float f = (float)Math.floor(n / 2);
        Shape shape = new Rectangle2D.Double(ilvPoint.x, ilvPoint.y, n2, n2);
        GeneralPath generalPath = new GeneralPath();
        Shape shape2 = generalPath;
        generalPath.moveTo(ilvPoint.x + f, ilvPoint.y + (float)n);
        generalPath.lineTo(ilvPoint.x + f, ilvPoint.y + 1.2f * (float)n);
        generalPath = new GeneralPath();
        Shape shape3 = generalPath;
        generalPath.moveTo(ilvPoint.x + (float)n, ilvPoint.y + f);
        generalPath.lineTo(ilvPoint.x + 1.2f * (float)n, ilvPoint.y + f);
        AffineTransform affineTransform = new AffineTransform();
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            affineTransform.setTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
            shape = affineTransform.createTransformedShape(shape);
            shape2 = affineTransform.createTransformedShape(shape2);
            shape3 = affineTransform.createTransformedShape(shape3);
        }
        float f2 = ilvTransformer == null ? 1.0f : (float)ilvTransformer.zoomFactor();
        BasicStroke basicStroke = new BasicStroke(f2);
        shape = basicStroke.createStrokedShape(shape);
        shape2 = basicStroke.createStrokedShape(shape2);
        shape3 = basicStroke.createStrokedShape(shape3);
        Rectangle2D rectangle2D = shape.getBounds2D();
        Rectangle2D rectangle2D2 = shape2.getBounds2D();
        Rectangle2D rectangle2D3 = shape3.getBounds2D();
        Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
        Rectangle2D.union(rectangle2D, rectangle2D3, rectangle2D);
        return new IlvRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(this.c);
            this.k.setInvalid();
        }
    }

    @Override
    public IlvSelection makeSelection() {
        return new IlvUnresizeableDrawSelection(this);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("point", this.c);
        ilvOutputStream.write("expanded", this.d);
        ilvOutputStream.write("size", this.e);
        ilvOutputStream.write("zoomable", this.j);
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("background", this.getBackground());
        ilvOutputStream.write("topLeftBorder", this.getTopLeftBorder());
        ilvOutputStream.write("bottomRightBorder", this.getBottomRightBorder());
    }
}

