/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvDefinitionRectInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvScale;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvRectangularScale
extends IlvScale
implements IlvDefinitionRectInterface {
    private int a;
    private int b;
    private int c = 1;
    private boolean d = false;
    private boolean e = false;
    private static final int f = 2;

    public IlvRectangularScale(IlvPoint ilvPoint, float f, String string, float f2, float f3, int n, int n2, int n3, int n4, float f4, float f5) {
        super(new IlvRect(), n, n2, f4, f5, f2, f3, string);
        if (n3 != 4 && n3 != 1 && n3 != 2 && n3 != 8) {
            throw new IllegalArgumentException("bad origin position");
        }
        this.b = n3;
        this.setLabelsPosition(n4);
        this.a(ilvPoint, f);
    }

    public IlvRectangularScale(IlvPoint ilvPoint, float f, String[] stringArray, int n, int n2, int n3, float f2, float f3) {
        super(new IlvRect(), stringArray, n, f2, f3);
        if (n2 != 4 && n2 != 1 && n2 != 2 && n2 != 8) {
            throw new IllegalArgumentException("bad origin position");
        }
        this.b = n2;
        this.setLabelsPosition(n3);
        this.a(ilvPoint, f);
    }

    public IlvRectangularScale() {
        this(new IlvPoint(), 100.0f, "###", 0.0f, 100.0f, 5, 2, 1, 4, 5.0f, 2.0f);
    }

    public IlvRectangularScale(IlvRectangularScale ilvRectangularScale) {
        super(ilvRectangularScale);
        this.a = ilvRectangularScale.a;
        this.b = ilvRectangularScale.b;
        this.e = ilvRectangularScale.e;
        this.d = ilvRectangularScale.d;
        this.c = ilvRectangularScale.c;
    }

    public IlvRectangularScale(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.b = ilvInputStream.readInt("originPosition");
        this.a = ilvInputStream.readInt("labelsPosition");
        try {
            this.e = ilvInputStream.readBoolean("labelsCentered");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public IlvGraphic copy() {
        return new IlvRectangularScale(this);
    }

    public final int getOriginPosition() {
        return this.b;
    }

    public final void setOriginPosition(int n) {
        float f;
        IlvPoint ilvPoint;
        if (n == 4 || n == 1 || n == 2 || n == 8) {
            ilvPoint = new IlvPoint();
            f = this.a(ilvPoint);
            this.b = n;
            if (this.a()) {
                if (this.a == 1) {
                    this.a = 8;
                } else if (this.a == 2) {
                    this.a = 4;
                }
            } else if (this.a == 4) {
                this.a = 2;
            } else if (this.a == 8) {
                this.a = 1;
            }
        } else {
            throw new IllegalArgumentException("orientation should be top, left, right or botton");
        }
        this.a(ilvPoint, f);
    }

    public final int getLabelsPosition() {
        return this.a;
    }

    public final void setLabelsPosition(int n) {
        if (n != 4 && n != 8 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Unsupported position for labels: " + n);
        }
        if (this.a()) {
            if (n == 1) {
                n = 8;
            } else if (n == 2) {
                n = 4;
            }
        } else if (n == 4) {
            n = 2;
        } else if (n == 8) {
            n = 1;
        }
        this.a = n;
    }

    private final boolean a() {
        return (this.b & 3) != 0;
    }

    public final void setSize(float f) {
        if (this.a()) {
            ((IlvScale)this).a.width = f;
        } else {
            ((IlvScale)this).a.height = f;
        }
    }

    public final float getSize() {
        return this.a() ? ((IlvScale)this).a.width : ((IlvScale)this).a.height;
    }

    public final boolean getLabelsCentered() {
        return this.e;
    }

    public final void setLabelsCentered(boolean bl) {
        this.e = bl;
    }

    @Override
    public IlvRect getDefinitionRect() {
        return new IlvRect(((IlvScale)this).a);
    }

    @Override
    public void setDefinitionRect(IlvRect ilvRect) {
        float f;
        IlvPoint ilvPoint = new IlvPoint(ilvRect.x, ilvRect.y);
        float f2 = Math.max(this.getStepSize(), this.getSubStepSize());
        if (this.a()) {
            f = ilvRect.width;
            if (this.b == 2) {
                ilvPoint.x += f;
            }
            if (this.a == 4) {
                ilvPoint.y += f2;
            }
        } else {
            f = ilvRect.height;
            if (this.b == 8) {
                ilvPoint.y += f;
            }
            if (this.a == 1) {
                ilvPoint.x += f2;
            }
        }
        this.a(ilvPoint, f);
    }

    @Override
    public IlvTransformer getDefinitionTransformer() {
        return null;
    }

    public final IlvPoint getOrigin() {
        IlvPoint ilvPoint = new IlvPoint();
        this.a(ilvPoint);
        return ilvPoint;
    }

    public final void setOrigin(IlvPoint ilvPoint) {
        IlvPoint ilvPoint2 = new IlvPoint();
        float f = this.a(ilvPoint2);
        this.a(ilvPoint, f);
    }

    private void a(IlvPoint ilvPoint, float f) {
        if (f < 1.0E-20f) {
            f = 1.0E-20f;
        }
        ((IlvScale)this).a.move(ilvPoint.x, ilvPoint.y);
        float f2 = Math.max(this.getStepSize(), this.getSubStepSize());
        if (this.a()) {
            ((IlvScale)this).a.resize(f, f2);
            if (this.b == 2) {
                ((IlvScale)this).a.translate(-f, 0.0f);
            }
            if (this.a == 4) {
                ((IlvScale)this).a.translate(0.0f, -f2);
            }
        } else {
            ((IlvScale)this).a.resize(f2, f);
            if (this.b == 8) {
                ((IlvScale)this).a.translate(0.0f, -f);
            }
            if (this.a == 1) {
                ((IlvScale)this).a.translate(-f2, 0.0f);
            }
        }
    }

    private float a(IlvPoint ilvPoint) {
        float f;
        float f2 = Math.max(this.getStepSize(), this.getSubStepSize());
        ilvPoint.x = ((IlvScale)this).a.x;
        ilvPoint.y = ((IlvScale)this).a.y;
        if (this.a()) {
            f = ((IlvScale)this).a.width;
            if (this.b == 2) {
                ilvPoint.x += f;
            }
            if (this.a == 4) {
                ilvPoint.y += f2;
            }
        } else {
            f = ((IlvScale)this).a.height;
            if (this.b == 8) {
                ilvPoint.y += f;
            }
            if (this.a == 1) {
                ilvPoint.x += f2;
            }
        }
        return f;
    }

    private void a(Graphics graphics, IlvTransformer ilvTransformer) {
        float f;
        IlvPoint ilvPoint = new IlvPoint();
        float f2 = this.a(ilvPoint);
        int n = this.getNumberOfSteps() - 1;
        float f3 = f = n != 0 ? f2 / (float)n : f2;
        if ((this.b & 0xA) != 0) {
            f *= -1.0f;
        }
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (this.a()) {
            f4 = this.d ? f * (float)n : f * (float)n;
        } else {
            f5 = this.d ? f * (float)n : f * (float)n;
        }
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        IlvPoint ilvPoint3 = new IlvPoint(ilvPoint);
        ilvPoint3.translate(f4, f5);
        if (ilvTransformer != null) {
            ilvTransformer.applyFloor(ilvPoint2);
            ilvTransformer.applyFloor(ilvPoint3);
        } else {
            ilvPoint2.floor();
            ilvPoint3.floor();
        }
        graphics.drawLine((int)ilvPoint2.x, (int)ilvPoint2.y, (int)ilvPoint3.x, (int)ilvPoint3.y);
    }

    private int b() {
        return this.c;
    }

    private boolean a(Graphics graphics, IlvPoint ilvPoint) {
        return true;
    }

    private IlvRect b(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
        }
        IlvPoint ilvPoint3 = new IlvPoint();
        float f = this.a(ilvPoint3);
        IlvPoint ilvPoint4 = new IlvPoint(ilvPoint3);
        IlvPoint ilvPoint5 = new IlvPoint(ilvPoint3);
        int n = this.getNumberOfSteps() - 1;
        this.c = this.b();
        for (int i = 0; i <= n; i += this.c) {
            ilvPoint5.move(ilvPoint4.x, ilvPoint4.y);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint5);
            }
            ilvRect.add(ilvPoint5.x, ilvPoint5.y);
            ilvPoint5.move(ilvPoint4.x, ilvPoint4.y);
            ilvPoint5.translate(ilvPoint2.x, ilvPoint2.y);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint5);
            }
            ilvRect.add(ilvPoint5.x, ilvPoint5.y);
            ilvPoint4.translate(this.d ? ilvPoint.x : ilvPoint.x, this.d ? ilvPoint.y : ilvPoint.y);
        }
        return ilvRect;
    }

    private void a(IlvRect ilvRect, int n, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint4 = new IlvPoint(ilvPoint.x + (float)n * (this.d ? ilvPoint2.x : ilvPoint2.x), ilvPoint.y + (float)n * (this.d ? ilvPoint2.y : ilvPoint2.y));
        IlvPoint ilvPoint5 = new IlvPoint(ilvPoint4);
        ilvPoint5.translate(ilvPoint3.x, ilvPoint3.y);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint5);
        }
        if (this.getLabels()[n] == null) {
            ilvRect.reshape(ilvPoint5.x, ilvPoint5.y, 1.0E-20f, 1.0E-20f);
        }
        float f = this.a(n);
        float f2 = this.b(n);
        float f3 = this.c(n);
        int n2 = (this.a & 5) != 0 ? -1 : 1;
        ilvRect.move(ilvPoint5.x, ilvPoint5.y);
        ilvRect.resize(f, f2);
        if (!this.a()) {
            ilvRect.translate(n2 == 1 ? 2.0f : -(f + 2.0f), -f2 / 2.0f);
        } else {
            ilvRect.translate(-f / 2.0f, n2 == 1 ? 2.0f : -(f2 + 2.0f));
        }
    }

    IlvRect a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = null;
        String[] stringArray = this.getLabels();
        if (stringArray != null) {
            IlvPoint ilvPoint3 = new IlvPoint();
            float f = this.a(ilvPoint3);
            int n = this.getNumberOfSteps() - 1;
            if (this.e) {
                float f2;
                if (n == 0) {
                    return new IlvRect();
                }
                float f3 = f2 = n != 0 ? f / (float)n : f;
                if ((this.b & 0xA) != 0) {
                    f2 *= -1.0f;
                }
                if (this.a()) {
                    ilvPoint3.translate(f2 / 2.0f, 0.0f);
                } else {
                    ilvPoint3.translate(0.0f, f2 / 2.0f);
                }
                --n;
            }
            IlvRect ilvRect2 = new IlvRect();
            this.c = this.b();
            for (int i = 0; i <= n; i += this.c) {
                this.a(ilvRect2, i, ilvPoint3, ilvPoint, ilvPoint2, ilvTransformer);
                if (i == 0) {
                    ilvRect = new IlvRect(ilvRect2);
                    continue;
                }
                ilvRect.add(ilvRect2);
            }
        }
        return ilvRect;
    }

    @Override
    public boolean zoomable() {
        return false;
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        float f;
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
        }
        if (this.getNumberOfSteps() < 2) {
            return ilvRect;
        }
        int n = this.getNumberOfSteps() - 1;
        IlvPoint ilvPoint = new IlvPoint();
        float f2 = this.a(ilvPoint);
        float f3 = f = n != 0 ? f2 / (float)n : f2;
        if ((this.b & 0xA) != 0) {
            f *= -1.0f;
        }
        IlvPoint ilvPoint2 = new IlvPoint();
        if (this.a()) {
            ilvPoint2.x = f;
        } else {
            ilvPoint2.y = f;
        }
        int n2 = (this.a & 5) != 0 ? -1 : 1;
        IlvPoint ilvPoint3 = new IlvPoint();
        float f4 = Math.max(this.getStepSize(), this.getSubStepSize());
        if (this.a()) {
            ilvPoint3.y = (float)n2 * f4;
        } else {
            ilvPoint3.x = (float)n2 * f4;
        }
        IlvRect ilvRect2 = this.b(ilvPoint2, ilvPoint3, ilvTransformer);
        ilvRect.add(ilvRect2);
        IlvRect ilvRect3 = this.a(ilvPoint2, ilvPoint3, ilvTransformer);
        ilvRect.add(ilvRect3);
        return ilvRect;
    }

    private void a(Graphics graphics, int n, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5, IlvTransformer ilvTransformer) {
        float f = ilvPoint.x + (float)n * (this.d ? ilvPoint2.x : ilvPoint2.x);
        float f2 = ilvPoint.y + (float)n * (this.d ? ilvPoint2.y : ilvPoint2.y);
        IlvPoint ilvPoint6 = new IlvPoint(f, f2);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint6);
        }
        IlvPoint ilvPoint7 = new IlvPoint(ilvPoint6);
        ilvPoint7.translate(ilvPoint4.x, ilvPoint4.y);
        if (this.a(graphics, ilvPoint7)) {
            ilvPoint6.floor();
            ilvPoint7.floor();
            graphics.drawLine((int)ilvPoint6.x, (int)ilvPoint6.y, (int)ilvPoint7.x, (int)ilvPoint7.y);
        }
        if (n != this.getNumberOfSteps() - 1 && this.c <= 1) {
            float f3 = f + ilvPoint3.x;
            float f4 = f2 + ilvPoint3.y;
            for (int i = 1; i < this.getNumberOfSubSteps(); ++i) {
                ilvPoint6.move(f3, f4);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint6);
                }
                ilvPoint7.x = ilvPoint6.x;
                ilvPoint7.y = ilvPoint6.y;
                ilvPoint7.translate(ilvPoint5.x, ilvPoint5.y);
                if (this.a(graphics, ilvPoint7)) {
                    ilvPoint6.floor();
                    ilvPoint7.floor();
                    graphics.drawLine((int)ilvPoint6.x, (int)ilvPoint6.y, (int)ilvPoint7.x, (int)ilvPoint7.y);
                }
                f3 += ilvPoint3.x;
                f4 += ilvPoint3.y;
            }
        }
    }

    private void b(Graphics graphics, IlvTransformer ilvTransformer) {
        float f;
        IlvPoint ilvPoint = new IlvPoint();
        float f2 = this.a(ilvPoint);
        int n = this.getNumberOfSteps() - 1;
        float f3 = n != 0 ? f2 / (float)n : f2;
        float f4 = f = n != 0 && this.getNumberOfSubSteps() > 1 ? f3 / (float)this.getNumberOfSubSteps() : 0.0f;
        if ((this.b & 0xA) != 0) {
            f3 *= -1.0f;
            f *= -1.0f;
        }
        IlvPoint ilvPoint2 = new IlvPoint();
        IlvPoint ilvPoint3 = new IlvPoint();
        if (this.a()) {
            ilvPoint2.x = f3;
            ilvPoint2.y = 0.0f;
            ilvPoint3.x = f;
            ilvPoint3.y = 0.0f;
        } else {
            ilvPoint2.x = 0.0f;
            ilvPoint2.y = f3;
            ilvPoint3.x = 0.0f;
            ilvPoint3.y = f;
        }
        int n2 = (this.a & 5) != 0 ? -1 : 1;
        IlvPoint ilvPoint4 = new IlvPoint();
        IlvPoint ilvPoint5 = new IlvPoint();
        if (this.a()) {
            ilvPoint4.move(0.0f, (float)n2 * this.getStepSize());
            ilvPoint5.move(0.0f, (float)n2 * this.getSubStepSize());
        } else {
            ilvPoint4.move((float)n2 * this.getStepSize(), 0.0f);
            ilvPoint5.move((float)n2 * this.getSubStepSize(), 0.0f);
        }
        this.c = this.b();
        for (int i = 0; i <= n; i += this.c) {
            this.a(graphics, i, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, ilvPoint5, ilvTransformer);
        }
    }

    private void c(Graphics graphics, IlvTransformer ilvTransformer) {
        float f;
        if (this.getLabels() == null) {
            return;
        }
        boolean bl = this.getLabelsCentered();
        IlvPoint ilvPoint = new IlvPoint();
        float f2 = this.a(ilvPoint);
        int n = this.getNumberOfSteps() - 1;
        float f3 = f = n != 0 ? f2 / (float)n : f2;
        if ((this.b & 0xA) != 0) {
            f *= -1.0f;
        }
        IlvPoint ilvPoint2 = new IlvPoint();
        if (this.a()) {
            ilvPoint2.move(f, 0.0f);
            if (bl) {
                ilvPoint.translate(f / 2.0f, 0.0f);
            }
        } else {
            ilvPoint2.move(0.0f, f);
            if (bl) {
                ilvPoint.translate(0.0f, f / 2.0f);
            }
        }
        int n2 = (this.a & 5) != 0 ? -1 : 1;
        IlvPoint ilvPoint3 = new IlvPoint();
        if (this.a()) {
            ilvPoint3.move(0.0f, (float)n2 * this.getStepSize());
        } else {
            ilvPoint3.move((float)n2 * this.getStepSize(), 0.0f);
        }
        if (bl) {
            if (n == 0) {
                return;
            }
            --n;
        }
        this.c = this.b();
        boolean bl2 = this.isAntialiasing();
        for (int i = 0; i <= n; i += this.c) {
            this.a(graphics, i, ilvPoint, ilvPoint2, ilvPoint3, ilvTransformer, bl2);
        }
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.getNumberOfSteps() < 1) {
            return;
        }
        graphics.setColor(this.getForeground());
        this.a(graphics, ilvTransformer);
        if (this.getNumberOfSteps() > 1) {
            this.b(graphics, ilvTransformer);
            this.c(graphics, ilvTransformer);
        }
    }

    private void a(Graphics graphics, int n, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvTransformer ilvTransformer, boolean bl) {
        int n2;
        String[] stringArray = this.getLabels();
        if (stringArray == null || stringArray[n] == null) {
            return;
        }
        IlvPoint ilvPoint4 = new IlvPoint(ilvPoint.x + (float)n * (this.d ? ilvPoint2.x : ilvPoint2.x), ilvPoint.y + (float)n * (this.d ? ilvPoint2.y : ilvPoint2.y));
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint4);
        }
        IlvPoint ilvPoint5 = new IlvPoint(ilvPoint4);
        ilvPoint5.translate(ilvPoint3.x, ilvPoint3.y);
        int n3 = n2 = (this.a & 5) != 0 ? -1 : 1;
        if (this.a(graphics, ilvPoint5)) {
            float f = this.a(n);
            float f2 = this.b(n);
            if ((this.b & 0xC) != 0) {
                ilvPoint5.translate(n2 == 1 ? 2.0f : -(f + 2.0f), f2 / 2.0f);
            } else {
                ilvPoint5.translate(-f / 2.0f, n2 == 1 ? f2 + 2.0f : -2.0f);
            }
            if (this.a(graphics, ilvPoint5)) {
                ilvPoint5.floor();
                graphics.setFont(this.getFont());
                IlvGraphicUtil.DrawString(this, graphics, stringArray[n], (int)ilvPoint5.x, (int)ilvPoint5.y, bl);
            }
        }
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = new IlvPoint();
        this.a(ilvPoint);
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
            ilvTransformer.apply(ilvPoint);
        }
        float f = this.a() ? ilvRect.width : ilvRect.height;
        this.a(ilvPoint, f);
    }

    @Override
    public void moveResize(IlvRect ilvRect) {
        super.moveResize(ilvRect);
        IlvUtility.correctMoveResizeNonzoomableGraphic(this, ilvRect, this.a(), !this.a());
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("originPosition", this.b);
        ilvOutputStream.write("labelsPosition", this.a);
        ilvOutputStream.write("labelsCentered", this.e);
    }
}

