/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import com.ibm.icu.util.ULocale;
import ilog.views.IlvApplyObject;
import ilog.views.IlvBidiGraphic;
import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTextInterface;
import ilog.views.IlvToolkit;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvLayoutTextRenderer;
import ilog.views.graphic.IlvTextSelection;
import ilog.views.internal.IlvUtility;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.objectinteractor.IlvTextEditor;
import ilog.views.util.java2d.IlvG2D;
import ilog.views.util.java2d.IlvPattern;
import ilog.views.util.java2d.IlvTexture;
import ilog.views.util.text.IlvAttributedStringUtil;
import ilog.views.util.text.IlvBidiUtil;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Map;

public class IlvText
extends IlvBidiGraphic
implements IlvTextInterface,
IlvFontInterface {
    private static final IlvTransformer a = new IlvTransformer();
    private static final String b = "margin should be positive or equal to 0";
    private static final short c = 4;
    private static final short d = 2;
    private static final short e = 8;
    private static final short f = 16;
    private static final short g = 128;
    private static final short h = 256;
    private static final short i = 512;
    private static final short j = 1024;
    private static final short k = 6144;
    private static final short l = 8192;
    private static final short m = 16384;
    public static final int OUTLINE_ONLY = 2048;
    public static final int OUTLINE_FRONT = 6144;
    public static final int OUTLINE_BACK = 4096;
    public static final int OUTLINE_DISABLED = 0;
    private int n = 256;
    private float o;
    private float p;
    private float q;
    private float r;
    private String s = "";
    private transient AttributedString t = null;
    private transient boolean u;
    private Font v = IlvToolkit.defaultFont;
    private short w;
    private Color x;
    private float y = 100.0f;
    private float z = 100.0f;
    private short aa;
    private Color ab;
    private Paint ac;
    private Paint ad;
    private float ae;
    private int af = 256;
    IlvPoint ag = new IlvPoint();
    private Renderer ah;
    private IlvTransformer ai;
    private Color aj;
    private float ak = 0.0f;
    private float al = 0.0f;
    private float am = 0.0f;
    private boolean an = false;
    public static final short WRAP_NONE = 0;
    public static final short WRAP_WORD = 1;
    public static final short WRAP_CHARACTER = 4;
    public static final short WRAP_TRUNCATE = 2;
    public static final int NO_AUTO_WRAPPING = 0;
    public static final int SIZE_AUTO_WRAPPING = 1;
    public static final int ZOOM_AUTO_WRAPPING = 2;
    private static boolean ao = false;
    private static LabelSetter ap = new LabelSetter();

    public IlvText() {
        this(new IlvPoint(0.0f, 0.0f), "");
    }

    public IlvText(IlvPoint ilvPoint, String string) {
        this.s = string != null ? string : "";
        this.ag.setLocation(ilvPoint);
        this.d();
    }

    private void d() {
        this.ah = new IlvLayoutTextRenderer(this);
    }

    public IlvText(IlvText ilvText) {
        super(ilvText);
        this.ai = new IlvTransformer(ilvText.ai);
        this.v = ilvText.v;
        this.s = ilvText.s;
        this.t = ilvText.t;
        this.u = ilvText.u;
        this.w = ilvText.w;
        this.ag = new IlvPoint(ilvText.ag);
        this.x = ilvText.x;
        this.ad = ilvText.ad;
        this.ab = ilvText.ab;
        this.af = ilvText.af;
        this.r = ilvText.r;
        this.q = ilvText.q;
        this.p = ilvText.p;
        this.o = ilvText.o;
        this.n = ilvText.n;
        this.aa = ilvText.aa;
        this.z = ilvText.z;
        this.y = ilvText.y;
        this.ae = ilvText.ae;
        this.aj = ilvText.aj;
        this.ak = ilvText.ak;
        this.al = ilvText.al;
        this.am = ilvText.am;
        this.d();
        this.a(this.ad);
        this.registerBlinkingResource(null, this.x);
        this.registerBlinkingResource(null, this.ab);
        this.registerBlinkingResource(null, this.aj);
        this.f();
    }

    public IlvText(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.ai = ilvInputStream.readTransformer("transform");
        if (this.ai.isIdentity()) {
            this.ai = null;
        }
        this.v = ilvInputStream.readFont("font");
        this.s = ilvInputStream.readString("label");
        try {
            Object[] objectArray = ilvInputStream.readObjectArray("attributes", "(i(sst)*)*");
            this.a(objectArray);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
        }
        this.w = ilvInputStream.readShort("flags");
        this.ag = ilvInputStream.readPoint("anchorPoint");
        this.x = ilvInputStream.readColor("foreground");
        this.ad = IlvUtility2D.readPaint(ilvInputStream);
        this.ab = ilvInputStream.readColor("sColor");
        try {
            this.aj = ilvInputStream.readColor("outlineColor");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ak = ilvInputStream.readFloat("outlineThickness");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.al = ilvInputStream.readFloat("rotationAlignmentThresholdAngle");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.am = ilvInputStream.readFloat("rotationAlignmentAngle");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.an = ilvInputStream.readBoolean("usesAnchorPos");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.af = ilvInputStream.readInt("aPosition");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.r = ilvInputStream.readFloat("leftMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.q = ilvInputStream.readFloat("rightMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.p = ilvInputStream.readFloat("topMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.o = ilvInputStream.readFloat("bottomMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.n = ilvInputStream.readInt("alignment");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.aa = ilvInputStream.readShort("wM");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.z = ilvInputStream.readFloat("wH");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.y = ilvInputStream.readFloat("wW");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ae = ilvInputStream.readFloat("spacing");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        this.d();
        this.a(this.ad);
        this.registerBlinkingResource(null, this.x);
        this.registerBlinkingResource(null, this.ab);
        this.registerBlinkingResource(null, this.aj);
        this.e();
        this.f();
    }

    @Override
    public IlvGraphic copy() {
        return new IlvText(this);
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.isFillOn() || this.isStrokeOn()) {
            Cloneable cloneable;
            Object object = this.ah.getBounds();
            if (this.getTopMargin() != 0.0f || this.getBottomMargin() != 0.0f || this.getLeftMargin() != 0.0f || this.getRightMargin() != 0.0f) {
                cloneable = object.getBounds2D();
                ((Rectangle2D)cloneable).setFrame(((RectangularShape)cloneable).getX() - (double)this.getLeftMargin(), ((RectangularShape)cloneable).getY() - (double)this.getTopMargin(), ((RectangularShape)cloneable).getWidth() + (double)this.getLeftMargin() + (double)this.getRightMargin(), ((RectangularShape)cloneable).getHeight() + (double)this.getTopMargin() + (double)this.getBottomMargin());
                object = cloneable;
            }
            Cloneable cloneable2 = cloneable = this.ai != null ? new IlvTransformer(this.ai) : null;
            if (cloneable != null) {
                ((IlvTransformer)cloneable).compose(ilvTransformer);
            } else {
                cloneable = ilvTransformer;
            }
            if (cloneable != null) {
                AffineTransform affineTransform = IlvUtility.IlvToJava2DTransformer((IlvTransformer)cloneable, null);
                object = affineTransform.createTransformedShape((Shape)object);
            }
            if (this.isFillOn()) {
                ((Graphics2D)graphics).setPaint(this.ac);
                IlvG2D.fill((Graphics2D)graphics, (Shape)object);
            }
            if (this.isStrokeOn()) {
                graphics.setColor(this.getStrokeColor());
                ((Graphics2D)graphics).draw((Shape)object);
            }
        }
        this.ah.draw(graphics, ilvTransformer);
    }

    public final IlvTransformer getTransformer() {
        return this.ai != null ? new IlvTransformer(this.ai) : null;
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2;
        IlvRect ilvRect = IlvUtility.Java2DToIlvRect(((IlvLayoutTextRenderer)this.ah).getBounds(), null);
        if (this.getTopMargin() != 0.0f || this.getBottomMargin() != 0.0f || this.getLeftMargin() != 0.0f || this.getRightMargin() != 0.0f) {
            ilvRect.setFrame(ilvRect.x - this.getLeftMargin(), ilvRect.y - this.getTopMargin(), ilvRect.width + this.getLeftMargin() + this.getRightMargin(), ilvRect.height + this.getTopMargin() + this.getBottomMargin());
        }
        IlvTransformer ilvTransformer3 = ilvTransformer2 = this.ai != null ? new IlvTransformer(this.ai) : null;
        if (ilvTransformer2 != null) {
            ilvTransformer2.compose(ilvTransformer);
        } else {
            ilvTransformer2 = ilvTransformer;
        }
        if (ilvTransformer2 != null) {
            ilvTransformer2.boundingBox(ilvRect, false);
        }
        return ilvRect;
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            if (this.ai == null) {
                this.ai = new IlvTransformer(ilvTransformer);
            } else {
                this.ai.compose(ilvTransformer);
            }
            this.e();
            this.a(false, false);
        }
    }

    private void e() {
        double d;
        double d2;
        double d3;
        double d4;
        if (this.isKeepingAspectRatio() && this.ai != null) {
            d4 = this.ai.getx11();
            d3 = this.ai.getx12();
            d2 = this.ai.getx21();
            d = this.ai.getx22();
            if (d3 == 0.0 && d2 == 0.0) {
                double d5 = Math.min(Math.abs(d4), Math.abs(d));
                d4 = d4 < 0.0 ? -d5 : d5;
                d = d < 0.0 ? -d5 : d5;
            } else if (d4 == 0.0 && d == 0.0) {
                double d6 = Math.min(Math.abs(d3), Math.abs(d2));
                d3 = d3 < 0.0 ? -d6 : d6;
                d2 = d2 < 0.0 ? -d6 : d6;
            } else {
                double d7 = 0.5 * (d4 + d);
                double d8 = 0.5 * (d2 - d3);
                d4 = d7;
                d3 = -d8;
                d2 = d8;
                d = d7;
            }
            if (d4 == 0.0 && d3 == 0.0 || d2 == 0.0 && d == 0.0) {
                this.ai.setValues(0.001, 0.0, 0.0, 0.001);
            } else {
                this.ai.setValues(d4, d3, d2, d);
            }
        }
        if (this.ai != null && Math.abs(this.ai.getDeterminant()) < 1.0E-16) {
            d4 = this.ai.getx11();
            d3 = this.ai.getx12();
            d2 = this.ai.getx21();
            d = this.ai.getx22();
            if (Math.abs(d4) < 1.0E-16 && d3 == 0.0) {
                d4 = d4 > 0.0 ? 1.0E-16 : -1.0E-16;
            } else if (Math.abs(d3) < 1.0E-16 && d4 == 0.0) {
                double d9 = d3 = d3 > 0.0 ? 1.0E-16 : -1.0E-16;
            }
            if (Math.abs(d) < 1.0E-16 && d2 == 0.0) {
                d = d > 0.0 ? 1.0E-16 : -1.0E-16;
            } else if (Math.abs(d2) < 1.0E-16 && d == 0.0) {
                d2 = d2 > 0.0 ? 1.0E-16 : -1.0E-16;
            }
            this.ai.setValues(d4, d3, d2, d);
        }
    }

    @Override
    public void moveResize(IlvRect ilvRect) {
        switch (this.getAutoWrappingResizeMode()) {
            case 0: {
                super.moveResize(ilvRect);
                break;
            }
            case 1: {
                this.b(ilvRect);
                break;
            }
            case 2: {
                this.a(ilvRect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvRect ilvRect) {
        IlvRect ilvRect2 = this.boundingBox();
        if (ilvRect2.equals(ilvRect)) {
            return;
        }
        if (ilvRect.width == 0.0f) {
            return;
        }
        if (ilvRect.height == 0.0f) {
            return;
        }
        boolean bl = this.isKeepingAspectRatio();
        short s = this.getWrappingMode();
        try {
            this.a(ilvRect.width, ilvRect.height);
            this.setKeepingAspectRatio(true);
            for (int i = 0; i < 3; ++i) {
                super.moveResize(ilvRect);
                ilvRect2 = this.boundingBox();
                this.ai.setValues(this.ai.getx0() + (double)ilvRect.x - (double)ilvRect2.x, this.ai.gety0() + (double)ilvRect.y - (double)ilvRect2.y);
            }
        }
        finally {
            this.setKeepingAspectRatio(bl);
            this.setWrappingMode(s);
        }
    }

    private void a(float f, float f2) {
        double d;
        float f3;
        double d2;
        double d3;
        short s = this.getWrappingMode();
        if (this.ai == null) {
            this.ai = new IlvTransformer();
        } else if (this.ai.isScale()) {
            d3 = this.ai.getx11();
            d2 = this.ai.getx22();
            d3 = d3 > 0.0 ? 1 : -1;
            d2 = d2 > 0.0 ? 1 : -1;
            this.ai = new IlvTransformer(d3, 0.0, 0.0, d2, 0.0, 0.0);
        } else if (this.ai.getx11() == 0.0 && this.ai.getx22() == 0.0) {
            d3 = this.ai.getx12();
            d2 = this.ai.getx21();
            d3 = d3 > 0.0 ? 1 : -1;
            d2 = d2 > 0.0 ? 1 : -1;
            this.ai = new IlvTransformer(0.0, d3, d2, 0.0, 0.0, 0.0);
        } else {
            d3 = this.ai.getx11();
            d2 = this.ai.getx12();
            double d4 = this.ai.getx21();
            double d5 = this.ai.getx22();
            double d6 = Math.abs(d3 * d5 - d4 * d2);
            if ((d6 = Math.sqrt(d6)) > 0.0) {
                this.ai.setValues(d3 / d6, d2 / d6, d4 / d6, d5 / d6);
            }
            this.e();
        }
        this.setWrappingMode((short)0);
        IlvRect ilvRect = this.boundingBox();
        this.setWrappingMode((short)(s & 0xFFFFFFFD));
        double d7 = (double)f / (double)f2;
        double d8 = d7 > 1.0 ? d7 : 1.0 / d7;
        double d9 = ilvRect.width;
        double d10 = ilvRect.height;
        float f4 = (float)Math.sqrt(d9 * d9 + d10 * d10);
        this.y = f3 = f4 + 10.0f;
        this.a(false, true);
        ilvRect = this.boundingBox();
        double d11 = (double)ilvRect.width / (double)ilvRect.height;
        boolean bl = true;
        float f5 = f3;
        float f6 = 0.001f;
        while (f5 > f6) {
            this.y = f5 /= 2.0f;
            this.a(false, true);
            ilvRect = this.boundingBox();
            d = (double)ilvRect.width / (double)ilvRect.height;
            if (d == d11) continue;
            if (d < d11) {
                bl = true;
                break;
            }
            bl = false;
            break;
        }
        f5 = 2.0f * f4 + 10.0f;
        f6 = 0.001f;
        double d12 = Double.MAX_VALUE;
        double d13 = Double.MAX_VALUE;
        while (f5 - f6 > 1.0f) {
            this.y = 0.5f * (f5 + f6);
            this.a(false, true);
            ilvRect = this.boundingBox();
            d = (double)ilvRect.width / (double)ilvRect.height;
            if (bl) {
                if (d > d7) {
                    f5 = this.y;
                    d12 = d;
                    continue;
                }
                f6 = this.y;
                d13 = d;
                continue;
            }
            if (d < d7) {
                f5 = this.y;
                d12 = d;
                continue;
            }
            f6 = this.y;
            d13 = d;
        }
        double d14 = Math.abs((d11 > 1.0 ? d11 : 1.0 / d11) - d8);
        double d15 = Math.abs((d12 > 1.0 ? d12 : 1.0 / d12) - d8);
        double d16 = Math.abs((d13 > 1.0 ? d13 : 1.0 / d13) - d8);
        this.y = f6 == 0.001f ? (d14 <= d15 ? f3 : f5) : (d14 <= d16 && d14 <= d15 ? f3 : (d15 <= d16 ? f5 : f6));
        this.a(false, true);
        if ((s & 2) != 0) {
            ilvRect = this.boundingBox();
            d9 = ilvRect.width;
            d10 = ilvRect.height;
            f4 = (float)Math.sqrt(d9 * d9 + d10 * d10);
            this.z = f4 + 10.0f;
            this.a(false, true);
        }
    }

    private void b(IlvRect ilvRect) {
        IlvRect ilvRect2 = this.boundingBox();
        if (ilvRect2.equals(ilvRect)) {
            return;
        }
        float f = ilvRect.x - ilvRect2.x;
        float f2 = ilvRect.y - ilvRect2.y;
        if (this.ai != null) {
            double d = this.ai.zoomXFactor();
            double d2 = this.ai.zoomYFactor();
            if (d != 0.0) {
                f = (float)((double)f / d);
            }
            if (d2 != 0.0) {
                f2 = (float)((double)f2 / d2);
            }
            ilvRect.width = (float)((double)ilvRect.width / d);
            ilvRect.height = (float)((double)ilvRect.height / d2);
        }
        if (this.ai == null) {
            this.ai = new IlvTransformer();
        }
        this.ai.translate(f, f2);
        this.y = Math.max(0.0f, ilvRect.width - (this.r + this.q));
        this.z = Math.max(0.0f, ilvRect.height - (this.p + this.o));
        this.a(false, true);
    }

    @Override
    public void translate(float f, float f2) {
        if (f != 0.0f || f2 != 0.0f) {
            switch (this.getAutoWrappingResizeMode()) {
                case 0: {
                    super.translate(f, f2);
                    break;
                }
                case 1: 
                case 2: {
                    if (this.ai != null) {
                        double d = this.ai.zoomXFactor();
                        double d2 = this.ai.zoomYFactor();
                        if (d != 0.0) {
                            f = (float)((double)f / d);
                        }
                        if (d2 != 0.0) {
                            f2 = (float)((double)f2 / d2);
                        }
                    }
                    if (this.ai == null) {
                        this.ai = new IlvTransformer();
                    }
                    this.ai.translate(f, f2);
                    this.a(false, true);
                }
            }
        }
    }

    @Override
    public void resize(float f, float f2) {
        switch (this.getAutoWrappingResizeMode()) {
            case 0: {
                super.resize(f, f2);
                break;
            }
            case 1: {
                this.c(f, f2);
                break;
            }
            case 2: {
                this.b(f, f2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(float f, float f2) {
        IlvRect ilvRect = this.boundingBox();
        if (f <= 0.0f) {
            return;
        }
        if (f2 <= 0.0f) {
            return;
        }
        boolean bl = this.isKeepingAspectRatio();
        short s = this.getWrappingMode();
        try {
            this.a(f, f2);
            this.setKeepingAspectRatio(true);
            for (int i = 0; i < 3; ++i) {
                super.resize(f, f2);
            }
        }
        finally {
            this.setKeepingAspectRatio(bl);
            this.setWrappingMode(s);
        }
        IlvRect ilvRect2 = this.boundingBox();
        this.translate(ilvRect.x - ilvRect2.x, ilvRect.y - ilvRect2.y);
    }

    private void c(float f, float f2) {
        if (this.ai != null) {
            double d = this.ai.zoomXFactor();
            double d2 = this.ai.zoomYFactor();
            if (d != 0.0) {
                f = (float)((double)f / d);
            }
            if (d2 != 0.0) {
                f2 = (float)((double)f2 / d2);
            }
        }
        float f3 = Math.max(0.0f, f - (this.r + this.q));
        float f4 = Math.max(0.0f, f2 - (this.p + this.o));
        if (f3 != this.y || f4 != this.z) {
            this.y = f3;
            this.z = f4;
            this.a(false, true);
        }
    }

    @Override
    public void rotate(IlvPoint ilvPoint, double d) {
        IlvPoint ilvPoint2 = null;
        if (this.isKeepingAspectRatio()) {
            ilvPoint2 = new IlvPoint(ilvPoint);
            this.ai.inverse(ilvPoint2);
        }
        super.rotate(ilvPoint, d);
        if (this.isKeepingAspectRatio()) {
            this.ai.apply(ilvPoint2);
            this.ai.setValues(this.ai.getx0() + (double)ilvPoint.x - (double)ilvPoint2.x, this.ai.gety0() + (double)ilvPoint.y - (double)ilvPoint2.y);
            this.a(false, false);
        }
    }

    public final void setAnchorPoint(IlvPoint ilvPoint) {
        if (!this.ag.equals(ilvPoint)) {
            this.ag.setLocation(ilvPoint);
            this.a(false, true);
        }
    }

    public final IlvPoint getAnchorPoint() {
        return new IlvPoint(this.ag);
    }

    public final IlvPoint getEffectiveAnchorPoint() {
        IlvPoint ilvPoint = this.getAnchorPoint();
        if (this.getTransformer() != null) {
            this.getTransformer().apply(ilvPoint);
        }
        return ilvPoint;
    }

    public final void setAnchorPosition(int n) {
        this.an = true;
        if (n != this.af) {
            this.af = n;
            this.a(false, true);
        }
    }

    public final int getAnchorPosition() {
        return this.af;
    }

    public IlvPoint[] getAnchorPoints(boolean bl, IlvTransformer ilvTransformer) {
        return this.ah.getAnchorPoints(bl, ilvTransformer);
    }

    @Override
    public void setLabel(String string) {
        String string2 = string != null ? string : "";
        if (!string2.equals(this.s) || this.t != null || this.u) {
            this.s = string2;
            this.t = null;
            this.u = false;
            this.a(false, true);
        }
    }

    @Override
    public String getLabel() {
        return this.s;
    }

    public void setAttributedLabel(AttributedString attributedString) {
        if (attributedString == null) {
            this.t = new AttributedString("");
            this.u = false;
        } else {
            this.t = attributedString;
            this.u = true;
        }
        this.s = IlvAttributedStringUtil.getString(this.t);
        this.a(false, true);
    }

    public AttributedString getAttributedLabel() {
        if (this.t == null) {
            return new AttributedString(this.s);
        }
        return this.t;
    }

    AttributedString a() {
        return this.u ? this.t : null;
    }

    public void addLabelAttribute(AttributedCharacterIterator.Attribute attribute, Object object) {
        if (this.t == null) {
            this.t = new AttributedString(this.s);
        }
        this.t.addAttribute(attribute, object);
        this.u = true;
        this.a(false, true);
    }

    public void addLabelAttribute(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
        if (this.t == null) {
            this.t = new AttributedString(this.s);
        }
        this.t.addAttribute(attribute, object, n, n2);
        this.u = true;
        this.a(false, true);
    }

    public void addLabelAttributes(Map map, int n, int n2) {
        if (this.t == null) {
            this.t = new AttributedString(this.s);
        }
        this.t.addAttributes(map, n, n2);
        this.u = true;
        this.a(false, true);
    }

    @Override
    public boolean supportMultiline() {
        return true;
    }

    public final boolean isTruncated() {
        return this.ah.hasEllipsis();
    }

    @Override
    public IlvRect getLabelBBox(IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2;
        IlvRect ilvRect = IlvUtility.Java2DToIlvRect(((IlvLayoutTextRenderer)this.ah).getBounds(), null);
        IlvTransformer ilvTransformer3 = ilvTransformer2 = this.ai != null ? new IlvTransformer(this.ai) : null;
        if (ilvTransformer2 != null) {
            ilvTransformer2.compose(ilvTransformer);
        } else {
            ilvTransformer2 = ilvTransformer;
        }
        if (ilvTransformer2 != null) {
            ilvTransformer2.boundingBox(ilvRect, false);
        }
        return ilvRect;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font should not be null");
        }
        if (!font.equals(this.v)) {
            this.v = font;
            this.a(true, true);
        }
    }

    @Override
    public Font getFont() {
        return this.v;
    }

    public final boolean isAntialiasing() {
        return (this.w & 8) != 0;
    }

    public final void setAntialiasing(boolean bl) {
        if (bl != this.isAntialiasing()) {
            this.w = bl ? (short)(this.w | 8) : (short)(this.w & 0xFFFFFFF7);
            this.a(true, true);
        }
    }

    public final boolean isStrikethrough() {
        return (this.w & 0x200) != 0;
    }

    public final void setStrikethrough(boolean bl) {
        if (bl != this.isStrikethrough()) {
            this.w = bl ? (short)(this.w | 0x200) : (short)(this.w & 0xFFFFFDFF);
            this.a(false, true);
        }
    }

    public final boolean isUnderline() {
        return (this.w & 0x400) != 0;
    }

    public final void setUnderline(boolean bl) {
        if (bl != this.isUnderline()) {
            this.w = bl ? (short)(this.w | 0x400) : (short)(this.w & 0xFFFFFBFF);
            this.a(false, true);
        }
    }

    public int getOutlineMode() {
        return this.w & 0x1800;
    }

    public void setOutlineMode(int n) {
        this.w = (short)(this.w & 0xFFFFE7FF);
        this.w = (short)(this.w | (short)n & 0x1800);
    }

    public final boolean isFractionalMetrics() {
        return (this.w & 0x80) == 0;
    }

    public final void setFractionalMetrics(boolean bl) {
        if (bl != this.isFractionalMetrics()) {
            this.w = bl ? (short)(this.w & 0xFFFFFF7F) : (short)(this.w | 0x80);
            this.a(true, true);
        }
    }

    @Override
    public void setForeground(Color color) {
        Color color2 = this.x;
        this.x = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        return this.x != null ? this.x : Color.black;
    }

    public void setOutlineColor(Color color) {
        Color color2 = this.aj;
        this.aj = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getOutlineColor() {
        return this.aj != null ? this.aj : Color.black;
    }

    @Override
    public void setBackground(Color color) {
        this.setFillPaint(color);
    }

    public void setFillPaint(Paint paint) {
        this.ad = paint;
        this.a(paint);
        this.f();
    }

    private void a(Paint paint) {
        Paint paint2 = this.ac;
        this.ac = paint;
        this.registerBlinkingResource(paint2, paint);
    }

    public Paint getFillPaint() {
        if (this.ad == null) {
            return Color.gray;
        }
        return this.ad;
    }

    private void f() {
        if (this.isFillOn()) {
            this.a(this.isPaintAbsolute() ? this.getFillPaint() : this.adaptPaint(this.boundingBox(), this.getFillPaint()));
        }
    }

    protected Paint adaptPaint(Shape shape, Paint paint) {
        return IlvUtility2D.AdaptPaint(shape, paint);
    }

    public final boolean isPaintAbsolute() {
        return (this.w & 0x10) != 0;
    }

    public final void setPaintAbsolute(boolean bl) {
        if (bl) {
            this.w = (short)(this.w | 0x10);
            this.a(this.getFillPaint());
        } else {
            this.w = (short)(this.w & 0xFFFFFFEF);
            this.f();
        }
    }

    @Override
    public final void setFillOn(boolean bl) {
        if (bl) {
            this.w = (short)(this.w | 4);
            this.f();
        } else {
            this.w = (short)(this.w & 0xFFFFFFFB);
        }
    }

    public final boolean isFillOn() {
        return (this.w & 4) != 0;
    }

    @Override
    public final void setStrokeOn(boolean bl) {
        this.w = bl ? (short)(this.w | 2) : (short)(this.w & 0xFFFFFFFD);
    }

    public final boolean isStrokeOn() {
        return (this.w & 2) != 0;
    }

    public final void setStrokeColor(Color color) {
        Color color2 = this.ab;
        this.ab = color;
        this.registerBlinkingResource(color2, color);
    }

    public final Color getStrokeColor() {
        return this.ab != null ? this.ab : this.getForeground();
    }

    public final boolean isKeepingAspectRatio() {
        return (this.w & 0x2000) != 0;
    }

    public final void setKeepingAspectRatio(boolean bl) {
        if (bl != this.isKeepingAspectRatio()) {
            IlvRect ilvRect = this.boundingBox();
            float f = ilvRect.x;
            float f2 = ilvRect.y;
            this.w = bl ? (short)(this.w | 0x2000) : (short)(this.w & 0xFFFFDFFF);
            this.e();
            this.a(false, true);
            this.move(f, f2);
        }
    }

    public final void setAutoWrappingSizeMode(boolean bl) {
        this.setAutoWrappingResizeMode(bl ? 1 : 0);
    }

    public final boolean isAutoWrappingSizeMode() {
        return this.getAutoWrappingResizeMode() == 1;
    }

    public final void setAutoWrappingResizeMode(int n) {
        switch (n) {
            case 0: {
                this.w = (short)(this.w & 0xFFFFFEFF);
                this.w = (short)(this.w & 0xFFFFBFFF);
                break;
            }
            case 1: {
                this.w = (short)(this.w | 0x100);
                this.w = (short)(this.w & 0xFFFFBFFF);
                break;
            }
            case 2: {
                this.w = (short)(this.w & 0xFFFFFEFF);
                this.w = (short)(this.w | 0x4000);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid mode: " + n);
            }
        }
    }

    public final int getAutoWrappingResizeMode() {
        boolean bl;
        boolean bl2 = (this.w & 0x100) != 0;
        boolean bl3 = bl = (this.w & 0x4000) != 0;
        if (bl2 && !bl) {
            return 1;
        }
        if (bl && !bl2) {
            return 2;
        }
        return 0;
    }

    public final void setWrappingMode(short s) {
        if (s != this.aa) {
            this.aa = s;
            this.a(false, true);
        }
    }

    public final short getWrappingMode() {
        return this.aa;
    }

    public final void setWrappingWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("must use a positive value");
        }
        if (f != this.y) {
            this.y = f;
            this.a(false, true);
        }
    }

    public final float getWrappingWidth() {
        return this.y;
    }

    public final void setWrappingHeight(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("must use a positive value");
        }
        if (f != this.z) {
            this.z = f;
            this.a(false, true);
        }
    }

    public final float getWrappingHeight() {
        return this.z;
    }

    public void setOutlineThickness(float f) {
        this.ak = f;
    }

    public float getOutlineThickness() {
        return this.ak;
    }

    public final void setLeftMargin(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(b);
        }
        if (this.r != f) {
            this.r = f;
            this.f();
        }
    }

    public final float getLeftMargin() {
        return this.r;
    }

    public final void setRightMargin(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(b);
        }
        if (this.q != f) {
            this.q = f;
            this.f();
        }
    }

    public final float getRightMargin() {
        return this.q;
    }

    public final void setTopMargin(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(b);
        }
        if (this.p != f) {
            this.p = f;
            this.f();
        }
    }

    public final float getTopMargin() {
        return this.p;
    }

    public final void setBottomMargin(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(b);
        }
        if (this.o != f) {
            this.o = f;
            this.f();
        }
    }

    public final float getBottomMargin() {
        return this.o;
    }

    public final void setAlignment(int n) {
        if (this.n != n) {
            this.n = n;
            this.a(false, true);
        }
    }

    public final int getAlignment() {
        return this.n;
    }

    public void setRotationAlignmentThresholdAngle(float f) {
        while (f >= 180.0f) {
            f -= 180.0f;
        }
        if (f >= 90.0f) {
            f = 90.0f - f;
        }
        this.al = f;
        this.a(false, true);
    }

    public final float getRotationAlignmentThresholdAngle() {
        return this.al;
    }

    public void setRotationAlignmentAngle(float f) {
        while (f >= 180.0f) {
            f -= 180.0f;
        }
        this.am = f;
        this.a(false, true);
    }

    public final float getRotationAlignmentAngle() {
        return this.am;
    }

    public final void setInterlineSpacing(float f) {
        this.ae = f;
    }

    public final float getInterlineSpacing() {
        return this.ae;
    }

    private void a(boolean bl, boolean bl2) {
        if (this.ah != null) {
            this.ah.invalidate(bl, bl2);
        }
        this.f();
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (super.contains(ilvPoint, ilvPoint2, ilvTransformer)) {
            return true;
        }
        return IlvText.a(this, ilvPoint2, ilvTransformer);
    }

    static boolean a(IlvGraphic ilvGraphic, IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        IlvSelection ilvSelection;
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (ilvGraphicBag instanceof IlvManager && (ilvSelection = ((IlvManager)ilvGraphicBag).getSelection(ilvGraphic)) instanceof IlvTextSelection) {
            return ((IlvTextSelection)ilvSelection).isOnBorder(ilvPoint, ilvTransformer);
        }
        return false;
    }

    @Override
    public Shape getCaretShape(IlvTextSelection.Range range, IlvTransformer ilvTransformer) {
        return this.ah.getCaretShape(range, ilvTransformer);
    }

    @Override
    public int pickCharacter(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        return this.ah.pickCharacter(ilvPoint, ilvTransformer);
    }

    @Override
    public int lineCount() {
        return this.ah.lineCount();
    }

    @Override
    public int lineOffset(int n) {
        return this.ah.lineOffset(n);
    }

    @Override
    public IlvSelection makeSelection() {
        boolean bl = true;
        boolean bl2 = (this.getWrappingMode() & 2) == 0;
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag instanceof IlvManager && !((IlvManager)ilvGraphicBag).isEditable(this)) {
            bl2 = false;
            bl = false;
        }
        return new IlvTextSelection(this, bl, bl2){

            @Override
            public String getDefaultInteractor() {
                return Editor.class.getName();
            }
        };
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("transform", this.ai != null ? this.ai : a);
        ilvOutputStream.write("font", this.getFont());
        ilvOutputStream.write("label", this.getLabel());
        if (this.u && this.t != null) {
            Object[] objectArray = this.g();
            ilvOutputStream.write("attributes", objectArray, "(i(sst)*)*");
        }
        ilvOutputStream.write("flags", this.w);
        ilvOutputStream.write("anchorPoint", this.ag);
        ilvOutputStream.write("foreground", this.getForeground());
        IlvUtility2D.writePaint(ilvOutputStream, this.getFillPaint());
        ilvOutputStream.write("sColor", this.getStrokeColor());
        if (this.aj != null) {
            ilvOutputStream.write("outlineColor", this.aj);
        }
        if (this.ak != 0.0f) {
            ilvOutputStream.write("outlineThickness", this.ak);
        }
        if (this.al > 0.0f) {
            ilvOutputStream.write("rotationAlignmentThresholdAngle", this.al);
        }
        if (this.am > 0.0f) {
            ilvOutputStream.write("rotationAlignmentAngle", this.am);
        }
        if (this.an) {
            ilvOutputStream.write("usesAnchorPos", this.an);
        }
        if (this.af != 256) {
            ilvOutputStream.write("aPosition", this.af);
        }
        if (this.r != 0.0f) {
            ilvOutputStream.write("leftMargin", this.r);
        }
        if (this.q != 0.0f) {
            ilvOutputStream.write("rightMargin", this.q);
        }
        if (this.p != 0.0f) {
            ilvOutputStream.write("topMargin", this.p);
        }
        if (this.o != 0.0f) {
            ilvOutputStream.write("bottomMargin", this.o);
        }
        if (this.n != 256) {
            ilvOutputStream.write("alignment", this.n);
        }
        if (this.aa != 0) {
            ilvOutputStream.write("wM", this.aa);
        }
        if (this.z != 100.0f) {
            ilvOutputStream.write("wH", this.z);
        }
        if (this.y != 100.0f) {
            ilvOutputStream.write("wW", this.y);
        }
        if (this.ae != -1.0f) {
            ilvOutputStream.write("spacing", this.ae);
        }
    }

    private Object[] g() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        AttributedCharacterIterator attributedCharacterIterator = this.getAttributedLabel().getIterator();
        int n = attributedCharacterIterator.getEndIndex();
        for (int i = attributedCharacterIterator.getBeginIndex(); i < n; ++i) {
            attributedCharacterIterator.setIndex(i);
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            arrayList2.clear();
            for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : map.entrySet()) {
                TextAttribute textAttribute = (TextAttribute)entry.getKey();
                Object object = entry.getValue();
                arrayList2.add(IlvAttributedStringUtil.getTextAttributeName(textAttribute));
                if (object instanceof String) {
                    arrayList2.add("s");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof Font) {
                    arrayList2.add("F");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof Boolean) {
                    arrayList2.add("b");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof Float) {
                    arrayList2.add("f");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof Double) {
                    arrayList2.add("d");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof Integer) {
                    arrayList2.add("i");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof Color) {
                    arrayList2.add("c");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof IlvPersistentObject) {
                    arrayList2.add("O");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof GradientPaint) {
                    arrayList2.add("G");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof IlvPattern) {
                    arrayList2.add("P");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof IlvTexture) {
                    arrayList2.add("X");
                    arrayList2.add(object);
                    continue;
                }
                if (!(object instanceof TransformAttribute)) continue;
                AffineTransform affineTransform = ((TransformAttribute)object).getTransform();
                IlvTransformer ilvTransformer = new IlvTransformer(affineTransform.getScaleX(), affineTransform.getShearX(), affineTransform.getShearY(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
                arrayList2.add("T");
                arrayList2.add(ilvTransformer);
            }
            if (arrayList2.size() <= 0) continue;
            arrayList.add(new Integer(i));
            arrayList.add(arrayList2.toArray());
        }
        return new Object[]{arrayList.toArray()};
    }

    private void a(Object[] objectArray) throws IlvReadFileException {
        try {
            Object[] objectArray2 = (Object[])objectArray[0];
            for (int i = 0; i < objectArray2.length; i += 2) {
                int n = (Integer)objectArray2[i];
                Object[] objectArray3 = (Object[])objectArray2[i + 1];
                for (int j = 0; j < objectArray3.length; j += 3) {
                    String string = (String)objectArray3[j];
                    Object object = objectArray3[j + 2];
                    if (object instanceof IlvTransformer) {
                        IlvTransformer ilvTransformer = (IlvTransformer)object;
                        AffineTransform affineTransform = new AffineTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
                        object = new TransformAttribute(affineTransform);
                    }
                    this.addLabelAttribute(IlvAttributedStringUtil.getTextAttribute(string), object, n, n + 1);
                }
            }
        }
        catch (Exception exception) {
            throw new IlvReadFileException("Illegal attributes for attributed string.\nMessage: " + exception.getMessage(), exception);
        }
    }

    public static void SetTransformerDependentRendering(boolean bl) {
        ao = bl;
    }

    public static boolean IsTransformerDependentRendering() {
        return ao;
    }

    @Override
    public boolean usesBidiMarkers() {
        return this.ah.usesMarkers();
    }

    @Override
    public boolean isBaseTextDirectionSensitive() {
        return IlvBidiUtil.isAdvancedBidiOn();
    }

    @Override
    public void baseTextDirectionChanged(int n, int n2) {
        super.baseTextDirectionChanged(n, n2);
        this.a(false, true);
    }

    @Override
    public void componentOrientationChanged(ComponentOrientation componentOrientation, ComponentOrientation componentOrientation2) {
        super.componentOrientationChanged(componentOrientation, componentOrientation2);
        if (this.getResolvedBaseTextDirection() == 527) {
            this.a(false, true);
        }
    }

    boolean b() {
        if (!IlvBidiUtil.isAdvancedBidiOn()) {
            return false;
        }
        return this.an;
    }

    final void a(int n) {
        if (IlvBidiUtil.isAdvancedBidiOn() && !this.b()) {
            this.af = n;
        }
    }

    @Override
    public boolean isLocaleSensitive() {
        if (this.getWrappingMode() != 0) {
            return true;
        }
        return super.isLocaleSensitive();
    }

    @Override
    public void localeChanged(ULocale uLocale, ULocale uLocale2) {
        if (this.isLocaleSensitive()) {
            this.a(false, true);
        }
    }

    private static final class LabelSetter
    implements IlvApplyObject {
        @Override
        public void apply(IlvGraphic ilvGraphic, Object object) {
            AttributedString attributedString = (AttributedString)object;
            if (!(ilvGraphic instanceof IlvText)) {
                throw new IllegalArgumentException("object must be IlvText");
            }
            ((IlvText)ilvGraphic).setAttributedLabel(attributedString);
        }
    }

    public static class Editor
    extends IlvTextEditor {
        @Override
        protected void deleteSelection(IlvTextInterface ilvTextInterface, int n, int n2) {
            IlvText ilvText = (IlvText)ilvTextInterface;
            if (ilvText.a() == null) {
                super.deleteSelection(ilvTextInterface, n, n2);
                return;
            }
            int n3 = ilvText.getLabel().length();
            AttributedString attributedString = ilvText.getAttributedLabel();
            if (ilvText.usesBidiMarkers()) {
                --n;
                --n2;
            }
            if (n < 0) {
                n = 0;
            }
            if (n >= n3) {
                return;
            }
            AttributedString attributedString2 = n2 >= n3 || n2 <= n ? IlvAttributedStringUtil.substring(attributedString, 0, n) : IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString, 0, n), IlvAttributedStringUtil.substring(attributedString, n2, n3));
            this.a((IlvGraphic)((Object)ilvTextInterface), attributedString2);
        }

        @Override
        protected void replaceSelection(IlvTextInterface ilvTextInterface, int n, int n2, String string) {
            IlvText ilvText = (IlvText)ilvTextInterface;
            if (ilvText.a() == null) {
                super.replaceSelection(ilvTextInterface, n, n2, string);
                return;
            }
            int n3 = ilvText.getLabel().length();
            AttributedString attributedString = ilvText.getAttributedLabel();
            if (ilvText.usesBidiMarkers()) {
                --n;
                --n2;
            }
            if (n < 0) {
                n = 0;
            }
            if (n > n3) {
                n = n3;
            }
            AttributedString attributedString2 = n2 >= n3 || n2 < n ? IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString, 0, n), string) : IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString, 0, n), string, IlvAttributedStringUtil.substring(attributedString, n2, n3));
            this.a((IlvGraphic)((Object)ilvTextInterface), attributedString2);
        }

        @Override
        protected void replaceSelection(IlvTextInterface ilvTextInterface, int n, int n2, AttributedString attributedString) {
            IlvText ilvText = (IlvText)ilvTextInterface;
            int n3 = ilvText.getLabel().length();
            AttributedString attributedString2 = ilvText.getAttributedLabel();
            if (ilvText.usesBidiMarkers()) {
                --n;
                --n2;
            }
            if (n < 0) {
                n = 0;
            }
            if (n > n3) {
                n = n3;
            }
            AttributedString attributedString3 = n2 >= n3 || n2 < n ? IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString2, 0, n), attributedString) : IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString2, 0, n), attributedString, IlvAttributedStringUtil.substring(attributedString2, n2, n3));
            this.a((IlvGraphic)((Object)ilvTextInterface), attributedString3);
        }

        @Override
        protected void copySelection(IlvTextInterface ilvTextInterface, int n, int n2) {
            IlvText ilvText = (IlvText)ilvTextInterface;
            if (ilvText.a() == null) {
                super.copySelection(ilvTextInterface, n, n2);
                return;
            }
            if (ilvText.usesBidiMarkers()) {
                --n;
                --n2;
            }
            if (n < 0) {
                return;
            }
            String string = ilvTextInterface.getLabel();
            if (n2 >= string.length()) {
                n2 = string.length();
            }
            if (n >= n2) {
                return;
            }
            AttributedString attributedString = IlvAttributedStringUtil.substring(ilvText.getAttributedLabel(), n, n2);
            Transferable transferable = IlvAttributedStringUtil.getTransferable(attributedString);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(transferable, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(IlvGraphic ilvGraphic, AttributedString attributedString) {
            IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
            IlvGraphicBag ilvGraphicBag2 = ilvGraphic.getTopLevelGraphicBag();
            IlvManager ilvManager = null;
            if (ilvGraphicBag2 != ilvGraphicBag && ilvGraphicBag2 != null) {
                ilvManager = (IlvManager)ilvGraphicBag2;
                ilvManager.setContentsAdjusting(true);
            }
            try {
                ilvGraphicBag.applyToObject(ilvGraphic, ap, attributedString, true);
            }
            finally {
                if (ilvManager != null) {
                    ilvManager.setContentsAdjusting(false);
                }
            }
        }
    }

    static interface Renderer
    extends Serializable {
        public void draw(Graphics var1, IlvTransformer var2);

        public void invalidate(boolean var1, boolean var2);

        public Rectangle2D getBounds();

        public Shape getCaretShape(IlvTextSelection.Range var1, IlvTransformer var2);

        public int pickCharacter(IlvPoint var1, IlvTransformer var2);

        public int lineCount();

        public int lineOffset(int var1);

        public IlvPoint[] getAnchorPoints(boolean var1, IlvTransformer var2);

        public boolean hasEllipsis();

        public boolean usesMarkers();
    }
}

