/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.editor;

import com.ibm.icu.util.ULocale;
import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleModel;
import ilog.views.css.model.IlvRuleUtils;
import ilog.views.css.model.IlvSelector;
import ilog.views.css.model.IlvSelectorImpl;
import ilog.views.css.model.event.CSSChangeEvent;
import ilog.views.css.model.event.CSSChangeListener;
import ilog.views.css.model.internal.IlvCSSWriter;
import ilog.views.css.selector.IlvSelectorContext;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectInsertedEvent;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.IlvURLKeyTable;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.IlvEventMap;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLayout;
import ilog.views.graphic.composite.layout.IlvCenteredLayout;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.symbology.editor.IlvSymbolSelectorContext;
import ilog.views.symbology.editor.action.IlvSymbolEditorAction;
import ilog.views.symbology.editor.event.ParameterListChangedEvent;
import ilog.views.symbology.editor.event.ParameterListChangedListener;
import ilog.views.symbology.editor.event.ParameterValueChangedEvent;
import ilog.views.symbology.editor.event.ParameterValueChangedListener;
import ilog.views.symbology.editor.event.SelectionChangedEvent;
import ilog.views.symbology.editor.event.SelectionChangedListener;
import ilog.views.symbology.editor.event.SymbolChangedEvent;
import ilog.views.symbology.editor.event.SymbolChangedListener;
import ilog.views.symbology.editor.internal.SymbolEditorUtilities;
import ilog.views.symbology.editor.rules.IlvSymbolRuleModel;
import ilog.views.symbology.editor.rules.IlvSymbolRuleStrategy;
import ilog.views.symbology.editor.tree.IlvSymbolTreeRoot;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteBaseObject;
import ilog.views.symbology.palettes.IlvPaletteManager;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.IlvPaletteSymbolParameter;
import ilog.views.symbology.palettes.IlvPaletteSymbolParameterValueSet;
import ilog.views.symbology.palettes.internal.IlvPaletteUtil;
import ilog.views.util.IlvImageUtil;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.beans.IlvConvertForSetters;
import ilog.views.util.beans.IlvPropertyEditorManager;
import ilog.views.util.convert.IlvConvert;
import ilog.views.util.convert.IlvConvertException;
import ilog.views.util.css.IlvApplicableDeclarationCollection;
import ilog.views.util.css.IlvCSSDOMImplementation;
import ilog.views.util.css.IlvCSSDocument;
import ilog.views.util.css.IlvCSSEngine;
import ilog.views.util.css.IlvCSSModel;
import ilog.views.util.css.Util;
import ilog.views.util.css.parser.AttributeSelector;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.css.parser.SimpleSelector;
import ilog.views.util.cssbeans.IlvCSSBeans;
import ilog.views.util.image.PNGImageEncoder;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.internal.IlvUndoManager;
import ilog.views.util.print.IlvPrintUtil;
import ilog.views.util.styling.IlvCSSAttributeSelector;
import ilog.views.util.styling.IlvCSSDeclaration;
import ilog.views.util.styling.IlvCSSFunction;
import ilog.views.util.styling.IlvCSSRule;
import ilog.views.util.styling.IlvStylingException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class IlvSymbolEditorDocument {
    public static boolean invisibleGhosts = false;
    private IlvPaletteSymbol a;
    private IlvPaletteSymbol b;
    private IlvSymbolRuleModel c;
    private String d;
    private IlvPaletteManager e;
    private IlvRule f;
    private IlvGraphic g;
    private boolean h;
    private IlvManager i;
    private static HashMap j = new HashMap();
    private ArrayList k = new ArrayList();
    private EventListenerList l = new EventListenerList();
    private EventListenerList m = new EventListenerList();
    private EventListenerList n = new EventListenerList();
    private EventListenerList o = new EventListenerList();
    private SymbolCSSModel p;
    private ConditionEditor q;
    private ResourceBundle r = IlvResourceUtil.getBundle("ilog.views.symbology.editor.symboleditor", IlvLocaleUtil.getCurrentLocale(), IlvSymbolEditorDocument.class.getClassLoader());
    private IlvPoint s;
    private IlvPoint t;
    private IlvRect u;
    private boolean v;
    private String w;
    private String x;
    private boolean y = false;
    private CSSHook z;
    private int aa;
    private static final String ab = "auto_icon_";
    public static final String designModePseudoClass = "design";
    public static final String[] designModePseudoClasses;
    private String[] ac = null;
    public static boolean confirmRuleUpdateWhenParameterRenamed;
    public static boolean confirmRuleUpdateWhenParameterDeleted;
    public static final String FrameworkComponentType = "Framework";
    public static final String DiagrammerComponentType = "Diagrammer";
    public static final String GanttComponentType = "Gantt";
    public static final String invisibleProperty = "invisible";
    public static final String unrealizedProperty = "unrealized";
    private UndoManager ad;
    private SymbolCompoundEdit ae;
    private int af;
    private int ag;
    private boolean ah;
    private static final boolean ai = false;

    public IlvSymbolEditorDocument(IlvPaletteSymbol ilvPaletteSymbol, String string, IlvPaletteManager ilvPaletteManager, ConditionEditor conditionEditor, UndoManager undoManager) throws IlvStylingException {
        Object object;
        IlvCSSRule ilvCSSRule;
        int n;
        this.a = (IlvPaletteSymbol)ilvPaletteSymbol.copy();
        this.b = ilvPaletteSymbol.getPalette() != null ? ilvPaletteSymbol : null;
        this.q = conditionEditor;
        this.ad = undoManager;
        this.z = new CSSHook();
        this.setComponentType(string);
        this.e = ilvPaletteManager;
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        if (invisibleGhosts) {
            ilvSymbolRuleModel.getCSSBeans().registerFunction(new VisibleFunction());
            this.ac = designModePseudoClasses;
        }
        if (ilvPaletteManager != null) {
            ilvPaletteManager.attach(((IlvSymbolRuleStrategy)ilvSymbolRuleModel.getCSSStrategy()).getCSSCompatible());
        }
        this.getRuleModel().getCSSBeans().setStyleSheet(ilvPaletteSymbol.getCSSURL().toExternalForm());
        IlvCSSEngine ilvCSSEngine = this.getRuleModel().getCSSBeans().getCSSengine();
        Object object2 = ilvCSSEngine.getRules(true);
        IlvRule[] ilvRuleArray = new ArrayList();
        for (n = 0; n < ((Rule[])object2).length; ++n) {
            boolean bl;
            block16: {
                block17: {
                    ilvCSSRule = object2[n];
                    bl = true;
                    if (((Rule)ilvCSSRule).getSelector().length != 1) break block16;
                    object = ((Rule)ilvCSSRule).getSelector()[0];
                    if ("MetaInfo".equals(((SimpleSelector)object).getType())) break block17;
                    if (!"Parameter".equals(((SimpleSelector)object).getType())) break block16;
                }
                bl = false;
            }
            if (!bl) continue;
            ilvRuleArray.add(ilvCSSRule);
        }
        if (ilvRuleArray.size() < ((Rule[])object2).length) {
            ilvCSSEngine.setRules(ilvRuleArray.toArray(new Rule[0]));
        }
        ilvCSSEngine.setAttributeHandler(new SymbolAttributeHandler(ilvCSSEngine.getAttributeHandler()));
        this.f = this.getRuleModel().getRule(this.a.getClassName(), false);
        this.i = this.createManager();
        this.i.setInsertionLayer(1);
        if (invisibleGhosts) {
            this.i.addLayer(new SymbolEditorLayer(), this.i.getInsertionLayer());
        }
        this.p = new SymbolCSSModel();
        if (!invisibleGhosts) {
            object2 = new ArrayList();
            ilvRuleArray = ilvSymbolRuleModel.getAllRules(true);
            for (n = 0; n < ilvRuleArray.length; ++n) {
                ilvCSSRule = ilvRuleArray[n];
                String[] stringArray = ilvCSSRule.getPseudoClasses();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(designModePseudoClass)) continue;
                    ((ArrayList)object2).add(ilvCSSRule);
                    break;
                }
                object = ilvCSSRule.getDeclarationValue("class");
                if (object == null || ((String)object).length() != 0) continue;
                try {
                    if (SymbolEditorUtilities.hasCondition((IlvRule)ilvCSSRule)) {
                        ilvCSSRule.removeDeclaration("class");
                    } else {
                        IlvRule ilvRule = ilvCSSRule.createSameRule();
                        ilvRule.getSelector().setPseudoClasses(designModePseudoClasses);
                        ilvRule.updateRule();
                        ilvRule.updateWeights();
                        ilvRule = ilvSymbolRuleModel.getRule(ilvRule.getSelectorString(), false);
                        object = ilvRule.getDeclarationValue("class");
                        ilvCSSRule.setDeclarationValue("class", (String)(object != null ? object : ""));
                    }
                    ilvCSSRule.setDeclaration("visible", "false");
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                ilvSymbolRuleModel.removeRule((IlvRule)((ArrayList)object2).get(n));
            }
        }
        this.d();
        this.i.addObject(this.getToplevelGraphic(), true);
        this.getRuleModel().addStyleChangeListener(new CSSChangeListener(){

            @Override
            public void styleChange(CSSChangeEvent cSSChangeEvent) {
                if (cSSChangeEvent.isAdjusting()) {
                    IlvSymbolEditorDocument.this.h = false;
                } else {
                    IlvSymbolEditorDocument.this.applyChanges();
                }
                IlvSymbolEditorDocument.this.a(cSSChangeEvent);
            }
        });
        this.addSymbolChangedListener(new SymbolChangedListener(){

            @Override
            public void symbolChanged(SymbolChangedEvent symbolChangedEvent) {
                block2: {
                    block4: {
                        block3: {
                            if (!(symbolChangedEvent.getChangedObject() instanceof IlvPaletteSymbolParameter)) break block2;
                            if (!"name".equals(symbolChangedEvent.getProperty())) break block3;
                            IlvSymbolEditorDocument.this.a((String)symbolChangedEvent.getOldValue(), (String)symbolChangedEvent.getNewValue());
                            break block2;
                        }
                        if ("value".equals(symbolChangedEvent.getProperty())) break block4;
                        if ("type".equals(symbolChangedEvent.getProperty())) break block4;
                        if (!"valueSet".equals(symbolChangedEvent.getProperty())) break block2;
                    }
                    IlvSymbolEditorDocument.this.applyChanges();
                }
                IlvSymbolEditorDocument.this.a(symbolChangedEvent);
                IlvSymbolEditorAction.updateActions(IlvSymbolEditorDocument.this);
            }
        });
        this.i.addManagerContentChangedListener(new ManagerContentChangedListener(){

            @Override
            public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
                if (managerContentChangedEvent.getType() == 1) {
                    final IlvGraphic ilvGraphic = ((ObjectInsertedEvent)managerContentChangedEvent).getGraphicObject();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IlvSymbolEditorDocument.this.i.removeObject(ilvGraphic, true);
                        }
                    });
                    IlvSymbolEditorDocument.this.addGraphic(ilvGraphic, true, null);
                }
            }
        });
    }

    private void a(IlvSymbolRuleModel ilvSymbolRuleModel, boolean bl) {
        if (bl) {
            ilvSymbolRuleModel.setAdjusting(true);
            if (this.i != null) {
                this.i.setContentsAdjusting(true);
            }
        } else {
            if (this.i != null) {
                this.i.setContentsAdjusting(false);
            }
            ilvSymbolRuleModel.setAdjusting(false);
        }
    }

    public IlvManager createManager() {
        return new IlvManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IlvPaletteSymbol ilvPaletteSymbol, IlvPaletteManager ilvPaletteManager, IlvPalette ilvPalette, URL uRL) throws IOException {
        File file = null;
        File file2 = null;
        File file3 = null;
        PrintWriter printWriter = null;
        try {
            Object object;
            Serializable serializable;
            Serializable serializable2;
            Object object2;
            Object object3;
            IlvCSSDeclaration[] ilvCSSDeclarationArray;
            int n;
            ilvPaletteSymbol.removeAllResources();
            file = File.createTempFile("tmp", ".txt");
            file2 = new File(file.getParentFile(), ilvPaletteSymbol.getName() + ".css");
            file.delete();
            file = null;
            URL uRL2 = IlvURLUtil.convertFileToAbsoluteURL(file2);
            printWriter = Util.makeUTF8Writer(new FileOutputStream(file2));
            IlvCSSDocument ilvCSSDocument = new IlvCSSDocument(uRL2, new URL[]{uRL2});
            IlvCSSDOMImplementation ilvCSSDOMImplementation = this.f.getDOMImplementation();
            Rule rule = ilvCSSDOMImplementation.createRule();
            SimpleSelector simpleSelector = new SimpleSelector();
            simpleSelector.setType("MetaInfo");
            rule.setSelector(new SimpleSelector[]{simpleSelector});
            Object object4 = ilvCSSDOMImplementation.createDeclaration("version");
            ((Declaration)object4).setValue(ilvPaletteSymbol.getVersion());
            rule.setDeclarations(new Declaration[]{object4});
            rule.printCSS(printWriter, ilvCSSDocument);
            int n2 = ilvPaletteSymbol.getParameterCount();
            for (n = 0; n < n2; ++n) {
                object4 = ilvPaletteSymbol.getParameter(n);
                ilvCSSDeclarationArray = ((IlvPaletteBaseObject)object4).getID();
                Object object5 = ((IlvPaletteSymbolParameter)object4).getValue();
                object3 = ((IlvPaletteSymbolParameter)object4).getType();
                if (object3 != null && (object2 = IlvPaletteUtil.getClassFromShortCut((String)object3)) != null) {
                    object3 = ((Class)object2).getName();
                }
                object2 = ilvCSSDOMImplementation.createRule();
                serializable2 = new SimpleSelector();
                serializable2.setType("Parameter");
                serializable2.setID((String)ilvCSSDeclarationArray);
                ((Rule)object2).setSelector(new SimpleSelector[]{serializable2});
                serializable = ilvCSSDOMImplementation.createDeclaration("class");
                ((Declaration)serializable).setValue((String)object3);
                object = ilvCSSDOMImplementation.createDeclaration("default");
                Class clazz = IlvPaletteUtil.getClass((String)object3);
                if (clazz != null) {
                    ((Declaration)object).setValue(IlvCSSBeans.convertExternalCSSParameterDefaultToString(clazz, object5));
                } else {
                    ((Declaration)object).setValue("");
                }
                ((Rule)object2).setDeclarations(new Declaration[]{serializable, object});
                ((Rule)object2).printCSS(printWriter, ilvCSSDocument);
            }
            IlvRule[] ilvRuleArray = this.c.getAllRules(true);
            for (n = 0; n < ilvRuleArray.length; ++n) {
                block22: {
                    object4 = ilvRuleArray[n];
                    ilvCSSDeclarationArray = object4.getCSSDeclarations();
                    if (ilvCSSDeclarationArray == null) break block22;
                    for (int i = 0; i < ilvCSSDeclarationArray.length; ++i) {
                        block24: {
                            block23: {
                                object3 = ilvCSSDeclarationArray[i];
                                object2 = object3.getValue();
                                if (((String)object2).startsWith("../resources/")) {
                                    ilvPaletteSymbol.addResource((String)object2);
                                    continue;
                                }
                                if (((String)object2).startsWith("palettejar:file:")) break block23;
                                if (!((String)object2).startsWith("jar:file")) break block24;
                            }
                            try {
                                serializable2 = new URL((String)object2);
                                ilvPaletteSymbol.addResource((URL)serializable2);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            continue;
                        }
                        if (!((String)object2).startsWith("file:")) continue;
                        try {
                            serializable2 = new URL((String)object2);
                            serializable = IlvURLUtil.convertFileURLToFile((URL)serializable2);
                            if (!((File)serializable).isAbsolute() || !((File)serializable).exists()) continue;
                            object4 = object4.copy();
                            object = "url(" + (String)object2 + ")";
                            object4.setDeclarationValue(object3.getProperty(), (String)object);
                            ilvPaletteSymbol.addResource((URL)serializable2);
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                object4.printCSS(printWriter, ilvCSSDocument);
            }
            printWriter.flush();
            ilvPaletteSymbol.setCSSURL(uRL2);
            file3 = this.setAutomaticIcon(ilvPaletteSymbol);
            ilvPaletteManager.save(ilvPalette, IlvURLUtil.convertFileURLToFile(uRL), false, true);
            this.a(ilvPaletteManager.getWorkingDirectory());
            this.b = ilvPaletteSymbol;
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (file != null) {
                file.delete();
            }
            if (file2 != null) {
                file2.delete();
            }
            if (file3 != null) {
                file3.delete();
            }
        }
    }

    public IlvPaletteSymbol getSymbol() {
        return this.a;
    }

    public IlvSymbolRuleModel getRuleModel() {
        if (this.c == null) {
            if (this.d == null) {
                throw new RuntimeException("Component type not set, cannot create rule model.");
            }
            this.c = this.b(this.d);
        }
        return this.c;
    }

    public String getComponentType() {
        return this.d;
    }

    public void setComponentType(String string) {
        this.d = string;
        this.c = null;
    }

    public IlvGraphic getToplevelGraphic() {
        return this.g;
    }

    public IlvManager getManager() {
        return this.i;
    }

    public IlvRule getToplevelRule() {
        return this.f;
    }

    public IlvSelectorContext getSelectorContext() {
        return new IlvSymbolSelectorContext(this);
    }

    public String getString(String string) {
        return this.r.getString(string);
    }

    public void applyChanges() {
        this.applyChanges(this.getRuleModel().isMustRecreateSymbol());
    }

    public void applyChanges(boolean bl) {
        if (bl && this.g instanceof IlvCompositeGraphic) {
            final IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)this.g;
            if (ilvCompositeGraphic.getGraphicBag() != null) {
                ilvCompositeGraphic.getGraphicBag().applyToObject(ilvCompositeGraphic, new IlvApplyObject(){

                    @Override
                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        ilvCompositeGraphic.setChildren(null);
                        ilvCompositeGraphic.setEventMaps(null);
                        ilvCompositeGraphic.setEventMap(null);
                        ilvCompositeGraphic.setConstraints(null);
                        ilvCompositeGraphic.removeAll(true);
                    }
                }, null, true);
            } else {
                ilvCompositeGraphic.setChildren(null);
                ilvCompositeGraphic.setEventMaps(null);
                ilvCompositeGraphic.setEventMap(null);
                ilvCompositeGraphic.setConstraints(null);
                ilvCompositeGraphic.removeAll(true);
            }
        }
        this.i.applyToObject(this.g, new IlvApplyObject(){

            @Override
            public void apply(IlvGraphic ilvGraphic, Object object) {
                IlvSymbolEditorDocument.this.d();
            }
        }, null, true);
        if (bl) {
            this.fireSymbolChanged(this.g, "topLevelGraphic", null, null);
        }
    }

    public void applyChangesIfNecessary() {
        if (!this.h) {
            this.applyChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void setDefaultValues(IlvRule var1_1, IlvRule var2_2, IlvCSSDeclaration[] var3_3) {
        var4_4 = this.getRuleModel();
        if (var2_2 == null || var2_2.getSelector().getID() == null) ** GOTO lbl-1000
        if (var2_2.getSelector().getID().endsWith("Attachment")) {
            var6_5 = var4_4.getMainRuleFromID(var2_2.getSelector().getID());
            var5_6 = var4_4.makeBeanFromRule(var6_5);
        } else lbl-1000:
        // 2 sources

        {
            var5_6 = var4_4.getGraphicFromRule(var1_1);
            var6_5 = var4_4.getMainRuleFromGraphic((IlvGraphic)var5_6);
        }
        if (var5_6 != null) {
            this.a(var4_4, true);
            try {
                var7_7 = null;
                var8_9 = null;
                var9_10 = null;
                var10_11 = var3_3 == null ? 0 : var3_3.length;
                for (var11_12 = 0; var11_12 < var10_11; ++var11_12) {
                    block33: {
                        var12_13 = var3_3[var11_12].getProperty();
                        if (var6_5.getDeclarationValue(var12_13) != null) continue;
                        if (var7_7 == null) {
                            var7_7 = Introspector.getBeanInfo(var5_6.getClass()).getPropertyDescriptors();
                        }
                        var13_14 = -1;
                        var14_15 = var12_13;
                        var15_16 = var12_13.lastIndexOf(91);
                        if (var15_16 > 0) {
                            if (var12_13.endsWith("]")) {
                                var16_17 = var12_13.substring(var15_16 + 1, var12_13.length() - 2);
                                var13_14 = Integer.parseInt((String)var16_17);
                                var14_15 = var12_13.substring(0, var15_16);
                            }
                        }
                        var16_17 = null;
                        for (var17_19 = 0; var17_19 < var7_7.length; ++var17_19) {
                            var18_20 = var7_7[var17_19];
                            if (!var18_20.getName().equals(var14_15)) continue;
                            var16_17 = var18_20;
                            break;
                        }
                        if (var16_17 == null) {
                            throw new RuntimeException("Property descriptor not found for " + var12_13);
                        }
                        if (var13_14 >= 0) {
                            var18_20 = ((IndexedPropertyDescriptor)var16_17).getIndexedReadMethod();
                            if (var18_20 == null) {
                                throw new RuntimeException("No indexed read method for " + var12_13);
                            }
                            var17_18 = var18_20.invoke(var5_6, new Object[]{new Integer(var13_14)});
                        } else {
                            var18_20 = var16_17.getReadMethod();
                            if (var18_20 == null) {
                                throw new RuntimeException("No read method for " + var12_13);
                            }
                            var17_18 = var18_20.invoke(var5_6, (Object[])null);
                        }
                        if (var17_18 == null) {
                            var18_20 = "";
                        } else {
                            try {
                                var19_21 = null;
                                var20_23 = var16_17.getPropertyEditorClass();
                                if (var20_23 != null) {
                                    var19_21 = (PropertyEditor)var20_23.newInstance();
                                }
                                if (var19_21 == null && var17_18 != null) {
                                    var19_21 = IlvPropertyEditorManager.findEditor(var17_18.getClass());
                                }
                                if (var19_21 != null) {
                                    var19_21.setValue(var17_18);
                                    var18_20 = var19_21.getAsText();
                                    break block33;
                                }
                                try {
                                    if (var8_9 == null) {
                                        var8_9 = new IlvConvertForSetters();
                                    }
                                    var18_20 = (String)var8_9.convert(var17_18, (PropertyDescriptor)var16_17, String.class);
                                }
                                catch (Exception var21_25) {
                                    var21_25.printStackTrace();
                                    var18_20 = null;
                                }
                                if (var18_20 == null) {
                                    var18_20 = (String)IlvConvert.convert(var17_18, String.class);
                                }
                            }
                            catch (Exception var19_22) {
                                var19_22.printStackTrace();
                                var18_20 = null;
                            }
                        }
                    }
                    if (var18_20 == null) {
                        if (var9_10 == null) {
                            var9_10 = new IlvCSSWriter(this.f.getDOMImplementation());
                        }
                        var19_21 = SymbolEditorUtilities.getUniqueRuleID(this, var4_4.getAllRules(true), var14_15);
                        var20_23 = "Subobject#" + (String)var19_21;
                        var21_24 = var9_10.convert((String)var20_23, var17_18, null);
                        var22_26 = var4_4.getRule((String)var20_23, true);
                        var23_27 = var21_24.getDeclarations();
                        for (var24_29 = 0; var24_29 < var23_27.length; ++var24_29) {
                            var4_4.setDeclarationValue(var22_26, var23_27[var24_29].getProperty(), var23_27[var24_29].getValue());
                        }
                        var24_28 = var21_24.getAdditionalRules();
                        this.c(var24_28);
                        for (var25_30 = 0; var25_30 < var24_28.length; ++var25_30) {
                            var4_4.addRule(var24_28[var25_30]);
                        }
                        var18_20 = "@#" + (String)var19_21;
                    }
                    var4_4.setDeclarationValue(var6_5, var12_13, (String)var18_20);
                }
            }
            catch (Exception var7_8) {
                var7_8.printStackTrace();
            }
            finally {
                this.a(var4_4, false);
            }
        }
    }

    public void setSelection(List list) {
        this.a(list, true);
    }

    private void a(List list, boolean bl) {
        int n;
        int n2;
        List list2 = this.getSelection();
        boolean bl2 = false;
        for (n2 = 0; n2 < this.k.size(); n2 += 1) {
            if (!(this.k.get(n2) instanceof IlvRule)) continue;
            bl2 = true;
            break;
        }
        this.k.clear();
        if (list != null) {
            this.k.addAll(list);
        }
        n2 = 0;
        String string = null;
        String string2 = null;
        for (n = 0; n < this.k.size(); ++n) {
            if (!(this.k.get(n) instanceof IlvRule)) continue;
            bl2 = true;
            if (this.a((IlvRule)list.get(n), "selected")) {
                n2 = 1;
            }
            if (this.a((IlvRule)list.get(n), "high-contrast")) {
                string = "high-contrast";
            }
            if (this.a((IlvRule)list.get(n), "normal-contrast")) {
                string = "normal-contrast";
            }
            if (this.a((IlvRule)list.get(n), "high-detail-level")) {
                string2 = "high-detail-level";
            }
            if (this.a((IlvRule)list.get(n), "medium-detail-level")) {
                string2 = "medium-detail-level";
            }
            if (!this.a((IlvRule)list.get(n), "low-detail-level")) continue;
            string2 = "low-detail-level";
        }
        n = 0;
        if (n2 != this.isSelected()) {
            this.setSelected(n2 != 0);
            n = 1;
        }
        if (string != this.getContrastMode()) {
            this.setContrastMode(string);
            n = 1;
        }
        if (string2 != this.getLevelOfDetailMode()) {
            this.setLevelOfDetailMode(string2);
            n = 1;
        }
        if (n == 0 && bl2 && !this.getRuleModel().isAdjusting()) {
            this.applyChanges(false);
        }
        if (bl) {
            this.a(list2);
        }
    }

    public void clearSelection() {
        this.setSelection(null);
    }

    public void setSelection(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        this.setSelection(arrayList);
    }

    private void a(Object object) {
        List list = this.getSelection();
        if (list.contains(object)) {
            list.remove(object);
            this.setSelection(list);
        }
    }

    public List getSelection() {
        return (List)this.k.clone();
    }

    public void addSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.l.add(SelectionChangedListener.class, selectionChangedListener);
    }

    public void removeSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.l.remove(SelectionChangedListener.class, selectionChangedListener);
    }

    private void a(List list) {
        Object[] objectArray = this.l.getListenerList();
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent(this, list);
        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            ((SelectionChangedListener)objectArray[i]).selectionChanged(selectionChangedEvent);
        }
        this.c(list);
    }

    private void b() {
        Object[] objectArray = this.l.getListenerList();
        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            ((SelectionChangedListener)objectArray[i]).refresh();
        }
    }

    public void addSymbolChangedListener(SymbolChangedListener symbolChangedListener) {
        this.m.add(SymbolChangedListener.class, symbolChangedListener);
    }

    public void removeSymbolChangedListener(SymbolChangedListener symbolChangedListener) {
        this.m.remove(SymbolChangedListener.class, symbolChangedListener);
    }

    public void addParameter(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
        this.a.addParameter(ilvPaletteSymbolParameter);
        this.b(ilvPaletteSymbolParameter);
    }

    public void removeParameter(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
        List<IlvRule> list = this.getRuleModel().getRulesUsingAttributeName(ilvPaletteSymbolParameter.getName());
        List list2 = this.a(ilvPaletteSymbolParameter.getName());
        if (list.size() > 0 || list2.size() > 0) {
            if (this.f()) {
                this.a((Object)ilvPaletteSymbolParameter);
                this.a(ilvPaletteSymbolParameter);
                if (list.size() > 0) {
                    this.getRuleModel().removeRulesUsingAttributeName(ilvPaletteSymbolParameter.getName());
                }
                if (list2.size() > 0) {
                    this.b(list2);
                }
                this.a.removeParameter(ilvPaletteSymbolParameter);
                this.c(ilvPaletteSymbolParameter);
            }
        } else {
            this.a((Object)ilvPaletteSymbolParameter);
            this.a.removeParameter(ilvPaletteSymbolParameter);
            this.c(ilvPaletteSymbolParameter);
        }
    }

    private List a(String string) {
        String string2 = "@" + string;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IlvRule[] ilvRuleArray = this.getRuleModel().getAllRules(true);
        block0: for (int i = 0; i < ilvRuleArray.length; ++i) {
            IlvRule ilvRule = ilvRuleArray[i];
            IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getCSSDeclarations();
            for (int j = 0; j < ilvCSSDeclarationArray.length; ++j) {
                String string3 = ilvCSSDeclarationArray[j].getProperty();
                String string4 = ilvCSSDeclarationArray[j].getValue();
                if (string4 == null) continue;
                if ("parameterToModify".equals(string3) && string.equals(string4)) {
                    arrayList.add(ilvCSSDeclarationArray[j]);
                    arrayList.add(ilvRule);
                    continue block0;
                }
                int n = this.b(string4, string2);
                if (n < 0) continue;
                arrayList.add(ilvCSSDeclarationArray[j]);
                arrayList.add(ilvRule);
                continue block0;
            }
        }
        return arrayList;
    }

    private void b(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IlvCSSDeclaration ilvCSSDeclaration = (IlvCSSDeclaration)iterator.next();
            IlvRule ilvRule = (IlvRule)iterator.next();
            this.getRuleModel().removeDeclaration(ilvRule, ilvCSSDeclaration.getProperty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
        String string = ilvPaletteSymbolParameter.getName();
        IlvRule ilvRule = this.getRuleModel().getRootRules(true)[0];
        IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getCSSDeclarations();
        block5: for (int i = 0; i < ilvCSSDeclarationArray.length; ++i) {
            if (!ilvCSSDeclarationArray[i].getProperty().startsWith("eventMaps")) continue;
            String string2 = ilvCSSDeclarationArray[i].getValue().substring(2);
            try {
                IlvRule ilvRule2 = this.getRuleModel().getRule("Subobject#" + string2, false);
                IlvCSSDeclaration[] ilvCSSDeclarationArray2 = ilvRule2.getCSSDeclarations();
                for (int j = 0; j < ilvCSSDeclarationArray2.length; ++j) {
                    if (!ilvCSSDeclarationArray2[j].getProperty().startsWith("actions")) continue;
                    String string3 = ilvCSSDeclarationArray2[j].getValue().substring(2);
                    IlvRule ilvRule3 = this.getRuleModel().getRule("Subobject#" + string3, false);
                    String string4 = ilvRule3.getDeclarationValue("parameterToModify");
                    if (!string.equals(string4)) continue;
                    this.getRuleModel().setAdjusting(true);
                    try {
                        this.getRuleModel().removeDeclaration(ilvRule, ilvCSSDeclarationArray[i].getProperty());
                        this.getRuleModel().removeRule(ilvRule2);
                        this.getRuleModel().removeRule(ilvRule3);
                        continue block5;
                    }
                    finally {
                        this.getRuleModel().setAdjusting(false);
                    }
                }
                continue;
            }
            catch (IlvStylingException ilvStylingException) {
                ilvStylingException.printStackTrace();
            }
        }
    }

    public void fireSymbolChanged(Object object, String string, Object object2, Object object3) {
        Object[] objectArray = this.m.getListenerList();
        SymbolChangedEvent symbolChangedEvent = new SymbolChangedEvent(this, object, string, object2, object3);
        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            ((SymbolChangedListener)objectArray[i]).symbolChanged(symbolChangedEvent);
        }
    }

    public void addParameterListChangedListener(ParameterListChangedListener parameterListChangedListener) {
        this.n.add(ParameterListChangedListener.class, parameterListChangedListener);
    }

    public void removeParameterListChangedListener(ParameterListChangedListener parameterListChangedListener) {
        this.n.remove(ParameterListChangedListener.class, parameterListChangedListener);
    }

    private void b(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
        Object[] objectArray = this.n.getListenerList();
        ParameterListChangedEvent parameterListChangedEvent = new ParameterListChangedEvent(this, 1, ilvPaletteSymbolParameter);
        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            ((ParameterListChangedListener)objectArray[i]).parameterAdded(parameterListChangedEvent);
        }
        this.a(parameterListChangedEvent);
    }

    private void c(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
        Object[] objectArray = this.n.getListenerList();
        ParameterListChangedEvent parameterListChangedEvent = new ParameterListChangedEvent(this, 2, ilvPaletteSymbolParameter);
        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            ((ParameterListChangedListener)objectArray[i]).parameterRemoved(parameterListChangedEvent);
        }
        this.a(parameterListChangedEvent);
    }

    private void a(IlvPaletteSymbolParameter[] ilvPaletteSymbolParameterArray) {
        Object[] objectArray = this.n.getListenerList();
        ParameterListChangedEvent parameterListChangedEvent = new ParameterListChangedEvent(this, ilvPaletteSymbolParameterArray);
        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            ((ParameterListChangedListener)objectArray[i]).parametersMoved(parameterListChangedEvent);
        }
        this.a(parameterListChangedEvent);
    }

    public void addParameterValueChangedListener(ParameterValueChangedListener parameterValueChangedListener) {
        this.o.add(ParameterValueChangedListener.class, parameterValueChangedListener);
    }

    public void removeParameterValueChangedListener(ParameterValueChangedListener parameterValueChangedListener) {
        this.o.remove(ParameterValueChangedListener.class, parameterValueChangedListener);
    }

    private void a(IlvPaletteSymbolParameter ilvPaletteSymbolParameter, Object object, Object object2) {
        Object[] objectArray = this.o.getListenerList();
        ParameterValueChangedEvent parameterValueChangedEvent = new ParameterValueChangedEvent(this, ilvPaletteSymbolParameter, object, object2);
        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            ((ParameterValueChangedListener)objectArray[i]).parameterValueChanged(parameterValueChangedEvent);
        }
        this.a(parameterValueChangedEvent);
    }

    public File setAutomaticIcon(IlvPaletteSymbol ilvPaletteSymbol) throws MalformedURLException {
        File file;
        block5: {
            Image image;
            block4: {
                file = null;
                if (ilvPaletteSymbol.getIconURL() == null) break block4;
                if (IlvURLUtil.lastPathComponent(ilvPaletteSymbol.getIconURL()).startsWith(ab)) break block4;
                if (!this.a.getIconURL().getFile().endsWith("/images/")) break block5;
            }
            if ((image = IlvSymbolEditorDocument.a(this.getToplevelGraphic(), 32, 32)) instanceof RenderedImage && (file = this.a((RenderedImage)((Object)image), ilvPaletteSymbol)) != null) {
                ilvPaletteSymbol.setIconURL(IlvURLUtil.convertFileToAbsoluteURL(file));
            }
        }
        return file;
    }

    private void a(IlvRule ilvRule, IlvRule ilvRule2, IlvGraphic ilvGraphic, IlvRect ilvRect, IlvRule[] ilvRuleArray, String string, boolean bl) throws IntrospectionException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IlvStylingException {
        IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)this.getRuleModel().getGraphicFromRule(ilvRule);
        this.a(ilvRule, ilvCompositeGraphic, ilvRule2, ilvGraphic, ilvRect, ilvRuleArray, string, bl, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int a(IlvRule ilvRule, IlvCompositeGraphic ilvCompositeGraphic, IlvRule ilvRule2, IlvGraphic ilvGraphic, IlvRect ilvRect, IlvRule[] ilvRuleArray, String string, boolean bl, boolean bl2, boolean bl3) throws IntrospectionException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IlvStylingException {
        int n;
        if (!(this.getToplevelGraphic() instanceof IlvCompositeGraphic)) {
            throw new IllegalArgumentException("Parent must be a composite graphic");
        }
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        String string2 = SymbolEditorUtilities.getUniqueGraphicName(this, string);
        ilvRule2.getSelector().setType("Subobject");
        ilvRule2.getSelector().setID(string2);
        ilvRule2.updateRule();
        ilvRule2.updateWeights();
        if (ilvGraphic instanceof IlvGeneralPath) {
            ((IlvGeneralPath)ilvGraphic).setTransformedShapeMode(true);
            ilvRule2.setDeclaration("transformedShapeMode", "true");
        }
        ilvRule2.setDeclaration("name", string2);
        IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
        if (ilvGraphicArray == null) {
            n = 0;
        } else {
            n = ilvGraphicArray.length;
            while (ilvGraphicArray[n - 1] == null) {
                --n;
            }
        }
        this.a(ilvSymbolRuleModel, true);
        try {
            int n2;
            ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
            if (bl) {
                arrayList.add(ilvRule2);
            }
            if (ilvRuleArray != null) {
                for (int i = 0; i < ilvRuleArray.length; ++i) {
                    if (ilvRuleArray[i] == ilvRule2) continue;
                    arrayList.add(ilvRuleArray[i]);
                }
            }
            ilvSymbolRuleModel.setDeclarationValue(ilvRule, "children[" + n + "]", "@+" + string2);
            this.addConstraint(ilvRule, ilvCompositeGraphic, string2, n, ilvRect, n > 0 ? bl3 : false, n > 0 ? bl3 : false, n > 0 ? bl3 : false);
            IlvRule[] ilvRuleArray2 = arrayList.toArray(new IlvRule[0]);
            this.c(ilvRuleArray2);
            for (n2 = 0; n2 < ilvRuleArray2.length; ++n2) {
                ilvSymbolRuleModel.addRule(ilvRuleArray2[n2]);
            }
            if (ilvRect.width > 0.0f && ilvRect.height > 0.0f) {
                ilvGraphic.moveResize(ilvRect);
                ilvSymbolRuleModel.updateGeometry(ilvGraphic, ilvRule2, false, null);
            }
            if (bl2) {
                this.applyChangesIfNecessary();
                this.setSelection(ilvRule2);
            }
            n2 = n;
            return n2;
        }
        finally {
            this.a(ilvSymbolRuleModel, false);
        }
    }

    public void addConstraint(IlvRule ilvRule, IlvCompositeGraphic ilvCompositeGraphic, String string, int n, IlvRect ilvRect, boolean bl, boolean bl2, boolean bl3) throws IntrospectionException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IlvStylingException {
        Object object;
        IlvAttachmentConstraint ilvAttachmentConstraint = new IlvAttachmentConstraint();
        if (ilvCompositeGraphic.getLayout() instanceof IlvAttachmentLayout) {
            if (n > 0) {
                ilvAttachmentConstraint.setRelativeOffset(bl3);
                object = SymbolEditorUtilities.getAttachmentBounds(ilvCompositeGraphic.getChildren(0));
                if (!bl3) {
                    ilvAttachmentConstraint.setOffset(new IlvPoint(ilvRect.x - ((Rectangle2D.Float)object).x, ilvRect.y - ((Rectangle2D.Float)object).y));
                } else {
                    ilvAttachmentConstraint.setOffset(new IlvPoint((ilvRect.x - ((Rectangle2D.Float)object).x) / ((Rectangle2D.Float)object).width, (ilvRect.y - ((Rectangle2D.Float)object).y) / ((Rectangle2D.Float)object).height));
                }
                ilvAttachmentConstraint.setRelativeSize(bl);
                if (bl) {
                    if (ilvRect.width > 0.0f) {
                        ilvAttachmentConstraint.setWidth(ilvRect.width / ((Rectangle2D.Float)object).width);
                    }
                    if (ilvRect.height > 0.0f) {
                        ilvAttachmentConstraint.setHeight(ilvRect.height / ((Rectangle2D.Float)object).height);
                    }
                }
            }
            if (bl2 && !bl) {
                if (ilvRect.width > 0.0f) {
                    ilvAttachmentConstraint.setWidth(ilvRect.width);
                }
                if (ilvRect.height > 0.0f) {
                    ilvAttachmentConstraint.setHeight(ilvRect.height);
                }
            }
        }
        object = string + "Attachment";
        IlvCSSWriter ilvCSSWriter = new IlvCSSWriter(this.f.getDOMImplementation());
        IlvCSSWriter.IlvCSSCustomizerDeclarations ilvCSSCustomizerDeclarations = ilvCSSWriter.convert("Subobject#" + (String)object, ilvAttachmentConstraint, null);
        this.getRuleModel().setDeclarationValue(ilvRule, "constraints[" + n + "]", "@+" + (String)object);
        IlvRule ilvRule2 = this.getRuleModel().getRule("Subobject#" + (String)object, true);
        Declaration[] declarationArray = ilvCSSCustomizerDeclarations.getDeclarations();
        for (int i = 0; i < declarationArray.length; ++i) {
            this.getRuleModel().setDeclarationValue(ilvRule2, declarationArray[i].getProperty(), declarationArray[i].getValue());
        }
    }

    public void removeConstraint(String string) {
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        IlvRule[] ilvRuleArray = ilvSymbolRuleModel.getRulesFromId(IlvRuleModel.ALL_RULES, string + "Attachment");
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            ilvSymbolRuleModel.removeRule(ilvRuleArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlvRule addObject(IlvGraphic ilvGraphic, String string, IlvRect ilvRect) throws IntrospectionException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IlvStylingException {
        this.a(this.getRuleModel(), true);
        try {
            IlvCSSWriter ilvCSSWriter = new IlvCSSWriter(this.f.getDOMImplementation());
            IlvCSSWriter.IlvCSSCustomizerDeclarations ilvCSSCustomizerDeclarations = ilvCSSWriter.convert(string, ilvGraphic, null);
            IlvRule ilvRule = this.getRuleModel().getRule(string, true);
            ilvRule.setDeclarations(ilvCSSCustomizerDeclarations.getDeclarations());
            ilvRule.setDeclaration("name", string);
            this.a(this.getToplevelRule(), ilvRule, ilvGraphic, ilvRect, ilvCSSCustomizerDeclarations.getAdditionalRules(), string, false);
            IlvRule ilvRule2 = ilvRule;
            return ilvRule2;
        }
        finally {
            this.a(this.getRuleModel(), false);
        }
    }

    public void addGraphic(IlvGraphic ilvGraphic, boolean bl, IlvRect ilvRect) {
        IlvGraphic ilvGraphic2;
        String string = ilvGraphic.getName();
        if (string == null) {
            string = ilvGraphic.getClass().getName();
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            if (string.startsWith("Ilv")) {
                string = string.substring(3);
            }
        }
        if ((ilvGraphic2 = SymbolEditorUtilities.translateGraphic(ilvGraphic, bl)) instanceof IlvGeneralPath && !bl) {
            ((IlvGeneralPath)ilvGraphic2).setPointEditionAllowed(false);
        }
        if (ilvGraphic2 instanceof IlvText && bl) {
            ((IlvText)ilvGraphic2).setAutoWrappingSizeMode(true);
        }
        if (ilvRect == null) {
            ilvRect = SymbolEditorUtilities.getAttachmentBounds(ilvGraphic2);
        }
        try {
            this.beginAggregateUndoableEdits(MessageFormat.format(this.getString("SymbolEditor.Undo.Add"), string));
            this.addObject(ilvGraphic2, string, ilvRect);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            this.endAggregateUndoableEdits();
        }
    }

    public void addSymbol(IlvPaletteSymbol ilvPaletteSymbol, IlvPoint ilvPoint) {
        if (ilvPaletteSymbol == this.b) {
            JOptionPane.showMessageDialog(null, this.r.getString("SymbolEditor.CannotAddSymbolToItself"), this.r.getString("SymbolEditor.CannotAddSubSymbol.Title"), 0);
            return;
        }
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        this.a(ilvSymbolRuleModel, true);
        try {
            Object object;
            Serializable serializable;
            String string = ilvPaletteSymbol.getName();
            IlvRule ilvRule = IlvRuleUtils.createRule(this.f.getDOMImplementation(), string);
            ilvRule.setDeclaration("class", ilvPaletteSymbol.createClassDeclarationValue());
            IlvConvertForSetters ilvConvertForSetters = new IlvConvertForSetters();
            for (int i = 0; i < ilvPaletteSymbol.getParameterCount(); ++i) {
                serializable = ilvPaletteSymbol.getParameter(i);
                object = ((IlvPaletteSymbolParameter)serializable).getValue();
                String string2 = null;
                if (object != null) {
                    if (object instanceof String) {
                        string2 = (String)object;
                    } else {
                        PropertyEditor propertyEditor = ((IlvPaletteSymbolParameter)serializable).getPropertyEditor();
                        if (propertyEditor != null) {
                            try {
                                propertyEditor.setValue(object);
                                string2 = propertyEditor.getAsText();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (string2 == null) {
                            string2 = ilvConvertForSetters.convertBack(object, object.getClass(), null);
                        }
                    }
                }
                if (string2 == null) {
                    string2 = "";
                }
                ilvRule.setDeclaration(((IlvPaletteBaseObject)serializable).getName(), string2);
            }
            IlvSymbolEditorDocument ilvSymbolEditorDocument = new IlvSymbolEditorDocument(ilvPaletteSymbol, this.getComponentType(), this.e, null, null);
            serializable = ilvSymbolEditorDocument.getToplevelGraphic();
            if (SymbolEditorUtilities.containsSubSymbol((IlvGraphic)serializable, this.b)) {
                JOptionPane.showMessageDialog(null, this.r.getString("SymbolEditor.CircularSymbolDependency"), this.r.getString("SymbolEditor.CannotAddSubSymbol.Title"), 0);
                return;
            }
            object = new IlvRect(ilvPoint.x, ilvPoint.y, 0.0f, 0.0f);
            this.a(this.getToplevelRule(), ilvRule, (IlvGraphic)serializable, (IlvRect)object, null, string, true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            this.a(ilvSymbolRuleModel, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(IlvGraphic ilvGraphic) {
        if (!(ilvGraphic.getGraphicBag() instanceof IlvCompositeGraphic)) {
            throw new IllegalArgumentException("Parent must be a composite graphic");
        }
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        IlvRule ilvRule = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvGraphic);
        this.a((Object)ilvRule);
        this.a(ilvSymbolRuleModel, true);
        try {
            IlvRule[] ilvRuleArray = this.b(ilvGraphic);
            this.a(ilvGraphic);
            for (int i = 0; i < ilvRuleArray.length; ++i) {
                if (ilvSymbolRuleModel.getSharpRuleUsageCount(ilvRuleArray[i].getSelector().getID()) != 0) continue;
                ilvSymbolRuleModel.removeRule(ilvRuleArray[i]);
            }
        }
        finally {
            this.a(ilvSymbolRuleModel, false);
        }
    }

    private void a(IlvGraphic ilvGraphic, IlvAttachmentConstraint ilvAttachmentConstraint, IlvCompositeGraphic ilvCompositeGraphic, IlvRule ilvRule, int n) {
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        ilvSymbolRuleModel.setDeclarationValue(ilvRule, "children[" + n + "]", "@+" + ilvGraphic.getName());
        ilvCompositeGraphic.setChildren(n, ilvGraphic);
        ilvGraphic.setGraphicBag(ilvCompositeGraphic);
        String string = ilvGraphic.getName() + "Attachment";
        try {
            if (n > 0) {
                boolean bl = ilvCompositeGraphic.getLayout() instanceof IlvAttachmentLayout;
                if (ilvSymbolRuleModel.getRule("Subobject#" + string, bl) != null) {
                    ilvSymbolRuleModel.setDeclarationValue(ilvRule, "constraints[" + n + "]", "@+" + string);
                    ilvCompositeGraphic.setConstraints(n, ilvAttachmentConstraint);
                }
            } else {
                ilvSymbolRuleModel.removeDeclaration(ilvRule, "constraints[" + n + "]");
                ilvCompositeGraphic.setConstraints(n, null);
            }
        }
        catch (IlvStylingException ilvStylingException) {
            ilvStylingException.printStackTrace();
        }
    }

    private void a(IlvGraphic ilvGraphic) {
        int n;
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic.getGraphicBag();
        int n2 = -1;
        IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
        Object[] objectArray = ilvCompositeGraphic.getConstraints();
        IlvEventMap[] ilvEventMapArray = ilvCompositeGraphic.getEventMaps();
        for (int i = 0; i < ilvGraphicArray.length; ++i) {
            if (ilvGraphicArray[i] != ilvGraphic) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            throw new RuntimeException("Cannot find child " + ilvGraphic.getName() + " in parent " + ilvCompositeGraphic);
        }
        IlvRule[] ilvRuleArray = ilvSymbolRuleModel.getAllRulesFromGraphic(ilvCompositeGraphic);
        for (n = 0; n < ilvRuleArray.length; ++n) {
            IlvRule ilvRule = ilvRuleArray[n];
            for (int i = n2 + 1; i < ilvGraphicArray.length; ++i) {
                IlvEventMap ilvEventMap;
                Object object;
                IlvGraphic ilvGraphic2;
                block17: {
                    ilvGraphic2 = ilvGraphicArray[i];
                    object = null;
                    if (objectArray != null && i < objectArray.length) {
                        object = objectArray[i];
                    }
                    ilvEventMap = null;
                    if (ilvEventMapArray != null && i < ilvEventMapArray.length) {
                        ilvEventMap = ilvEventMapArray[i];
                    }
                    if (ilvGraphic2 != null) {
                        ilvSymbolRuleModel.setDeclarationValue(ilvRule, "children[" + (i - 1) + "]", "@+" + ilvGraphic2.getName());
                        try {
                            if (ilvSymbolRuleModel.getRule("Subobject#" + ilvGraphic2.getName() + "Attachment", false) != null) {
                                ilvSymbolRuleModel.setDeclarationValue(ilvRule, "constraints[" + (i - 1) + "]", "@+" + ilvGraphic2.getName() + "Attachment");
                            }
                            if (ilvEventMap != null) {
                                if (ilvSymbolRuleModel.getRule("Subobject#" + ilvGraphic2.getName() + "EventMap", false) != null) {
                                    ilvSymbolRuleModel.setDeclarationValue(ilvRule, "eventMaps[" + (i - 1) + "]", "@+" + ilvGraphic2.getName() + "EventMap");
                                    break block17;
                                }
                            }
                            ilvSymbolRuleModel.removeDeclaration(ilvRule, "eventMaps[" + (i - 1) + "]");
                        }
                        catch (IlvStylingException ilvStylingException) {
                            ilvStylingException.printStackTrace();
                        }
                    } else {
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "children[" + (i - 1) + "]");
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "constraints[" + (i - 1) + "]");
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "eventMaps[" + (i - 1) + "]");
                    }
                }
                if (n != 0) continue;
                if (i == ilvGraphicArray.length - 1) {
                    ilvCompositeGraphic.setChildren(i, null);
                    ilvCompositeGraphic.setConstraints(i, null);
                    ilvCompositeGraphic.setEventMaps(i, null);
                }
                ilvCompositeGraphic.setChildren(i - 1, ilvGraphic2);
                ilvCompositeGraphic.setConstraints(i - 1, object);
                ilvCompositeGraphic.setEventMaps(i - 1, ilvEventMap);
            }
            ilvSymbolRuleModel.removeDeclaration(ilvRule, "children[" + (ilvGraphicArray.length - 1) + "]");
            ilvSymbolRuleModel.removeDeclaration(ilvRule, "constraints[" + (ilvGraphicArray.length - 1) + "]");
            ilvSymbolRuleModel.removeDeclaration(ilvRule, "eventMaps[" + (ilvGraphicArray.length - 1) + "]");
        }
        if (n2 == ilvGraphicArray.length - 1) {
            ilvCompositeGraphic.setChildren(n2, null);
            ilvCompositeGraphic.setConstraints(n2, null);
            ilvCompositeGraphic.setEventMaps(n2, null);
        }
        if ((ilvGraphicArray = ilvCompositeGraphic.getChildren()) != null) {
            for (n = 0; n < ilvGraphicArray.length; ++n) {
                if (ilvGraphicArray[n] == null) continue;
                ilvGraphicArray[n].setGraphicBag(ilvCompositeGraphic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCondition(IlvRule ilvRule) {
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        String string = ilvRule.getSelector().getID();
        IlvRule ilvRule2 = ilvRule.copy();
        ilvRule2.getSelector().setID(string + "Attachment");
        ilvRule2 = ilvSymbolRuleModel.getSameRule(ilvRule2);
        this.a((Object)ilvRule);
        this.a(ilvSymbolRuleModel, true);
        try {
            IlvRule[] ilvRuleArray = this.a(ilvRule);
            for (int i = 0; i < ilvRuleArray.length; ++i) {
                ilvSymbolRuleModel.removeRule(ilvRuleArray[i]);
            }
            if (ilvRule2 != null) {
                ilvSymbolRuleModel.removeRule(ilvRule2);
            }
        }
        finally {
            this.a(ilvSymbolRuleModel, false);
        }
    }

    public void renameSymbol(String string) {
        String string2 = this.a.getName();
        if (!string2.equals(string)) {
            this.a.setName(string);
            this.a.setID(string);
            if (this.b != null && this.b.getPalette() != null) {
                String string3 = this.b.getPalette().getPackageName() + "symbols/" + string2 + ".css";
                ArrayList arrayList = this.e.getPalettesToUpdate(string3);
                if (arrayList != null) {
                    String string4 = new String();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        string4 = string4 + ((IlvPalette)arrayList.get(i)).getName() + "\n";
                    }
                    String string5 = MessageFormat.format(this.r.getString("SymbolEditor.ConfirmSymbolReferenceUpdate.Message"), string4);
                    String string6 = this.r.getString("SymbolEditor.ConfirmSymbolReferenceUpdate.Title");
                    int n = JOptionPane.showOptionDialog(null, string5, string6, 0, 2, null, null, null);
                    if (n != 1 && n != -1) {
                        this.e.updateSymbolReferences(arrayList, string3, string2, string);
                    }
                }
            }
            this.fireSymbolChanged(this.a, "name", string2, string);
        }
    }

    public void renameParameter(IlvPaletteSymbolParameter ilvPaletteSymbolParameter, String string) {
        String string2 = ilvPaletteSymbolParameter.getName();
        if (!string2.equals(string)) {
            ilvPaletteSymbolParameter.setName(string);
            ilvPaletteSymbolParameter.setID(string);
            this.fireSymbolChanged(ilvPaletteSymbolParameter, "name", string2, string);
        }
    }

    public void renameObject(IlvGraphic ilvGraphic, String string) {
        this.a(ilvGraphic, string, true, false);
        this.setSelection(this.getSelection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvGraphic ilvGraphic, String string, boolean bl, boolean bl2) {
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        boolean bl3 = this.ah;
        this.ah = true;
        this.a(ilvSymbolRuleModel, true);
        try {
            String string2 = ilvGraphic.getName();
            if (!bl2) {
                if (string2.startsWith("port_")) {
                    if (!string.startsWith("port_")) {
                        if (string2.startsWith("port_inout_")) {
                            string = "port_inout_" + string;
                        } else if (string2.startsWith("port_in_")) {
                            string = "port_in_" + string;
                        } else if (string2.startsWith("port_out_")) {
                            string = "port_out_" + string;
                        }
                    }
                }
            }
            if (!string2.equals(string)) {
                ilvGraphic.setName(string);
                this.a(ilvSymbolRuleModel.getAllRules(true), string2, string, true);
                if (bl) {
                    this.a(ilvSymbolRuleModel.getMainRuleFromGraphic(ilvGraphic), string2, string);
                }
            }
        }
        finally {
            this.a(ilvSymbolRuleModel, false);
            this.ah = bl3;
        }
    }

    private static void b(IlvRule ilvRule, IlvRule ilvRule2) {
        String string = ilvRule2.getName();
        IlvSelector ilvSelector = ilvRule2.getSelector();
        if (ilvSelector != null) {
            if (ilvSelector.getID() != null) {
                if (string.startsWith(ilvSelector.getID() + "[")) {
                    string = string.substring(ilvSelector.getID().length() + 1);
                }
            }
            if (string.endsWith("]")) {
                string = string.substring(0, string.length() - 1);
            }
            ilvRule.setName(string);
        }
    }

    public void cut(Clipboard clipboard) {
        this.a(this.getRuleModel(), true);
        try {
            this.copy(clipboard);
            this.delete();
        }
        finally {
            this.a(this.getRuleModel(), false);
        }
    }

    public void copy(Clipboard clipboard) {
        List list = this.getSelection();
        clipboard.a();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (IlvSymbolEditorDocument.isConditionSelection(e)) {
                clipboard.a(new ConditionClipboardElement(this.a((IlvRule)e)));
                continue;
            }
            if (this.c(e)) {
                IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e);
                if (ilvGraphic == null) continue;
                clipboard.a(new GraphicClipboardElement(ilvGraphic, this.b(ilvGraphic)));
                continue;
            }
            if (!this.d(e)) continue;
            clipboard.a(new ParameterClipboardElement((IlvPaletteSymbolParameter)e));
        }
    }

    public void paste(Clipboard clipboard) {
        this.setSelection(clipboard.b(this));
    }

    public boolean canPaste(Clipboard clipboard) {
        return clipboard.a(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        this.a(this.getRuleModel(), true);
        try {
            List list = this.getSelection();
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (IlvSymbolEditorDocument.isConditionSelection(e)) {
                    this.removeCondition((IlvRule)e);
                    continue;
                }
                if (this.c(e)) {
                    IlvRule ilvRule = (IlvRule)e;
                    int n = this.a(ilvRule, false, false, false);
                    if (n < 0) continue;
                    IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)this.getToplevelGraphic();
                    IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule(ilvRule);
                    IlvCompositeGraphic ilvCompositeGraphic2 = (IlvCompositeGraphic)ilvGraphic.getGraphicBag();
                    IlvRule ilvRule2 = this.getRuleModel().getMainRuleFromGraphic(ilvCompositeGraphic2);
                    if (n > 0) {
                        this.a(ilvCompositeGraphic2, n);
                    }
                    if (ilvCompositeGraphic2 != ilvCompositeGraphic) {
                        SymbolEditorUtilities.disableLayout((IlvCompositeGraphic)ilvCompositeGraphic2.getGraphicBag());
                    } else {
                        SymbolEditorUtilities.disableLayout(ilvCompositeGraphic2);
                    }
                    this.removeObject(ilvGraphic);
                    this.getRuleModel().updateGeometry(ilvCompositeGraphic2, ilvRule2, false, null);
                    if (ilvCompositeGraphic2 != ilvCompositeGraphic) {
                        SymbolEditorUtilities.enableLayout((IlvCompositeGraphic)ilvCompositeGraphic2.getGraphicBag());
                        continue;
                    }
                    SymbolEditorUtilities.enableLayout(ilvCompositeGraphic2);
                    continue;
                }
                if (!this.d(e)) continue;
                this.removeParameter((IlvPaletteSymbolParameter)e);
            }
        }
        finally {
            this.a(this.getRuleModel(), false);
        }
    }

    public boolean canCopy() {
        return this.hasSelection(false, false);
    }

    public boolean canDelete() {
        return this.hasSelection(true, false) && !this.c();
    }

    private boolean c() {
        List list = this.getSelection();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!this.c(e)) continue;
            IlvRule ilvRule = (IlvRule)e;
            IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule(ilvRule);
            IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic.getGraphicBag();
            if (!(ilvCompositeGraphic.getLayout() instanceof IlvCenteredLayout)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelection(boolean bl, boolean bl2) {
        if (!(this.getToplevelGraphic() instanceof IlvCompositeGraphic)) {
            return false;
        }
        List list = this.getSelection();
        if (list.size() == 0) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (this.c(e)) {
                IlvGraphicBag ilvGraphicBag;
                IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e);
                if (ilvGraphic == this.getToplevelGraphic()) {
                    return false;
                }
                if (!bl || !((ilvGraphicBag = ilvGraphic.getGraphicBag()) instanceof IlvCompositeGraphic)) continue;
                IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphicBag;
                IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
                boolean bl3 = true;
                for (int j = 0; j < ilvGraphicArray.length; ++j) {
                    IlvRule ilvRule;
                    IlvGraphic ilvGraphic2 = ilvGraphicArray[j];
                    if (ilvGraphic2 == null || list.contains(ilvRule = this.getRuleModel().getMainRuleFromGraphic(ilvGraphic2))) continue;
                    bl3 = false;
                    break;
                }
                if (!bl3) continue;
                return false;
            }
            if (!IlvSymbolEditorDocument.isConditionSelection(e) && !this.d(e)) {
                return false;
            }
            if (!bl2) continue;
            return false;
        }
        return true;
    }

    private int a(IlvRule ilvRule, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        int n = 0;
        String string = null;
        if (this.c(ilvRule) && (object2 = (IlvGraphic)((Object)((IlvGraphic)(object = this.getRuleModel().getGraphicFromRule(ilvRule))).getGraphicBag())) instanceof IlvCompositeGraphic) {
            IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)object2;
            IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
            int n2 = -1;
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                if (ilvGraphicArray[i] != object) continue;
                n2 = i;
                break;
            }
            if (!bl && !bl2) {
                if (n2 == n) {
                    n = n2 + 1;
                }
            } else if (bl) {
                if (bl3) {
                    if (n == 0) {
                        n = n2;
                    }
                } else if (n2 == 1) {
                    n = 1;
                }
            } else if (bl2 && n2 == n) {
                n = n2 + 1;
            }
            if (n != 0) {
                string = ilvGraphicArray[n].getName();
            }
        }
        if (n != 0) {
            object = MessageFormat.format(this.r.getString("SymbolEditor.ConfirmNewBase.Message"), string);
            object2 = this.r.getString("SymbolEditor.ConfirmNewBase.Title");
            int n3 = JOptionPane.showOptionDialog(null, object, (String)object2, 0, 2, null, null, null);
            if (n3 == 1 || n3 == -1) {
                return -1;
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void a(IlvCompositeGraphic var1_1, int var2_2) {
        if (!(var1_1.getLayout() instanceof IlvAttachmentLayout)) {
            return;
        }
        var3_3 = this.getRuleModel();
        var4_4 = var1_1.getChildren();
        var5_5 = SymbolEditorUtilities.getAttachmentBounds(var4_4[var2_2]);
        if (var1_1 == this.getToplevelGraphic()) {
            this.t = this.s;
            this.s = new IlvPoint(var5_5.x, var5_5.y);
        }
        for (var6_6 = 0; var6_6 < var4_4.length; ++var6_6) {
            var7_7 = var4_4[var6_6];
            if (var7_7 == null) continue;
            var8_8 = var3_3.getMainRuleFromGraphic(var7_7);
            var9_9 = (IlvAttachmentConstraint)var1_1.getConstraints(var6_6);
            var10_10 = var9_9.getAnchor().getValue(var1_1.getAttachables()[var2_2]);
            var11_11 = var9_9.getHotSpot().getValue(var1_1.getAttachables()[var6_6]);
            var12_12 = new IlvPoint(var11_11.x - var10_10.x, var11_11.y - var10_10.y);
            if (var6_6 == var2_2) {
                var13_13 /* !! */  = var3_3.getAllRulesFromGraphic(var1_1);
                var13_13 /* !! */  = var3_3.getAllRules(true);
                var14_15 = var7_7.getName() + "Attachment";
                var15_16 /* !! */  = new ArrayList<IlvRule>();
                for (var16_17 = 0; var16_17 < var13_13 /* !! */ .length; ++var16_17) {
                    var17_19 = var13_13 /* !! */ [var16_17];
                    if (var17_19.getSelector() == null || !var14_15.equals(var17_19.getSelector().getID())) continue;
                    var15_16 /* !! */ .add((IlvRule)var17_19);
                }
                for (var16_17 = 0; var16_17 < var15_16 /* !! */ .size(); ++var16_17) {
                    var17_19 = (IlvRule)var15_16 /* !! */ .get(var16_17);
                    var3_3.removeDeclaration((IlvRule)var17_19, "offsetX");
                    var3_3.removeDeclaration((IlvRule)var17_19, "offsetY");
                    var3_3.removeDeclaration((IlvRule)var17_19, "relativeOffset");
                    var3_3.removeDeclaration((IlvRule)var17_19, "rotationAngle");
                    var3_3.removeDeclaration((IlvRule)var17_19, "rotationCenterRelativeToBase");
                    var3_3.removeDeclaration((IlvRule)var17_19, "rotationCenter");
                    var3_3.removeDeclaration((IlvRule)var17_19, "anchor");
                    var3_3.removeDeclaration((IlvRule)var17_19, "hotSpot");
                    var18_20 = var3_3.getDeclarationValue((IlvRule)var17_19, "relativeSize");
                    if (var18_20 != null) {
                        if (var18_20.equalsIgnoreCase("true")) {
                            var19_21 = SymbolEditorUtilities.getAttachmentBounds(var4_4[0]);
                            var20_22 = var3_3.getDeclarationValue((IlvRule)var17_19, "height");
                            var21_23 = var3_3.getDeclarationValue((IlvRule)var17_19, "width");
                            if (var21_23 != null) {
                                var3_3.setDeclarationValue((IlvRule)var17_19, "width", String.valueOf(var19_21.width * Float.valueOf(var21_23).floatValue()));
                            }
                            if (var20_22 != null) {
                                var3_3.setDeclarationValue((IlvRule)var17_19, "height", String.valueOf(var19_21.height * Float.valueOf(var20_22).floatValue()));
                            }
                        }
                    }
                    var3_3.removeDeclaration((IlvRule)var17_19, "relativeSize");
                }
                continue;
            }
            try {
                var13_13 /* !! */  = var3_3.getRule("Subobject#" + var7_7.getName() + "Attachment", true);
                var3_3.setDeclarationValue((IlvRule)var13_13 /* !! */ , "class", IlvAttachmentConstraint.class.getName());
                var14_15 = var3_3.getMainRuleFromGraphic(var1_1);
                var3_3.setDeclarationValue((IlvRule)var14_15, "constraints[" + var6_6 + "]", "@+" + var7_7.getName() + "Attachment");
                var15_16 /* !! */  = SymbolEditorUtilities.getAttachmentBounds(var7_7);
                var16_18 = var3_3.getDeclarationValue((IlvRule)var13_13 /* !! */ , "relativeSize");
                if (var16_18 != null) {
                    if (var16_18.equalsIgnoreCase("true")) {
                        if (!this.getRuleModel().isBound((IlvRule)var13_13 /* !! */ , "width")) {
                            var3_3.setDeclarationValue((IlvRule)var13_13 /* !! */ , "width", String.valueOf(var15_16 /* !! */ .width / var5_5.width));
                        }
                    }
                }
                if (var16_18 != null) {
                    if (var16_18.equalsIgnoreCase("true")) {
                        if (!this.getRuleModel().isBound((IlvRule)var13_13 /* !! */ , "height")) {
                            var3_3.setDeclarationValue((IlvRule)var13_13 /* !! */ , "height", String.valueOf(var15_16 /* !! */ .height / var5_5.height));
                        }
                    }
                }
                var17_19 = var3_3.getDeclarationValue((IlvRule)var13_13 /* !! */ , "relativeOffset");
                if (var17_19 == null) ** GOTO lbl-1000
                if (var17_19.equalsIgnoreCase("true")) {
                    if (!this.getRuleModel().isBound((IlvRule)var13_13 /* !! */ , "offsetX")) {
                        var3_3.setDeclarationValue((IlvRule)var13_13 /* !! */ , "offsetX", String.valueOf(var12_12.x / var5_5.width));
                    }
                    if (!this.getRuleModel().isBound((IlvRule)var13_13 /* !! */ , "offsetY")) {
                        var3_3.setDeclarationValue((IlvRule)var13_13 /* !! */ , "offsetY", String.valueOf(var12_12.y / var5_5.height));
                    }
                } else lbl-1000:
                // 2 sources

                {
                    if (!this.getRuleModel().isBound((IlvRule)var13_13 /* !! */ , "offsetX")) {
                        var3_3.setDeclarationValue((IlvRule)var13_13 /* !! */ , "offsetX", String.valueOf(var12_12.x));
                    }
                    if (!this.getRuleModel().isBound((IlvRule)var13_13 /* !! */ , "offsetY")) {
                        var3_3.setDeclarationValue((IlvRule)var13_13 /* !! */ , "offsetY", String.valueOf(var12_12.y));
                    }
                }
                var3_3.removeDeclaration((IlvRule)var13_13 /* !! */ , "rotationAngle");
                continue;
            }
            catch (IlvStylingException var13_14) {
                var13_14.printStackTrace();
            }
        }
    }

    public void group() {
        List list = this.getSelection();
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        IlvRule ilvRule = null;
        this.a(ilvSymbolRuleModel, true);
        try {
            Object object;
            Object object2;
            Object object3;
            IlvRect ilvRect = null;
            ArrayList<IlvGraphic> arrayList = new ArrayList<IlvGraphic>();
            ArrayList<IlvAttachmentConstraint> arrayList2 = new ArrayList<IlvAttachmentConstraint>();
            ArrayList<IlvRect> arrayList3 = new ArrayList<IlvRect>();
            IlvRule ilvRule2 = null;
            IlvCompositeGraphic ilvCompositeGraphic = null;
            this.clearSelection();
            for (int i = 0; i < list.size(); ++i) {
                object3 = list.get(i);
                if (!this.c(object3)) continue;
                object2 = ilvSymbolRuleModel.getGraphicFromRule((IlvRule)object3);
                object = SymbolEditorUtilities.getAttachmentConstraint((IlvGraphic)object2);
                if (i == 0) {
                    ilvCompositeGraphic = (IlvCompositeGraphic)((IlvGraphic)object2).getGraphicBag();
                    ilvRule2 = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvCompositeGraphic);
                    ilvRect = SymbolEditorUtilities.getAttachmentBounds((IlvGraphic)object2);
                } else {
                    ilvRect.add(SymbolEditorUtilities.getAttachmentBounds((IlvGraphic)object2));
                }
                arrayList.add((IlvGraphic)object2);
                arrayList2.add((IlvAttachmentConstraint)object);
                arrayList3.add(SymbolEditorUtilities.getAttachmentBounds((IlvGraphic)object2));
            }
            String string = SymbolEditorUtilities.getUniqueGraphicName(this, "Group");
            object3 = new IlvCompositeGraphic();
            ((IlvCompositeGraphic)object3).setSelectionType(3);
            ((IlvCompositeGraphic)object3).setTransformationMode(1);
            ((IlvCompositeGraphic)object3).setResizingPolicy(0);
            ((IlvGraphic)object3).setName(string);
            ilvRule = ilvSymbolRuleModel.getRule("#" + string, true);
            ilvRule.setDeclaration("class", object3.getClass().getName());
            ilvRule.setDeclaration("selectionType", String.valueOf(3));
            ilvRule.setDeclaration("transformationMode", String.valueOf(1));
            ilvRule.setDeclaration("resizingPolicy", String.valueOf(0));
            object2 = string + "Layout";
            object = ilvSymbolRuleModel.getRule("Subobject#" + (String)object2, true);
            object.setDeclaration("class", ((IlvCompositeGraphic)object3).getLayout().getClass().getName());
            ilvRule.setDeclaration("layout", "@+" + (String)object2);
            for (int i = 0; i < arrayList.size(); ++i) {
                IlvRect ilvRect2;
                IlvGraphic ilvGraphic = (IlvGraphic)arrayList.get(i);
                IlvAttachmentConstraint ilvAttachmentConstraint = (IlvAttachmentConstraint)arrayList2.get(i);
                this.a(ilvGraphic);
                this.removeConstraint(ilvGraphic.getName());
                this.a(ilvGraphic, ilvAttachmentConstraint, (IlvCompositeGraphic)object3, ilvRule, i);
                if (i > 0) {
                    ilvRect2 = (IlvRect)arrayList3.get(i);
                    ilvGraphic.move(ilvRect2.x, ilvRect2.y);
                    this.addConstraint(ilvRule, (IlvCompositeGraphic)object3, ilvGraphic.getName(), i, ilvRect2, ilvAttachmentConstraint.isRelativeSize(), ilvAttachmentConstraint.getSize() != null, ilvAttachmentConstraint.isRelativeOffset());
                    continue;
                }
                ilvRect2 = (IlvRect)arrayList3.get(i);
                ilvRect2.width = 0.0f;
                ilvRect2.height = 0.0f;
                this.addConstraint(ilvRule, (IlvCompositeGraphic)object3, ilvGraphic.getName(), i, ilvRect2, false, ilvAttachmentConstraint.getSize() != null, false);
            }
            ilvRect.width = 0.0f;
            ilvRect.height = 0.0f;
            this.a(ilvRule2, ilvRule, (IlvGraphic)object3, ilvRect, null, string, false);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            this.a(ilvSymbolRuleModel, false);
        }
        this.setSelection(ilvRule);
    }

    private boolean a(int n) {
        List list = this.getSelection();
        int n2 = 0;
        IlvCompositeGraphic ilvCompositeGraphic = null;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (this.c(e)) {
                IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e);
                if (!(ilvGraphic.getGraphicBag() instanceof IlvCompositeGraphic)) {
                    return false;
                }
                IlvCompositeGraphic ilvCompositeGraphic2 = (IlvCompositeGraphic)ilvGraphic.getGraphicBag();
                if (ilvCompositeGraphic == null) {
                    ilvCompositeGraphic = ilvCompositeGraphic2;
                } else if (ilvCompositeGraphic2 != ilvCompositeGraphic) {
                    return false;
                }
                if (SymbolEditorUtilities.getCompositeChildIndex(ilvGraphic) == 0) {
                    return false;
                }
                ++n2;
                continue;
            }
            return false;
        }
        return n2 >= n;
    }

    public boolean canGroup() {
        return this.a(2);
    }

    public void ungroup() {
        List list = this.getSelection();
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        this.a(ilvSymbolRuleModel, true);
        try {
            this.clearSelection();
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                IlvGraphicSet ilvGraphicSet;
                Object e = list.get(i);
                if (!this.c(e)) continue;
                IlvGraphic ilvGraphic = ilvSymbolRuleModel.getGraphicFromRule((IlvRule)e);
                IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic.getGraphicBag();
                IlvRule ilvRule = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvCompositeGraphic);
                if (ilvGraphic instanceof IlvCompositeGraphic) {
                    ilvGraphicSet = (IlvCompositeGraphic)ilvGraphic;
                    object = ((IlvCompositeGraphic)ilvGraphicSet).getChildren();
                    if (object != null) {
                        Object[] objectArray;
                        IlvGraphic[] ilvGraphicArray = new IlvGraphic[((IlvGraphic[])object).length];
                        System.arraycopy(object, 0, ilvGraphicArray, 0, ((IlvGraphic[])object).length);
                        object = ilvGraphicArray;
                        Object[] objectArray2 = ((IlvCompositeGraphic)ilvGraphicSet).getConstraints();
                        if (objectArray2 != null) {
                            objectArray = new Object[objectArray2.length];
                            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
                            objectArray2 = objectArray;
                        }
                        objectArray = new IlvRect[((IlvGraphic[])object).length];
                        for (int j = 0; j < ((IlvGraphic[])object).length; ++j) {
                            IlvGraphic ilvGraphic2 = object[j];
                            if (ilvGraphic2 == null) continue;
                            objectArray[j] = SymbolEditorUtilities.getAttachmentBounds(ilvGraphic2);
                        }
                        IlvGraphic[] ilvGraphicArray2 = ilvCompositeGraphic.getChildren();
                        int n = ilvGraphicArray2.length;
                        while (ilvGraphicArray2[n - 1] == null) {
                            --n;
                        }
                        ArrayList<IlvGraphic> arrayList2 = new ArrayList<IlvGraphic>();
                        for (int j = 0; j < ((IlvGraphic[])object).length; ++j) {
                            IlvGraphic ilvGraphic3 = object[j];
                            if (ilvGraphic3 == null) continue;
                            this.a(ilvGraphic3);
                            this.removeConstraint(ilvGraphic3.getName());
                            IlvAttachmentConstraint ilvAttachmentConstraint = (IlvAttachmentConstraint)(objectArray2 != null && objectArray2.length > j ? objectArray2[j] : null);
                            if (ilvAttachmentConstraint == null) {
                                ilvAttachmentConstraint = new IlvAttachmentConstraint();
                            }
                            this.a(ilvGraphic3, ilvAttachmentConstraint, ilvCompositeGraphic, ilvRule, n);
                            if (n > 0) {
                                this.addConstraint(ilvRule, ilvCompositeGraphic, ilvGraphic3.getName(), n, (IlvRect)objectArray[j], ilvAttachmentConstraint.isRelativeSize(), ilvAttachmentConstraint.getSize() != null, ilvAttachmentConstraint.isRelativeOffset());
                            } else {
                                this.removeConstraint(ilvGraphic3.getName());
                            }
                            arrayList.add(ilvSymbolRuleModel.getMainRuleFromGraphic(ilvGraphic3));
                            arrayList2.add(ilvGraphic3);
                            ++n;
                        }
                    }
                    this.removeObject(ilvGraphic);
                    continue;
                }
                this.removeObject(ilvGraphic);
                ilvGraphicSet = (IlvGraphicSet)ilvGraphic;
                if (ilvGraphicSet.getClass().getName().equals("ilog.views.sdm.graphic.IlvURLGraphic") && ilvGraphicSet.getCardinal() == 1 && ilvGraphicSet.getObject(0) instanceof IlvGraphicSet) {
                    object = ilvGraphicSet.getName();
                    ilvGraphicSet = (IlvGraphicSet)ilvGraphicSet.getObject(0);
                    if (object != null) {
                        ilvGraphicSet.setName((String)object);
                    }
                }
                this.a(ilvGraphicSet, ilvCompositeGraphic, ilvRule);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            this.a(ilvSymbolRuleModel, false);
            this.setSelection(arrayList);
        }
    }

    private IlvGraphic a(IlvGraphicSet ilvGraphicSet, IlvCompositeGraphic ilvCompositeGraphic, IlvRule ilvRule) throws IntrospectionException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IlvStylingException {
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        String string = ilvGraphicSet.getName();
        if (string == null) {
            string = ilvGraphicSet.getClass().getName();
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            if (string.startsWith("Ilv")) {
                string = string.substring(3);
            }
        }
        String string2 = SymbolEditorUtilities.getUniqueRuleID(this, new IlvRule[0], string);
        IlvCompositeGraphic ilvCompositeGraphic2 = new IlvCompositeGraphic();
        ilvCompositeGraphic2.setSelectionType(3);
        ilvCompositeGraphic2.setTransformationMode(1);
        ilvCompositeGraphic2.setResizingPolicy(0);
        ilvCompositeGraphic2.setName(string2);
        IlvRule ilvRule2 = ilvSymbolRuleModel.getRule("#" + string2, true);
        ilvRule2.setDeclaration("class", ilvCompositeGraphic2.getClass().getName());
        ilvRule2.setDeclaration("selectionType", String.valueOf(3));
        ilvRule2.setDeclaration("transformationMode", String.valueOf(1));
        ilvRule2.setDeclaration("resizingPolicy", String.valueOf(0));
        String string3 = string2 + "Layout";
        IlvRule ilvRule3 = ilvSymbolRuleModel.getRule("Subobject#" + string3, true);
        ilvRule3.setDeclaration("class", ilvCompositeGraphic2.getLayout().getClass().getName());
        ilvRule2.setDeclaration("layout", "@+" + string3);
        IlvRect ilvRect = null;
        for (int i = 0; i < ilvGraphicSet.getCardinal(); ++i) {
            IlvGraphic ilvGraphic = ilvGraphicSet.getObject(i);
            IlvGraphic ilvGraphic2 = null;
            ilvGraphic2 = ilvGraphic instanceof IlvGraphicSet ? this.a((IlvGraphicSet)ilvGraphic, ilvCompositeGraphic2, ilvRule2) : (ilvGraphic = SymbolEditorUtilities.translateGraphic(ilvGraphic, false));
            IlvRect ilvRect2 = SymbolEditorUtilities.getAttachmentBounds(ilvGraphic2);
            if (ilvRect == null) {
                ilvRect = new IlvRect(ilvRect2);
            } else {
                ilvRect.add(ilvRect2);
            }
            if (!(ilvGraphic instanceof IlvGraphicSet)) {
                String string4 = ilvGraphic.getName();
                if (string4 == null) {
                    string4 = ilvGraphic.getClass().getName();
                    int n = string4.lastIndexOf(46);
                    if (n > 0) {
                        string4 = string4.substring(n + 1);
                    }
                    if (string4.startsWith("Ilv")) {
                        string4 = string4.substring(3);
                    }
                }
                string4 = SymbolEditorUtilities.getUniqueRuleID(this, new IlvRule[0], string4);
                IlvCSSWriter ilvCSSWriter = new IlvCSSWriter(this.f.getDOMImplementation());
                IlvCSSWriter.IlvCSSCustomizerDeclarations ilvCSSCustomizerDeclarations = ilvCSSWriter.convert(string4, ilvGraphic, null);
                IlvRule ilvRule4 = this.getRuleModel().getRule(string4, true);
                ilvRule4.setDeclarations(ilvCSSCustomizerDeclarations.getDeclarations());
                this.a(ilvRule2, ilvCompositeGraphic2, ilvRule4, ilvGraphic, ilvRect2, ilvCSSCustomizerDeclarations.getAdditionalRules(), string4, false, false, true);
            }
            ilvCompositeGraphic2.setChildren(i, ilvGraphic2);
        }
        this.a(ilvRule, ilvCompositeGraphic, ilvRule2, ilvCompositeGraphic2, ilvRect, null, string2, false, false, true);
        return ilvCompositeGraphic2;
    }

    public boolean canUngroup() {
        List list = this.getSelection();
        if (list.size() == 0) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (this.c(e)) {
                IlvCompositeGraphic ilvCompositeGraphic;
                IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e);
                if (SymbolEditorUtilities.isSubSymbol(ilvGraphic)) {
                    return false;
                }
                if (!(ilvGraphic instanceof IlvCompositeGraphic) && !(ilvGraphic instanceof IlvGraphicSet)) {
                    return false;
                }
                if (!(ilvGraphic instanceof IlvCompositeGraphic ? ilvGraphic == ((IlvCompositeGraphic)ilvGraphic.getGraphicBag()).getChildren(0) : ilvGraphic == (ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic.getGraphicBag()).getChildren(0) && ilvCompositeGraphic.getChildren().length > 1)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public void reparent(IlvRule ilvRule) {
        IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)this.getRuleModel().getGraphicFromRule(ilvRule);
        List list = this.getSelection();
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        this.a(ilvSymbolRuleModel, true);
        try {
            IlvGraphic ilvGraphic;
            IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
            int n = ilvGraphicArray.length;
            while (ilvGraphicArray[n - 1] == null) {
                --n;
            }
            IlvRect[] ilvRectArray = new IlvRect[list.size()];
            IlvAttachmentConstraint[] ilvAttachmentConstraintArray = new IlvAttachmentConstraint[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e);
                ilvRectArray[i] = SymbolEditorUtilities.getAttachmentBounds(ilvGraphic);
                ilvAttachmentConstraintArray[i] = SymbolEditorUtilities.getAttachmentConstraint(ilvGraphic);
            }
            IlvCompositeGraphic ilvCompositeGraphic2 = (IlvCompositeGraphic)this.getToplevelGraphic();
            for (int i = 0; i < list.size(); ++i) {
                ilvGraphic = list.get(i);
                IlvGraphic ilvGraphic2 = this.getRuleModel().getGraphicFromRule((IlvRule)((Object)ilvGraphic));
                if (!(ilvGraphic2.getGraphicBag() instanceof IlvCompositeGraphic)) continue;
                IlvCompositeGraphic ilvCompositeGraphic3 = (IlvCompositeGraphic)ilvGraphic2.getGraphicBag();
                IlvRule ilvRule2 = this.getRuleModel().getMainRuleFromGraphic(ilvCompositeGraphic3);
                if (ilvCompositeGraphic3 != ilvCompositeGraphic2) {
                    SymbolEditorUtilities.disableLayout((IlvGraphic)((Object)ilvCompositeGraphic3.getGraphicBag()));
                } else {
                    SymbolEditorUtilities.disableLayout(ilvCompositeGraphic2);
                }
                this.a(ilvGraphic2);
                this.removeConstraint(ilvGraphic2.getName());
                this.getRuleModel().updateGeometry(ilvCompositeGraphic3, ilvRule2, false, null);
                this.a(ilvGraphic2, null, ilvCompositeGraphic, ilvRule, n);
                this.addConstraint(ilvRule, ilvCompositeGraphic, ilvGraphic2.getName(), n, ilvRectArray[i], ilvAttachmentConstraintArray[i] != null && ilvAttachmentConstraintArray[i].isRelativeSize(), ilvAttachmentConstraintArray[i] != null && ilvAttachmentConstraintArray[i].getSize() != null, false);
                this.getRuleModel().updateGeometry(ilvCompositeGraphic, ilvRule, false, null);
                if (ilvCompositeGraphic3 != ilvCompositeGraphic2) {
                    SymbolEditorUtilities.enableLayout((IlvGraphic)((Object)ilvCompositeGraphic3.getGraphicBag()));
                    continue;
                }
                SymbolEditorUtilities.enableLayout(ilvCompositeGraphic2);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            this.a(ilvSymbolRuleModel, false);
            this.b();
        }
    }

    public boolean canReparent(IlvRule ilvRule) {
        List list;
        IlvGraphic ilvGraphic;
        if (ilvRule != null) {
            ilvGraphic = this.getRuleModel().getGraphicFromRule(ilvRule);
            if (!(ilvGraphic instanceof IlvCompositeGraphic) || SymbolEditorUtilities.isSubSymbol(ilvGraphic)) {
                return false;
            }
            if (((IlvCompositeGraphic)ilvGraphic).getLayout() instanceof IlvCenteredLayout) {
                return false;
            }
        } else {
            ilvGraphic = null;
        }
        if ((list = this.getSelection()).size() == 0) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (this.c(e)) {
                IlvGraphicBag ilvGraphicBag;
                IlvGraphic ilvGraphic2 = this.getRuleModel().getGraphicFromRule((IlvRule)e);
                if (ilvGraphic2 == ilvGraphic) {
                    return false;
                }
                if (ilvGraphic != null) {
                    for (ilvGraphicBag = ilvGraphic.getGraphicBag(); ilvGraphicBag != null; ilvGraphicBag = ilvGraphicBag.getGraphicBag()) {
                        if (ilvGraphicBag != ilvGraphic2) continue;
                        return false;
                    }
                }
                if (ilvGraphic2.getGraphicBag() instanceof IlvCompositeGraphic) {
                    ilvGraphicBag = (IlvCompositeGraphic)ilvGraphic2.getGraphicBag();
                    if (ilvGraphic2 == ((IlvCompositeGraphic)ilvGraphicBag).getChildren(0) || ilvGraphicBag == ilvGraphic) {
                        return false;
                    }
                    if (!(((IlvCompositeGraphic)ilvGraphicBag).getLayout() instanceof IlvCenteredLayout)) continue;
                    return false;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public void newCondition() {
        IlvRule ilvRule;
        IlvRule ilvRule2;
        List list = this.getSelection();
        if (list.size() == 1 && list.get(0) instanceof IlvRule && (ilvRule2 = this.a(ilvRule = (IlvRule)list.get(0), false)) != null) {
            ilvRule2.setMetaDeclaration("__KEEPEMPTYRULE", "true");
            IlvSymbolEditorDocument.b(ilvRule2, ilvRule2);
            this.getRuleModel().addRule(ilvRule2);
            this.setSelection(ilvRule2);
        }
    }

    public boolean newConditionEnabled() {
        List list = this.getSelection();
        return list.size() == 1 && list.get(0) instanceof IlvRule;
    }

    public void changeCondition() {
        IlvRule ilvRule;
        IlvRule ilvRule2;
        List list = this.getSelection();
        if (list.size() == 1 && IlvSymbolEditorDocument.isConditionSelection(list.get(0)) && (ilvRule2 = this.a(ilvRule = (IlvRule)list.get(0), true)) != null) {
            IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
            IlvRule ilvRule3 = ilvRule.copy();
            ilvRule3.getSelector().setID(ilvRule3.getSelector().getID() + "Attachment");
            ilvRule3.updateRule();
            ilvRule3.updateWeights();
            try {
                ilvRule3 = ilvSymbolRuleModel.getRule(ilvRule3.getSelectorString(), false);
            }
            catch (IlvStylingException ilvStylingException) {
                ilvStylingException.printStackTrace();
                ilvRule3 = null;
            }
            IlvSymbolEditorDocument.b(ilvRule, ilvRule2);
            ilvSymbolRuleModel.setSelector(ilvRule, ilvRule2.getSelector());
            if (ilvRule3 != null) {
                IlvSelector ilvSelector = ilvRule.getSelector().copy();
                ilvSelector.setID(ilvSelector.getID() + "Attachment");
                ilvSymbolRuleModel.setSelector(ilvRule3, ilvSelector);
            }
        }
    }

    public boolean changeConditionEnabled() {
        List list = this.getSelection();
        return list.size() == 1 && IlvSymbolEditorDocument.isConditionSelection(list.get(0));
    }

    public void newParameter() {
        String string = SymbolEditorUtilities.getUniqueParameterName(this, this.r.getString("SymbolEditor.NewParameterName"));
        String string2 = this.r.getString("SymbolEditor.NewParameterDescription");
        IlvPaletteSymbolParameter ilvPaletteSymbolParameter = new IlvPaletteSymbolParameter(string, "", "java.lang.String", null);
        ilvPaletteSymbolParameter.setName(string);
        ilvPaletteSymbolParameter.setShortDescription(string2);
        ilvPaletteSymbolParameter.setLongDescription(string2);
        this.addParameter(ilvPaletteSymbolParameter);
        this.setSelection(ilvPaletteSymbolParameter);
    }

    public boolean newParameterEnabled() {
        List list = this.getSelection();
        if (list.size() == 1) {
            Object e = list.get(0);
            return this.d(e) || this.f(e) || this.b(e);
        }
        return false;
    }

    public void moveUp() {
        this.a(true, false);
    }

    public boolean moveUpEnabled() {
        return this.b(true, false);
    }

    public void sendBackward() {
        this.a(true, false);
        this.b();
    }

    public boolean sendBackwardEnabled() {
        return this.b(true, true);
    }

    public void sendToBack() {
        this.a(true, true);
        this.b();
    }

    public boolean sendToBackEnabled() {
        return this.b(true, true);
    }

    public void moveDown() {
        this.a(false, false);
    }

    public boolean moveDownEnabled() {
        return this.b(false, false);
    }

    public void bringForward() {
        this.a(false, false);
        this.b();
    }

    public boolean bringForwardEnabled() {
        return this.b(false, true);
    }

    public void bringToFront() {
        this.a(false, true);
        this.b();
    }

    public boolean bringToFrontEnabled() {
        return this.b(false, true);
    }

    private void a(boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        List list = this.getSelection();
        int n4 = list.size();
        if (n4 == 0) {
            return;
        }
        boolean bl3 = list.get(0) instanceof IlvRule;
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        if (bl3) {
            this.a(ilvSymbolRuleModel, true);
        }
        Object[] objectArray = new SelectedInfo[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            objectArray[n3] = new SelectedInfo(list.get(n3));
        }
        Arrays.sort(objectArray);
        if (bl) {
            n3 = 0;
            n2 = n4;
            n = 1;
        } else {
            n3 = n4 - 1;
            n2 = -1;
            n = -1;
        }
        IlvPaletteSymbolParameter[] ilvPaletteSymbolParameterArray = null;
        IlvPaletteSymbolParameter[] ilvPaletteSymbolParameterArray2 = null;
        boolean bl4 = false;
        while (!bl4) {
            boolean bl5 = false;
            for (int i = n3; i != n2; i += n) {
                int n5;
                Object object;
                IlvRule[] ilvRuleArray;
                Object object2;
                Object object3;
                Object object4;
                int n6;
                Object object5 = ((SelectedInfo)objectArray[i]).a;
                int n7 = ((SelectedInfo)objectArray[i]).d;
                int n8 = ((SelectedInfo)objectArray[i]).e;
                int n9 = n6 = bl ? n7 - 1 : n7 + 1;
                if (n7 == 0 && bl) {
                    bl4 = true;
                    break;
                }
                if (n7 == n8 - 1 && !bl) {
                    bl4 = true;
                    break;
                }
                if (this.c(object5)) {
                    object4 = (IlvRule)object5;
                    object3 = ((SelectedInfo)objectArray[i]).b;
                    object2 = (IlvCompositeGraphic)((SelectedInfo)objectArray[i]).c;
                    ilvRuleArray = ilvSymbolRuleModel.getMainRuleFromGraphic((IlvGraphic)object2);
                    object = ((IlvCompositeGraphic)object2).getChildren();
                    Object[] objectArray2 = ((IlvCompositeGraphic)object2).getConstraints();
                    IlvEventMap[] ilvEventMapArray = ((IlvCompositeGraphic)object2).getEventMaps();
                    int n10 = this.a((IlvRule)object4, bl, !bl, false);
                    if (n10 < 0) {
                        bl4 = true;
                        break;
                    }
                    if (n10 > 0) {
                        this.a((IlvCompositeGraphic)object2, n10);
                    }
                    bl5 = true;
                    ((SelectedInfo)objectArray[i]).d = n6;
                    IlvGraphic ilvGraphic = object[n6];
                    Object object6 = objectArray2[n7];
                    Object object7 = objectArray2[n6];
                    IlvEventMap ilvEventMap = ilvEventMapArray != null && n7 < ilvEventMapArray.length ? ilvEventMapArray[n7] : null;
                    IlvEventMap ilvEventMap2 = ilvEventMapArray != null && n6 < ilvEventMapArray.length ? ilvEventMapArray[n6] : null;
                    ilvSymbolRuleModel.setDeclarationValue((IlvRule)ilvRuleArray, "children[" + n6 + "]", "@+" + ((IlvGraphic)object3).getName());
                    if (object6 != null) {
                        ilvSymbolRuleModel.setDeclarationValue((IlvRule)ilvRuleArray, "constraints[" + n6 + "]", "@+" + ((IlvGraphic)object3).getName() + "Attachment");
                    } else {
                        ilvSymbolRuleModel.removeDeclaration((IlvRule)ilvRuleArray, "constraints[" + n6 + "]");
                    }
                    if (ilvEventMap != null) {
                        ilvSymbolRuleModel.setDeclarationValue((IlvRule)ilvRuleArray, "eventMaps[" + n6 + "]", "@+" + ((IlvGraphic)object3).getName() + "EventMap");
                    } else {
                        ilvSymbolRuleModel.removeDeclaration((IlvRule)ilvRuleArray, "eventMaps[" + n6 + "]");
                    }
                    ilvSymbolRuleModel.setDeclarationValue((IlvRule)ilvRuleArray, "children[" + n7 + "]", "@+" + ilvGraphic.getName());
                    if (object7 != null) {
                        ilvSymbolRuleModel.setDeclarationValue((IlvRule)ilvRuleArray, "constraints[" + n7 + "]", "@+" + ilvGraphic.getName() + "Attachment");
                    } else {
                        ilvSymbolRuleModel.removeDeclaration((IlvRule)ilvRuleArray, "constraints[" + n7 + "]");
                    }
                    if (ilvEventMap2 != null) {
                        ilvSymbolRuleModel.setDeclarationValue((IlvRule)ilvRuleArray, "eventMaps[" + n7 + "]", "@+" + ilvGraphic.getName() + "EventMap");
                    } else {
                        ilvSymbolRuleModel.removeDeclaration((IlvRule)ilvRuleArray, "eventMaps[" + n7 + "]");
                    }
                    IlvLayoutManager ilvLayoutManager = ((IlvCompositeGraphic)object2).getLayout();
                    if (ilvLayoutManager instanceof IlvCenteredLayout) {
                        ((IlvCompositeGraphic)object2).setLayout(new IlvAttachmentLayout());
                    }
                    ((IlvCompositeGraphic)object2).setChildren(n6, (IlvGraphic)object3);
                    ((IlvCompositeGraphic)object2).setConstraints(n6, object6);
                    ((IlvCompositeGraphic)object2).setEventMaps(n6, ilvEventMap);
                    ((IlvCompositeGraphic)object2).setChildren(n7, ilvGraphic);
                    ((IlvCompositeGraphic)object2).setConstraints(n7, object7);
                    ((IlvCompositeGraphic)object2).setEventMaps(n7, ilvEventMap2);
                    if (!(ilvLayoutManager instanceof IlvCenteredLayout)) continue;
                    ((IlvCompositeGraphic)object2).setLayout(ilvLayoutManager);
                    ((IlvCompositeGraphic)object2).doLayout();
                    continue;
                }
                if (IlvSymbolEditorDocument.isConditionSelection(object5)) {
                    object4 = (IlvRule)((SelectedInfo)objectArray[i]).c;
                    bl5 = true;
                    ((SelectedInfo)objectArray[i]).d = n6;
                    object3 = (IlvRule)object5;
                    object2 = (IlvRule)object4.getChildAt(n6);
                    ilvRuleArray = ilvSymbolRuleModel.getAllRules(true);
                    for (int j = 0; j < ilvRuleArray.length; ++j) {
                        if (ilvRuleArray[j] == object3) {
                            ilvRuleArray[j] = object2;
                            continue;
                        }
                        if (ilvRuleArray[j] != object2) continue;
                        ilvRuleArray[j] = object3;
                    }
                    ilvSymbolRuleModel.setRules(ilvRuleArray);
                    try {
                        object = ilvSymbolRuleModel.getRule("_fake_" + System.currentTimeMillis(), true);
                        if (object == null) continue;
                        ilvSymbolRuleModel.removeRule((IlvRule)object);
                    }
                    catch (IlvStylingException ilvStylingException) {
                        ilvStylingException.printStackTrace();
                    }
                    continue;
                }
                if (!this.d(object5)) continue;
                bl5 = true;
                ((SelectedInfo)objectArray[i]).d = n6;
                object4 = (IlvPaletteSymbolParameter)object5;
                object3 = this.a.getParameter(n6);
                int n11 = this.a.getParameterCount();
                ilvPaletteSymbolParameterArray = new IlvPaletteSymbolParameter[n11];
                ilvPaletteSymbolParameterArray2 = new IlvPaletteSymbolParameter[n11];
                for (n5 = 0; n5 < n11; ++n5) {
                    ilvPaletteSymbolParameterArray2[n5] = this.a.getParameter(n5);
                    ilvPaletteSymbolParameterArray[n5] = this.a.getParameter(n5);
                }
                ilvPaletteSymbolParameterArray2[n6] = object4;
                ilvPaletteSymbolParameterArray2[n7] = object3;
                this.a.removeAllParameters();
                for (n5 = 0; n5 < n11; ++n5) {
                    this.a.addParameter(ilvPaletteSymbolParameterArray2[n5]);
                }
            }
            if (!bl5) {
                bl4 = true;
            }
            if (bl2) continue;
            bl4 = true;
        }
        if (bl3) {
            this.a(ilvSymbolRuleModel, false);
        } else {
            this.a(ilvPaletteSymbolParameterArray);
        }
    }

    private boolean b(boolean bl, boolean bl2) {
        List list = this.getSelection();
        if (list.size() == 0) {
            return false;
        }
        if (list.size() > 1 && !bl2) {
            return false;
        }
        Object object = null;
        Object var5_5 = null;
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        for (int i = 0; i < list.size(); ++i) {
            int n;
            Object e = list.get(i);
            if (var5_5 == null) {
                var5_5 = e;
            }
            if (this.c(e)) {
                int n2;
                if (!bl2) {
                    return false;
                }
                if (!this.c((Object)var5_5)) {
                    return false;
                }
                IlvGraphic ilvGraphic = ilvSymbolRuleModel.getGraphicFromRule((IlvRule)e);
                if (!(ilvGraphic.getGraphicBag() instanceof IlvCompositeGraphic)) {
                    return false;
                }
                IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic.getGraphicBag();
                if (object == null) {
                    object = ilvCompositeGraphic;
                } else if (ilvCompositeGraphic != object) {
                    return false;
                }
                IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
                for (n = 0; n < ilvGraphicArray.length && ilvGraphicArray[n] != ilvGraphic; ++n) {
                }
                if (bl && n == 0) {
                    return false;
                }
                for (n2 = ilvGraphicArray.length - 1; ilvGraphicArray[n2] == null && n2 > 0; --n2) {
                }
                if (bl || n != n2) continue;
                return false;
            }
            if (IlvSymbolEditorDocument.isConditionSelection(e)) {
                if (bl2) {
                    return false;
                }
                if (!IlvSymbolEditorDocument.isConditionSelection(var5_5)) {
                    return false;
                }
                IlvGraphic ilvGraphic = ilvSymbolRuleModel.getGraphicFromRule((IlvRule)e);
                IlvRule ilvRule = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvGraphic);
                if (object == null) {
                    object = ilvRule;
                } else if (ilvRule != object) {
                    return false;
                }
                n = ilvRule.getIndex((IlvRule)e);
                int n3 = ilvRule.getChildCount();
                if (bl && n == 0) {
                    return false;
                }
                if (bl) {
                    IlvRule ilvRule2 = (IlvRule)ilvRule.getChildAt(n - 1);
                    ilvRule2.updateWeights();
                    ((IlvRule)e).updateWeights();
                    if (ilvRule2.compare((IlvRule)e) != 0) {
                        return false;
                    }
                }
                if (!bl && n == n3 - 1) {
                    return false;
                }
                if (bl) continue;
                IlvRule ilvRule3 = (IlvRule)ilvRule.getChildAt(n + 1);
                ilvRule3.updateWeights();
                ((IlvRule)e).updateWeights();
                if (ilvRule3.compare((IlvRule)e) == 0) continue;
                return false;
            }
            if (this.d(e)) {
                int n4;
                if (bl2) {
                    return false;
                }
                if (!this.d((Object)var5_5)) {
                    return false;
                }
                int n5 = this.a.getParameterCount();
                for (n4 = 0; n4 < n5 && e != this.a.getParameter(n4); ++n4) {
                }
                if (bl && n4 == 0) {
                    return false;
                }
                if (bl || n4 != n5 - 1) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void d() {
        String[] stringArray;
        if (this.g != null) {
            this.beforeApply(this.g);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.w != null) {
            arrayList.add(this.w);
        }
        if (this.x != null) {
            arrayList.add(this.x);
        }
        if (this.v) {
            arrayList.add("selected");
        }
        if (arrayList.size() > 0) {
            if (this.ac != null) {
                for (int i = 0; i < this.ac.length; ++i) {
                    arrayList.add(this.ac[i]);
                }
            }
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        } else {
            stringArray = this.ac;
        }
        IlvCSSBeans.AppliedDeclarationHook appliedDeclarationHook = this.getRuleModel().getCSSBeans().getAppliedDeclarationHook();
        this.getRuleModel().getCSSBeans().setAppliedDeclarationHook(this.z);
        this.g = (IlvGraphic)this.getRuleModel().getCSSBeans().createBeanAndApplyDeclarations(this.p, this.f, this.f, this.g, true, stringArray);
        this.getRuleModel().getCSSBeans().setAppliedDeclarationHook(appliedDeclarationHook);
        this.g.setName(this.a.getClassName());
        this.afterApply(this.g, this.f);
        if (this.g instanceof IlvCompositeGraphic) {
            Serializable serializable;
            IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)this.g;
            if (this.s != null && !this.y && (serializable = ilvCompositeGraphic.getChildren(0)) != null) {
                serializable.move(this.s);
            }
            ilvCompositeGraphic.doLayout();
            if (this.u != null && this.y) {
                serializable = new IlvTransformer();
                if (this.aa > -1) {
                    IlvTransformer.computeTransformer(SymbolEditorUtilities.getAttachmentBounds(((IlvCompositeGraphic)this.g).getChildren(this.aa)), this.u, (IlvTransformer)serializable);
                } else {
                    IlvTransformer.computeTransformer(SymbolEditorUtilities.getAttachmentBounds(this.g), this.u, (IlvTransformer)serializable);
                }
                this.g.applyTransform((IlvTransformer)serializable);
            }
        }
        this.h = true;
    }

    protected void appliedDeclarations(IlvCSSModel ilvCSSModel, Object object, Object object2, String[] stringArray, IlvApplicableDeclarationCollection ilvApplicableDeclarationCollection, Collection<String> collection, int n) {
    }

    protected void beforeApply(IlvGraphic ilvGraphic) {
        IlvCompositeGraphic ilvCompositeGraphic;
        IlvGraphic[] ilvGraphicArray;
        if (invisibleGhosts) {
            ilvGraphic.removeProperty(unrealizedProperty);
            ilvGraphic.removeProperty(invisibleProperty);
        }
        if (ilvGraphic instanceof IlvCompositeGraphic && !SymbolEditorUtilities.isSubSymbol(ilvGraphic) && (ilvGraphicArray = (ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic).getChildren()) != null) {
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                IlvGraphic ilvGraphic2 = ilvGraphicArray[i];
                if (ilvGraphic2 == null) continue;
                ilvGraphic2.setGraphicBag(ilvCompositeGraphic);
                this.beforeApply(ilvGraphic2);
                if (this.getRuleModel().getMainRuleFromGraphic(ilvGraphic2) != null) continue;
                ilvCompositeGraphic.setChildren(i, null);
            }
        }
    }

    protected void afterApply(IlvGraphic ilvGraphic, IlvRule ilvRule) {
        block10: {
            IlvCompositeGraphic ilvCompositeGraphic;
            IlvGraphic[] ilvGraphicArray;
            String string = ilvRule.getSelector().getID();
            if (string == null) {
                string = ilvRule.getSelector().getType();
            }
            ilvGraphic.setName(string);
            if (!(ilvGraphic instanceof IlvCompositeGraphic) || SymbolEditorUtilities.isSubSymbol(ilvGraphic) || (ilvGraphicArray = (ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic).getChildren()) == null) break block10;
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                IlvRule ilvRule2;
                IlvGraphic ilvGraphic2;
                block11: {
                    String string2;
                    block12: {
                        ilvGraphic2 = ilvGraphicArray[i];
                        if (ilvGraphic2 == null) continue;
                        ilvGraphic2.setGraphicBag(ilvCompositeGraphic);
                        if (i == 0 && ilvCompositeGraphic.getLayout() instanceof IlvAttachmentLayout) {
                            ((IlvAttachmentLayout)ilvCompositeGraphic.getLayout()).setAnchor(ilvCompositeGraphic.getAttachableGraphic(ilvGraphic2));
                        }
                        ilvRule2 = null;
                        string2 = ilvRule.getDeclarationValue("children[" + i + "]");
                        if (string2 == null) break block11;
                        if (string2.startsWith("@#")) break block12;
                        if (string2.startsWith("@+")) break block12;
                        if (!string2.startsWith("@=")) break block11;
                    }
                    String string3 = string2.substring(2);
                    try {
                        ilvRule2 = this.getRuleModel().getRule("Subobject#" + string3, false);
                    }
                    catch (IlvStylingException ilvStylingException) {
                        ilvStylingException.printStackTrace();
                    }
                }
                if (ilvRule2 == null) {
                    throw new RuntimeException("Could not find the rule that created the element " + ilvGraphic2);
                }
                if (ilvGraphic2 instanceof IlvGeneralPath && !((IlvGeneralPath)ilvGraphic2).isTransformedShapeMode()) {
                    ((IlvGeneralPath)ilvGraphic2).setTransformedShapeMode(true);
                    ilvRule2.setDeclaration("transformedShapeMode", "true");
                }
                this.afterApply(ilvGraphic2, ilvRule2);
            }
        }
    }

    public void updatePosition() {
        IlvCompositeGraphic ilvCompositeGraphic;
        IlvGraphic ilvGraphic;
        if (this.g instanceof IlvCompositeGraphic && (ilvGraphic = (ilvCompositeGraphic = (IlvCompositeGraphic)this.g).getChildren(0)) != null) {
            IlvRect ilvRect = ilvGraphic.boundingBox();
            this.t = this.s;
            this.s = new IlvPoint(ilvRect.x, ilvRect.y);
        }
    }

    public void updateBBox() {
        this.u = this.aa > -1 ? SymbolEditorUtilities.getAttachmentBounds(((IlvCompositeGraphic)this.g).getChildren(this.aa)) : SymbolEditorUtilities.getAttachmentBounds(this.g);
    }

    private IlvSymbolRuleModel b(String string) {
        String string2 = (String)j.get(string);
        if (string2 != null) {
            try {
                IlvSymbolRuleModel ilvSymbolRuleModel = (IlvSymbolRuleModel)Class.forName(string2).newInstance();
                ilvSymbolRuleModel.setDocument(this);
                return ilvSymbolRuleModel;
            }
            catch (Exception exception) {
                throw new RuntimeException("Error while creating rule model for component type " + string, exception);
            }
        }
        throw new RuntimeException("Cannot find rule model for component type " + string);
    }

    public void runMode() {
        this.clearSelection();
        Object object = this.getRuleModel().getCSSBeans().getDeclarationValue(this.p, this.f, this.f, "LinkConnectionRectangle", -1, null, null);
        this.aa = object != IlvCSSBeans.NO_VALUE && object != null ? Integer.parseInt(object.toString()) : -1;
        this.o = new EventListenerList();
        this.p.a();
        this.ac = null;
        this.applyChanges();
    }

    public void designMode() {
        this.p.b();
        if (invisibleGhosts) {
            this.ac = designModePseudoClasses;
        }
        this.applyChanges();
    }

    public void setRunModeParameterValue(String string, Object object) {
        this.p.a(string, object);
        IlvPaletteSymbol ilvPaletteSymbol = this.getSymbol();
        this.a(ilvPaletteSymbol.getParameter(string), null, object);
    }

    public Object getRunModeParameterValue(String string) {
        return this.p.getValueAsObject(null, string.intern());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, String string2) {
        if (string2 != null && string2.equals(string)) {
            return;
        }
        IlvRule[] ilvRuleArray = this.getRuleModel().getAllRules(true);
        boolean bl = false;
        try {
            for (int i = 0; i < ilvRuleArray.length; ++i) {
                Object object;
                Object object2;
                IlvRule ilvRule = ilvRuleArray[i];
                boolean bl2 = true;
                block7: while (bl2) {
                    IlvCSSAttributeSelector[] ilvCSSAttributeSelectorArray;
                    bl2 = false;
                    object2 = ilvRule.getSelector();
                    if (object2 == null || (ilvCSSAttributeSelectorArray = object2.getAttributes()) == null) continue;
                    for (int j = 0; j < ilvCSSAttributeSelectorArray.length; ++j) {
                        if (!ilvCSSAttributeSelectorArray[j].getAttributeName().equals(string)) continue;
                        bl2 = true;
                        if (!bl) {
                            if (!this.e()) {
                                return;
                            }
                            bl = true;
                            this.a(this.getRuleModel(), true);
                        }
                        object = new IlvSelectorImpl((IlvSelectorImpl)object2);
                        ((AttributeSelector)object.getAttributes()[j]).setAttributeName(string2);
                        this.getRuleModel().setSelector(ilvRule, (IlvSelector)object);
                        String string3 = ilvRule.getName();
                        string3 = this.a(string3, string, string2);
                        ilvRule.setName(string3);
                        continue block7;
                    }
                }
                object2 = ilvRule.getCSSDeclarations();
                if (object2 == null) continue;
                for (int j = 0; j < ((Object)object2).length; ++j) {
                    String string4 = object2[j].getProperty();
                    object = object2[j].getValue();
                    if (string4.endsWith("parameterToModify") && ((String)object).equals(string)) {
                        if (!bl) {
                            if (!this.e()) {
                                return;
                            }
                            bl = true;
                            this.a(this.getRuleModel(), true);
                        }
                        this.getRuleModel().setDeclarationValue(ilvRule, string4, string2);
                        continue;
                    }
                    if (this.b((String)object, "@" + string) < 0) continue;
                    if (!bl) {
                        if (!this.e()) {
                            return;
                        }
                        bl = true;
                        this.a(this.getRuleModel(), true);
                    }
                    object = this.a((String)object, "@" + string, "@" + string2);
                    this.getRuleModel().setDeclarationValue(ilvRule, string4, (String)object);
                }
            }
        }
        finally {
            if (bl) {
                this.a(this.getRuleModel(), false);
            }
        }
    }

    private int b(String string, String string2) {
        return this.a(string, string2, 0);
    }

    private int a(String string, String string2, int n) {
        int n2 = string.indexOf(string2, n);
        while (n2 >= 0) {
            boolean bl;
            boolean bl2 = bl = string.length() <= n2 + string2.length();
            if (!bl) {
                char c = string.charAt(n2 + string2.length());
                boolean bl3 = bl = !Character.isLetterOrDigit(c);
            }
            if (bl) {
                return n2;
            }
            n2 = string.indexOf(string2, n2 + 1);
        }
        return -1;
    }

    private String a(String string, String string2, String string3) {
        int n = 0;
        while ((n = this.a(string, string2, n)) >= 0) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
            n += string3.length();
        }
        return string;
    }

    private boolean e() {
        if (!confirmRuleUpdateWhenParameterRenamed || this.ah) {
            return true;
        }
        JCheckBox jCheckBox = new JCheckBox(this.r.getString("SymbolEditor.ConfirmUpdateRules.DontAskMeAgain"));
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                confirmRuleUpdateWhenParameterRenamed = !((JCheckBox)itemEvent.getSource()).isSelected();
            }
        });
        String string = this.r.getString("SymbolEditor.ConfirmUpdateRules.Message");
        String string2 = this.r.getString("SymbolEditor.ConfirmUpdateRules.Title");
        int n = JOptionPane.showOptionDialog(null, new Object[]{string, jCheckBox}, string2, 0, 3, null, null, null);
        return n == 0;
    }

    private boolean f() {
        if (!confirmRuleUpdateWhenParameterDeleted || this.ah) {
            return true;
        }
        JCheckBox jCheckBox = new JCheckBox(this.r.getString("SymbolEditor.ConfirmUpdateRules.DontAskMeAgain"));
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                confirmRuleUpdateWhenParameterDeleted = !((JCheckBox)itemEvent.getSource()).isSelected();
            }
        });
        String string = this.r.getString("SymbolEditor.ConfirmDeleteRules.Message");
        String string2 = this.r.getString("SymbolEditor.ConfirmDeleteRules.Title");
        int n = JOptionPane.showOptionDialog(null, new Object[]{string, jCheckBox}, string2, 0, 3, null, null, null);
        return n == 0;
    }

    private static Image a(IlvGraphic ilvGraphic, int n, int n2) {
        int n3;
        int n4;
        IlvRect ilvRect = ilvGraphic.boundingBox();
        if (n > 0 && n2 > 0) {
            n4 = n;
            n3 = n2;
            float f = n4 / n3;
            if (ilvRect.width > ilvRect.height * f) {
                ilvRect.y -= (ilvRect.width / f - ilvRect.height) / 2.0f;
                ilvRect.height = ilvRect.width / f;
            } else {
                ilvRect.x -= (ilvRect.height * f - ilvRect.width) / 2.0f;
                ilvRect.width = ilvRect.height * f;
            }
        } else {
            n4 = (int)Math.ceil(ilvRect.width);
            n3 = (int)Math.ceil(ilvRect.height);
        }
        BufferedImage bufferedImage = new BufferedImage(n4, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(IlvPrintUtil.KEY_PRINTING, IlvPrintUtil.VALUE_PRINT_ON);
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, n4, n3);
        IlvTransformer ilvTransformer = new IlvTransformer();
        ilvRect.width += 1.0f;
        ilvRect.height += 1.0f;
        IlvTransformer.computeTransformer(ilvRect, new IlvRect(0.0f, 0.0f, n4, n3), ilvTransformer);
        ilvGraphic.draw(graphics2D, ilvTransformer);
        graphics2D.dispose();
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File a(RenderedImage renderedImage, IlvPaletteSymbol ilvPaletteSymbol) {
        OutputStream outputStream = null;
        File file = null;
        try {
            file = File.createTempFile("tmp", ".txt");
            String string = ilvPaletteSymbol.getFullID();
            int n = string.indexOf(46);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            string = string.replace('.', '_');
            File file2 = new File(file.getParentFile(), ab + string + ".png");
            file2.deleteOnExit();
            file.delete();
            file = null;
            outputStream = new BufferedOutputStream(new FileOutputStream(file2));
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder(outputStream, null);
            pNGImageEncoder.encode(renderedImage);
            Image image = IlvImageUtil.loadImage(file2.getPath());
            if (image != null) {
                image.flush();
            }
            File file3 = file2;
            return file3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            File file4 = null;
            return file4;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (file != null) {
                file.delete();
            }
        }
    }

    private IlvRule[] b(IlvGraphic ilvGraphic) {
        int n;
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        IlvRule[] ilvRuleArray = ilvSymbolRuleModel.getAllRulesFromGraphic(ilvGraphic);
        IlvRule[] ilvRuleArray2 = ilvSymbolRuleModel.getAdditionalRules(ilvRuleArray);
        IlvRule[] ilvRuleArray3 = ilvSymbolRuleModel.getRulesFromId(IlvRuleModel.ALL_RULES, ilvGraphic.getName() + "Attachment");
        IlvRule[] ilvRuleArray4 = ilvSymbolRuleModel.getRulesFromId(IlvRuleModel.ALL_RULES, ilvGraphic.getName() + "EventMap");
        IlvRule[] ilvRuleArray5 = new IlvRule[]{};
        if (ilvRuleArray4.length > 0) {
            ilvRuleArray5 = ilvSymbolRuleModel.getAdditionalRules(ilvRuleArray4);
        }
        for (n = 0; n < ilvRuleArray.length; ++n) {
            arrayList.add(ilvRuleArray[n]);
        }
        for (n = 0; n < ilvRuleArray2.length; ++n) {
            arrayList.add(ilvRuleArray2[n]);
        }
        for (n = 0; n < ilvRuleArray3.length; ++n) {
            arrayList.add(ilvRuleArray3[n]);
        }
        for (n = 0; n < ilvRuleArray4.length; ++n) {
            arrayList.add(ilvRuleArray4[n]);
        }
        for (n = 0; n < ilvRuleArray5.length; ++n) {
            arrayList.add(ilvRuleArray5[n]);
        }
        return arrayList.toArray(new IlvRule[0]);
    }

    private IlvRule[] a(IlvRule ilvRule) {
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        arrayList.add(ilvRule);
        IlvRule[] ilvRuleArray = this.getRuleModel().getAdditionalRules(new IlvRule[]{ilvRule});
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            arrayList.add(ilvRuleArray[i]);
        }
        return arrayList.toArray(new IlvRule[0]);
    }

    private static IlvRule[] b(IlvRule[] ilvRuleArray) {
        IlvRule[] ilvRuleArray2 = new IlvRule[ilvRuleArray.length];
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            ilvRuleArray2[i] = ilvRuleArray[i].copy();
        }
        return ilvRuleArray2;
    }

    private void a(IlvRule[] ilvRuleArray, String string, String string2, boolean bl) {
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            IlvCSSDeclaration[] ilvCSSDeclarationArray;
            IlvRule ilvRule = ilvRuleArray[i];
            IlvSelector ilvSelector = ilvRule.getSelector();
            boolean bl2 = false;
            if (ilvSelector != null) {
                if ((string + "Attachment").equals(ilvSelector.getID())) {
                    if (!bl2 && bl) {
                        ilvSelector = ilvSelector.copy();
                    }
                    ilvSelector.setID(string2 + "Attachment");
                    if (!bl) {
                        ilvRule.updateRule();
                        ilvRule.updateWeights();
                    }
                    bl2 = true;
                }
                if ((string + "Layout").equals(ilvSelector.getID())) {
                    if (!bl2 && bl) {
                        ilvSelector = ilvSelector.copy();
                    }
                    ilvSelector.setID(string2 + "Layout");
                    if (!bl) {
                        ilvRule.updateRule();
                        ilvRule.updateWeights();
                    }
                    bl2 = true;
                }
                if (string.equals(ilvSelector.getID())) {
                    if (!bl2 && bl) {
                        ilvSelector = ilvSelector.copy();
                    }
                    ilvSelector.setID(string2);
                    if (!bl) {
                        ilvRule.updateRule();
                        ilvRule.updateWeights();
                    }
                    bl2 = true;
                }
            }
            if (bl2 && bl) {
                this.getRuleModel().setSelector(ilvRule, ilvSelector);
            }
            if ((ilvCSSDeclarationArray = ilvRule.getCSSDeclarations()) == null) continue;
            for (int j = 0; j < ilvCSSDeclarationArray.length; ++j) {
                if (!(ilvCSSDeclarationArray[j] instanceof Declaration)) continue;
                Declaration declaration = (Declaration)ilvCSSDeclarationArray[j];
                this.a(ilvRule, declaration, string, string2, bl, "@+", "Attachment");
                this.a(ilvRule, declaration, string, string2, bl, "@+", "Layout");
                this.a(ilvRule, declaration, string, string2, bl, "@+", "");
                this.a(ilvRule, declaration, string, string2, bl, "@#", "Attachment");
                this.a(ilvRule, declaration, string, string2, bl, "@#", "Layout");
                this.a(ilvRule, declaration, string, string2, bl, "@#", "");
                this.a(ilvRule, declaration, string, string2, bl, "@=", "Attachment");
                this.a(ilvRule, declaration, string, string2, bl, "@=", "Layout");
                this.a(ilvRule, declaration, string, string2, bl, "@=", "");
                this.a(ilvRule, declaration, string, string2, bl, "", "");
            }
        }
    }

    private void a(IlvRule ilvRule, Declaration declaration, String string, String string2, boolean bl, String string3, String string4) {
        if ((string3 + string + string4).equals(declaration.getValue()) && declaration instanceof Declaration) {
            String string5 = string3 + string2 + string4;
            if (bl) {
                this.getRuleModel().setDeclarationValue(ilvRule, declaration.getProperty(), string5);
            } else {
                declaration.setValue(string5);
            }
        }
    }

    private void c(IlvRule[] ilvRuleArray) {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            for (int i = 0; i < ilvRuleArray.length; ++i) {
                IlvRule ilvRule = ilvRuleArray[i];
                if (ilvRule.getSelector() == null || ilvRule.getSelector().getID() == null || SymbolEditorUtilities.hasCondition(ilvRule)) continue;
                String string = ilvRule.getSelector().getID();
                IlvRule[] ilvRuleArray2 = this.getRuleModel().getRulesFromId(IlvRuleModel.ALL_RULES, string);
                if (ilvRuleArray2 != null && ilvRuleArray2.length > 0) {
                    String string2 = SymbolEditorUtilities.getUniqueRuleID(this, ilvRuleArray, string);
                    this.a(ilvRuleArray, string, string2, false);
                    bl = true;
                    continue block0;
                }
                if (bl) continue block0;
            }
        }
    }

    private boolean b(Object object) {
        return object instanceof IlvPaletteSymbol;
    }

    private boolean c(Object object) {
        return object instanceof IlvRule && !SymbolEditorUtilities.hasCondition((IlvRule)object);
    }

    public static boolean isConditionSelection(Object object) {
        return object instanceof IlvRule && SymbolEditorUtilities.hasCondition((IlvRule)object);
    }

    private boolean d(Object object) {
        return object instanceof IlvPaletteSymbolParameter;
    }

    private boolean e(Object object) {
        return IlvSymbolTreeRoot.elementsNode.equals(object);
    }

    private boolean f(Object object) {
        return IlvSymbolTreeRoot.parametersNode.equals(object);
    }

    private IlvRule a(IlvRule ilvRule, boolean bl) {
        IlvRule ilvRule2 = this.q.editCondition(ilvRule, this.r.getString("SymbolEditor." + (bl ? "Change" : "New") + "ConditionDialog.Title"), !bl);
        if (ilvRule2 != null) {
            try {
                IlvRule ilvRule3 = this.getRuleModel().getRule(ilvRule2.getSelectorString(), false);
                if (ilvRule3 != null && ilvRule3 != ilvRule) {
                    JOptionPane.showMessageDialog(null, this.r.getString("SymbolEditor.ConditionExistsDialog.Message"), this.r.getString("SymbolEditor.ConditionExistsDialog.Title"), 0);
                    return null;
                }
            }
            catch (IlvStylingException ilvStylingException) {
                ilvStylingException.printStackTrace();
            }
        }
        return ilvRule2;
    }

    public boolean canAlign() {
        return this.a(2);
    }

    public boolean canDistribute() {
        return this.a(3);
    }

    public void alignLeft() {
        this.a(1, false);
    }

    public void alignRight() {
        this.a(2, false);
    }

    public void alignTop() {
        this.a(4, false);
    }

    public void alignBottom() {
        this.a(8, false);
    }

    public void alignVerticalCenter() {
        this.a(64, false);
    }

    public void alignHorizontalCenter() {
        this.a(32, false);
    }

    public void distributeHorizontally() {
        this.a(96, false);
    }

    public void distributeVertically() {
        this.a(128, false);
    }

    public void sameWidth() {
        this.a(96, true);
    }

    public void sameHeight() {
        this.a(128, true);
    }

    private void a(final int n, boolean bl) {
        Object object;
        int n2;
        IlvRect ilvRect = null;
        float f = 0.0f;
        float f2 = 0.0f;
        ArrayList<IlvGraphic> arrayList = new ArrayList<IlvGraphic>();
        List list = this.getSelection();
        for (n2 = 0; n2 < list.size(); ++n2) {
            Object e = list.get(n2);
            if (!this.c(e)) continue;
            object = this.getRuleModel().getGraphicFromRule((IlvRule)e);
            arrayList.add((IlvGraphic)object);
            IlvRect ilvRect2 = ((IlvGraphic)object).boundingBox();
            if (ilvRect2 == null) continue;
            if (ilvRect == null) {
                ilvRect = ilvRect2;
            } else {
                ilvRect.add(ilvRect2);
            }
            if (n == 96) {
                f += ilvRect2.width;
            } else if (n == 128) {
                f += ilvRect2.height;
            }
            if (n2 != 0) continue;
            if (n == 96) {
                f2 = ilvRect2.width;
                continue;
            }
            if (n != 128) continue;
            f2 = ilvRect2.height;
        }
        n2 = arrayList.size();
        if (n2 < 2) {
            return;
        }
        float f3 = n == 96 ? (ilvRect.width - f) / (float)(n2 - 1) : (n == 128 ? (ilvRect.height - f) / (float)(n2 - 1) : 0.0f);
        if (n == 96 || n == 128) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    IlvRect ilvRect = ((IlvGraphic)object).boundingBox();
                    IlvRect ilvRect2 = ((IlvGraphic)object2).boundingBox();
                    if (n == 96) {
                        return (int)(ilvRect.x - ilvRect2.x);
                    }
                    return (int)(ilvRect.y - ilvRect2.y);
                }
            });
        }
        object = this.getRuleModel();
        this.a((IlvSymbolRuleModel)object, true);
        float f4 = 0.0f;
        for (int i = 0; i < n2; ++i) {
            IlvGraphic ilvGraphic = (IlvGraphic)arrayList.get(i);
            IlvRect ilvRect3 = ilvGraphic.boundingBox();
            IlvRect ilvRect4 = new IlvRect(ilvRect3);
            if (ilvRect3 == null) continue;
            switch (n) {
                case 1: {
                    ilvRect3.x = ilvRect.x;
                    break;
                }
                case 2: {
                    ilvRect3.x = ilvRect.x + ilvRect.width - ilvRect3.width;
                    break;
                }
                case 4: {
                    ilvRect3.y = ilvRect.y;
                    break;
                }
                case 8: {
                    ilvRect3.y = ilvRect.y + ilvRect.height - ilvRect3.height;
                    break;
                }
                case 32: {
                    ilvRect3.x = ilvRect.x + ilvRect.width / 2.0f - ilvRect3.width / 2.0f;
                    break;
                }
                case 64: {
                    ilvRect3.y = ilvRect.y + ilvRect.height / 2.0f - ilvRect3.height / 2.0f;
                    break;
                }
                case 96: {
                    if (bl) {
                        ilvRect3.width = f2;
                        break;
                    }
                    if (i > 0 && i < n2 - 1) {
                        ilvRect3.x = f4 + f3;
                    }
                    f4 = ilvRect3.x + ilvRect3.width;
                    break;
                }
                case 128: {
                    if (bl) {
                        ilvRect3.height = f2;
                        break;
                    }
                    if (i > 0 && i < n2 - 1) {
                        ilvRect3.y = f4 + f3;
                    }
                    f4 = ilvRect3.y + ilvRect3.height;
                }
            }
            if (bl) {
                ilvGraphic.resize(ilvRect3.width, ilvRect3.height);
            } else {
                ilvGraphic.move(ilvRect3.x, ilvRect3.y);
            }
            IlvRule ilvRule = ((IlvSymbolRuleModel)object).getMainRuleFromGraphic(ilvGraphic);
            ((IlvSymbolRuleModel)object).updateGeometry(ilvGraphic, ilvRule, !bl, new IlvPoint(ilvRect3.x - ilvRect4.x, ilvRect3.y - ilvRect4.y));
        }
        this.a((IlvSymbolRuleModel)object, false);
    }

    public boolean canFlipRotate() {
        List list = this.getSelection();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (this.c(e)) {
                IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e);
                if (!(ilvGraphic instanceof IlvGeneralPath)) {
                    return false;
                }
                ++n;
                continue;
            }
            return false;
        }
        return n > 0;
    }

    public void flipHorizontal() {
        this.a(-1, 1, 0);
    }

    public void flipVertical() {
        this.a(1, -1, 0);
    }

    public void rotateRight() {
        this.a(1, 1, 1);
    }

    public void rotateLeft() {
        this.a(1, 1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(int n, int n2, int n3) {
        List list = this.getSelection();
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        this.a(ilvSymbolRuleModel, true);
        try {
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (!this.c(e)) continue;
                IlvGeneralPath ilvGeneralPath = (IlvGeneralPath)this.getRuleModel().getGraphicFromRule((IlvRule)e);
                IlvRect ilvRect = ilvGeneralPath.boundingBox();
                IlvTransformer ilvTransformer = new IlvTransformer();
                float f = ilvRect.x + ilvRect.width / 2.0f;
                float f2 = ilvRect.y + ilvRect.height / 2.0f;
                ilvTransformer.scale(f, f2, n, n2);
                ilvTransformer.rotate(f, f2, n3 * 90);
                boolean bl = ilvGeneralPath.isTransformedShapeMode();
                ilvGeneralPath.setTransformedShapeMode(false);
                ilvGeneralPath.applyTransform(ilvTransformer);
                boolean bl2 = ilvGeneralPath.isPointEditionAllowed();
                ilvGeneralPath.setPointEditionAllowed(true);
                ilvSymbolRuleModel.updateGeometry(ilvGeneralPath, (IlvRule)e, false, null);
                ilvGeneralPath.setPointEditionAllowed(bl2);
                ilvGeneralPath.setTransformedShapeMode(bl);
            }
        }
        finally {
            this.a(ilvSymbolRuleModel, false);
        }
    }

    public UndoManager getUndoManager() {
        return this.ad;
    }

    public void undo() {
        if (this.ad == null || !this.canUndo()) {
            return;
        }
        boolean bl = this.ah;
        ++this.af;
        this.ah = true;
        this.a(this.getRuleModel(), true);
        try {
            this.ad.undo();
        }
        finally {
            this.a(this.getRuleModel(), false);
            this.a((List)null);
            this.ah = bl;
        }
    }

    public boolean canUndo() {
        return this.ad != null && this.ad.canUndo();
    }

    public void redo() {
        if (this.ad == null || !this.canRedo()) {
            return;
        }
        boolean bl = this.ah;
        ++this.af;
        this.ah = true;
        this.a(this.getRuleModel(), true);
        try {
            this.ad.redo();
        }
        finally {
            this.a(this.getRuleModel(), false);
            this.a((List)null);
            this.ah = bl;
        }
    }

    public boolean canRedo() {
        return this.ad != null && this.ad.canRedo();
    }

    public void beginAggregateUndoableEdits(String string) {
        ++this.ag;
        ++this.af;
        if (this.ae == null) {
            this.ae = new SymbolCompoundEdit(string);
            if (this.ad instanceof IlvUndoManager) {
                ((IlvUndoManager)this.ad).startAggregation(this.ae);
            } else {
                throw new RuntimeException("No IlvUndoManager");
            }
        }
    }

    public void endAggregateUndoableEdits() {
        --this.ag;
        ++this.af;
        if (this.ag == 0 && !this.getRuleModel().isAdjusting()) {
            if (!(this.ad instanceof IlvUndoManager)) {
                throw new RuntimeException("No IlvUndoManager");
            }
            ((IlvUndoManager)this.ad).stopAggregation();
            if (this.ae != null) {
                this.ae = null;
                IlvSymbolEditorAction.updateActions(this);
            } else {
                throw new RuntimeException("endAggregateUndoableEdits without beginAggregateUndoableEdits");
            }
        }
    }

    public boolean isAggregateUndoableEditsSignificant() {
        if (this.ae == null) {
            return false;
        }
        return this.ae.isSignificant();
    }

    private void a(EventObject eventObject) {
        if (this.ad == null || this.ah) {
            return;
        }
        AbstractUndoableEdit abstractUndoableEdit = null;
        if (eventObject instanceof CSSChangeEvent) {
            CSSChangeEvent cSSChangeEvent = (CSSChangeEvent)eventObject;
            if (cSSChangeEvent.getMode() == CSSChangeEvent.ADD) {
                abstractUndoableEdit = cSSChangeEvent.getDeclarations() == null ? new AddRuleEdit((CSSChangeEvent.Add)cSSChangeEvent) : new AddDeclarationsEdit((CSSChangeEvent.Add)cSSChangeEvent);
            } else if (cSSChangeEvent.getMode() == CSSChangeEvent.DELETE) {
                abstractUndoableEdit = cSSChangeEvent.getDeclarations() == null ? new RemoveRuleEdit((CSSChangeEvent.Remove)cSSChangeEvent) : new RemoveDeclarationsEdit((CSSChangeEvent.Remove)cSSChangeEvent);
            } else if (cSSChangeEvent.getMode() == CSSChangeEvent.SELECTOR_CHANGE) {
                abstractUndoableEdit = new SelectorEdit((CSSChangeEvent.SelectorChange)cSSChangeEvent);
            }
        } else if (eventObject instanceof SymbolChangedEvent) {
            if (!"topLevelGraphic".equals(((SymbolChangedEvent)eventObject).getProperty())) {
                abstractUndoableEdit = new SymbolEdit((SymbolChangedEvent)eventObject);
            }
        } else if (eventObject instanceof ParameterListChangedEvent) {
            ParameterListChangedEvent parameterListChangedEvent = (ParameterListChangedEvent)eventObject;
            if (parameterListChangedEvent.getType() == 1) {
                abstractUndoableEdit = new AddParameterEdit(parameterListChangedEvent.getParameter());
            } else if (parameterListChangedEvent.getType() == 2) {
                abstractUndoableEdit = new RemoveParameterEdit(parameterListChangedEvent.getParameter());
            } else if (parameterListChangedEvent.getType() == 3) {
                abstractUndoableEdit = new MoveParametersEdit(parameterListChangedEvent.getOldParameters());
            }
        }
        if (eventObject instanceof CSSChangeEvent) {
            if (((CSSChangeEvent)eventObject).isAdjusting()) {
                if (this.ae == null) {
                    this.ae = new SymbolCompoundEdit("");
                    if (this.ad instanceof IlvUndoManager) {
                        ((IlvUndoManager)this.ad).startAggregation(this.ae);
                    } else {
                        throw new RuntimeException("No IlvUndoManager");
                    }
                }
                if (abstractUndoableEdit != null) {
                    this.ad.addEdit(abstractUndoableEdit);
                }
            } else if (((CSSChangeEvent)eventObject).getMode() == CSSChangeEvent.ADJUSTMENT_END && !this.getRuleModel().isAdjusting() && this.ag == 0) {
                if (this.ae != null) {
                    if (this.ad instanceof IlvUndoManager) {
                        ((IlvUndoManager)this.ad).stopAggregation();
                    } else {
                        throw new RuntimeException("No IlvUndoManager");
                    }
                }
                this.ae = null;
            } else if (abstractUndoableEdit != null) {
                this.ad.addEdit(abstractUndoableEdit);
            }
        } else if (abstractUndoableEdit != null) {
            this.ad.addEdit(abstractUndoableEdit);
        }
    }

    private void c(List list) {
        if (this.ad == null || this.ah) {
            return;
        }
        SelectionEdit selectionEdit = new SelectionEdit(list, this.getSelection());
        this.ad.addEdit(selectionEdit);
    }

    private void a(IlvRule ilvRule, String string, String string2) {
        if (this.ad == null) {
            return;
        }
        RenameEdit renameEdit = new RenameEdit(ilvRule, string, string2);
        this.ad.addEdit(renameEdit);
    }

    public void customizerChangedStyle(IlvCSSDeclaration[] ilvCSSDeclarationArray, IlvRule ilvRule) {
        if (ilvCSSDeclarationArray == null && ilvRule == null) {
            return;
        }
        if (ilvRule != null) {
            boolean bl = this.ah;
            this.ah = true;
            this.getRuleModel().removeRule(ilvRule);
            this.ah = bl;
        }
        if (this.ad == null) {
            return;
        }
        if (this.ah) {
            IlvSymbolEditorAction.updateActions(this);
            return;
        }
        StyleChangeEdit styleChangeEdit = new StyleChangeEdit(ilvCSSDeclarationArray, ilvRule);
        this.ad.addEdit(styleChangeEdit);
        IlvSymbolEditorAction.updateActions(this);
    }

    private String c(String string) {
        if (string.length() > 10) {
            string = string.substring(0, 10) + "...";
        }
        return string;
    }

    public String getDeclarationUndoPresentationName(String string, String string2) {
        return MessageFormat.format(this.getString("SymbolEditor.Undo.Change"), string, this.c(string2));
    }

    public void setSelected(boolean bl) {
        if (bl != this.v) {
            this.v = bl;
            if (!this.getRuleModel().isAdjusting()) {
                this.applyChanges();
            }
        }
    }

    public boolean isSelected() {
        return this.v;
    }

    public void setContrastMode(String string) {
        if (string != this.w) {
            this.w = string;
            if (!this.getRuleModel().isAdjusting()) {
                this.applyChanges();
            }
        }
    }

    public String getContrastMode() {
        return this.w;
    }

    public void setLevelOfDetailMode(String string) {
        if (string != this.x) {
            this.x = string;
            if (!this.getRuleModel().isAdjusting()) {
                this.applyChanges();
            }
        }
    }

    public String getLevelOfDetailMode() {
        return this.x;
    }

    private boolean a(IlvRule ilvRule, String string) {
        String[] stringArray = ilvRule.getPseudoClasses();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    boolean a() {
        return this.y;
    }

    private void a(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.a(file2);
            }
            file2.delete();
        }
    }

    public void setPortIn() {
        this.d("port_in_");
    }

    public void setPortOut() {
        this.d("port_out_");
    }

    public void setPortInOut() {
        this.d("port_inout_");
    }

    public void unsetPort() {
        this.d(null);
    }

    private void d(String string) {
        List list = this.getSelection();
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        this.a(ilvSymbolRuleModel, true);
        try {
            for (int i = 0; i < list.size(); ++i) {
                String string2;
                String string3;
                String string4;
                IlvGraphic ilvGraphic;
                block22: {
                    block23: {
                        Object e = list.get(i);
                        if (!this.c(e) || (ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e)) == null) continue;
                        string4 = ilvGraphic.getName();
                        if (string != null) break block22;
                        if (string4.startsWith("port_in_")) break block23;
                        if (string4.startsWith("port_out_")) break block23;
                        if (!string4.startsWith("port_inout_")) break block22;
                    }
                    string3 = ilvGraphic.getClass().getName();
                    if (string4.startsWith("port_")) {
                        string2 = string4;
                        if (string4.startsWith("port_inout_")) {
                            string2 = string4.substring(11);
                        } else if (string4.startsWith("port_in_")) {
                            string2 = string4.substring(8);
                        } else if (string4.startsWith("port_out_")) {
                            string2 = string4.substring(9);
                        }
                        string3 = string2;
                    }
                    string2 = null;
                    string2 = SymbolEditorUtilities.findGraphicByName(this, string3) == null ? string3 : SymbolEditorUtilities.getUniqueGraphicName(this, string3);
                    this.a(ilvGraphic, string2, true, true);
                    continue;
                }
                string3 = string + string4;
                if (string4.startsWith("port_")) {
                    string2 = string4;
                    if (string4.startsWith("port_inout_")) {
                        string2 = string4.substring(11);
                    } else if (string4.startsWith("port_in_")) {
                        string2 = string4.substring(8);
                    } else if (string4.startsWith("port_out_")) {
                        string2 = string4.substring(9);
                    }
                    string3 = string + string2;
                }
                this.renameObject(ilvGraphic, string3);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            this.a(ilvSymbolRuleModel, false);
        }
    }

    public boolean canSetPort() {
        boolean bl = this.hasSelection(false, true);
        return bl;
    }

    public boolean canUnsetPort() {
        boolean bl = false;
        List list = this.getSelection();
        for (int i = 0; i < list.size(); ++i) {
            block6: {
                IlvGraphic ilvGraphic;
                block5: {
                    Object e = list.get(i);
                    if (!this.c(e) || (ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e)) == null) continue;
                    if (ilvGraphic == null) break block5;
                    if (ilvGraphic.getName().startsWith("port_in_")) break block6;
                }
                if (!ilvGraphic.getName().startsWith("port_out_")) {
                    if (!ilvGraphic.getName().startsWith("port_inout_")) continue;
                }
            }
            bl = true;
            break;
        }
        return bl && this.hasSelection(false, true);
    }

    public IlvPaletteSymbol getOriginalSymbol() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newMultipleImage(IlvGraphic ilvGraphic, IlvRect ilvRect, IlvURLKeyTable ilvURLKeyTable, IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
        String string = ilvGraphic.getName();
        if (string == null) {
            string = ilvGraphic.getClass().getName();
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            if (string.startsWith("Ilv")) {
                string = string.substring(3);
            }
        }
        this.a(this.getRuleModel(), true);
        try {
            IlvRule ilvRule = this.addObject(ilvGraphic, string, ilvRect);
            String string2 = "ImageList" + ilvRule.getSelector().getID();
            ilvRule.setDeclaration("imageTable", "@+" + string2);
            if ("int".equals(ilvPaletteSymbolParameter.getType())) {
                ilvRule.setDeclaration("showIndex", "@" + ilvPaletteSymbolParameter.getName());
            } else {
                ilvRule.setDeclaration("showKey", "@" + ilvPaletteSymbolParameter.getName());
            }
            IlvCSSWriter ilvCSSWriter = new IlvCSSWriter(this.f.getDOMImplementation());
            IlvCSSWriter.IlvCSSCustomizerDeclarations ilvCSSCustomizerDeclarations = ilvCSSWriter.convert(string2, ilvURLKeyTable, null);
            IlvRule ilvRule2 = this.getRuleModel().getRule(string2, true);
            ilvRule2.setDeclarations(ilvCSSCustomizerDeclarations.getDeclarations());
            ilvRule2.getSelector().setType("Subobject");
            ilvRule2.getSelector().setID(string2);
            ilvRule2.updateRule();
            ilvRule2.updateWeights();
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IlvStylingException ilvStylingException) {
            ilvStylingException.printStackTrace();
        }
        finally {
            this.a(this.getRuleModel(), false);
        }
    }

    public void printRulesToStdErr() {
        this.printRules(new PrintWriter(System.err, true));
    }

    public void printRules(PrintWriter printWriter) {
        printWriter.println("The rules are: ");
        IlvRule[] ilvRuleArray = this.getRuleModel().getAllRules(true);
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            ilvRuleArray[i].printCSS(printWriter);
        }
        printWriter.println("Internal rules are: ");
        Rule[] ruleArray = this.getRuleModel().getCSSBeans().getCSSengine().getRules(true);
        for (int i = 0; i < ruleArray.length; ++i) {
            ruleArray[i].printCSS(printWriter);
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = designModePseudoClass;
        designModePseudoClasses = stringArray;
        confirmRuleUpdateWhenParameterRenamed = true;
        confirmRuleUpdateWhenParameterDeleted = true;
        j.put(FrameworkComponentType, "ilog.views.symbology.editor.rules.IlvSymbolRuleModel");
        j.put(DiagrammerComponentType, "ilog.views.symbology.editor.diagrammer.rules.DiagrammerSymbolRuleModel");
        j.put(GanttComponentType, "ilog.views.symbology.editor.gantt.rules.GanttSymbolRuleModel");
        IlvCSSWriter.setIgnoredProperty(IlvText.class, "attributedLabel");
    }

    private class StyleChangeEdit
    extends AbstractUndoableEdit {
        private UndoableEdit a;
        private String b;
        private IlvRule c;

        public StyleChangeEdit(IlvCSSDeclaration[] ilvCSSDeclarationArray, IlvRule ilvRule) {
            try {
                block7: {
                    block4: {
                        String string;
                        String string2;
                        block6: {
                            block5: {
                                if (ilvCSSDeclarationArray == null || ilvCSSDeclarationArray.length != 1) break block4;
                                string2 = ilvCSSDeclarationArray[0].getProperty();
                                string = ilvCSSDeclarationArray[0].getValue();
                                if (string.startsWith("@#")) break block5;
                                if (string.startsWith("@+")) break block5;
                                if (!string.startsWith("@=")) break block6;
                            }
                            string = IlvSymbolEditorDocument.this.getString("SymbolEditor.Undo.ComplexValue");
                        }
                        this.b = IlvSymbolEditorDocument.this.getDeclarationUndoPresentationName(string2, string);
                        break block7;
                    }
                    this.b = IlvSymbolEditorDocument.this.getString("SymbolEditor.Undo.StyleChanges");
                }
                this.c = ilvRule;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.b = IlvSymbolEditorDocument.this.getString("SymbolEditor.Undo.StyleChanges");
                this.c = ilvRule;
            }
        }

        @Override
        public boolean replaceEdit(UndoableEdit undoableEdit) {
            this.a = undoableEdit;
            return true;
        }

        @Override
        public String getPresentationName() {
            return this.b;
        }

        @Override
        public boolean isSignificant() {
            if (this.a != null) {
                return this.a.isSignificant();
            }
            return super.isSignificant();
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.c != null) {
                IlvSymbolEditorDocument.this.getRuleModel().addRule(this.c);
            }
            this.a.undo();
            IlvSymbolEditorAction.updateActions(IlvSymbolEditorDocument.this);
        }

        @Override
        public void redo() throws CannotRedoException {
            this.a.redo();
            if (this.c != null) {
                IlvSymbolEditorDocument.this.getRuleModel().removeRule(this.c);
            }
            IlvSymbolEditorAction.updateActions(IlvSymbolEditorDocument.this);
        }

        @Override
        public boolean canRedo() {
            return this.a.canRedo();
        }

        @Override
        public boolean canUndo() {
            return this.a.canUndo();
        }
    }

    private class SelectionEdit
    extends AbstractUndoableEdit {
        private List a;
        private List b;

        public SelectionEdit(List list, List list2) {
            this.a = list;
            this.b = list2;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolEditorDocument.this.a(this.a, false);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolEditorDocument.this.a(this.b, false);
        }
    }

    private class MoveParametersEdit
    extends AbstractUndoableEdit {
        IlvPaletteSymbolParameter[] a;
        IlvPaletteSymbolParameter[] b;

        public MoveParametersEdit(IlvPaletteSymbolParameter[] ilvPaletteSymbolParameterArray) {
            this.a = ilvPaletteSymbolParameterArray;
            int n = IlvSymbolEditorDocument.this.a.getParameterCount();
            this.b = new IlvPaletteSymbolParameter[n];
            for (int i = 0; i < n; ++i) {
                this.b[i] = IlvSymbolEditorDocument.this.a.getParameter(i);
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.a(this.a);
            IlvSymbolEditorDocument.this.a(this.b);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.a(this.b);
            IlvSymbolEditorDocument.this.a(this.a);
        }

        private void a(IlvPaletteSymbolParameter[] ilvPaletteSymbolParameterArray) {
            IlvSymbolEditorDocument.this.a.removeAllParameters();
            for (int i = 0; i < ilvPaletteSymbolParameterArray.length; ++i) {
                IlvSymbolEditorDocument.this.a.addParameter(ilvPaletteSymbolParameterArray[i]);
            }
        }
    }

    private class RemoveParameterEdit
    extends AbstractUndoableEdit {
        IlvPaletteSymbolParameter a;

        public RemoveParameterEdit(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
            this.a = ilvPaletteSymbolParameter;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolEditorDocument.this.addParameter(this.a);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolEditorDocument.this.removeParameter(this.a);
        }
    }

    private class AddParameterEdit
    extends AbstractUndoableEdit {
        IlvPaletteSymbolParameter a;

        public AddParameterEdit(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
            this.a = ilvPaletteSymbolParameter;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolEditorDocument.this.removeParameter(this.a);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolEditorDocument.this.addParameter(this.a);
        }
    }

    private class SymbolEdit
    extends AbstractUndoableEdit {
        private Object a;
        private String b;
        private Object c;
        private Object d;
        private String e;

        public SymbolEdit(SymbolChangedEvent symbolChangedEvent) {
            this.a = symbolChangedEvent.getChangedObject();
            this.b = symbolChangedEvent.getProperty();
            this.c = symbolChangedEvent.getOldValue();
            this.d = symbolChangedEvent.getNewValue();
            this.e = MessageFormat.format(IlvSymbolEditorDocument.this.getString("SymbolEditor.Undo.Change"), this.b, this.d instanceof String ? IlvSymbolEditorDocument.this.c((String)this.d) : IlvSymbolEditorDocument.this.getString("SymbolEditor.Undo.ComplexValue"));
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.a(true);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.a(false);
        }

        private void a(boolean bl) {
            Object object = bl ? this.c : this.d;
            if (this.b.equals("name")) {
                if (this.a == IlvSymbolEditorDocument.this.a) {
                    IlvSymbolEditorDocument.this.renameSymbol((String)object);
                } else if (this.a instanceof IlvPaletteSymbolParameter) {
                    IlvSymbolEditorDocument.this.renameParameter((IlvPaletteSymbolParameter)this.a, (String)object);
                }
            } else {
                String string = Character.toUpperCase(this.b.charAt(0)) + this.b.substring(1);
                String string2 = "get" + string;
                String string3 = "set" + string;
                try {
                    Class clazz;
                    Method method = this.a.getClass().getMethod(string2, null);
                    Object object2 = method.invoke(this.a, (Object[])null);
                    if (this.b.equals("value")) {
                        clazz = Object.class;
                    } else if (this.b.equals("valueSet")) {
                        clazz = IlvPaletteSymbolParameterValueSet.class;
                    } else if (this.d != null) {
                        clazz = this.d.getClass();
                    } else if (this.c != null) {
                        clazz = this.c.getClass();
                    } else {
                        throw new RuntimeException("Cannot determine type of property " + this.b);
                    }
                    Method method2 = this.a.getClass().getMethod(string3, clazz);
                    method2.invoke(this.a, object);
                    IlvSymbolEditorDocument.this.fireSymbolChanged(this.a, this.b, object2, object);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }

        @Override
        public String getPresentationName() {
            return this.e;
        }
    }

    private class RenameEdit
    extends AbstractUndoableEdit {
        private IlvRule a;
        private String b;
        private String c;
        private String d;

        public RenameEdit(IlvRule ilvRule, String string, String string2) {
            this.a = ilvRule;
            this.b = string;
            this.c = string2;
            this.d = IlvSymbolEditorDocument.this.getString("SymbolEditor.Undo.Rename");
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            IlvGraphic ilvGraphic = IlvSymbolEditorDocument.this.getRuleModel().getGraphicFromRule(this.a);
            IlvSymbolEditorDocument.this.a(ilvGraphic, this.b, false, false);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            IlvGraphic ilvGraphic = IlvSymbolEditorDocument.this.getRuleModel().getGraphicFromRule(this.a);
            IlvSymbolEditorDocument.this.a(ilvGraphic, this.c, false, false);
        }

        @Override
        public String getPresentationName() {
            return this.d;
        }
    }

    private class SelectorEdit
    extends AbstractUndoableEdit {
        private IlvRule a;
        private IlvSelector[] b;
        private IlvSelector[] c;

        public SelectorEdit(CSSChangeEvent.SelectorChange selectorChange) {
            this.a = selectorChange.getRule();
            this.b = IlvRuleUtils.copySelector(selectorChange.getOldSelector());
            this.c = IlvRuleUtils.copySelector(this.a.getSelectors());
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            ilvSymbolRuleModel.setSelector(this.a, IlvRuleUtils.copySelector(this.b));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            ilvSymbolRuleModel.setSelector(this.a, IlvRuleUtils.copySelector(this.c));
        }
    }

    private class RemoveRuleEdit
    extends AbstractUndoableEdit {
        private int a;
        private ArrayList b;
        private IlvPoint c;
        private IlvPoint d;

        public RemoveRuleEdit(CSSChangeEvent.Remove remove) {
            this.a = IlvSymbolEditorDocument.this.af;
            this.b = new ArrayList();
            this.b.add(remove.getRule());
            this.d = IlvSymbolEditorDocument.this.s;
            this.c = IlvSymbolEditorDocument.this.t;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            IlvSymbolEditorDocument.this.s = this.c;
            for (int i = 0; i < this.b.size(); ++i) {
                IlvRule ilvRule = (IlvRule)this.b.get(i);
                ilvSymbolRuleModel.addRule(ilvRule);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolEditorDocument.this.s = this.d;
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            for (int i = 0; i < this.b.size(); ++i) {
                IlvRule ilvRule = (IlvRule)this.b.get(i);
                ilvSymbolRuleModel.removeRule(ilvRule);
            }
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof RemoveRuleEdit) {
                RemoveRuleEdit removeRuleEdit = (RemoveRuleEdit)undoableEdit;
                if (this.a == removeRuleEdit.a) {
                    for (int i = 0; i < removeRuleEdit.b.size(); ++i) {
                        this.b.add(removeRuleEdit.b.get(i));
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private class AddRuleEdit
    extends AbstractUndoableEdit {
        private int a;
        private ArrayList b;
        private IlvPoint c;
        private IlvPoint d;

        public AddRuleEdit(CSSChangeEvent.Add add) {
            this.a = IlvSymbolEditorDocument.this.af;
            this.b = new ArrayList();
            this.b.add(add.getRule());
            this.d = IlvSymbolEditorDocument.this.s;
            this.c = IlvSymbolEditorDocument.this.t;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            IlvSymbolEditorDocument.this.s = this.c;
            for (int i = 0; i < this.b.size(); ++i) {
                IlvRule ilvRule = (IlvRule)this.b.get(i);
                ilvSymbolRuleModel.removeRule(ilvRule);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            IlvSymbolEditorDocument.this.s = this.d;
            for (int i = 0; i < this.b.size(); ++i) {
                IlvRule ilvRule = (IlvRule)this.b.get(i);
                ilvSymbolRuleModel.addRule(ilvRule);
            }
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof AddRuleEdit) {
                AddRuleEdit addRuleEdit = (AddRuleEdit)undoableEdit;
                if (this.a == addRuleEdit.a) {
                    for (int i = 0; i < addRuleEdit.b.size(); ++i) {
                        this.b.add(addRuleEdit.b.get(i));
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private class RemoveDeclarationsEdit
    extends AbstractUndoableEdit {
        private IlvRule a;
        private ArrayList b = new ArrayList();
        private ArrayList c = new ArrayList();

        public RemoveDeclarationsEdit(CSSChangeEvent.Remove remove) {
            this.a = remove.getRule();
            Declaration[] declarationArray = remove.getDeclarations();
            if (declarationArray != null) {
                for (int i = 0; i < declarationArray.length; ++i) {
                    String string = declarationArray[i].getProperty();
                    String string2 = declarationArray[i].getValue();
                    this.b.add(string);
                    this.c.add(string2);
                }
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            for (int i = 0; i < this.b.size(); ++i) {
                String string = (String)this.b.get(i);
                ilvSymbolRuleModel.setDeclarationValue(this.a, string, (String)this.c.get(i));
                this.a.resetModified(string);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            for (int i = 0; i < this.b.size(); ++i) {
                String string = (String)this.b.get(i);
                ilvSymbolRuleModel.removeDeclaration(this.a, string);
            }
        }

        @Override
        public String getPresentationName() {
            return super.getPresentationName();
        }
    }

    private class AddDeclarationsEdit
    extends AbstractUndoableEdit {
        private int a;
        private HashMap b;
        private IlvPoint c;
        private IlvPoint d;

        public AddDeclarationsEdit(CSSChangeEvent.Add add) {
            this.a = IlvSymbolEditorDocument.this.af;
            this.b = new HashMap();
            Declarations declarations = new Declarations(add);
            this.b.put(declarations.a, declarations);
            this.d = IlvSymbolEditorDocument.this.s;
            this.c = IlvSymbolEditorDocument.this.t;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            Iterator iterator = this.b.values().iterator();
            while (iterator.hasNext()) {
                ((Declarations)iterator.next()).undo();
            }
            IlvSymbolEditorDocument.this.s = this.c;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            Iterator iterator = this.b.values().iterator();
            while (iterator.hasNext()) {
                ((Declarations)iterator.next()).redo();
            }
            IlvSymbolEditorDocument.this.s = this.d;
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof AddDeclarationsEdit) {
                AddDeclarationsEdit addDeclarationsEdit = (AddDeclarationsEdit)undoableEdit;
                if (this.a == addDeclarationsEdit.a) {
                    for (Declarations declarations : addDeclarationsEdit.b.values()) {
                        Declarations declarations2 = (Declarations)this.b.get(declarations.a);
                        if (declarations2 != null) {
                            declarations2.b(declarations);
                            continue;
                        }
                        this.b.put(declarations.a, declarations);
                    }
                    return true;
                }
            }
            return false;
        }

        private class Declarations {
            private IlvRule a;
            private ArrayList b = new ArrayList();
            private ArrayList c = new ArrayList();
            private ArrayList d = new ArrayList();

            public Declarations(CSSChangeEvent.Add add) {
                this.a = add.getRule();
                Declaration[] declarationArray = add.getDeclarations();
                if (declarationArray != null) {
                    for (int i = 0; i < declarationArray.length; ++i) {
                        String string = declarationArray[i].getProperty();
                        String string2 = this.a.getDeclarationValue(string);
                        String string3 = this.a.getOldValue(string);
                        this.b.add(string);
                        this.c.add(string3);
                        this.d.add(string2);
                        this.a.setUnModified(string);
                    }
                }
            }

            public void undo() {
                IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
                for (int i = 0; i < this.b.size(); ++i) {
                    String string = (String)this.b.get(i);
                    if (this.c.get(i) != null) {
                        ilvSymbolRuleModel.setDeclarationValue(this.a, string, (String)this.c.get(i));
                        this.a.resetModified(string);
                        this.a.setDeclarationValue(string, (String)this.c.get(i));
                        continue;
                    }
                    ilvSymbolRuleModel.removeDeclaration(this.a, string);
                }
            }

            public void redo() {
                IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
                for (int i = 0; i < this.b.size(); ++i) {
                    String string = (String)this.b.get(i);
                    ilvSymbolRuleModel.setDeclarationValue(this.a, string, (String)this.d.get(i));
                    this.a.resetModified(string);
                    this.a.setDeclarationValue(string, (String)this.d.get(i));
                }
            }

            private void b(Declarations declarations) {
                for (int i = 0; i < declarations.b.size(); ++i) {
                    int n = this.b.indexOf(declarations.b.get(i));
                    if (n >= 0) {
                        this.d.set(n, declarations.d.get(i));
                        continue;
                    }
                    this.b.add(declarations.b.get(i));
                    this.c.add(declarations.c.get(i));
                    this.d.add(declarations.d.get(i));
                }
            }
        }
    }

    private class SymbolCompoundEdit
    extends CompoundEdit {
        private int a;
        private String b;

        public SymbolCompoundEdit(String string) {
            this.a = IlvSymbolEditorDocument.this.af;
            this.b = string;
        }

        @Override
        public String getPresentationName() {
            if (this.b == null) {
                return this.a().getPresentationName();
            }
            return this.b;
        }

        private UndoableEdit a() {
            UndoableEdit undoableEdit = null;
            for (UndoableEdit undoableEdit2 : this.edits) {
                if (!(undoableEdit2 instanceof SymbolEdit)) continue;
                undoableEdit = undoableEdit2;
            }
            return undoableEdit != null ? undoableEdit : this.lastEdit();
        }

        @Override
        public String getUndoPresentationName() {
            String string = this.getPresentationName();
            if (string == null) {
                return this.a().getUndoPresentationName();
            }
            string = !"".equals(string) ? UIManager.getString("AbstractUndoableEdit.undoText") + " " + string : UIManager.getString("AbstractUndoableEdit.undoText");
            return string;
        }

        @Override
        public String getRedoPresentationName() {
            String string = this.getPresentationName();
            if (string == null) {
                return this.a().getRedoPresentationName();
            }
            string = !"".equals(string) ? UIManager.getString("AbstractUndoableEdit.redoText") + " " + string : UIManager.getString("AbstractUndoableEdit.redoText");
            return string;
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof SymbolCompoundEdit) {
                SymbolCompoundEdit symbolCompoundEdit = (SymbolCompoundEdit)undoableEdit;
                if (this.a == symbolCompoundEdit.a && this.edits.size() == 1 && symbolCompoundEdit.edits.size() == 1 && this.edits.get(0) instanceof AddDeclarationsEdit && symbolCompoundEdit.edits.get(0) instanceof AddDeclarationsEdit) {
                    this.edits.get(0).addEdit(symbolCompoundEdit.edits.get(0));
                    return true;
                }
            }
            return super.addEdit(undoableEdit);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
        }
    }

    private class VisibleFunction
    extends IlvCSSFunction {
        private VisibleFunction() {
        }

        @Override
        public String getName() {
            return "visible";
        }

        @Override
        public Object call(Object[] objectArray, Class clazz, IlvCSSModel ilvCSSModel, Object object, Object object2, Object object3) {
            ((IlvGraphic)object2).setProperty(IlvSymbolEditorDocument.invisibleProperty, Boolean.FALSE.equals(objectArray[0]) ? Boolean.TRUE : null);
            ((IlvGraphic)object2).setProperty(IlvSymbolEditorDocument.unrealizedProperty, Boolean.FALSE.equals(objectArray[1]) ? Boolean.TRUE : null);
            return Boolean.TRUE;
        }
    }

    private class SymbolEditorLayer
    extends IlvManagerLayer {
        private boolean a;

        private SymbolEditorLayer() {
        }

        @Override
        protected void draw(Graphics graphics, IlvManagerView ilvManagerView) {
            try {
                this.a = true;
                super.draw(graphics, ilvManagerView);
            }
            finally {
                this.a = false;
            }
        }

        @Override
        public void mapIntersects(IlvRect ilvRect, IlvRect ilvRect2, IlvApplyObject ilvApplyObject, Object object, final IlvTransformer ilvTransformer) {
            if (this.a) {
                ilvApplyObject = new IlvApplyObject(){

                    @Override
                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        if (ilvGraphic.isVisible()) {
                            if (ilvGraphic instanceof IlvCompositeGraphic) {
                                SymbolEditorLayer.this.a((IlvCompositeGraphic)ilvGraphic, (Graphics)object, ilvTransformer);
                            } else {
                                ilvGraphic.draw((Graphics)object, ilvTransformer);
                            }
                        }
                    }
                };
            }
            super.mapIntersects(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
        }

        private void a(IlvCompositeGraphic ilvCompositeGraphic, Graphics graphics, IlvTransformer ilvTransformer) {
            if (ilvCompositeGraphic.getLayout() != null && !ilvCompositeGraphic.isValid()) {
                ilvCompositeGraphic.doLayout();
            }
            double d = ilvTransformer != null ? Math.abs(ilvTransformer.zoomFactor()) : 1.0;
            IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
            if (ilvGraphicArray == null) {
                return;
            }
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                IlvGraphic ilvGraphic;
                if (d < ilvCompositeGraphic.getVisibilityThresholds(i) || (ilvGraphic = ilvGraphicArray[i]) == null || !ilvGraphic.isVisible()) continue;
                float f = 1.0f;
                if (ilvGraphic.getProperty(IlvSymbolEditorDocument.unrealizedProperty) != null) {
                    f /= 4.0f;
                }
                if (ilvGraphic.getProperty(IlvSymbolEditorDocument.invisibleProperty) != null) {
                    f /= 2.0f;
                }
                if (f != 1.0f) {
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
                    ((Graphics2D)graphics).setComposite(alphaComposite);
                    ilvGraphic.draw(graphics, ilvTransformer);
                    ((Graphics2D)graphics).setComposite(AlphaComposite.SrcOver);
                    continue;
                }
                ilvGraphic.draw(graphics, ilvTransformer);
            }
        }
    }

    private class SymbolAttributeHandler
    implements IlvCSSEngine.AttributeHandler {
        private IlvCSSEngine.AttributeHandler a;

        SymbolAttributeHandler(IlvCSSEngine.AttributeHandler attributeHandler) {
            this.a = attributeHandler;
        }

        @Override
        public Object computeAttributeNameValue(IlvCSSModel ilvCSSModel, Object object, String string) {
            return this.a.computeAttributeNameValue(ilvCSSModel, object, string);
        }

        @Override
        public int evaluateAttributeSelector(IlvCSSModel ilvCSSModel, Object object, AttributeSelector attributeSelector) {
            if (IlvSymbolEditorDocument.this.getRuleModel().getCSSBeans().isProcessingSymbol()) {
                return this.a.evaluateAttributeSelector(ilvCSSModel, object, attributeSelector);
            }
            List list = IlvSymbolEditorDocument.this.getSelection();
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (IlvSymbolEditorDocument.isConditionSelection(e)) {
                    bl = true;
                    IlvSelector ilvSelector = ((IlvRule)e).getSelector();
                    IlvCSSAttributeSelector[] ilvCSSAttributeSelectorArray = ilvSelector.getAttributes();
                    for (int j = 0; j < ilvCSSAttributeSelectorArray.length; ++j) {
                        if (!attributeSelector.deepEquals(ilvCSSAttributeSelectorArray[j])) continue;
                        return 1;
                    }
                    continue;
                }
                if (!IlvSymbolEditorDocument.this.c(e)) continue;
                bl2 = true;
            }
            if (bl) {
                return 0;
            }
            if (bl2) {
                return 0;
            }
            return this.a.evaluateAttributeSelector(ilvCSSModel, object, attributeSelector);
        }

        @Override
        public boolean usesModelAttributes(Set<String> set, AttributeSelector attributeSelector) {
            return this.a.usesModelAttributes(set, attributeSelector);
        }

        @Override
        public void collectUsedAttributeNames(AttributeSelector attributeSelector, Set<String> set, Set<String> set2) {
            this.a.collectUsedAttributeNames(attributeSelector, set, set2);
        }
    }

    private class SymbolCSSModel
    implements IlvCSSModel {
        IdentityHashMap a = null;

        private SymbolCSSModel() {
        }

        void a() {
            if (IlvSymbolEditorDocument.this.y) {
                return;
            }
            this.a = new IdentityHashMap();
            IlvPaletteSymbol ilvPaletteSymbol = IlvSymbolEditorDocument.this.getSymbol();
            for (int i = 0; i < ilvPaletteSymbol.getParameterCount(); ++i) {
                IlvPaletteSymbolParameter ilvPaletteSymbolParameter = ilvPaletteSymbol.getParameter(i);
                this.a.put(ilvPaletteSymbolParameter.getID().intern(), ilvPaletteSymbolParameter.getValue());
            }
            IlvSymbolEditorDocument.this.y = true;
            IlvSymbolEditorDocument.this.u = null;
            IlvSymbolEditorDocument.this.setSelected(false);
            IlvSymbolEditorDocument.this.setContrastMode(null);
            IlvSymbolEditorDocument.this.setLevelOfDetailMode(null);
        }

        void b() {
            if (!IlvSymbolEditorDocument.this.y) {
                return;
            }
            this.a = null;
            IlvSymbolEditorDocument.this.y = false;
            if (IlvSymbolEditorDocument.this.u != null) {
                IlvSymbolEditorDocument.this.applyChanges(true);
            }
            IlvSymbolEditorDocument.this.u = null;
            IlvSymbolEditorDocument.this.setSelected(false);
            IlvSymbolEditorDocument.this.setContrastMode(null);
            IlvSymbolEditorDocument.this.setLevelOfDetailMode(null);
            IlvSymbolEditorDocument.this.getManager().deSelectAll(true);
        }

        @Override
        public Object[] getChildrenAsArray(Object object) {
            return null;
        }

        @Override
        public String getType(Object object) {
            return IlvSymbolEditorDocument.this.f.getType();
        }

        @Override
        public String getCSSclasses(Object object) {
            return null;
        }

        @Override
        public String getID(Object object) {
            return null;
        }

        @Override
        public String getValue(Object object, String string) {
            Object object2 = null;
            if (IlvSymbolEditorDocument.this.y) {
                object2 = this.a.get(string);
            } else {
                IlvPaletteSymbolParameter ilvPaletteSymbolParameter = IlvSymbolEditorDocument.this.a.getParameter(string);
                if (ilvPaletteSymbolParameter != null) {
                    object2 = ilvPaletteSymbolParameter.getValue();
                }
            }
            if (object2 != null) {
                try {
                    return IlvConvert.convertToString(object2);
                }
                catch (IlvConvertException ilvConvertException) {
                    ilvConvertException.printStackTrace();
                    return null;
                }
            }
            return null;
        }

        @Override
        public Object getValueAsObject(Object object, String string) {
            if (IlvSymbolEditorDocument.this.y) {
                return this.a.get(string);
            }
            IlvPaletteSymbolParameter ilvPaletteSymbolParameter = IlvSymbolEditorDocument.this.a.getParameter(string);
            if (ilvPaletteSymbolParameter != null) {
                return ilvPaletteSymbolParameter.getValue();
            }
            return null;
        }

        @Override
        public ULocale getULocale(Object object) {
            return IlvSymbolEditorDocument.this.i.getULocale();
        }

        @Override
        public ComponentOrientation getComponentOrientation(Object object) {
            return IlvSymbolEditorDocument.this.i.getComponentOrientation();
        }

        void a(String string, Object object) {
            if (!IlvSymbolEditorDocument.this.y) {
                throw new RuntimeException("setValueAsObject in design mode should not happen");
            }
            this.a.put(string.intern(), object);
        }
    }

    private class CSSHook
    implements IlvCSSBeans.AppliedDeclarationHook {
        private CSSHook() {
        }

        @Override
        public void applyDeclarations(IlvCSSModel ilvCSSModel, Object object, Object object2, String[] stringArray, IlvApplicableDeclarationCollection ilvApplicableDeclarationCollection, Collection<String> collection, int n) {
            IlvSymbolEditorDocument.this.appliedDeclarations(ilvCSSModel, object, object2, stringArray, ilvApplicableDeclarationCollection, collection, n);
        }
    }

    private class SelectedInfo
    implements Comparable {
        Object a;
        IlvGraphic b;
        Object c;
        int d;
        int e;

        SelectedInfo(Object object) {
            this.a = object;
            this.b = null;
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            if (IlvSymbolEditorDocument.this.c(object)) {
                IlvRule ilvRule = (IlvRule)object;
                this.b = ilvSymbolRuleModel.getGraphicFromRule(ilvRule);
                IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)this.b.getGraphicBag();
                this.c = ilvCompositeGraphic;
                IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
                this.e = ilvGraphicArray.length;
                for (int i = 0; i < this.e; ++i) {
                    if (ilvGraphicArray[i] != this.b) continue;
                    this.d = i;
                    break;
                }
            } else if (IlvSymbolEditorDocument.isConditionSelection(object)) {
                IlvGraphic ilvGraphic = ilvSymbolRuleModel.getGraphicFromRule((IlvRule)object);
                IlvRule ilvRule = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvGraphic);
                this.c = ilvRule;
                this.d = ilvRule.getIndex((IlvRule)object);
                this.e = ilvRule.getChildCount();
            } else if (IlvSymbolEditorDocument.this.d(object)) {
                this.c = IlvSymbolEditorDocument.this.a;
                this.e = IlvSymbolEditorDocument.this.a.getParameterCount();
                for (int i = 0; i < this.e; ++i) {
                    if (object != IlvSymbolEditorDocument.this.a.getParameter(i)) continue;
                    this.d = i;
                    break;
                }
            } else {
                this.d = 0;
                this.e = 0;
                this.c = null;
            }
        }

        public int compareTo(Object object) {
            SelectedInfo selectedInfo = (SelectedInfo)object;
            return this.d - selectedInfo.d;
        }
    }

    private static class ParameterClipboardElement
    extends ClipboardElement {
        private IlvPaletteSymbolParameter a;

        ParameterClipboardElement(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
            this.a = ilvPaletteSymbolParameter;
        }

        @Override
        boolean a(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            List list = ilvSymbolEditorDocument.getSelection();
            return list.size() == 0 || list.size() == 1 && (ilvSymbolEditorDocument.f(list.get(0)) || ilvSymbolEditorDocument.d(list.get(0)));
        }

        @Override
        Object b(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            IlvPaletteSymbolParameter ilvPaletteSymbolParameter = this.a.copy();
            String string = SymbolEditorUtilities.getUniqueParameterName(ilvSymbolEditorDocument, ilvPaletteSymbolParameter.getName());
            ilvPaletteSymbolParameter.setName(string);
            ilvPaletteSymbolParameter.setID(string);
            ilvSymbolEditorDocument.addParameter(ilvPaletteSymbolParameter);
            return ilvPaletteSymbolParameter;
        }
    }

    private static class ConditionClipboardElement
    extends ClipboardElement {
        private IlvRule[] a;

        ConditionClipboardElement(IlvRule[] ilvRuleArray) {
            this.a = IlvSymbolEditorDocument.b(ilvRuleArray);
        }

        @Override
        boolean a(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            if (this.a.length == 0) {
                return false;
            }
            List list = ilvSymbolEditorDocument.getSelection();
            if (list.size() == 0) {
                return true;
            }
            if (list.size() == 1) {
                Object e = list.get(0);
                if (e instanceof IlvRule) {
                    IlvGraphic ilvGraphic = ilvSymbolEditorDocument.getRuleModel().getGraphicFromRule(this.a[0]);
                    IlvGraphic ilvGraphic2 = ilvSymbolEditorDocument.getRuleModel().getGraphicFromRule((IlvRule)e);
                    return ilvGraphic2 == ilvGraphic;
                }
                return false;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Object b(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            IlvRule ilvRule = ilvSymbolEditorDocument.a(this.a[0], false);
            if (ilvRule == null) {
                return null;
            }
            IlvSymbolRuleModel ilvSymbolRuleModel = ilvSymbolEditorDocument.getRuleModel();
            ilvSymbolEditorDocument.a(ilvSymbolRuleModel, true);
            try {
                IlvRule[] ilvRuleArray = IlvSymbolEditorDocument.b(this.a);
                IlvSymbolEditorDocument.b(ilvRuleArray[0], ilvRule);
                ilvRuleArray[0].setSelector(ilvRule.getSelector());
                ilvSymbolEditorDocument.c(ilvRuleArray);
                for (int i = 0; i < ilvRuleArray.length; ++i) {
                    ilvSymbolRuleModel.addRule(ilvRuleArray[i]);
                }
                if (ilvRuleArray.length > 0) {
                    IlvRule ilvRule2 = ilvRuleArray[0];
                    return ilvRule2;
                }
                Object var5_7 = null;
                return var5_7;
            }
            finally {
                ilvSymbolEditorDocument.a(ilvSymbolRuleModel, false);
            }
        }
    }

    private static class GraphicClipboardElement
    extends ClipboardElement {
        private String a;
        private IlvRule[] b;
        private IlvPoint c;

        GraphicClipboardElement(IlvGraphic ilvGraphic, IlvRule[] ilvRuleArray) {
            this.a = ilvGraphic.getName();
            this.b = IlvSymbolEditorDocument.b(ilvRuleArray);
            IlvRect ilvRect = ilvGraphic.boundingBox();
            this.c = new IlvPoint(ilvRect.x, ilvRect.y);
        }

        @Override
        boolean a(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            List list = ilvSymbolEditorDocument.getSelection();
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (ilvSymbolEditorDocument.c(e) || ilvSymbolEditorDocument.b(e) || ilvSymbolEditorDocument.e(e)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Object b(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            IlvRule ilvRule;
            Object object;
            IlvSymbolRuleModel ilvSymbolRuleModel = ilvSymbolEditorDocument.getRuleModel();
            ilvSymbolRuleModel.setAdjusting(true);
            try {
                object = this.a;
                IlvRule[] ilvRuleArray = IlvSymbolEditorDocument.b(this.b);
                String string = SymbolEditorUtilities.getUniqueRuleID(ilvSymbolEditorDocument, ilvRuleArray, (String)object);
                ilvSymbolEditorDocument.a(ilvRuleArray, (String)object, string, false);
                ilvSymbolEditorDocument.c(ilvRuleArray);
                for (int i = 0; i < ilvRuleArray.length; ++i) {
                    ilvSymbolRuleModel.addRule(ilvRuleArray[i]);
                }
                ilvRule = ilvSymbolRuleModel.getMainRuleFromID(string);
                IlvRule ilvRule2 = ilvSymbolEditorDocument.getToplevelRule();
                IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvSymbolEditorDocument.getToplevelGraphic();
                IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
                int n = ilvGraphicArray.length;
                while (ilvGraphicArray[n - 1] == null) {
                    --n;
                }
                ilvSymbolRuleModel.setDeclarationValue(ilvRule2, "children[" + n + "]", "@+" + string);
                try {
                    IlvRule ilvRule3 = ilvSymbolRuleModel.getRule("Subobject#" + string + "Attachment", true);
                    ilvSymbolRuleModel.setDeclarationValue(ilvRule3, "class", IlvAttachmentConstraint.class.getName());
                    ilvSymbolRuleModel.setDeclarationValue(ilvRule2, "constraints[" + n + "]", "@+" + string + "Attachment");
                }
                catch (IlvStylingException ilvStylingException) {
                    ilvStylingException.printStackTrace();
                }
            }
            finally {
                ilvSymbolRuleModel.setAdjusting(false);
            }
            this.c.translate(10.0f, 10.0f);
            object = ilvSymbolRuleModel.getGraphicFromRule(ilvRule);
            ((IlvGraphic)object).move(this.c.x, this.c.y);
            ilvSymbolRuleModel.updateGeometry((IlvGraphic)object, ilvRule, true, null);
            return ilvRule;
        }
    }

    private static abstract class ClipboardElement {
        private ClipboardElement() {
        }

        abstract boolean a(IlvSymbolEditorDocument var1);

        abstract Object b(IlvSymbolEditorDocument var1);
    }

    static class Clipboard {
        private ArrayList a = new ArrayList();

        Clipboard() {
        }

        void a() {
            this.a.clear();
        }

        void a(ClipboardElement clipboardElement) {
            this.a.add(clipboardElement);
        }

        void b(ClipboardElement clipboardElement) {
            this.a.remove(clipboardElement);
        }

        boolean a(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            if (this.a.size() > 0) {
                for (int i = 0; i < this.a.size(); ++i) {
                    if (((ClipboardElement)this.a.get(i)).a(ilvSymbolEditorDocument)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        List b(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < this.a.size(); ++i) {
                Object object = ((ClipboardElement)this.a.get(i)).b(ilvSymbolEditorDocument);
                if (object == null) continue;
                arrayList.add(object);
            }
            return arrayList;
        }
    }

    public static interface ConditionEditor {
        public IlvRule editCondition(IlvRule var1, String var2, boolean var3);
    }
}

