/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.editor.rules;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.beans.editor.IlvShapePropertyEditor;
import ilog.views.css.model.IlvConfigNode;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleImpl;
import ilog.views.css.model.IlvRuleModelImpl;
import ilog.views.css.model.IlvSelector;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvAttachableGraphic;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.io.IlvPersistentObject;
import ilog.views.symbology.editor.IlvSymbolEditorDocument;
import ilog.views.symbology.editor.internal.SymbolEditorUtilities;
import ilog.views.symbology.editor.rules.IlvSymbolRuleStrategy;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.beans.editor.IlvFloatPropertyEditor;
import ilog.views.util.css.event.RuleSetEvent;
import ilog.views.util.styling.IlvStylingException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class IlvSymbolRuleModel
extends IlvRuleModelImpl {
    private HashMap<String, List<RuleWithIndex>> a;
    private HashMap<String, List<RuleWithIndex>> b;
    private IlvSymbolEditorDocument c;
    private IlvRule d;
    private ParametersNode e;
    private IlvFloatPropertyEditor f = new IlvFloatPropertyEditor();
    private IlvShapePropertyEditor g = new IlvShapePropertyEditor();
    private boolean h;
    private boolean i;

    public IlvSymbolRuleModel() {
        super(new IlvSymbolRuleStrategy());
    }

    protected IlvSymbolRuleModel(IlvSymbolRuleStrategy ilvSymbolRuleStrategy) {
        super(ilvSymbolRuleStrategy);
    }

    public void setDocument(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
        this.c = ilvSymbolEditorDocument;
        ((IlvSymbolRuleStrategy)this.getCSSStrategy()).setDocument(ilvSymbolEditorDocument);
    }

    public IlvSymbolEditorDocument getDocument() {
        return this.c;
    }

    @Override
    public IlvConfigNode getConfig() {
        return this.e;
    }

    @Override
    public IlvRule getRootRule() {
        return this.d;
    }

    @Override
    public void revalidateRules(boolean bl) {
        if (!this.isDragging()) {
            this.validateRules(bl);
        }
    }

    @Override
    public synchronized void rulesChanged(RuleSetEvent ruleSetEvent) {
        super.rulesChanged(ruleSetEvent);
        if (ruleSetEvent == null || !ruleSetEvent.isTemporary()) {
            this.a = null;
            this.b = null;
        }
    }

    private void a() {
        HashMap<String, ArrayList<RuleWithIndex>> hashMap = new HashMap<String, ArrayList<RuleWithIndex>>();
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            String string;
            IlvRule ilvRule = ilvRuleArray[i];
            IlvSelector ilvSelector = ilvRule.getSelector();
            if (ilvSelector == null || (string = ilvSelector.getID()) == null) continue;
            RuleWithIndex ruleWithIndex = new RuleWithIndex(ilvRule, i);
            ArrayList<RuleWithIndex> arrayList = (ArrayList<RuleWithIndex>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<RuleWithIndex>(1);
                arrayList.add(ruleWithIndex);
                hashMap.put(string, arrayList);
                continue;
            }
            arrayList.add(ruleWithIndex);
        }
        this.a = hashMap;
    }

    private void a(IlvRule ilvRule, int n) {
        String string;
        HashMap<String, List<RuleWithIndex>> hashMap = this.a;
        IlvSelector ilvSelector = ilvRule.getSelector();
        if (ilvSelector != null && (string = ilvSelector.getID()) != null) {
            RuleWithIndex ruleWithIndex = new RuleWithIndex(ilvRule, n);
            List<RuleWithIndex> list = hashMap.get(string);
            if (list == null) {
                list = new ArrayList<RuleWithIndex>(1);
                list.add(ruleWithIndex);
                hashMap.put(string, list);
            } else {
                list.add(ruleWithIndex);
            }
        }
    }

    private void a(IlvRule ilvRule) {
        List<RuleWithIndex> list;
        String string;
        HashMap<String, List<RuleWithIndex>> hashMap = this.a;
        IlvSelector ilvSelector = ilvRule.getSelector();
        if (ilvSelector != null && (string = ilvSelector.getID()) != null && (list = hashMap.get(string)) != null) {
            list.remove(ilvRule);
            if (list.isEmpty()) {
                hashMap.remove(string);
            }
        }
    }

    private void b() {
        HashMap<String, ArrayList<RuleWithIndex>> hashMap = new HashMap<String, ArrayList<RuleWithIndex>>();
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            String string;
            IlvRule ilvRule = ilvRuleArray[i];
            IlvSelector ilvSelector = ilvRule.getSelector();
            if (ilvSelector == null || (string = ilvSelector.getType()) == null) continue;
            RuleWithIndex ruleWithIndex = new RuleWithIndex(ilvRule, i);
            ArrayList<RuleWithIndex> arrayList = (ArrayList<RuleWithIndex>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<RuleWithIndex>(1);
                arrayList.add(ruleWithIndex);
                hashMap.put(string, arrayList);
                continue;
            }
            arrayList.add(ruleWithIndex);
        }
        this.b = hashMap;
    }

    private void b(IlvRule ilvRule, int n) {
        String string;
        HashMap<String, List<RuleWithIndex>> hashMap = this.b;
        IlvSelector ilvSelector = ilvRule.getSelector();
        if (ilvSelector != null && (string = ilvSelector.getType()) != null) {
            RuleWithIndex ruleWithIndex = new RuleWithIndex(ilvRule, n);
            List<RuleWithIndex> list = hashMap.get(string);
            if (list == null) {
                list = new ArrayList<RuleWithIndex>(1);
                list.add(ruleWithIndex);
                hashMap.put(string, list);
            } else {
                list.add(ruleWithIndex);
            }
        }
    }

    private void b(IlvRule ilvRule) {
        List<RuleWithIndex> list;
        String string;
        HashMap<String, List<RuleWithIndex>> hashMap = this.b;
        IlvSelector ilvSelector = ilvRule.getSelector();
        if (ilvSelector != null && (string = ilvSelector.getType()) != null && (list = hashMap.get(string)) != null) {
            list.remove(ilvRule);
            if (list.isEmpty()) {
                hashMap.remove(string);
            }
        }
    }

    @Override
    protected void beforeSelectorChange(IlvRule ilvRule) {
        super.beforeSelectorChange(ilvRule);
        if (this.a != null) {
            this.a(ilvRule);
        }
        if (this.b != null) {
            this.b(ilvRule);
        }
    }

    @Override
    protected void afterSelectorChange(IlvRule ilvRule, int n) {
        super.afterSelectorChange(ilvRule, n);
        if (this.a != null) {
            this.a(ilvRule, n);
        }
        if (this.b != null) {
            this.b(ilvRule, n);
        }
    }

    private HashMap<String, List<RuleWithIndex>> c() {
        if (this.a == null) {
            this.a();
        }
        return this.a;
    }

    public List<RuleWithIndex> getAllRulesWithIndicesFromId(String string) {
        HashMap<String, List<RuleWithIndex>> hashMap = this.c();
        List<RuleWithIndex> list = hashMap.get(string);
        return list;
    }

    private HashMap<String, List<RuleWithIndex>> d() {
        if (this.b == null) {
            this.b();
        }
        return this.b;
    }

    public List<RuleWithIndex> getAllRulesWithIndicesFromType(String string) {
        HashMap<String, List<RuleWithIndex>> hashMap = this.d();
        List<RuleWithIndex> list = hashMap.get(string);
        return list;
    }

    public List<RuleWithIndex> mergeOrdered(List<RuleWithIndex> list, List<RuleWithIndex> list2) {
        List<RuleWithIndex> list3;
        if (list != null) {
            if (list2 != null) {
                int n;
                int n2 = list.size();
                int n3 = list2.size();
                RuleWithIndex[] ruleWithIndexArray = new RuleWithIndex[n2 + n3];
                for (n = 0; n < n2; ++n) {
                    ruleWithIndexArray[n] = list.get(n);
                }
                for (n = 0; n < n3; ++n) {
                    ruleWithIndexArray[n2 + n] = list2.get(n);
                }
                Arrays.sort(ruleWithIndexArray, new RuleWithIndexComparator());
                list3 = new ArrayList<RuleWithIndex>();
                for (n = 0; n < n2 + n3; ++n) {
                    if (n != 0 && ruleWithIndexArray[n].b == ruleWithIndexArray[n - 1].b) continue;
                    list3.add(ruleWithIndexArray[n]);
                }
            } else {
                list3 = list;
            }
        } else {
            list3 = list2 != null ? list2 : Collections.emptyList();
        }
        return list3;
    }

    @Override
    public void buildTree() {
        this.d = new IlvRuleImpl(this.c.getToplevelRule().getDOMImplementation().createRule());
        IlvRule ilvRule = this.c.getToplevelRule();
        this.a(ilvRule, this.c.getToplevelGraphic());
        this.d.addChild(ilvRule);
        this.e = new ParametersNode();
    }

    private void a(IlvRule ilvRule, IlvGraphic ilvGraphic) {
        IlvRule ilvRule2;
        ilvRule.resetTreeNode();
        List<RuleWithIndex> list = ilvRule.getSelector().getID() != null ? this.c.getRuleModel().getAllRulesWithIndicesFromId(ilvRule.getSelector().getID()) : null;
        List<RuleWithIndex> list2 = ilvRule.getSelector().getType() != null ? this.c.getRuleModel().getAllRulesWithIndicesFromType(ilvRule.getSelector().getType()) : null;
        List<RuleWithIndex> list3 = this.c.getRuleModel().mergeOrdered(list, list2);
        for (RuleWithIndex object : list3) {
            ilvRule2 = object.getRule();
            if (ilvRule2 == ilvRule) continue;
            ilvRule.addChild(ilvRule2);
        }
        if (ilvGraphic instanceof IlvGraphicSet) {
            for (int i = 0; i < ((IlvGraphicSet)ilvGraphic).getCardinal(); ++i) {
                IlvGraphic ilvGraphic2 = ((IlvGraphicSet)ilvGraphic).getObject(i);
                if (ilvGraphic2.getName() == null || (ilvRule2 = this.getMainRuleFromGraphic(ilvGraphic2)) == null) continue;
                this.a(ilvRule2, ilvGraphic2);
                ilvRule.addChild(ilvRule2);
            }
        }
    }

    public IlvRule getMainRuleFromID(String string) {
        List<RuleWithIndex> list = this.c.getRuleModel().getAllRulesWithIndicesFromId(string);
        List<RuleWithIndex> list2 = this.c.getRuleModel().getAllRulesWithIndicesFromType(string);
        List<RuleWithIndex> list3 = this.c.getRuleModel().mergeOrdered(list, list2);
        for (RuleWithIndex ruleWithIndex : list3) {
            IlvRule ilvRule = ruleWithIndex.getRule();
            if (SymbolEditorUtilities.hasCondition(ilvRule)) continue;
            return ilvRule;
        }
        return null;
    }

    public IlvRule getMainRuleFromGraphic(IlvGraphic ilvGraphic) {
        if (ilvGraphic == this.c.getToplevelGraphic()) {
            return this.c.getToplevelRule();
        }
        return this.getMainRuleFromID(ilvGraphic.getName());
    }

    public IlvRule[] getAllRulesFromGraphic(IlvGraphic ilvGraphic) {
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        String string = ilvGraphic.getName();
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            if (ilvRuleArray[i].getSelector() == null || !string.equals(ilvRuleArray[i].getSelector().getID()) && !string.equals(ilvRuleArray[i].getSelector().getType())) continue;
            arrayList.add(ilvRuleArray[i]);
        }
        return arrayList.toArray(new IlvRule[0]);
    }

    public IlvGraphic getGraphicFromRule(IlvRule ilvRule) {
        if (ilvRule == this.c.getToplevelRule()) {
            return this.c.getToplevelGraphic();
        }
        if (ilvRule != null && this.c.getToplevelGraphic() instanceof IlvGraphicSet) {
            return SymbolEditorUtilities.findGraphicByName(this.c, ilvRule.getSelector().getID());
        }
        return null;
    }

    public final boolean updateGeometry(IlvGraphic ilvGraphic, IlvRule ilvRule, boolean bl, IlvPoint ilvPoint) {
        IlvPersistentObject ilvPersistentObject;
        Object object = ilvGraphic;
        while (((IlvGraphic)object).getGraphicBag() instanceof IlvCompositeGraphic) {
            ilvPersistentObject = SymbolEditorUtilities.getAttachmentConstraint((IlvGraphic)object);
            if (ilvPersistentObject != null && ilvPersistentObject.getRotationAngle() != 0.0 && !bl) {
                this.c.applyChanges();
                return false;
            }
            object = (IlvGraphic)((Object)((IlvGraphic)object).getGraphicBag());
        }
        this.setAdjusting(true);
        if (!bl && ilvGraphic instanceof IlvCompositeGraphic && !SymbolEditorUtilities.isSubSymbol(ilvGraphic)) {
            this.a((IlvCompositeGraphic)ilvGraphic);
        }
        this.a(ilvGraphic, ilvPoint);
        if (!bl) {
            this.a(ilvGraphic, ilvRule);
        }
        object = ilvGraphic.getGraphicBag();
        while (object instanceof IlvCompositeGraphic) {
            boolean bl2;
            IlvRule ilvRule2;
            block10: {
                block11: {
                    ilvPersistentObject = (IlvCompositeGraphic)object;
                    ilvRule2 = this.getMainRuleFromGraphic((IlvGraphic)ilvPersistentObject);
                    bl2 = false;
                    IlvRule ilvRule3 = this.getAttachmentConstraintRule((IlvGraphic)ilvPersistentObject, false);
                    if (ilvRule3 == null) break block10;
                    if (ilvRule3.getDeclaration("width") != null) break block11;
                    if (ilvRule3.getDeclaration("height") == null) break block10;
                }
                bl2 = true;
            }
            if (bl2) {
                this.updateGeometry((IlvGraphic)ilvPersistentObject, ilvRule2, false, null);
            } else {
                this.a((IlvGraphic)ilvPersistentObject, (IlvPoint)null);
            }
            object = object.getGraphicBag();
        }
        this.setAdjusting(false);
        return true;
    }

    private void a(IlvCompositeGraphic ilvCompositeGraphic) {
        IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
        if (ilvGraphicArray != null) {
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                IlvRule ilvRule;
                IlvGraphic ilvGraphic = ilvGraphicArray[i];
                if (ilvGraphic == null || (ilvRule = this.getMainRuleFromGraphic(ilvGraphic)) == null) continue;
                this.a(ilvGraphic, (IlvPoint)null);
            }
        }
    }

    private void a(IlvGraphic ilvGraphic, IlvPoint ilvPoint) {
        if (ilvGraphic == this.c.getToplevelGraphic()) {
            this.c.updatePosition();
            return;
        }
        IlvAttachmentConstraint ilvAttachmentConstraint = SymbolEditorUtilities.getAttachmentConstraint(ilvGraphic);
        if (ilvAttachmentConstraint != null && !this.a(ilvGraphic)) {
            IlvCompositeGraphic ilvCompositeGraphic = SymbolEditorUtilities.getComposite(ilvGraphic);
            IlvRule ilvRule = this.getAttachmentConstraintRule(ilvGraphic, false);
            if (ilvRule != null) {
                Object object;
                IlvPoint ilvPoint2 = ilvAttachmentConstraint.getOffset();
                IlvAttachable ilvAttachable = ilvCompositeGraphic.getAttachables()[0];
                IlvRect ilvRect = ilvAttachable.getAttachmentBounds();
                if (ilvAttachmentConstraint.isRelativeOffset()) {
                    ilvPoint2.x *= ilvRect.width;
                    ilvPoint2.y *= ilvRect.height;
                }
                if (ilvPoint != null) {
                    ilvPoint2.x += ilvPoint.x;
                    ilvPoint2.y += ilvPoint.y;
                } else {
                    object = ilvAttachmentConstraint.compute(ilvAttachable, ilvRect);
                    IlvAttachableGraphic ilvAttachableGraphic = ilvCompositeGraphic.getAttachableGraphic(ilvGraphic);
                    IlvPoint ilvPoint3 = ilvAttachmentConstraint.getHotSpot().getValue(ilvAttachableGraphic);
                    float f = ilvPoint3.x - ((Point2D.Float)object).x;
                    float f2 = ilvPoint3.y - ((Point2D.Float)object).y;
                    ilvPoint2.x += f;
                    ilvPoint2.y += f2;
                }
                if (ilvAttachmentConstraint.isRelativeOffset()) {
                    ilvPoint2.x /= ilvRect.width;
                    ilvPoint2.y /= ilvRect.height;
                }
                if (!this.isBound(ilvRule, "offsetX")) {
                    this.f.setValue(new Float(ilvPoint2.x));
                    object = this.f.getAsText();
                    this.setDeclarationValue(ilvRule, "offsetX", (String)object);
                }
                if (!this.isBound(ilvRule, "offsetY")) {
                    this.f.setValue(new Float(ilvPoint2.y));
                    object = this.f.getAsText();
                    this.setDeclarationValue(ilvRule, "offsetY", (String)object);
                }
            }
        }
    }

    private boolean a(IlvGraphic ilvGraphic) {
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (!(ilvGraphicBag instanceof IlvCompositeGraphic)) {
            return false;
        }
        IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphicBag;
        return ilvCompositeGraphic.getChildren(0) == ilvGraphic;
    }

    private void a(IlvGraphic ilvGraphic, IlvRule ilvRule) {
        Object object;
        Object object2;
        IlvPersistentObject ilvPersistentObject;
        if (ilvGraphic instanceof IlvGeneralPath) {
            if (!this.isBound(ilvRule, "shape")) {
                ilvPersistentObject = (IlvGeneralPath)ilvGraphic;
                object2 = ((IlvGeneralPath)ilvPersistentObject).getShape();
                if (((IlvGeneralPath)ilvPersistentObject).isTransformedShapeMode()) {
                    ((IlvGeneralPath)ilvPersistentObject).setTransformedShapeMode(false);
                    ((IlvGeneralPath)ilvPersistentObject).setTransformedShapeMode(true);
                }
                this.g.setValue(object2);
                object = this.g.getAsText();
                this.setDeclarationValue(ilvRule, "shape", (String)object);
            }
        }
        if (ilvGraphic instanceof IlvText) {
            if (!this.isBound(ilvRule, "label")) {
                ilvPersistentObject = (IlvText)ilvGraphic;
                this.setDeclarationValue(ilvRule, "label", ((IlvText)ilvPersistentObject).getLabel());
            }
        }
        if ((ilvPersistentObject = SymbolEditorUtilities.getAttachmentConstraint(ilvGraphic)) != null && ((IlvAttachmentConstraint)ilvPersistentObject).getSize() != null || !(ilvGraphic instanceof IlvGeneralPath)) {
            object2 = SymbolEditorUtilities.getComposite(ilvGraphic);
            if (object2 == null) {
                return;
            }
            object = ((IlvCompositeGraphic)object2).getChildren(0);
            IlvRect ilvRect = SymbolEditorUtilities.getAttachmentBounds((IlvGraphic)object);
            IlvRect ilvRect2 = SymbolEditorUtilities.getAttachmentBounds(ilvGraphic);
            IlvRule ilvRule2 = this.getAttachmentConstraintRule(ilvGraphic, false);
            if (ilvRule2 != null) {
                if (!this.isBound(ilvRule2, "width")) {
                    this.setDeclarationValue(ilvRule2, "width", String.valueOf(((IlvAttachmentConstraint)ilvPersistentObject).isRelativeSize() ? ilvRect2.width / ilvRect.width : ilvRect2.width));
                }
                if (!this.isBound(ilvRule2, "height")) {
                    this.setDeclarationValue(ilvRule2, "height", String.valueOf(((IlvAttachmentConstraint)ilvPersistentObject).isRelativeSize() ? ilvRect2.height / ilvRect.height : ilvRect2.height));
                }
            }
        }
    }

    public boolean isBound(IlvRule ilvRule, String string) {
        String string2 = this.getDeclarationValue(ilvRule, string);
        if (string2 == null) {
            return false;
        }
        return string2.startsWith("@");
    }

    public IlvRule getAttachmentConstraintRule(IlvGraphic ilvGraphic, boolean bl) {
        try {
            return this.getRule("Subobject#" + ilvGraphic.getName() + "Attachment", false);
        }
        catch (IlvStylingException ilvStylingException) {
            ilvStylingException.printStackTrace();
            return null;
        }
    }

    @Override
    public void removeDeclaration(IlvRule ilvRule, String string) {
        String string2 = ilvRule.getDeclarationValue(string);
        if (string2 != null) {
            this.h = true;
            ilvRule.resetModified(string);
            ilvRule.setDeclarationValue(string, string2);
            super.removeDeclaration(ilvRule, string);
        }
    }

    @Override
    public void setDeclarationValue(IlvRule ilvRule, String string, String string2) {
        super.setDeclarationValue(ilvRule, string, string2);
        if (string.startsWith("constraints")) {
            this.h = true;
        } else if (string.startsWith("children")) {
            this.h = true;
        } else if (string.startsWith("eventMaps")) {
            this.h = true;
        } else if (string.startsWith("shape")) {
            this.h = true;
        }
    }

    @Override
    public void setDeclarationValueAndUpdateUnusedSharpRules(IlvRule ilvRule, String string, String string2) {
        super.setDeclarationValueAndUpdateUnusedSharpRules(ilvRule, string, string2);
        if (string.startsWith("constraints")) {
            this.h = true;
        } else if (string.startsWith("children")) {
            this.h = true;
        } else if (string.startsWith("eventMaps")) {
            this.h = true;
        }
    }

    public boolean isMustRecreateSymbol() {
        boolean bl = this.h;
        this.h = false;
        return bl;
    }

    public void setDragging(boolean bl) {
        this.i = bl;
    }

    public boolean isDragging() {
        return this.i;
    }

    private static class ParametersNode
    extends IlvConfigNode {
        private String a = IlvResourceUtil.getBundle("ilog.views.symbology.editor.rules.rules", IlvLocaleUtil.getCurrentLocale(), IlvSymbolEditorDocument.class.getClassLoader()).getString("SymbolEditor.Rules.Parameters");

        @Override
        public String toString() {
            return this.a;
        }
    }

    static class RuleWithIndexComparator
    implements Comparator<RuleWithIndex> {
        RuleWithIndexComparator() {
        }

        @Override
        public int compare(RuleWithIndex ruleWithIndex, RuleWithIndex ruleWithIndex2) {
            return ruleWithIndex.b - ruleWithIndex2.b;
        }
    }

    public static class RuleWithIndex {
        IlvRule a;
        int b;

        public RuleWithIndex(IlvRule ilvRule, int n) {
            this.a = ilvRule;
            this.b = n;
        }

        public IlvRule getRule() {
            return this.a;
        }
    }
}

